/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.dei.DeInstallInfo;
import com.oracle.cie.gdr.dao.ftr.FeatureLibrary;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dao.loui.LegacyComponent;
import com.oracle.cie.gdr.dao.loui.LegacyComponents;
import com.oracle.cie.gdr.deinstallation.DistributionDeInstallationSession;
import com.oracle.cie.gdr.external.BaseInventory;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.Directory;
import com.oracle.cie.gdr.external.DirectoryMap;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.FederatedRelationship;
import com.oracle.cie.gdr.external.FederatedSorting;
import com.oracle.cie.gdr.external.FileMap;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.InventoryFactory;
import com.oracle.cie.gdr.external.Mapping;
import com.oracle.cie.gdr.external.MappingSymbol;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import com.oracle.cie.gdr.external.RootMapping;
import com.oracle.cie.gdr.external.impl.ComponentImpl;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.HomeHelper;
import com.oracle.cie.gdr.helpers.LegacyComponentHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.libraries.JarLibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryEntryLocation;
import com.oracle.cie.gdr.libraries.LibraryKey;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.ProductFamilyService;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InventoryUtil {
    private OracleHomeInventory _ohInventory;
    private Path _ohInventoryPath;
    private Map<DistributionTarget, ComponentLoader> _distCompLoaderMap;
    private static final Logger _log = Logger.getLogger(InventoryUtil.class.getName());

    public InventoryUtil(File homeDir) throws InventoryException {
        this(NioHelper.getInstance().getPath(homeDir));
    }

    public InventoryUtil(Path homeDir) throws InventoryException {
        this(InventoryFactory.getOracleHomeInventory(homeDir));
        this._distCompLoaderMap = new LRUCache<DistributionTarget, ComponentLoader>(10);
    }

    public InventoryUtil(OracleHomeInventory ohInventory) throws InventoryException {
        if (ohInventory == null) {
            throw new InventoryException("The oracle home inventory provided was null.");
        }
        this._ohInventory = ohInventory;
        this._ohInventoryPath = ohInventory.getHomeDirPath().toAbsolutePath().resolve("inventory");
    }

    public Set<String> getProductDirectories() throws InventoryException {
        return new HashSet<String>(InventoryUtil.getProductDirectories(this._ohInventory, false).keySet());
    }

    public Set<String> getProductDirectories(boolean includeRootMapping) throws InventoryException {
        return new HashSet<String>(InventoryUtil.getProductDirectories(this._ohInventory, includeRootMapping).keySet());
    }

    private static Map<String, File> getLegacyProductDirectories(OracleHomeInventory inventory) {
        HashMap<String, File> prodDirs = new HashMap<String, File>();
        prodDirs.put(inventory.getHomeDirPath().toUri().toString(), inventory.getHomeDir());
        return prodDirs;
    }

    public static Map<String, File> getProductDirectories(OracleHomeInventory inventory, boolean includeRootMapping) throws InventoryException {
        if (inventory == null) {
            throw new InventoryException("The inventory specified was null.");
        }
        if (HomeHelper.isLegacyHome(inventory.getHomeDirPath())) {
            return InventoryUtil.getLegacyProductDirectories(inventory);
        }
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        Collection<Distribution> distributions = inventory.getInstalledDistributions();
        HashMap<String, File> productHomes = new HashMap<String, File>();
        for (Distribution dist : distributions) {
            mappings.addAll(dist.getDirectoryMap().getMappings());
        }
        HashSet<String> rootSymbols = new HashSet<String>();
        for (Mapping mapping : mappings) {
            String directory = mapping.getDirectory();
            if (includeRootMapping && mapping.isRoot()) {
                RootMapping rootMap = mapping.getRootMapping();
                List<MappingSymbol> symbols = rootMap.getMappingSymbols();
                for (MappingSymbol symbol : symbols) {
                    rootSymbols.add(symbol.getSymbol());
                }
            }
            if (!Files.exists(Paths.get(inventory.getHomeDir().getAbsolutePath(), directory), new LinkOption[0]) || StringUtil.isNullOrEmpty((String)directory)) continue;
            productHomes.put(directory, new File(inventory.getHomeDir(), directory));
        }
        if (includeRootMapping) {
            for (Component component : inventory.getInstalledComponents()) {
                for (FileMap fileMap : component.getFileMaps()) {
                    if (!rootSymbols.contains(fileMap.getSymbol())) continue;
                    for (Directory rootSymbolDirectory : fileMap.getDirectories()) {
                        String directory = rootSymbolDirectory.getDest();
                        if (directory.isEmpty()) {
                            for (Directory internalDirectory : rootSymbolDirectory.getDirectories()) {
                                String rootLevelDirectory = internalDirectory.getDest();
                                if (!Files.exists(Paths.get(inventory.getHomeDir().getAbsolutePath(), rootLevelDirectory), new LinkOption[0]) || StringUtil.isNullOrEmpty((String)rootLevelDirectory)) continue;
                                productHomes.put(rootLevelDirectory, new File(inventory.getHomeDir(), rootLevelDirectory));
                            }
                        }
                        if (!Files.exists(Paths.get(inventory.getHomeDir().getAbsolutePath(), directory), new LinkOption[0]) || StringUtil.isNullOrEmpty((String)directory)) continue;
                        productHomes.put(directory, new File(inventory.getHomeDir(), directory));
                    }
                }
            }
        }
        return productHomes;
    }

    public Set<String> getProductDirectories(String componentName, String componentVersion, String symbol) throws InventoryException {
        return InventoryUtil.getProductDirectories(componentName, componentVersion, symbol, this._ohInventory);
    }

    public static Set<String> getProductDirectories(String componentName, String componentVersion, String symbol, BaseInventory inventory) throws InventoryException {
        if (StringUtil.isNullOrEmpty((String)componentName, (boolean)true)) {
            throw new InventoryException("The component name specified was null or empty.");
        }
        if (StringUtil.isNullOrEmpty((String)componentVersion, (boolean)true)) {
            throw new InventoryException("The component version specified was null or empty.");
        }
        if (StringUtil.isNullOrEmpty((String)symbol, (boolean)true)) {
            throw new InventoryException("The component symbol specified was null or empty.");
        }
        if (inventory == null) {
            throw new InventoryException("The inventory specified was null.");
        }
        HashSet<String> productHomes = new HashSet<String>();
        Collection<Distribution> distributions = inventory.getDistributions();
        LinkedHashMap<Distribution, List<Mapping>> mappingDistributions = new LinkedHashMap<Distribution, List<Mapping>>();
        for (Distribution distribution : distributions) {
            DirectoryMap directoryMap = distribution.getDirectoryMap();
            List<Mapping> mappings = directoryMap.getMappings(symbol);
            if (mappings == null || mappings.isEmpty()) continue;
            mappingDistributions.put(distribution, mappings);
        }
        if (!mappingDistributions.isEmpty()) {
            for (Map.Entry entry : mappingDistributions.entrySet()) {
                Distribution distribution = (Distribution)entry.getKey();
                boolean foundComponent = false;
                for (Component component : distribution.getComponents()) {
                    if (!component.getName().equals(componentName) || !component.getVersion().equals(componentVersion)) continue;
                    foundComponent = true;
                    break;
                }
                if (!foundComponent) continue;
                for (Mapping mapping : (List)entry.getValue()) {
                    String directory = mapping.getDirectory();
                    productHomes.add(directory);
                }
            }
        }
        return productHomes;
    }

    public Map<String, OracleHomeInventory> getProductFamilies(FederatedRelationship relationship, FederatedSorting sorting, boolean includeSelf) throws InventoryException {
        LinkedHashMap<String, OracleHomeInventory> fohProductFamilies = new LinkedHashMap<String, OracleHomeInventory>();
        Collection<OracleHomeInventory> fohInventories = this._ohInventory.getFederatedOracleHomeInventories(relationship, sorting, includeSelf);
        if (fohInventories != null) {
            for (OracleHomeInventory fohInv : fohInventories) {
                for (Distribution distribution : fohInv.getInstalledDistributions()) {
                    Collection<String> productFamilies = distribution.getProductFamilies();
                    if (productFamilies == null) continue;
                    for (String productFamily : productFamilies) {
                        fohProductFamilies.put(productFamily, fohInv);
                    }
                }
            }
        }
        return fohProductFamilies;
    }

    public Map<String, String> getProductFamilyVariables(FederatedRelationship relationship, FederatedSorting sorting, boolean includeSelf) throws InventoryException {
        LinkedHashMap<String, String> fohProductFamilies = new LinkedHashMap<String, String>();
        Collection<OracleHomeInventory> fohInventories = this._ohInventory.getFederatedOracleHomeInventories(relationship, sorting, includeSelf);
        if (fohInventories != null) {
            for (OracleHomeInventory fohInv : fohInventories) {
                if (HomeHelper.isLegacyHome(fohInv.getHomeDirPath())) {
                    try {
                        for (String productFamily : HomeHelper.getLegacyProductFamilies(fohInv.getHomeDirPath())) {
                            fohProductFamilies.putAll(ProductFamilyService.getInstance().generateProductFamilyVariables(productFamily, fohInv.getHomeDir()));
                        }
                        continue;
                    }
                    catch (Exception e) {
                        throw new InventoryException(e);
                    }
                }
                for (Distribution distribution : fohInv.getInstalledDistributions()) {
                    Collection<String> productFamilies = distribution.getProductFamilies();
                    if (productFamilies == null) continue;
                    for (String productFamily : productFamilies) {
                        try {
                            fohProductFamilies.putAll(ProductFamilyService.getInstance().generateProductFamilyVariables(productFamily, fohInv.getHomeDir()));
                        }
                        catch (GdrException e) {
                            throw new InventoryException(e);
                        }
                    }
                }
            }
        }
        return fohProductFamilies;
    }

    public Map<String, Set<File>> getFederatedProductDirectories(FederatedRelationship relationship, FederatedSorting sorting, boolean includeSelf) throws InventoryException {
        LinkedHashMap<String, Set<File>> productDirectories = new LinkedHashMap<String, Set<File>>();
        Collection<OracleHomeInventory> inventories = this._ohInventory.getFederatedOracleHomeInventories(relationship, sorting, includeSelf);
        if (inventories != null) {
            for (OracleHomeInventory inventory : inventories) {
                Map<String, File> prodDirMap = InventoryUtil.getProductDirectories(inventory, false);
                if (prodDirMap == null) continue;
                for (Map.Entry<String, File> entry : prodDirMap.entrySet()) {
                    LinkedHashSet<File> dirs = (LinkedHashSet<File>)productDirectories.get(entry.getKey());
                    if (dirs == null) {
                        dirs = new LinkedHashSet<File>();
                        productDirectories.put(entry.getKey(), dirs);
                    }
                    dirs.add(entry.getValue());
                }
            }
        }
        return productDirectories;
    }

    public Set<File> getFederatedHomeLocations(FederatedRelationship relationship, FederatedSorting sorting, boolean includeSelf) throws InventoryException {
        LinkedHashSet<File> homeDirs = new LinkedHashSet<File>();
        ArrayList<OracleHomeInventory> inventories = new ArrayList<OracleHomeInventory>(this._ohInventory.getFederatedOracleHomeInventories(relationship, sorting, includeSelf));
        for (OracleHomeInventory inventory : inventories) {
            homeDirs.add(inventory.getHomeDir());
        }
        return homeDirs;
    }

    public Set<String> getSymbols(FeatureSet feature) throws InventoryException {
        Collection<Distribution> parentDistributions = this._ohInventory.getDistributions(feature);
        LinkedHashSet<String> symbols = new LinkedHashSet<String>();
        for (Distribution distribution : parentDistributions) {
            for (Mapping mapping : distribution.getDirectoryMap().getMappings(feature)) {
                symbols.addAll(Arrays.asList(mapping.getSymbols()));
            }
        }
        return symbols;
    }

    public String getInventoryDirectoryName() {
        return "inventory";
    }

    public File getInventoryDirectoryFile() {
        return this._ohInventoryPath.toFile();
    }

    public Path getInventoryDirectoryPath() {
        return this._ohInventoryPath;
    }

    public List<File> getOrderedLibraryDependencies(File libraryJar) throws IOException, DataHandlerException, GdrException, DependencyException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        ArrayList<File> libraryJars = new ArrayList<File>();
        libraryJars.add(libraryJar);
        return libraryJars;
    }

    public List<File> getOrderedLibraryDependencies(List<File> libraryJars) throws IOException, DataHandlerException, GdrException, DependencyException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        ArrayList<File> originalJars = new ArrayList<File>(libraryJars);
        ArrayList<File> orderedDependencies = new ArrayList<File>();
        HashSet<Integer> platforms = new HashSet<Integer>();
        platforms.add(PlatformInfoHelper.getInstance().getCurrentPlatformId());
        LabelMap labelMap = null;
        Home home = Home.getHome(this._ohInventoryPath.getParent());
        block0: for (Distribution dist : this._ohInventory.getDistributions()) {
            DistributionDeInstallationSession session = new DistributionDeInstallationSession(home.getHome(), new Reference(dist.getName(), dist.getVersion()));
            ComponentLoader componentLoader = new ComponentLoader(session.getMetaDataHome(), new ServiceHolder(platforms, null, null), Mode.DEINSTALL, session.getDistributionLoader().getFeatureSets(), session.getDistributionLoader().getDirectoryMap(), null, labelMap);
            Collection<LibraryTargetHolder> libraryTargetHolders = FeatureSetHelper.getInstance(home.getClassLoader()).getLibraryTargets(home.getInstalledFeatures(), home, componentLoader.getComponentsMap(), componentLoader.getServiceHolder(), session.getDistributionLoader().getDirectoryMap()).values();
            File foundJar = null;
            for (LibraryTargetHolder holder : libraryTargetHolders) {
                for (LibraryKey key : holder.getFeatureLibraryKeys()) {
                    if (!key.getType().isNone()) {
                        JarLibraryHandler libHandler = (JarLibraryHandler)key.getType().getHandler();
                        libHandler.setHome(home);
                        FeatureLibrary library = holder.getFeatureLibrary(key);
                        for (String libPath : libHandler.getAbsoluteFeaturesetJarPaths(key, holder)) {
                            libPath = FileUtils.formatPath(libPath, "/");
                            String productHome = holder.getProductHome(library, Mode.DEINSTALL);
                            String regex = FileUtils.formatPath(home.getHome().getAbsolutePath(), "/");
                            libPath = regex + "/" + productHome + libPath.replaceFirst(regex, "");
                            for (File libraryJar : libraryJars) {
                                if (!libraryJar.getAbsolutePath().equals(FileUtils.formatPath(libPath))) continue;
                                foundJar = libraryJar;
                                orderedDependencies.remove(libraryJar);
                                orderedDependencies.add(libraryJar);
                                for (LibraryEntryLocation entry : libHandler.getFeatureLibraryEntryLocations(holder, key)) {
                                    File newDependency = new File(home.getHome(), entry.getFullPath());
                                    orderedDependencies.remove(newDependency);
                                    orderedDependencies.add(newDependency);
                                }
                            }
                            libraryJars.remove(foundJar);
                            if (!libraryJars.isEmpty()) continue;
                            break;
                        }
                    }
                    if (!libraryJars.isEmpty()) continue;
                    break;
                }
                if (!libraryJars.isEmpty()) continue;
                continue block0;
            }
        }
        if (!libraryJars.isEmpty()) {
            throw new GdrException("The following libraries were not found: " + libraryJars);
        }
        orderedDependencies.retainAll(originalJars);
        Collections.reverse(orderedDependencies);
        return orderedDependencies;
    }

    private Set<Component> getLegacyComponentsInstallingFile(File installedFile) throws IOException, DataHandlerException, GdrException {
        LegacyComponents legacyComponents = LegacyComponentHelper.getInstance().getLegacyComponents(installedFile.toPath());
        HashSet<Component> legacyCompSet = new HashSet<Component>();
        for (LegacyComponent legacyComp : legacyComponents.getTopLevelList().getTopLevelComponents()) {
            legacyCompSet.add(this.convertToNextGenComponent(legacyComp));
        }
        if (legacyCompSet.isEmpty()) {
            for (LegacyComponent legacyComp : legacyComponents.getCompList().getComponents()) {
                legacyCompSet.add(this.convertToNextGenComponent(legacyComp));
            }
        }
        return legacyCompSet;
    }

    private Component convertToNextGenComponent(LegacyComponent legacyComponent) {
        return ComponentImpl.newInstance(legacyComponent.getName(), legacyComponent.getVersion());
    }

    public Set<Component> getComponentsInstallingFile(File installedFile) throws IOException, DataHandlerException, GdrException {
        if (installedFile == null) {
            _log.log(Level.WARNING, "no File object was provided");
            return null;
        }
        if (!installedFile.isAbsolute()) {
            installedFile = new File(this._ohInventory.getHomeDir(), installedFile.getPath());
        } else if (!installedFile.getAbsolutePath().startsWith(this._ohInventory.getHomeDir().getAbsolutePath())) {
            _log.log(Level.INFO, "Path provided does not match active home directory");
            return null;
        }
        HashSet<Component> componentsResult = new HashSet<Component>();
        File homeDir = this._ohInventory.getHomeDir();
        if (HomeHelper.isLegacyHome(homeDir)) {
            return this.getLegacyComponentsInstallingFile(new File(homeDir, "inventory" + File.separator + "ContentsXML" + File.separator + "comps.xml"));
        }
        Home home = Home.getHome(homeDir);
        Collection<DistributionTarget> installedDists = home.getInstalledDistributions();
        if (installedDists != null) {
            String invtrLoc = homeDir.getCanonicalPath();
            Path installedFilePath = Paths.get(installedFile.getPath(), new String[0]);
            for (DistributionTarget distTarget : installedDists) {
                ComponentLoader componentLoader = this._distCompLoaderMap.get(distTarget);
                if (componentLoader == null) {
                    try {
                        componentLoader = new ComponentLoader(home.getMetaDataHome(), new ServiceHolder(), Mode.DEINSTALL, distTarget.getFeatureSets(), distTarget.getDirectoryMap(), (DeInstallInfo)null);
                        this._distCompLoaderMap.put(distTarget, componentLoader);
                    }
                    catch (Exception e) {
                        _log.log(Level.WARNING, "Could not load Component Loader", e);
                        continue;
                    }
                }
                Set<com.oracle.cie.gdr.dao.cpd.Component> components = componentLoader.getComponents();
                for (com.oracle.cie.gdr.dao.cpd.Component comp : components) {
                    Collection<ComponentTarget> targets = comp.getComponentTargets();
                    if (targets == null) continue;
                    for (ComponentTarget compTarget : targets) {
                        List<FileTarget> fileTargets = compTarget.getFileTargets();
                        for (FileTarget fileTarget : fileTargets) {
                            if (!fileTarget.getDest().endsWith(installedFile.getName())) continue;
                            try {
                                if (!Files.isSameFile(installedFilePath, Paths.get(invtrLoc, fileTarget.getDest()))) continue;
                                componentsResult.add(this._ohInventory.getComponent(comp.getName(), comp.getVersion()));
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
        return componentsResult;
    }

    private static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int capacity;

        public LRUCache(int capacity) {
            super(capacity, 0.75f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.capacity;
        }
    }
}

