/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.impl.FeatureSetImpl;
import com.oracle.cie.gdr.repository.RepositoryBOMConfig;
import com.oracle.cie.gdr.repository.RepositoryProcessor;
import com.oracle.cie.gdr.services.TopLevelDirectoryService;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.repository.common.NextGenHelper;
import com.oracle.cie.repository.common.NextGenHelperFactory;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class RepositoryBOM {
    private static final Logger _log = Logger.getLogger(RepositoryBOM.class.getName());
    private RestHandler _restHandler = RestFactory.getRestHandler();
    private NextGenHelper _nextGenHelper = NextGenHelperFactory.getNextGenHelper((RestHandler)this._restHandler);
    private RepositoryVersionResolver _versionResolver;
    private RepositoryBOMConfig _bomConfig;

    public RepositoryBOM(Properties properties) throws RepositoryCommonException {
        this._bomConfig = new RepositoryBOMConfig(properties);
    }

    public List<FeatureSet> getRMProducts() throws RestException, RepositoryCommonException, IOException, DependencyManagementException, GdrException {
        ArrayList<FeatureSet> rmProducts = new ArrayList<FeatureSet>();
        RepoCommonConfig repoCommonConfig = this._bomConfig.getRepoCommonConfig();
        if (!repoCommonConfig.hasProperty("USE_LATEST")) {
            repoCommonConfig.setProperty("USE_LATEST", "true");
        }
        ArrayList<Repository> repos = new ArrayList<Repository>();
        for (Repository r : repoCommonConfig.getRepositories()) {
            repos.add(r);
        }
        this._versionResolver = this._nextGenHelper.getConfiguredRepositoryVersionResolver(repoCommonConfig);
        File gdrDir = this.getGdrMetaDataDir(repoCommonConfig);
        RepositoryProcessor repositoryProcessor = new RepositoryProcessor(this._restHandler, this._versionResolver, gdrDir, repos, false);
        HashSet<FeatureSetReference> filteredList = new HashSet<FeatureSetReference>();
        for (FeatureSetReference f : this._bomConfig.getFeaturesets()) {
            if (this._versionResolver.featureSetQualifierExist(f.getName(), f.getVersion())) {
                filteredList.add(f);
                continue;
            }
            _log.info("The featureset " + f.getName() + ":" + f.getVersion() + " was not found.");
        }
        Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> featuresets = repositoryProcessor.getFeatures(filteredList, true, false);
        for (com.oracle.cie.gdr.dao.ftr.FeatureSet feature : featuresets) {
            if (StringUtil.isNullOrEmpty((String)feature.getRmProd(), (boolean)true)) continue;
            rmProducts.add(FeatureSetImpl.newInstance(feature, new MetaDataHome(gdrDir), null));
        }
        return rmProducts;
    }

    private File getGdrMetaDataDir(RepoCommonConfig repoCommonConfig) {
        String gdrPath = repoCommonConfig.getProperty(TopLevelDirectoryService.GDR_PATH_PROPERTY);
        if (StringUtil.isNullOrEmpty((String)gdrPath, (boolean)true)) {
            gdrPath = repoCommonConfig.getRepoBaseDir() + File.separator + "gdr" + File.separator + "dev";
        }
        return new File(gdrPath);
    }
}

