/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.DirectoryMap;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.FileMap;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.Mapping;
import com.oracle.cie.gdr.external.impl.MappingImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class DirectoryMapImpl
implements DirectoryMap {
    private com.oracle.cie.gdr.dao.dbd.DirectoryMap _directoryMap;
    private Distribution _parentDistribution;
    private MetaDataHome _metaDataHome;

    DirectoryMapImpl(com.oracle.cie.gdr.dao.dbd.DirectoryMap directoryMap, Distribution distribution, MetaDataHome metaDataHome) {
        this._directoryMap = directoryMap;
        this._parentDistribution = distribution;
        this._metaDataHome = metaDataHome;
    }

    @Override
    public List<Mapping> getMappings() {
        MappingImpl mapping = null;
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        for (com.oracle.cie.gdr.dao.dbd.Mapping mappingDao : this._directoryMap.getMappings()) {
            mapping = new MappingImpl(mappingDao, this._metaDataHome);
            mappings.add(mapping);
        }
        if (null != this._directoryMap.getRootMapping()) {
            mapping = new MappingImpl(this._directoryMap.getRootMapping(), this._metaDataHome);
            mappings.add(mapping);
        }
        return mappings;
    }

    @Override
    public List<Mapping> getMappings(FeatureSet feature) throws InventoryException {
        if (!this._parentDistribution.getFeatureSets().contains(feature)) {
            throw new InventoryException("The Feature Set is not present in this distribution.");
        }
        HashSet<Mapping> featureMappings = new HashSet<Mapping>();
        for (Component component : feature.getComponents()) {
            featureMappings.addAll(this.getMappings(component));
        }
        return new ArrayList<Mapping>(featureMappings);
    }

    @Override
    public List<Mapping> getMappings(Component component) throws InventoryException {
        boolean isContainedInFeature = false;
        for (FeatureSet featureSet : this._parentDistribution.getFeatureSets()) {
            if (!featureSet.getComponents().contains(component)) continue;
            isContainedInFeature = true;
        }
        if (!isContainedInFeature) {
            throw new InventoryException("The Component is not present in this distribution.");
        }
        HashSet<Mapping> mappings = new HashSet<Mapping>();
        ArrayList<String> componentsSymbols = new ArrayList<String>();
        List<String> mappingsSymbols = null;
        for (FileMap fileMap : component.getFileMaps()) {
            componentsSymbols.add(fileMap.getSymbol());
        }
        block2: for (Mapping mapping : this.getMappings()) {
            mappingsSymbols = Arrays.asList(mapping.getSymbols());
            for (String componentSymbol : componentsSymbols) {
                if (!mappingsSymbols.contains(componentSymbol)) continue;
                mappings.add(mapping);
                continue block2;
            }
        }
        return new ArrayList<Mapping>(mappings);
    }

    @Override
    public List<Mapping> getMappings(String ... symbol) throws InventoryException {
        HashSet<Mapping> mappingsContainingSymbols = new HashSet<Mapping>();
        List<String> symbols = Arrays.asList(symbol);
        block0: for (Mapping mapping : this.getMappings()) {
            for (String mappingSymbol : mapping.getSymbols()) {
                if (!symbols.contains(mappingSymbol)) continue;
                mappingsContainingSymbols.add(mapping);
                continue block0;
            }
        }
        return new ArrayList<Mapping>(mappingsContainingSymbols);
    }
}

