/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.external.BaseInventory;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.impl.BaseInventoryImpl;
import com.oracle.cie.gdr.external.impl.InventoryCache;
import com.oracle.cie.gdr.external.impl.RepositoryComponentImpl;
import com.oracle.cie.gdr.external.impl.RepositoryDistributionImpl;
import com.oracle.cie.gdr.external.impl.RepositoryFeatureSetImpl;
import com.oracle.cie.gdr.repository.RepositoryProcessor;
import com.oracle.cie.repository.common.NextGenHelper;
import com.oracle.cie.repository.common.NextGenHelperFactory;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.rest.GavcSearchResult;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import com.oracle.cie.rest.impl.RepositoryImpl;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RepositoryInventoryImpl
extends BaseInventoryImpl
implements BaseInventory {
    private RepositoryProcessor _repositoryProcessor;
    private RestHandler _restHandler = RestFactory.getRestHandler();
    private NextGenHelper _nextGenHelper = NextGenHelperFactory.getNextGenHelper((RestHandler)this._restHandler);
    private RepositoryVersionResolver _versionResolver;
    private RepoCommonConfig _repoCommonConfig;
    private static final Map<String, Map<String, Artifact>> _gavcSearchCache = new HashMap<String, Map<String, Artifact>>();

    RepositoryInventoryImpl(List<URL> urls, String username, String password, File localCacheRepo, Properties properties) throws RestException, RepositoryCommonException, IOException, DependencyManagementException {
        List<Repository> repositories = this.getRepositories(urls, username, password, localCacheRepo);
        this._repoCommonConfig = RepoCommonConfig.createRepoCommonConfig(repositories, (File)localCacheRepo, (Properties)properties, null);
        if (!this._repoCommonConfig.hasProperty("USE_LATEST")) {
            this._repoCommonConfig.setProperty("USE_LATEST", "true");
        }
        this._versionResolver = this._nextGenHelper.getConfiguredRepositoryVersionResolver(this._repoCommonConfig);
        this._repositoryProcessor = new RepositoryProcessor(this._restHandler, this._versionResolver, this.getGdrMetaDataDir(), repositories, false);
    }

    File getGdrMetaDataDir() {
        return null;
    }

    RepositoryInventoryImpl(List<URL> urls, String username, String password, File localCacheRepo, File propertiesLocation) throws RestException, RepositoryCommonException, IOException, DependencyManagementException {
        List<Repository> repositories = this.getRepositories(urls, username, password, localCacheRepo);
        this._repoCommonConfig = RepoCommonConfig.createRepoCommonConfig(repositories, (File)localCacheRepo, (File)propertiesLocation, null);
        if (!this._repoCommonConfig.hasProperty("USE_LATEST")) {
            this._repoCommonConfig.setProperty("USE_LATEST", "true");
        }
        this._versionResolver = this._nextGenHelper.getConfiguredRepositoryVersionResolver(this._repoCommonConfig);
        this._repositoryProcessor = new RepositoryProcessor(this._restHandler, this._versionResolver, this.getGdrMetaDataDir(), repositories, false);
    }

    private List<Repository> getRepositories(List<URL> urls, String username, String password, File localCacheRepo) {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (URL url : urls) {
            repositories.add((Repository)new RepositoryImpl(null, RepositoryType.REMOTE, url.toString(), null, username, password));
        }
        return repositories;
    }

    @Override
    public Collection<Distribution> getDistributions() throws InventoryException {
        LinkedHashSet<Distribution> distributions = new LinkedHashSet<Distribution>();
        try {
            for (Map.Entry<String, Artifact> entry : this.getUniqueArtifactsMap("com.oracle.cie.gdr.distribution", "xml").entrySet()) {
                distributions.add(this.getDistribution(entry.getValue().getName(), entry.getValue().getBaseVersion()));
            }
        }
        catch (Exception anyException) {
            throw new InventoryException(anyException);
        }
        return distributions;
    }

    @Override
    public Distribution getDistribution(String name, String version) throws InventoryException {
        try {
            Distribution cachedDistribution = InventoryCache.getInstance().getDistribution(this._repoCommonConfig.getCacheRepository(), name, version);
            if (null == cachedDistribution) {
                cachedDistribution = RepositoryDistributionImpl.newInstance(name, version, this._repositoryProcessor, this._versionResolver, this._repoCommonConfig.getCacheRepository());
                InventoryCache.getInstance().putDistribution(this._repoCommonConfig.getCacheRepository(), cachedDistribution);
            }
            return cachedDistribution;
        }
        catch (Exception anyException) {
            throw new InventoryException(anyException);
        }
    }

    @Override
    public Collection<FeatureSet> getFeatureSets() throws InventoryException {
        LinkedHashSet<FeatureSet> features = new LinkedHashSet<FeatureSet>();
        try {
            for (Map.Entry<String, Artifact> entry : this.getUniqueArtifactsMap("com.oracle.cie.gdr.featureset", "xml").entrySet()) {
                features.add(this.getFeatureSet(entry.getValue().getName(), entry.getValue().getBaseVersion()));
            }
        }
        catch (Exception anyException) {
            throw new InventoryException(anyException);
        }
        return features;
    }

    private Map<String, Artifact> getUniqueArtifactsMap(String groupId, String type) throws RestException {
        Map<String, Artifact> uniqueArtifacts = new HashMap<String, Artifact>();
        for (Repository repository : this._repoCommonConfig.getRepositories()) {
            if (_gavcSearchCache.containsKey(groupId + "_" + repository)) {
                uniqueArtifacts = _gavcSearchCache.get(groupId + "_" + repository);
                continue;
            }
            GavcSearchResult gavcSearchResult = this._restHandler.gavcSearch(groupId, null, null, null, repository, true);
            if (gavcSearchResult != null && gavcSearchResult.getArtifactMap() != null) {
                for (Map.Entry entry : gavcSearchResult.getArtifactMap().entrySet()) {
                    Artifact artifact;
                    String uniqueKey = ((Artifact)entry.getKey()).getName() + "_" + ((Artifact)entry.getKey()).getBaseVersion();
                    if (uniqueArtifacts.containsKey(uniqueKey) || !this._restHandler.artifactExists(artifact = DependencyManagementFactory.getInstance().getArtifact(groupId, ((Artifact)entry.getKey()).getName(), ((Artifact)entry.getKey()).getVersion(), type), repository)) continue;
                    uniqueArtifacts.put(uniqueKey, (Artifact)entry.getKey());
                }
            }
            _gavcSearchCache.put(groupId + "_" + repository, uniqueArtifacts);
        }
        return uniqueArtifacts;
    }

    @Override
    public FeatureSet getFeatureSet(String name, String version) throws InventoryException {
        try {
            FeatureSet cachedFeature = InventoryCache.getInstance().getFeatureSet(this._repoCommonConfig.getCacheRepository(), name, version);
            if (null == cachedFeature) {
                cachedFeature = RepositoryFeatureSetImpl.newInstance(name, version, this._repositoryProcessor, this._versionResolver, this._repoCommonConfig.getCacheRepository());
                InventoryCache.getInstance().putFeatureSet(this._repoCommonConfig.getCacheRepository(), cachedFeature);
            }
            return cachedFeature;
        }
        catch (Exception anyException) {
            throw new InventoryException(anyException);
        }
    }

    @Override
    public Collection<Component> getComponents() throws InventoryException {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        try {
            for (Map.Entry<String, Artifact> entry : this.getUniqueArtifactsMap("com.oracle.cie.gdr.carb", "carb").entrySet()) {
                components.add(this.getComponent(entry.getValue().getName(), entry.getValue().getBaseVersion()));
            }
        }
        catch (Exception anyException) {
            throw new InventoryException(anyException);
        }
        return components;
    }

    @Override
    public Component getComponent(String name, String version) throws InventoryException {
        try {
            Component cachedComponent = InventoryCache.getInstance().getComponent(this._repoCommonConfig.getCacheRepository(), name, version);
            if (null == cachedComponent) {
                cachedComponent = RepositoryComponentImpl.newInstance(name, version, this._repositoryProcessor, this._versionResolver);
                InventoryCache.getInstance().putComponent(this._repoCommonConfig.getCacheRepository(), cachedComponent);
            }
            return cachedComponent;
        }
        catch (Exception anyException) {
            throw new InventoryException(anyException);
        }
    }

    @Override
    protected MetaDataHome loadMetaDataHome(File metaDataHome) throws InventoryException {
        return null;
    }

    @Override
    protected MetaDataHome loadMetaDataHome(Path metaDataHome) throws InventoryException {
        return null;
    }
}

