/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.generation;

import com.oracle.cie.nextgen.common.utils.Util;

public enum GenerationType {
    COMPONENT("component"),
    FEATURESET("featureset"),
    DISTRIBUTION("distribution"),
    DISTRIBUTION_INFO("distribution-info"),
    GENERIC("generic");

    private String value;

    private GenerationType(String value) {
        this.value = value;
    }

    public static GenerationType getGenerationType(String genType) {
        if (DISTRIBUTION_INFO.getValue().equalsIgnoreCase(genType)) {
            return DISTRIBUTION_INFO;
        }
        if (FEATURESET.getValue().equalsIgnoreCase(genType)) {
            return FEATURESET;
        }
        if (DISTRIBUTION.getValue().equalsIgnoreCase(genType)) {
            return DISTRIBUTION;
        }
        if (COMPONENT.getValue().equalsIgnoreCase(genType)) {
            return COMPONENT;
        }
        throw new IllegalArgumentException("The generation type provided is not supported: " + genType);
    }

    public static GenerationType getEnum(String str) {
        if (Util.isNullOrBlank((String)str, (boolean)true)) {
            return null;
        }
        return Enum.valueOf(GenerationType.class, str);
    }

    public String getValue() {
        return this.value;
    }
}

