/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.dao.fsc.FeatureSetConsumption;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeatureSetConsumptionHelper
extends GdrHelper<FeatureSetConsumption> {
    private static final Logger _log = Logger.getLogger(FeatureSetConsumptionHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/fsc";
    public static final String FEATURE_SET_CONSUMPTION_DEF = "feature-set-consumption";
    public static final String FEATURE_SETS_CONSUMPTION_DIR = "restricted";
    public static final String RESTRICTED = "restricted";
    private static FeatureSetConsumptionHelper _instance;

    public static FeatureSetConsumptionHelper getInstance() {
        if (_instance == null) {
            _instance = new FeatureSetConsumptionHelper(null);
        }
        return _instance;
    }

    public static FeatureSetConsumptionHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return FeatureSetConsumptionHelper.getInstance();
        }
        return new FeatureSetConsumptionHelper(classLoader);
    }

    private FeatureSetConsumptionHelper(ClassLoader classLoader) {
        super(FeatureSetConsumption.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return FEATURE_SET_CONSUMPTION_DEF;
    }

    public String getPath() {
        return "featuresets" + File.separator + "restricted";
    }

    public FeatureSetConsumption getFeatureSetConsumption(File metaDataDir, FeatureSet feature) throws GdrException {
        FeatureSetConsumption featureConsumption = this.getFeatureSetConsumption(metaDataDir, feature.getName(), feature.getVersion());
        return featureConsumption;
    }

    public FeatureSetConsumption getFeatureSetConsumption(File metaDataDir, String name, String version) throws GdrException {
        FeatureSetConsumption feature;
        try {
            feature = (FeatureSetConsumption)((Object)this.getRootWrapperFromMetaDataDir(metaDataDir, this.getFeatureSetConsumptionFileName(name, version)));
        }
        catch (Exception anyException) {
            throw new GdrException((Throwable)anyException);
        }
        if (!name.equals(feature.getName()) || !version.equals(feature.getVersion())) {
            GdrException ex = new GdrException("The internal feature name and version is incorrect.  Expected: " + name + " " + version + " Defined: " + feature.getName() + " " + feature.getVersion());
            _log.throwing(FeatureSetConsumptionHelper.class.getName(), "getFeatureSetConsumption", ex);
            throw ex;
        }
        return feature;
    }

    public List<File> getFeatureSetConsumptionFiles(File metaDataDir) {
        List<Path> paths = this.getFeatureSetConsumptionPaths(NioHelper.getInstance().getPath(metaDataDir));
        ArrayList<File> files = new ArrayList<File>();
        for (Path path : paths) {
            files.add(path.toFile());
        }
        return files;
    }

    public List<Path> getFeatureSetConsumptionPaths(Path metaDataDir) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (metaDataDir != null && Files.isDirectory(metaDataDir, new LinkOption[0])) {
            paths.addAll(this.getFileLocatorService(metaDataDir).getPathsUnderPath(this.getPath()));
            Iterator it = paths.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".xml")) continue;
                it.remove();
            }
        }
        return paths;
    }

    public FeatureSetConsumption getFeatureSetConsumption(File FeatureSetConsumptionFile) throws IOException, DataHandlerException, GdrException {
        FeatureSetConsumption FeatureSetConsumption2 = null;
        if (FeatureSetConsumptionFile != null) {
            FeatureSetConsumption2 = (FeatureSetConsumption)this.getRootWrapper(FeatureSetConsumptionFile);
            if (!FeatureSetConsumptionFile.getName().equals(this.getFeatureSetConsumptionFileName(FeatureSetConsumption2))) {
                GdrException ex = new GdrException("The internal feature name and version is incorrect.  File name should be: " + this.getFeatureSetConsumptionFileName(FeatureSetConsumption2) + " File name is: " + FeatureSetConsumptionFile.getName());
                _log.throwing(FeatureSetConsumptionHelper.class.getName(), "getFeatureSetConsumption", ex);
                throw ex;
            }
        }
        return FeatureSetConsumption2;
    }

    public Set<FeatureSetConsumption> getFeatureSetConsumptions(File metaDataDir) throws IOException, DataHandlerException, GdrException {
        return this.getFeatureSetConsumptions(metaDataDir, false);
    }

    public Set<FeatureSetConsumption> getFeatureSetConsumptions(File metaDataDir, boolean ignoreParsingFailures) throws IOException, DataHandlerException, GdrException {
        LinkedHashSet<FeatureSetConsumption> FeatureSetConsumptions = new LinkedHashSet<FeatureSetConsumption>();
        if (metaDataDir != null && metaDataDir.isDirectory()) {
            for (File f : this.getFeatureSetConsumptionFiles(metaDataDir)) {
                FeatureSetConsumption feature;
                try {
                    feature = this.getFeatureSetConsumption(f);
                }
                catch (DataHandlerException dhe) {
                    if (!ignoreParsingFailures) {
                        throw dhe;
                    }
                    _log.log(Level.WARNING, "Error parsing feature set file " + f, dhe);
                    continue;
                }
                FeatureSetConsumptions.add(feature);
            }
        }
        return FeatureSetConsumptions;
    }

    public Set<FeatureSetConsumption> getFeatureSetsConsumptions(Collection<FeatureSet> features, File metaDataDir) throws IOException, DataHandlerException, GdrException {
        LinkedHashSet<FeatureSetConsumption> featuresConsumptions = new LinkedHashSet<FeatureSetConsumption>();
        if (features != null && !features.isEmpty()) {
            for (FeatureSet feature : features) {
                FeatureSetConsumption featureConsumption = this.getFeatureSetConsumption(metaDataDir, feature);
                featuresConsumptions.add(featureConsumption);
            }
        }
        return featuresConsumptions;
    }

    public String getFeatureSetConsumptionFileName(FeatureSetConsumption featureConsumption) {
        return this.getFeatureSetConsumptionFileName(featureConsumption.getName(), featureConsumption.getVersion());
    }

    public String getFeatureSetConsumptionFileName(String name, String version) {
        return this.getFeatureSetConsumptionBaseFileName(name, version) + ".xml";
    }

    public String getFeatureSetConsumptionBaseFileName(String name, String version) {
        return name + "_" + version + "_" + "restricted";
    }
}

