/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.packaging;

import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.dbd.Mapping;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class PackagerComponentTarget
extends ComponentTarget {
    private Component _extComponent;
    private List<FileTarget> _fileTargets;
    private Mode _packagingMode = Mode.PACKAGE_COMPONENT;
    private static final Logger _log = Logger.getLogger(PackagerComponentTarget.class.getName());

    public PackagerComponentTarget(Component component, FileMap componentFileMap, ServiceHolder serviceHolder, Mode packagingMode) {
        this(component, null, componentFileMap, serviceHolder, packagingMode);
    }

    public PackagerComponentTarget(Component baseComponent, Component extComponent, FileMap componentFileMap, ServiceHolder serviceHolder, Mode packagingMode) {
        this(baseComponent, extComponent, componentFileMap, serviceHolder, null, packagingMode);
    }

    public PackagerComponentTarget(Component baseComponent, Component extComponent, FileMap componentFileMap, ServiceHolder serviceHolder, Mapping locationMapping, Mode packagingMode) {
        super(baseComponent, componentFileMap, serviceHolder, locationMapping);
        if (baseComponent != extComponent) {
            this._extComponent = extComponent;
        }
        this._packagingMode = packagingMode;
    }

    public Component getFileMapComponent() {
        if (this._extComponent != null) {
            return this._extComponent;
        }
        return this.getComponent();
    }

    @Override
    public List<FileTarget> getFileTargets() throws GdrException {
        if (this._fileTargets == null) {
            if (this.getFileMapComponent().isComponentArchive() && !this.getComponentFileMap().isExpanded()) {
                GdrException ex = new GdrException("File targets are not available for components which have already been packaged since source fields have been cleared.");
                _log.throwing(PackagerComponentTarget.class.getName(), "getFileTargets", ex);
                throw ex;
            }
            this._fileTargets = ComponentHelper.getInstance().getFilesForPackaging(this, this._packagingMode);
            for (String location : ComponentHelper.RESTRICTED_INSTALL_LOCATIONS) {
                if (this.locateFileTarget(location) == null) continue;
                _log.warning("The component " + this.getComponent() + " is attempting to install files to the restricted location " + location);
            }
        }
        return new ArrayList<FileTarget>(this._fileTargets);
    }
}

