/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch;

import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.patch.PatchHandlerImpl;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.LocalizedGdrException;
import java.util.logging.Logger;

public class PatchLockedRegistryHandler {
    private static final Logger _log = Logger.getLogger(PatchLockedRegistryHandler.class.getName());
    private Home _home;
    private Registry _lockedRegistry;

    public PatchLockedRegistryHandler(Home home) {
        this._home = home;
    }

    public Home getHome() {
        return this._home;
    }

    public Registry getLockedRegistry() throws GdrException {
        if (this._lockedRegistry == null) {
            try {
                this._lockedRegistry = this.getHome().lockRegistry();
            }
            catch (Exception e) {
                LocalizedGdrException ex = new LocalizedGdrException("70014", e, this.getHome());
                _log.throwing(PatchHandlerImpl.class.getName(), "processPatch", (Throwable)((Object)ex));
                throw ex;
            }
        }
        return this._lockedRegistry;
    }

    public void unlockRegistry(boolean persistChanges) throws GdrException {
        if (this._lockedRegistry != null) {
            this._lockedRegistry = null;
            if (this.getHome().isRegistryLocked()) {
                if (persistChanges) {
                    try {
                        this.getHome().unlockRegistry();
                    }
                    catch (Exception e) {
                        LocalizedGdrException ex = new LocalizedGdrException("70015", e, this.getHome());
                        _log.throwing(PatchHandlerImpl.class.getName(), "processPatch", (Throwable)((Object)ex));
                        throw ex;
                    }
                }
                try {
                    this.getHome().releaseRegistryLock();
                }
                catch (Exception e) {
                    LocalizedGdrException ex = new LocalizedGdrException("70015", e, this.getHome());
                    _log.throwing(PatchHandlerImpl.class.getName(), "processPatch", (Throwable)((Object)ex));
                    throw ex;
                }
            }
        }
    }
}

