/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.gdr.helpers.LocaleInfoHelper;
import com.oracle.cie.gdr.locale.LocaleInfoHolder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class LocaleService {
    private final Logger _log = Logger.getLogger(LocaleService.class.getName());
    private Set<Integer> _locales = new HashSet<Integer>();

    public static LocaleService getLocaleService() {
        return LocaleService.getLocaleService(null);
    }

    public static LocaleService getLocaleService(Collection<Integer> locales) {
        return new LocaleService(locales);
    }

    private LocaleService(Collection<Integer> locales) {
        this.setLocales(locales);
    }

    public Set<Integer> getLocales() {
        return this._locales;
    }

    public void setLocales(Collection<Integer> locales) {
        this._locales.clear();
        this.addLocales(locales);
    }

    public void addLocales(Collection<Integer> locales) {
        if (locales != null && !locales.isEmpty()) {
            for (Integer locale : locales) {
                this.addLocale(locale);
            }
        }
    }

    public void addLocale(Integer locale) {
        if (locale != null) {
            LocaleInfoHolder holder = LocaleInfoHelper.getInstance().getLocaleInfoHolderById(locale.intValue());
            if (holder == null) {
                this._log.warning("Unable to locate locale with name " + locale);
            } else if (holder.getId() == 2000) {
                Collection holders = LocaleInfoHelper.getInstance().getLocaleInfoHolders().values();
                for (LocaleInfoHolder tempHolder : holders) {
                    this._locales.add(tempHolder.getId());
                }
            } else {
                this._locales.add(locale);
            }
        }
    }

    public boolean contains(Integer locale) {
        return this._locales.contains(locale);
    }

    public boolean containsAll(Set<Integer> locales) {
        return this._locales.containsAll(locales);
    }

    public boolean contains(String locale) {
        return this._locales.contains(LocaleInfoHelper.getInstance().getLocaleInfoHolder(locale).getId());
    }
}

