/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.session;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.services.VariableResolverService;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;

public class BaseSession {
    private static final Logger _log = Logger.getLogger(BaseSession.class.getName());
    protected Home _home;
    protected MetaDataHome _metaDataHome;
    protected ServiceHolder _serviceHolder;

    public BaseSession(MetaDataHome metaDataHome, File homeDir, Set<Integer> platforms, Set<Integer> locales) throws GdrException, IOException, DataHandlerException {
        this(metaDataHome, NioHelper.getInstance().getPath(homeDir), platforms, locales);
    }

    public BaseSession(MetaDataHome metaDataHome, Path homeDir, Set<Integer> platforms, Set<Integer> locales) throws GdrException, IOException, DataHandlerException {
        this(metaDataHome, homeDir != null ? Home.getHome(homeDir) : null, platforms, locales);
    }

    public BaseSession(MetaDataHome metaDataHome, Home home, Set<Integer> platforms, Set<Integer> locales) throws GdrException, IOException, DataHandlerException {
        if (metaDataHome == null) {
            GdrException ex = new GdrException("The meta-data home was null.");
            _log.throwing(BaseSession.class.getName(), "BaseSession", ex);
            throw ex;
        }
        this._metaDataHome = metaDataHome;
        this._home = home;
        if (this._home != null) {
            this._metaDataHome.setClassLoader(this._home.getClassLoader());
        }
        if (platforms == null || platforms.isEmpty()) {
            if (platforms == null) {
                platforms = new HashSet<Integer>();
            }
            platforms.add(PlatformInfoHelper.getInstance().getCurrentPlatformId());
        }
        this._serviceHolder = new ServiceHolder(platforms, locales, null);
        this.initVariables();
    }

    public BaseSession(File homeDir) throws GdrException, IOException, DataHandlerException {
        this(NioHelper.getInstance().getPath(homeDir));
    }

    public BaseSession(Path homeDir) throws GdrException, IOException, DataHandlerException {
        if (homeDir == null) {
            GdrException ex = new GdrException("The home directory was null.");
            _log.throwing(BaseSession.class.getName(), "BaseSession", ex);
            throw ex;
        }
        this._home = Home.getHome(homeDir);
        this._metaDataHome = this._home.getMetaDataHome();
        this.initVariables();
    }

    public File getHomeDir() {
        return this._home != null ? this._home.getHome() : null;
    }

    public Path getHomeDirPath() {
        return this._home != null ? this._home.getHomePath() : null;
    }

    public Home getHome() {
        return this._home;
    }

    public void setHomeDir(File homeDir) throws GdrException {
        this.setHomeDir(NioHelper.getInstance().getPath(homeDir));
    }

    public void setHomeDir(Path homeDir) throws GdrException {
        try {
            this.setHome(Home.getHome(homeDir));
            this.initVariables();
        }
        catch (GdrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GdrException((Throwable)e);
        }
    }

    public void setFederatedHomes(Collection<File> homes) throws GdrException {
        LinkedHashSet<Path> homePaths = null;
        if (homes != null) {
            homePaths = new LinkedHashSet<Path>();
            for (File home : homes) {
                homePaths.add(NioHelper.getInstance().getPath(home));
            }
        }
        this.setFederatedHomePaths(homePaths);
    }

    public void setFederatedHomePaths(Collection<Path> homes) throws GdrException {
        try {
            this.getHome().setSessionFederatedHomes(homes);
        }
        catch (GdrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GdrException((Throwable)e);
        }
    }

    protected void initVariables() {
        Path homeDir = this.getHomeDirPath();
        if (homeDir != null) {
            VariableResolverService.getVariableResolverService().set("ORACLE_HOME", homeDir.toString());
        }
    }

    public void setHome(Home home) throws GdrException {
        this._home = home;
        ClassLoader classLoader = this._home != null ? this._home.getClassLoader() : null;
        this._metaDataHome.setClassLoader(classLoader);
    }

    public MetaDataHome getMetaDataHome() {
        return this._metaDataHome;
    }

    public ServiceHolder getServiceHolder() {
        return this._serviceHolder;
    }
}

