/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Library;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dei.DeInstallInfo;
import com.oracle.cie.gdr.dao.ftr.FeatureLibrary;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DeInstallInfoHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.libraries.LibraryVisibility;
import com.oracle.cie.gdr.services.ServiceHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class InstallationSizeAnalyzer {
    private File _oracleHome;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: " + InstallationSizeAnalyzer.class.getName() + " <oraclehome>");
            System.exit(-1);
        }
        File oracleHome = new File(args[0]);
        try {
            new InstallationSizeAnalyzer(oracleHome).analyse();
        }
        catch (InstallationSizeAnalyserException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public InstallationSizeAnalyzer(File oracleHome) {
        this._oracleHome = oracleHome;
    }

    public void analyse() throws InstallationSizeAnalyserException {
        if (this._oracleHome == null) {
            throw new InstallationSizeAnalyserException("OracleHome provided was null.");
        }
        if (!this._oracleHome.isDirectory()) {
            throw new InstallationSizeAnalyserException("OracleHome provided did not exist or was not a directory: " + this._oracleHome);
        }
        try {
            ArrayList files = new ArrayList();
            IOUtil.getFileList((File)this._oracleHome, files, (boolean)true);
            long totalSize = 0L;
            ArrayList<File> canonicalFiles = new ArrayList<File>();
            for (File f : files) {
                File canonicalFile;
                if (f.isDirectory() || canonicalFiles.contains(canonicalFile = f.getCanonicalFile())) continue;
                canonicalFiles.add(canonicalFile);
                totalSize += f.length();
            }
            long remainingSize = totalSize;
            long calculatedSize = 0L;
            Set<Component> components = this.getComponents();
            if (components != null && !components.isEmpty()) {
                File f;
                Iterator it;
                Object libName;
                File f2;
                Iterator it2;
                Set<String> locations;
                for (Component component : components) {
                    Collection<ComponentTarget> targets = component.getComponentTargets();
                    for (ComponentTarget componentTarget : targets) {
                        calculatedSize += componentTarget.getSize();
                        List<FileTarget> fileTargets = componentTarget.getFileTargets();
                        block5: for (FileTarget fileTarget : fileTargets) {
                            File destFile = new File(this._oracleHome, fileTarget.getDest());
                            Iterator it22 = files.iterator();
                            while (it22.hasNext()) {
                                File f22 = (File)it22.next();
                                if (!destFile.equals(f22)) continue;
                                remainingSize -= f22.length();
                                it22.remove();
                                continue block5;
                            }
                        }
                    }
                    block7: for (Library library : component.getLibraries()) {
                        if (LibraryType.getLibraryType(library.getType()).isNone() || LibraryVisibility.getLibraryVisibility(library.getVisibility()) == LibraryVisibility.none || LibraryType.getLibraryType(library.getType()).isManifest()) continue;
                        calculatedSize += library.getSize();
                        locations = library.getLocation();
                        block8: for (String location : locations) {
                            String libName2 = location + this.getLibraryName(library.getName(), library.getVersion(), library.getSuppressVersion(), component.getVersion(), library.getExtension());
                            libName2 = libName2.replace("/", File.separator);
                            it2 = files.iterator();
                            while (it2.hasNext()) {
                                f2 = (File)it2.next();
                                if (!f2.getPath().endsWith(libName2)) continue;
                                remainingSize -= f2.length();
                                it2.remove();
                                continue block8;
                            }
                        }
                        if (!locations.isEmpty()) continue;
                        libName = this.getLibraryName(library.getName(), library.getVersion(), library.getSuppressVersion(), component.getVersion(), library.getExtension());
                        it = files.iterator();
                        while (it.hasNext()) {
                            f = (File)it.next();
                            if (!f.getPath().endsWith((String)libName)) continue;
                            remainingSize -= f.length();
                            it.remove();
                            continue block7;
                        }
                    }
                }
                Set<FeatureSet> features = this.getFeatures();
                if (features != null && !components.isEmpty()) {
                    for (FeatureSet feature : features) {
                        block12: for (FeatureLibrary featureLibrary : feature.getLibraries()) {
                            if (LibraryType.getLibraryType(featureLibrary.getType()).isNone() || LibraryVisibility.getLibraryVisibility(featureLibrary.getVisibility()) == LibraryVisibility.none || LibraryType.getLibraryType(featureLibrary.getType()).isManifest()) continue;
                            calculatedSize += featureLibrary.getSize();
                            locations = featureLibrary.getLocation();
                            block13: for (String location : locations) {
                                String libName2 = location + this.getLibraryName(featureLibrary.getName(), featureLibrary.getVersion(), featureLibrary.getSuppressVersion(), feature.getVersion(), featureLibrary.getExtension());
                                libName2 = libName2.replace("/", File.separator);
                                it2 = files.iterator();
                                while (it2.hasNext()) {
                                    f2 = (File)it2.next();
                                    if (!f2.getPath().endsWith(libName2)) continue;
                                    remainingSize -= f2.length();
                                    it2.remove();
                                    continue block13;
                                }
                            }
                            if (!locations.isEmpty()) continue;
                            libName = this.getLibraryName(featureLibrary.getName(), featureLibrary.getVersion(), featureLibrary.getSuppressVersion(), feature.getVersion(), featureLibrary.getExtension());
                            it = files.iterator();
                            while (it.hasNext()) {
                                f = (File)it.next();
                                if (!f.getPath().endsWith((String)libName)) continue;
                                remainingSize -= f.length();
                                it.remove();
                                continue block12;
                            }
                        }
                    }
                }
            }
            System.out.println("Total Size: " + this.getConvertedSize(totalSize));
            System.out.println("Calculated Size: " + this.getConvertedSize(calculatedSize));
            System.out.println("Unaccounted Size: " + this.getConvertedSize(remainingSize));
            System.out.println("Unaccounted Files: ");
            for (File file : files) {
                if (file.isDirectory()) {
                    System.out.println("Directory: " + file);
                    continue;
                }
                System.out.println("File: " + file);
            }
        }
        catch (Exception e) {
            throw new InstallationSizeAnalyserException((Throwable)e);
        }
    }

    private String getLibraryName(String libraryName, String libraryVersion, Boolean supressVersion, String version, String extension) {
        String libName = File.separator + libraryName;
        String libVersion = "";
        libVersion = libraryVersion == null && ComponentHelper.getShortenedVersion(version) != null ? ComponentHelper.getShortenedVersion(version) : libraryVersion;
        if (!supressVersion.booleanValue()) {
            libName = libName + "_" + libVersion;
        }
        libName = libName + "." + extension;
        return libName;
    }

    private Set<FeatureSet> getFeatures() throws InstallationSizeAnalyserException {
        try {
            Home home = Home.getHome(this._oracleHome);
            MetaDataHome metaDataHome = home.getMetaDataHome();
            HashSet<Integer> platforms = new HashSet<Integer>();
            platforms.add(home.getRegistry().getPlatform());
            Collection<DistributionTarget> distributionTargets = home.getInstalledDistributions();
            if (distributionTargets == null || distributionTargets.isEmpty()) {
                throw new InstallationSizeAnalyserException("OracleHome provided did not contain any installed distributions: " + this._oracleHome);
            }
            ArrayList<Distribution> distributions = new ArrayList<Distribution>();
            for (DistributionTarget target : distributionTargets) {
                distributions.add(target.getDistribution());
            }
            File deInstallInfoFile = DeInstallInfoHelper.getInstance().getDeInstallInfoFile(home.getInventoryDirectory());
            if (deInstallInfoFile.exists()) {
                // empty if block
            }
            FeatureLoader featureLoader = new FeatureLoader(metaDataHome);
            return featureLoader.getFeatureSets();
        }
        catch (Exception e) {
            throw new InstallationSizeAnalyserException((Throwable)e);
        }
    }

    private String getConvertedSize(long bytes) {
        long unit = 1024L;
        if (bytes < unit) {
            return bytes + "B";
        }
        long mb = bytes / (unit * unit);
        return mb + "MB";
    }

    private Set<Component> getComponents() throws InstallationSizeAnalyserException {
        try {
            Home home = Home.getHome(this._oracleHome);
            MetaDataHome metaDataHome = home.getMetaDataHome();
            HashSet<Integer> platforms = new HashSet<Integer>();
            platforms.add(home.getRegistry().getPlatform());
            ServiceHolder serviceHolder = new ServiceHolder(platforms, null, null);
            Collection<DistributionTarget> distributionTargets = home.getInstalledDistributions();
            if (distributionTargets == null || distributionTargets.isEmpty()) {
                throw new InstallationSizeAnalyserException("OracleHome provided did not contain any installed distributions: " + this._oracleHome);
            }
            ArrayList<Distribution> distributions = new ArrayList<Distribution>();
            for (DistributionTarget target : distributionTargets) {
                distributions.add(target.getDistribution());
            }
            DirectoryMap directoryMap = DistributionHelper.getInstance().mergeDirectoryMaps(distributions, new DirectoryMap[0]);
            DeInstallInfo deInstallInfo = null;
            File deInstallInfoFile = DeInstallInfoHelper.getInstance().getDeInstallInfoFile(home.getInventoryDirectory());
            if (deInstallInfoFile.exists()) {
                deInstallInfo = DeInstallInfoHelper.getInstance().getDeInstallInfo(deInstallInfoFile);
            }
            ComponentLoader componentLoader = new ComponentLoader(metaDataHome, serviceHolder, Mode.DEINSTALL, home.getInstalledFeatures(), directoryMap, deInstallInfo);
            return componentLoader.getComponents();
        }
        catch (Exception e) {
            throw new InstallationSizeAnalyserException((Throwable)e);
        }
    }

    public class InstallationSizeAnalyserException
    extends Exception {
        public InstallationSizeAnalyserException(Throwable cause) {
            super(cause);
        }

        public InstallationSizeAnalyserException(String message, Throwable cause) {
            super(message, cause);
        }

        public InstallationSizeAnalyserException(String message) {
            super(message);
        }
    }
}

