/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.common.NLS;
import com.oracle.cie.gdr.tools.NextGenPropertiesManager;
import com.oracle.cie.nextgen.common.logging.LoggingException;
import com.oracle.cie.nextgen.common.logging.OUILogManager;
import com.oracle.cie.nextgen.common.logging.OUILogManagerFactory;
import com.oracle.cie.nextgen.common.utils.JavaHomeException;
import java.io.File;
import java.util.HashMap;

public class SetProperty {
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILURE = 1;
    private static final String CMD = "setProperty";
    private static final String NAME_OPT = "-name";
    private static final String VALUE_OPT = "-value";
    private static final String JRE_LOC_OPT = "-jreLoc";
    private static final String ORACLE_HOME_OPT = "-oracleHome";
    private static final String DEBUG_OPT = "-debug";
    private static final String FORCE_OPT = "-force";
    private static final String HELP_OPT = "-help";

    private SetProperty() {
    }

    public static void main(String[] args) {
        String msg;
        HashMap<String, String> argMap = SetProperty.parseArgs(args);
        if (argMap == null || argMap.containsKey(HELP_OPT)) {
            SetProperty.doExit(SetProperty.getUsage(CMD), 1);
        }
        if ((msg = SetProperty.validateArgs(argMap)) != null) {
            SetProperty.doExit(msg, 1);
        }
        String ohLoc = argMap.get(ORACLE_HOME_OPT);
        String name = argMap.get(NAME_OPT);
        String value = argMap.get(VALUE_OPT);
        boolean force = Boolean.parseBoolean(argMap.get(FORCE_OPT));
        try {
            String debug = argMap.get(DEBUG_OPT);
            if (debug == null) {
                debug = "false";
            }
            String logDir = ohLoc + File.separator + "cfgtoollogs" + File.separator + "oui";
            System.setProperty("oracle.installer.debug", debug);
            System.setProperty("oracle.installer.logPath", logDir);
            OUILogManager manager = OUILogManagerFactory.getInstance();
            manager.setupLogging(CMD);
        }
        catch (LoggingException debug) {
            // empty catch block
        }
        NextGenPropertiesManager manager = NextGenPropertiesManager.getInstance();
        manager.setOraHomePath(ohLoc);
        try {
            if (name.startsWith("JAVA_HOME")) {
                value = manager.updateJavaHome(name, value, force);
            } else {
                manager.addVariable(name, value);
            }
        }
        catch (JavaHomeException e) {
            SetProperty.doExit(e.getMessage(), 1);
        }
        catch (NextGenPropertiesManager.UnsupportedCharacterException e) {
            SetProperty.doExit(e.getMessage(), 1);
        }
        SetProperty.doExit(NLS.getMsg("SetProperty.successful", name, value), 0);
    }

    private static void doExit(String msg, int exitCode) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.exit(exitCode);
    }

    private static HashMap<String, String> parseArgs(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        boolean err = false;
        for (int i = 0; i < args.length; ++i) {
            String optValue;
            String optName = args[i];
            String string = optValue = i + 1 < args.length ? args[i + 1] : null;
            if (optName.equalsIgnoreCase(NAME_OPT)) {
                if (optValue == null) {
                    err = true;
                    continue;
                }
                map.put(NAME_OPT, optValue);
                ++i;
                continue;
            }
            if (optName.equalsIgnoreCase(VALUE_OPT)) {
                if (optValue == null) {
                    err = true;
                    continue;
                }
                map.put(VALUE_OPT, optValue);
                ++i;
                continue;
            }
            if (optName.equalsIgnoreCase(ORACLE_HOME_OPT)) {
                if (optValue == null) {
                    err = true;
                    continue;
                }
                map.put(ORACLE_HOME_OPT, optValue);
                ++i;
                continue;
            }
            if (optName.equalsIgnoreCase(JRE_LOC_OPT)) {
                if (optValue == null) {
                    err = true;
                    continue;
                }
                map.put(JRE_LOC_OPT, optValue);
                ++i;
                continue;
            }
            if (optName.equalsIgnoreCase(HELP_OPT)) {
                map.put(HELP_OPT, "");
                continue;
            }
            if (optName.equalsIgnoreCase(DEBUG_OPT)) {
                map.put(DEBUG_OPT, "true");
                continue;
            }
            if (optName.equalsIgnoreCase(FORCE_OPT)) {
                map.put(FORCE_OPT, "true");
                continue;
            }
            err = true;
        }
        if (err) {
            return null;
        }
        return map;
    }

    private static String validateArgs(HashMap<String, String> argMap) {
        String msg = null;
        if (!argMap.containsKey(NAME_OPT)) {
            msg = NLS.getMsg("SetProperty.missing.option", NAME_OPT);
        } else if (StringUtil.isNullOrEmpty((String)argMap.get(NAME_OPT))) {
            msg = NLS.getMsg("SetProperty.missing.value", NAME_OPT);
        } else if (!argMap.containsKey(VALUE_OPT)) {
            msg = NLS.getMsg("SetProperty.missing.option", VALUE_OPT);
        } else if (!argMap.containsKey(ORACLE_HOME_OPT)) {
            msg = NLS.getMsg("SetProperty.missing.option", ORACLE_HOME_OPT);
        } else if (StringUtil.isNullOrEmpty((String)argMap.get(ORACLE_HOME_OPT))) {
            msg = NLS.getMsg("SetProperty.missing.value", ORACLE_HOME_OPT);
        }
        return msg;
    }

    private static String getUsage(String cmd) {
        StringBuffer sb = new StringBuffer();
        String ls = System.getProperty("line.separator");
        sb.append(NLS.getMsg("SetProperty.usage", CMD));
        sb.append(ls);
        sb.append("  -name <property name>");
        sb.append(ls);
        sb.append("  -value <property value>");
        sb.append(ls);
        sb.append("  -jreLoc <Java Home>");
        sb.append(ls);
        sb.append("  -debug");
        sb.append(ls);
        sb.append("  -help");
        sb.append(ls);
        return sb.toString();
    }
}

