/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.TempFileHandler;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfo;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.Components;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.repository.RepositoryFeatureLoader;
import com.oracle.cie.gdr.services.TopLevelDirectoryService;
import com.oracle.cie.gdr.utils.ComponentArchiveMerger;
import com.oracle.cie.gdr.utils.ComponentArchiveUtils;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.repository.common.CommonCommandLine;
import com.oracle.cie.repository.common.NextGenHelperFactory;
import com.oracle.cie.repository.common.RepositoryUtils;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.repository.resolver.RepositoryVersionResolverException;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeatureArchiveBuilder
extends CommonCommandLine {
    private static final Logger _log = Logger.getLogger(FeatureArchiveBuilder.class.getName());
    private String _featureArchiveName;
    private String _featureArchiveVersion;
    private File _outputDir;
    private RepositoryVersionResolver _versionResolver;
    private String _versionQualifier;
    private boolean _createArchive;
    private boolean _outputDirRepositoryLayout = false;
    private File _createdFarbsFile;
    private DependencyFileType _createdFarbsFileType = DependencyFileType.pom;

    public FeatureArchiveBuilder(String featureArchiveName, String featureArchiveVersion, File outputDir, String versionQualifier) {
        this(featureArchiveName, featureArchiveVersion, null, outputDir, versionQualifier, false, true);
    }

    public FeatureArchiveBuilder(String featureArchiveName, String featureArchiveVersion, RepositoryVersionResolver versionResolver, File outputDir, String versionQualifier) {
        this(featureArchiveName, featureArchiveVersion, versionResolver, outputDir, versionQualifier, true, true);
    }

    public FeatureArchiveBuilder(String featureArchiveName, String featureArchiveVersion, RepositoryVersionResolver versionResolver, File outputDir, String versionQualifier, boolean outputDirRepositoryLayout, boolean createArchive) {
        if (StringUtil.isNullOrEmpty((String)featureArchiveName, (boolean)true)) {
            throw new NullPointerException("The feature archive name specified was null or empty.");
        }
        if (StringUtil.isNullOrEmpty((String)featureArchiveVersion, (boolean)true)) {
            throw new NullPointerException("The feature archive version specified was null or empty.");
        }
        if (outputDir == null) {
            throw new NullPointerException("The output directory specified was null.");
        }
        this._featureArchiveName = featureArchiveName;
        this._featureArchiveVersion = featureArchiveVersion;
        this._versionResolver = versionResolver;
        this._outputDir = outputDir;
        this._versionQualifier = versionQualifier;
        this._outputDirRepositoryLayout = outputDirRepositoryLayout;
        this._createArchive = createArchive;
    }

    public File getCreatedFarbsFile() {
        return this._createdFarbsFile;
    }

    public void setCreatedFarbsFile(File createdFarbsFile) {
        this._createdFarbsFile = createdFarbsFile;
    }

    public DependencyFileType getCreatedFarbsFileType() {
        return this._createdFarbsFileType;
    }

    public void setCreatedFarbsFileType(DependencyFileType createdFarbsFileType) {
        this._createdFarbsFileType = createdFarbsFileType;
    }

    public File build(Set<FeatureSetReference> featureSetsRefs) throws RestException, IOException, RepositoryVersionResolverException, DataHandlerException, GdrException, DependencyManagementException {
        return this.build(featureSetsRefs, null, null);
    }

    public File build(Set<FeatureSetReference> featureSetsRefs, File metaDataDir, Collection<File> stageDirs) throws RestException, IOException, RepositoryVersionResolverException, DataHandlerException, GdrException, DependencyManagementException {
        return this.build(featureSetsRefs, metaDataDir, stageDirs, null, null);
    }

    public File build(Set<FeatureSetReference> featureSetsRefs, File metaDataDir, Collection<File> stageDirs, Map<String, String> manifestEntries) throws RestException, IOException, RepositoryVersionResolverException, DataHandlerException, GdrException, DependencyManagementException {
        return this.build(featureSetsRefs, metaDataDir, stageDirs, null, manifestEntries);
    }

    public File build(Set<FeatureSetReference> featureSetsRefs, File metaDataDir, Collection<File> stageDirs, File srchome) throws RestException, IOException, RepositoryVersionResolverException, DataHandlerException, GdrException, DependencyManagementException {
        return this.build(featureSetsRefs, metaDataDir, stageDirs, srchome, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File build(Set<FeatureSetReference> featureSetsRefs, File metaDataDir, Collection<File> stageDirs, File srchome, Map<String, String> manifestEntries) throws RestException, IOException, RepositoryVersionResolverException, DataHandlerException, GdrException, DependencyManagementException {
        FeatureLoader featureLoader;
        File tmpDir;
        if (featureSetsRefs == null || featureSetsRefs.isEmpty()) {
            throw new NullPointerException("The feature set refs specified were null or empty.");
        }
        File file = tmpDir = this._createArchive ? TempFileHandler.getTempFolder((String)"farb_builder-", null) : this._outputDir;
        if (this._versionResolver != null) {
            featureLoader = new RepositoryFeatureLoader(tmpDir, featureSetsRefs, false, this._versionResolver.getRestHandler(), this._versionResolver, Arrays.asList(this._versionResolver.getRepositories()), false, false, true);
        } else {
            if (metaDataDir == null && srchome != null) {
                metaDataDir = TopLevelDirectoryService.getGdrLabelTopLevelDirectory(srchome);
            }
            featureLoader = new FeatureLoader(new MetaDataHome(metaDataDir, false), featureSetsRefs, null, false);
        }
        Set<FeatureSet> featureSets = featureLoader.getFeatureSets();
        if (featureSets == null || featureSets.isEmpty()) {
            throw new NullPointerException("The feature sets specified were null or empty.");
        }
        try {
            HashSet<Components> compRefs = new HashSet<Components>();
            for (FeatureSet featureSet : featureSets) {
                List<Components> components = featureSet.getComponents();
                if (components == null) continue;
                compRefs.addAll(components);
            }
            File farbTmp = new File(tmpDir, ComponentArchiveUtils.getCarbName(this._featureArchiveName, this._featureArchiveVersion, this._versionQualifier));
            ComponentArchiveMerger merger = new ComponentArchiveMerger(stageDirs, compRefs, this._versionResolver, srchome, farbTmp);
            merger.merge();
            File featureDir = new File(farbTmp, FeatureSetHelper.getInstance().getPath());
            for (FeatureSet featureSet : featureSets) {
                File resourceLocation;
                File featureSetFile = featureSet.getFeatureSetFileLocation();
                FileCopy.copy((File)featureSetFile, (File)new File(featureDir, FeatureSetHelper.getInstance().getFeatureSetFileName(featureSet)), (boolean)true);
                ResourceBundleInfo rbi = featureSet.getResourceBundleInfo();
                if (rbi == null || (resourceLocation = rbi.getResourceLocation()) == null || !resourceLocation.exists()) continue;
                JarHelper jarHelper = new JarHelper(resourceLocation);
                jarHelper.extract(farbTmp);
                jarHelper.close();
            }
            File farbArchive = this._createArchive ? ComponentArchiveUtils.packageCarb(this._featureArchiveName, this._featureArchiveVersion, farbTmp, this._outputDir, this._versionQualifier, manifestEntries, this._outputDirRepositoryLayout, "com.oracle.cie.gdr.farb", "farb") : farbTmp;
            _log.info("Created feature archive " + farbArchive);
            if (this.getCreatedFarbsFile() != null) {
                ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
                artifacts.add(DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.farb", this._featureArchiveName, this._featureArchiveVersion, "farb", new String[]{this._versionQualifier}));
                ComponentArchiveUtils.createArtifactManifest(this.getCreatedFarbsFile(), artifacts, "com.oracle.cie.gdr.farb.artifacts", "created-farbs", DependencyManagementFactory.getInstance().getVersion("1.0.0", new String[]{this._versionQualifier}), this.getCreatedFarbsFileType());
            }
            File file2 = farbArchive;
            return file2;
        }
        finally {
            if (this._createArchive) {
                Delete.delete((File)tmpDir, (boolean)true);
            }
        }
    }

    public static void main(String[] args) {
        int retVal = 0;
        try {
            RepoCommonConfig repoCommonConfig = FeatureArchiveBuilder.getRepoCommonConfig((String[])args);
            RestHandler restHandler = RestFactory.getRestHandler();
            RepositoryVersionResolver versionResolver = NextGenHelperFactory.getNextGenHelper((RestHandler)restHandler).getConfiguredRepositoryVersionResolver(repoCommonConfig);
            List overrideModules = versionResolver.getOverrideModules();
            if (overrideModules == null || overrideModules.isEmpty()) {
                versionResolver = null;
            }
            String farbName = repoCommonConfig.getProperty("FEATURE_ARCHIVE_NAME", true);
            String farbVersion = repoCommonConfig.getProperty("FEATURE_ARCHIVE_VERSION", true);
            File outputDir = new File(repoCommonConfig.getProperty("OUTPUT_DIR", true));
            String value = repoCommonConfig.getProperty("FEATURE_SETS", true);
            Collection featureNameVersions = RepositoryUtils.parseNameVersionString((String)value);
            LinkedHashSet<FeatureSetReference> featureSetRefs = new LinkedHashSet<FeatureSetReference>();
            for (String[] featureNameVersion : featureNameVersions) {
                featureSetRefs.add(new FeatureSetReference(featureNameVersion[0], featureNameVersion[1]));
            }
            ArrayList<File> stageDirs = null;
            value = repoCommonConfig.getProperty("STAGE_DIRS");
            if (!StringUtil.isNullOrEmpty((String)value, (boolean)true)) {
                String[] split;
                stageDirs = new ArrayList<File>();
                for (String s : split = value.split(",")) {
                    stageDirs.add(new File(s));
                }
            }
            File srchome = null;
            value = repoCommonConfig.getProperty("SOURCE_PATH");
            if (!StringUtil.isNullOrEmpty((String)value, (boolean)true)) {
                srchome = new File(value);
            }
            String versionQualifier = repoCommonConfig.getProperty("VERSION_QUALIFIER");
            boolean outputDirRepoLayout = repoCommonConfig.hasProperty("OUTPUT_DIR_REPO_LAYOUT") || Boolean.parseBoolean(repoCommonConfig.getProperty("OUTPUT_DIR_REPO_LAYOUT"));
            boolean createArchive = !repoCommonConfig.hasProperty("CREATE_ARCHIVE") || Boolean.parseBoolean(repoCommonConfig.getProperty("CREATE_ARCHIVE"));
            File metaDataDir = repoCommonConfig.hasProperty("GDR_METADATA_DIR") ? new File(repoCommonConfig.getProperty("GDR_METADATA_DIR")) : null;
            File createdFarbFile = null;
            DependencyFileType createdFarbFileType = null;
            if (repoCommonConfig.hasProperty("CREATED_FARBS_FILE")) {
                createdFarbFile = new File(repoCommonConfig.getProperty("CREATED_FARBS_FILE"));
                if (repoCommonConfig.hasProperty("CREATED_FARBS_FILE_FORMAT")) {
                    createdFarbFileType = DependencyFileType.valueOf((String)repoCommonConfig.getProperty("CREATED_FARBS_FILE_FORMAT"));
                }
            }
            FeatureArchiveBuilder builder = new FeatureArchiveBuilder(farbName, farbVersion, versionResolver, outputDir, versionQualifier, outputDirRepoLayout, createArchive);
            if (createdFarbFile != null) {
                builder.setCreatedFarbsFile(createdFarbFile);
                if (createdFarbFileType != null) {
                    builder.setCreatedFarbsFileType(createdFarbFileType);
                }
            }
            builder.build(featureSetRefs, metaDataDir, stageDirs, srchome);
        }
        catch (CommonCommandLine.CommonCommandLineException e) {
            System.out.println(e.getMessage());
            FeatureArchiveBuilder.printUsage(FeatureArchiveBuilder.class);
            retVal = -1;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Feature Archive Builder failed.", e);
            e.printStackTrace();
            retVal = -1;
        }
        System.exit(retVal);
    }
}

