/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.common.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class POSIXPermissionUtil {
    private static final Logger _log = Logger.getLogger(POSIXPermissionUtil.class.getName());
    private static Path _target;
    private static Path _archive;
    private static Set<PosixFilePermission> _perms;
    private static FileAttribute<Set<PosixFilePermission>> _attrs;
    public static final String DEFAULT_DIR_PERM = "750";
    public static final String DEFAULT_FILE_PERM = "640";

    public static boolean setPermissions(Path path, String numeric_perm) {
        if (path == null || path.toString().equals("")) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("The path you are trying to use is null or empty. Please Verify.");
            }
            return false;
        }
        if (StringUtil.isNullOrEmpty((String)numeric_perm) || numeric_perm.length() != 3) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("The permission you are trying to set is incorrect(null/empty) or not supported. Please verify.");
            }
            return false;
        }
        String perm = POSIXPermissionUtil.changeFormat(numeric_perm);
        _perms = PosixFilePermissions.fromString(perm);
        try {
            Files.setPosixFilePermissions(path, _perms);
        }
        catch (IOException e) {
            _log.warning("Unable to set these permissions " + numeric_perm + " to " + path);
            return false;
        }
        return true;
    }

    public static boolean setPermissions(String path, String numeric_perm) {
        return POSIXPermissionUtil.setPermissions(Paths.get(path, new String[0]), numeric_perm);
    }

    public static boolean createFile(String path, String numeric_perm) {
        if (path == null || path.equals("")) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("The path you are trying to use is null or empty. Please Verify.");
            }
            return false;
        }
        if (StringUtil.isNullOrEmpty((String)numeric_perm) || numeric_perm.length() != 3) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("The permission you are trying to set is incorrect(null/empty) or not supported. Please verify.");
            }
            return false;
        }
        try {
            POSIXPermissionUtil.init(path, numeric_perm);
            _archive = Files.createFile(_target, _attrs);
        }
        catch (IOException e) {
            _log.warning("Unable to set these file permissions: " + numeric_perm + " to " + path);
            return false;
        }
        return true;
    }

    public static boolean createDirectory(String path, String numeric_perm) {
        if (path == null || path.equals("")) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("The path you are trying to use is null or empty. Please Verify.");
            }
            return false;
        }
        if (StringUtil.isNullOrEmpty((String)numeric_perm) || numeric_perm.length() != 3) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("The permission you are trying to set is incorrect(null/empty) or not supported. Please verify.");
            }
            return false;
        }
        try {
            POSIXPermissionUtil.init(path, numeric_perm);
            _archive = Files.createDirectory(_target, _attrs);
        }
        catch (IOException e) {
            _log.warning("Unable to set these directory permissions: " + numeric_perm + " to " + path);
            return false;
        }
        return true;
    }

    private static void init(String path, String numeric_perm) {
        if (StringUtil.isNullOrEmpty((String)numeric_perm)) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("The permission is null or empty. Please verify.");
            }
            return;
        }
        _target = Paths.get(path, new String[0]);
        String perm = POSIXPermissionUtil.changeFormat(numeric_perm);
        _perms = PosixFilePermissions.fromString(perm);
        _attrs = PosixFilePermissions.asFileAttribute(_perms);
    }

    public static String changeFormat(String numeric_perm) {
        StringBuilder builder = new StringBuilder();
        block10: for (int x = 0; x < numeric_perm.length(); ++x) {
            switch (numeric_perm.charAt(x)) {
                case '0': {
                    builder.append("---");
                    continue block10;
                }
                case '1': {
                    builder.append("--x");
                    continue block10;
                }
                case '2': {
                    builder.append("-w-");
                    continue block10;
                }
                case '3': {
                    builder.append("-wx");
                    continue block10;
                }
                case '4': {
                    builder.append("r--");
                    continue block10;
                }
                case '5': {
                    builder.append("r-x");
                    continue block10;
                }
                case '6': {
                    builder.append("rw-");
                    continue block10;
                }
                case '7': {
                    builder.append("rwx");
                }
            }
        }
        return builder.toString();
    }

    public static String getPermissions(File file) {
        String posix = "---------";
        try {
            Path filePath = file.toPath();
            Set<PosixFilePermission> set = Files.getPosixFilePermissions(filePath, new LinkOption[0]);
            posix = PosixFilePermissions.toString(set);
        }
        catch (Exception e) {
            return "000";
        }
        int ownerPosix = 0;
        int groupPosix = 0;
        int allPosix = 0;
        if (posix.charAt(0) != '-') {
            ownerPosix = (short)(ownerPosix + 4);
        }
        if (posix.charAt(1) != '-') {
            ownerPosix = (short)(ownerPosix + 2);
        }
        if (posix.charAt(2) != '-') {
            ownerPosix = (short)(ownerPosix + 1);
        }
        if (posix.charAt(3) != '-') {
            groupPosix = (short)(groupPosix + 4);
        }
        if (posix.charAt(4) != '-') {
            groupPosix = (short)(groupPosix + 2);
        }
        if (posix.charAt(5) != '-') {
            groupPosix = (short)(groupPosix + 1);
        }
        if (posix.charAt(6) != '-') {
            allPosix = (short)(allPosix + 4);
        }
        if (posix.charAt(7) != '-') {
            allPosix = (short)(allPosix + 2);
        }
        if (posix.charAt(8) != '-') {
            allPosix = (short)(allPosix + 1);
        }
        return "" + ownerPosix + groupPosix + allPosix;
    }
}

