/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchFmwEnv;
import oracle.opatch.OPatchState;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.Rules;
import oracle.opatch.SCM;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

class InstallOCMState
extends OPatchState {
    public InstallOCMState() {
        super(21, 90, 90, "Install OCM", OLogger.CONFIG, false);
    }

    public void setPresentForOCM(PatchObject[] po, IIPMReadServices readServices) {
        this.present = false;
        String oracleHomePath = OPatchEnv.getOracleHome();
        if (OPatchEnv.isOPatchSDKMode()) {
            return;
        }
        int homePatchingModel = PatchingModel.returnModelCode(oracleHomePath);
        if (homePatchingModel == 2) {
            return;
        }
        this.present = this.shouldDoOCMInstallation(oracleHomePath, false);
        if (Rules.shouldDoMiddlewareHomeOCM() && (!SCM.needToConfigureOHInMiddleware(readServices) || SCM.needToConfigureOHInMiddleware(readServices) && !this.present)) {
            String mwHome = OPatchFmwEnv.getMwHome();
            String parentCCR = mwHome + File.separator + "utils";
            this.present = this.shouldDoOCMInstallation(parentCCR, true);
        }
    }

    protected String getStateAssociatedMessage(String oracleHome, PatchObject po) {
        StringBuffer buff = new StringBuffer("");
        buff.append("Install OCM from the perspective of a Middleware Home and Oracle Home.");
        return buff.toString();
    }

    private boolean shouldDoOCMInstallation(String oracleHomePath, boolean isMwInstall) {
        if (SCM.isEBSHome(oracleHomePath) && !isMwInstall) {
            return false;
        }
        String curWorkDir = System.getProperty("OPatch.RUNNING_DIR");
        if (curWorkDir == null || curWorkDir.equals("")) {
            curWorkDir = oracleHomePath;
        }
        if (SCM.isPlatformSpecific(curWorkDir, oracleHomePath)) {
            StringBuffer buff = new StringBuffer(curWorkDir);
            if (curWorkDir.equals(oracleHomePath)) {
                buff.append(File.separator).append("OPatch");
            }
            buff.append(File.separator).append("ocm");
            buff.append(File.separator).append("generic.zip");
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
            return !Files.exists(f2, new LinkOption[0]) || Files.isDirectory(f2, new LinkOption[0]);
        }
        return false;
    }
}

