/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

public class InterviewContextVar
implements Cloneable {
    private String contextVarName = "";
    private char[] contextVarValue = new char[0];
    private String contextDesc = "";
    private boolean isEnv = false;
    private boolean isPrompt = true;
    private boolean isRequired = true;
    private boolean isVisible = true;

    public InterviewContextVar(String contextVarName, char[] contextVarValue, String contextDesc, boolean isEnv, boolean isPrompt, boolean isRequired, boolean isVisible) {
        this.contextVarName = contextVarName;
        this.contextVarValue = contextVarValue;
        this.contextDesc = contextDesc;
        this.isEnv = isEnv;
        this.isPrompt = isPrompt;
        this.isRequired = isRequired;
        this.isVisible = isVisible;
    }

    public String getContextVarName() {
        return this.contextVarName;
    }

    public char[] getContextVarValue() {
        return this.contextVarValue;
    }

    public String getContextVarDesc() {
        return this.contextDesc;
    }

    protected void setContextVarValue(char[] in) {
        this.contextVarValue = in;
    }

    public boolean isEnv() {
        return this.isEnv;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isPrompt() {
        return this.isPrompt;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public static InterviewContextVar lookUpVar(String input, InterviewContextVar[] icvList) {
        for (int i2 = 0; icvList != null && i2 < icvList.length; ++i2) {
            if (!icvList[i2].getContextVarName().equals(input)) continue;
            return icvList[i2];
        }
        return null;
    }

    public static char[] lookUpVal(String input, InterviewContextVar[] icvList) {
        char[] output = new char[]{};
        InterviewContextVar icv = InterviewContextVar.lookUpVar(input, icvList);
        if (icv != null) {
            output = icv.getContextVarValue();
            return output;
        }
        return null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("[");
        buff.append("Variable=" + this.contextVarName + ",");
        if (this.isVisible) {
            buff.append("Value=" + new String(this.contextVarValue) + ",");
        } else {
            buff.append(this.contextVarValue != null ? "Value=********," : "Value=<null>,");
        }
        buff.append("Description=" + this.contextDesc + ",");
        buff.append("Get from environment=" + this.isEnv + ",");
        buff.append("Get from user prompt=" + this.isPrompt + ",");
        buff.append("Need to make it invisible=" + !this.isVisible + ",");
        buff.append("Is this variable required?=" + this.isRequired);
        buff.append("]\n");
        return buff.toString();
    }

    public Object clone() {
        String contextVarName = this.contextVarName;
        char[] contextVarValue = this.contextVarValue;
        String contextDesc = this.contextDesc;
        boolean isEnv = this.isEnv;
        boolean isPrompt = this.isPrompt;
        boolean isRequired = this.isRequired;
        boolean isVisible = this.isVisible;
        InterviewContextVar icv = new InterviewContextVar(contextVarName, contextVarValue, contextDesc, isEnv, isPrompt, isRequired, isVisible);
        return icv;
    }
}

