/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.opatch.DeleteJarAction;
import oracle.opatch.JarAction;
import oracle.opatch.JarActionEntity;
import oracle.opatch.JarActionEntityTree;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OUIReplacer;
import oracle.opatch.PatchAction;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.ZipUtilities;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;
import org.apache.commons.compress.archivers.ArchiveException;

public class MultiJarUtil {
    static StringBuffer db;

    protected static boolean foundEntry(String entryToSearch, String entryName) {
        if (OPatchEnv.isWindows()) {
            boolean found = entryToSearch.equalsIgnoreCase(entryName);
            if (!found) {
                String converted = entryToSearch.replace('\\', '/');
                entryName = entryName.replace('\\', '/');
                return converted.equalsIgnoreCase(entryName);
            }
            return true;
        }
        return entryToSearch.equalsIgnoreCase(entryName);
    }

    private static void writeBackEntry(String patchedFile, ZipInputStream parentStream, ZipOutputStream patchedStream, ZipEntry parentEntry) throws IOException {
        String pName = parentEntry.getName();
        StringBuffer buff = new StringBuffer("Not matched, updating patched file \"");
        buff.append(patchedFile);
        buff.append("\" using entry \"");
        buff.append(pName);
        buff.append("\" (write-back)");
        OLogger.debug(buff.toString());
        MultiJarUtil.addOneZipEntryToStreamUsingStream(parentStream, patchedStream, parentEntry);
    }

    private static void closeStreams(ZipInputStream in, ZipOutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e2) {
                OLogger.printlnOnLog(e2.getMessage());
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e3) {
                OLogger.printlnOnLog(e3.getMessage());
            }
        }
    }

    private static void extractOneZipEntryToFile(String fileName, Path zipFile, ZipEntry ze) throws IOException {
        ZipInputStream zin = new ZipInputStream(Files.newInputStream(zipFile, new OpenOption[0]));
        ZipEntry entry = null;
        String zeName = ze.getName();
        while ((entry = zin.getNextEntry()) != null) {
            if (!MultiJarUtil.foundEntry(entry.getName(), zeName)) continue;
            MultiJarUtil.writeOneZipEntryToFile(fileName, zin);
            break;
        }
        if (zin != null) {
            zin.close();
        }
    }

    protected static void writeOneZipEntryToFile(String fileName, ZipInputStream zin) throws IOException {
        byte[] buff = new byte[1024];
        try {
            OutputStream fout = Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]), new OpenOption[0]);
            int n2 = 0;
            while ((n2 = zin.read(buff)) > -1) {
                fout.write(buff, 0, n2);
            }
            fout.flush();
            fout.close();
        }
        catch (IOException e2) {
            db = new StringBuffer("Error in writeOneZipEntryToStream(): ");
            db.append(e2.getMessage());
            OLogger.debug(db);
            throw e2;
        }
    }

    protected static void addAllZipEntrysToStreamUsingFileExceptOne(Path zinPath, ZipOutputStream zout, String fileToSkip) throws IOException {
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(Files.newInputStream(zinPath, new OpenOption[0]));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            if (!name.equals(fileToSkip)) {
                int len;
                zout.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    zout.write(buf, 0, len);
                }
            }
            entry = zin.getNextEntry();
        }
        if (zin != null) {
            zin.close();
        }
    }

    protected static void addOneZipEntryToStreamUsingStream(ZipInputStream zin, ZipOutputStream zout, ZipEntry ze) throws IOException {
        byte[] buff = new byte[1024];
        try {
            String name = ze.getName();
            if (OPatchEnv.isWindows()) {
                name = name.replace('\\', '/');
            }
            ZipEntry newEntry = new ZipEntry(name);
            newEntry.setTime(ze.getTime());
            zout.putNextEntry(newEntry);
            int n2 = 0;
            while ((n2 = zin.read(buff)) > -1) {
                zout.write(buff, 0, n2);
            }
            zout.flush();
            zout.closeEntry();
        }
        catch (IOException e2) {
            db = new StringBuffer("Error in addOneZipEntryToStreamUsingStream(): ");
            db.append(e2.getMessage());
            OLogger.debug(db);
            throw e2;
        }
    }

    protected static void addOneZipEntryToStreamUsingFile(ZipOutputStream zout, String file, ZipEntry ze) throws IOException {
        byte[] buff = new byte[1024];
        try {
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(file, new String[0]);
            long fl = Files.size(f2);
            if (fl <= 0L) {
                StringBuffer buffer = new StringBuffer("addOneZipEntryToStreamUsingFile()");
                buffer.append(", file is " + file);
                buffer.append(", file has zero-byte len, skip creating an jarentry for it.\n");
                OLogger.debug(buffer);
                return;
            }
            String name = ze.getName();
            if (OPatchEnv.isWindows()) {
                name = name.replace('\\', '/');
            }
            ZipEntry newEntry = new ZipEntry(name);
            zout.putNextEntry(newEntry);
            InputStream fin = Files.newInputStream(f2, new OpenOption[0]);
            int n2 = 0;
            while ((n2 = fin.read(buff)) > -1) {
                zout.write(buff, 0, n2);
            }
            zout.flush();
            zout.closeEntry();
            fin.close();
        }
        catch (IOException e2) {
            db = new StringBuffer("Error in addOneZipEntryToStreamUsingFile(): ");
            db.append(e2.getMessage());
            OLogger.debug(db);
            throw e2;
        }
    }

    protected static void addOneZipEntryToStreamUsingDirectory(ZipOutputStream zout, ZipEntry ze) throws IOException {
        try {
            String name = ze.getName();
            if (OPatchEnv.isWindows()) {
                name = name.replace('\\', '/');
            }
            ZipEntry newEntry = new ZipEntry(name);
            zout.putNextEntry(newEntry);
            zout.flush();
            zout.closeEntry();
        }
        catch (IOException e2) {
            db = new StringBuffer("Error in addOneZipEntryToStreamUsingDirectory(): ");
            db.append(e2.getMessage());
            OLogger.debug(db);
            throw e2;
        }
    }

    protected static void copyFile(String src, String dst) throws IOException {
        try {
            Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
            Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
            Files.deleteIfExists(dstFile);
            SystemCall.copyFile(srcFile, dstFile);
        }
        catch (RuntimeException e2) {
            e2.printStackTrace();
            IOException ie = new IOException(e2.getMessage());
            ie.setStackTrace(e2.getStackTrace());
            throw ie;
        }
    }

    protected static void copyFile(String src, String dst, boolean retain_permission) throws IOException {
        try {
            Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
            Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
            int finalPerm = 0;
            if (retain_permission && Files.exists(dstFile, new LinkOption[0])) {
                finalPerm = OUIReplacer.getPermission(dstFile.toString());
            }
            Files.deleteIfExists(dstFile);
            SystemCall.copyFile(srcFile, dstFile);
            if (retain_permission && finalPerm != 0) {
                OUIReplacer.changePermission(dstFile.toString(), finalPerm);
                OLogger.justlog(OLogger.INFO, "Retain Permission for destfile: " + dstFile.toString());
            }
        }
        catch (RuntimeException e2) {
            e2.printStackTrace();
            IOException ie = new IOException(e2.getMessage());
            ie.setStackTrace(e2.getStackTrace());
            throw ie;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void backUpForRollbackBaseOnJarTree(JarActionEntityTree.TreeNode node, String jarIn, String backForRollBackPath, String scratchLocation, String relWorkPath, ArrayList failed) throws RuntimeException {
        JarActionEntityTree.TreeNode curNode;
        StringBuffer buff = new StringBuffer("MultiJarUtil::backUpForRollbackBaseOnJarTree() called");
        OLogger.debug(buff.toString());
        if (node == null || node.isLeaf()) {
            return;
        }
        ArrayList childs = node.getChilds();
        String parentPath = node.getJarPath();
        relWorkPath = MultiJarUtil.combineEntry(relWorkPath, parentPath);
        ZipInputStream targetJarFile = null;
        try {
            Path jarFile = WrapperFactory.getNioServiceWrapper().getPath(jarIn, new String[0]);
            if (!Files.exists(jarFile, new LinkOption[0])) {
                buff = new StringBuffer("backUpForRollbackBaseOnJarTree() failed. Parent jar file for backing up not exist : \"");
                buff.append(jarIn);
                buff.append("\"");
                throw new IOException(buff.toString());
            }
            targetJarFile = new ZipInputStream(Files.newInputStream(jarFile, new OpenOption[0]));
        }
        catch (IOException e2) {
            MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.BACKUPFORROLLBACK, true, e2.getMessage());
            OLogger.printlnOnLog(e2.getMessage());
            return;
        }
        ZipEntry entry = null;
        try {
            block9: while (true) {
                if ((entry = targetJarFile.getNextEntry()) == null) {
                    targetJarFile.close();
                    break;
                }
                int i2 = 0;
                while (true) {
                    if (i2 >= childs.size()) continue block9;
                    curNode = (JarActionEntityTree.TreeNode)childs.get(i2);
                    if (MultiJarUtil.foundEntry(entry.getName(), curNode.getEntryName())) {
                        curNode.setEntryExist(true);
                        if (curNode.isLeaf()) {
                            String backupLocation = MultiJarUtil.getBackupForRollbackPath(backForRollBackPath, curNode.getJarAction().getClassName());
                            try {
                                Path backup = WrapperFactory.getNioServiceWrapper().getPath(backupLocation, new String[0]);
                                if (!Files.exists(backup.getParent(), new LinkOption[0])) {
                                    Files.createDirectories(backup.getParent(), new FileAttribute[0]);
                                }
                                buff = new StringBuffer("Back up leaf entry \"" + entry.getName() + "\" in Jar File \"");
                                buff.append(jarIn);
                                buff.append("\" to \"" + backupLocation + "\"");
                                OLogger.debug(buff.toString());
                                MultiJarUtil.writeOneZipEntryToFile(backupLocation, targetJarFile);
                                if (curNode.getJarAction().isBackupZip() && Files.exists(WrapperFactory.getNioServiceWrapper().getPath(backupLocation, new String[0]), new LinkOption[0])) {
                                    ZipUtilities.compressZip(backupLocation + ".zip", backupLocation);
                                    Files.deleteIfExists(WrapperFactory.getNioServiceWrapper().getPath(backupLocation, new String[0]));
                                }
                                curNode.getJarAction().setTriedToBackUp(true);
                                continue block9;
                            }
                            catch (IOException e3) {
                                curNode.getJarAction().setTriedToBackUp(true);
                                curNode.getJarAction().setErrorMsg(e3.getMessage());
                                failed.add(curNode.getJarAction());
                                buff = new StringBuffer("File not backed up from leaf entry \"" + entry.getName() + "\" in Jar File \"");
                                buff.append(jarIn);
                                buff.append("\" to \"" + backupLocation + "\"");
                                buff.append(e3.getMessage());
                                OLogger.println(buff.toString());
                                throw new RuntimeException(e3);
                            }
                            catch (ArchiveException e4) {
                                throw new RuntimeException(e4);
                            }
                        }
                        String lowLevelRelPath = MultiJarUtil.combineEntry(relWorkPath, curNode.getEntryName());
                        String lowLevelLoc = MultiJarUtil.getWorkPath(scratchLocation, lowLevelRelPath);
                        Path lowLevelJarFile = WrapperFactory.getNioServiceWrapper().getPath(lowLevelLoc, new String[0]);
                        try {
                            buff = new StringBuffer("Unzip Multi-level Jar file \"" + jarIn + "\" to low-level Jar Entry file \"");
                            buff.append(lowLevelLoc + "\"");
                            OLogger.debug(buff.toString());
                            MultiJarUtil.writeOneZipEntryToFile(lowLevelLoc, targetJarFile);
                        }
                        catch (IOException e5) {
                            MultiJarUtil.getAllLeavesForNode(curNode, failed, JarOperation.BACKUPFORROLLBACK, true, e5.getMessage());
                            buff = new StringBuffer("Unzip Multi-level Jar file failed in MultiJarUtil::backUpForRollbackBaseOnJarTree()");
                            OLogger.printlnOnLog(buff.toString());
                            continue block9;
                        }
                        MultiJarUtil.backUpForRollbackBaseOnJarTree(curNode, lowLevelLoc, backForRollBackPath, scratchLocation, relWorkPath, failed);
                        if (!Files.exists(lowLevelJarFile, new LinkOption[0])) continue block9;
                        Files.deleteIfExists(lowLevelJarFile);
                        continue block9;
                    }
                    ++i2;
                }
                break;
            }
        }
        catch (IOException e1) {
            MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.BACKUPFORROLLBACK, true, e1.getMessage());
            buff = new StringBuffer("Backup for rollback failed: ");
            buff.append(e1.getMessage());
            OLogger.printlnOnLog(buff.toString());
        }
        int i3 = 0;
        while (i3 < childs.size()) {
            curNode = (JarActionEntityTree.TreeNode)childs.get(i3);
            if (!curNode.isEntryExist()) {
                MultiJarUtil.recursiveBackupNewFile(curNode, backForRollBackPath, failed);
            }
            ++i3;
        }
        return;
    }

    public static void recursiveBackupNewFile(JarActionEntityTree.TreeNode node, String backForRollBackPath, ArrayList failed) {
        StringBuffer buff = new StringBuffer("MultiJarUtil::recursiveBackupNewFile() called");
        OLogger.debug(buff.toString());
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            String backupPath = MultiJarUtil.getBackupForRollbackPath(backForRollBackPath, node.getJarAction().getClassName());
            Path backupFile = WrapperFactory.getNioServiceWrapper().getPath(backupPath, new String[0]);
            buff = new StringBuffer("Create zero byte file for new files in jar actions as backing up for rollback. ");
            buff.append("Back up zero byte file to \"");
            buff.append(backupPath);
            buff.append("\"");
            OLogger.debug(buff.toString());
            if (!Files.exists(backupFile.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectories(backupFile.getParent(), new FileAttribute[0]);
                }
                catch (IOException e1) {
                    OLogger.debug(e1.getMessage());
                }
            }
            try {
                try {
                    Files.deleteIfExists(backupFile);
                }
                catch (IOException e2) {
                    OLogger.debug(e2.getMessage());
                }
                node.getJarAction().setTriedToBackUp(true);
            }
            catch (RuntimeException e3) {
                node.getJarAction().setTriedToBackUp(true);
                node.getJarAction().setErrorMsg(e3.getMessage());
                failed.add(node.getJarAction());
                buff = new StringBuffer("Back up for new files from jar actions failed. ");
                OLogger.printlnOnLog(buff.toString());
            }
        } else {
            ArrayList childs = node.getChilds();
            for (int i2 = 0; i2 < childs.size(); ++i2) {
                JarActionEntityTree.TreeNode child = (JarActionEntityTree.TreeNode)childs.get(i2);
                MultiJarUtil.recursiveBackupNewFile(child, backForRollBackPath, failed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String rollbackBaseOnJarTree(JarActionEntityTree.TreeNode node, String parentJarFile, String scratchLocation, String backForRollBackPath, String relativeWorkName, ArrayList failed) throws RuntimeException {
        StringBuffer buff = new StringBuffer("MultiJarUtil::rollbackBaseOnJarTree() called");
        OLogger.debug(buff.toString());
        if (node == null || node.isLeaf()) {
            return null;
        }
        ArrayList childs = node.getChilds();
        String parentPath = node.getJarPath();
        String relWorkName = MultiJarUtil.combineEntry(relativeWorkName, parentPath);
        String dstPatchedPath = MultiJarUtil.combineEntry(relativeWorkName, node.getEntryName());
        String tempOutput = MultiJarUtil.getPatchedPath(scratchLocation, dstPatchedPath);
        boolean modify = Rules.SystemWrite_continue();
        buff = new StringBuffer("Rollback for Jar Action: Extract entry from file \"" + parentJarFile);
        buff.append("\" to produce file \"");
        buff.append(tempOutput + "\"");
        OLogger.debug(buff.toString());
        ZipInputStream targetJarFile = null;
        ZipOutputStream jos = null;
        Path patchedJar = null;
        try {
            patchedJar = WrapperFactory.getNioServiceWrapper().getPath(parentJarFile, new String[0]);
            if (!Files.exists(patchedJar, new LinkOption[0])) {
                buff = new StringBuffer("rollbackBaseOnJarTree() failed. Rollbacked Jar file not exist : \"");
                buff.append(parentJarFile);
                buff.append("\"");
                throw new IOException(buff.toString());
            }
            targetJarFile = new ZipInputStream(Files.newInputStream(patchedJar, new OpenOption[0]));
            if (modify) {
                jos = new JarOutputStream(Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(tempOutput, new String[0]), new OpenOption[0]));
            }
        }
        catch (IOException e2) {
            MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.ROLLBACK, true, e2.getMessage());
            buff = new StringBuffer("Rollback failed in creating inputstream/outputstream.");
            buff.append(e2.getMessage());
            OLogger.printlnOnLog(buff.toString());
            try {
                if (jos != null) {
                    jos.close();
                }
                if (targetJarFile != null) {
                    targetJarFile.close();
                }
            }
            catch (IOException ioe) {
                OLogger.printlnOnLog("Close stream failed: " + ioe.getMessage());
            }
            return null;
        }
        Object entry = null;
        try {
            MultiJarUtil.rollbackJarActons(parentJarFile, scratchLocation, backForRollBackPath, relativeWorkName, failed, childs, relWorkName, tempOutput, modify, targetJarFile, jos);
            MultiJarUtil.rollbackDeleteJarActions(scratchLocation, backForRollBackPath, relativeWorkName, failed, childs, relWorkName, tempOutput, modify, jos, patchedJar);
        }
        catch (IOException e3) {
            MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.ROLLBACK, true, e3.getMessage());
            buff = new StringBuffer("Rollback failed: ");
            buff.append(e3.getMessage());
            OLogger.printlnOnLog(buff.toString());
        }
        finally {
            try {
                if (modify) {
                    if (targetJarFile != null) {
                        targetJarFile.close();
                    }
                    if (jos != null) {
                        jos.flush();
                        jos.close();
                    }
                }
            }
            catch (IOException ioe) {
                OLogger.printlnOnLog("Close stream failed: " + ioe.getMessage());
                return null;
            }
        }
        return tempOutput;
    }

    private static void rollbackJarActons(String parentJarFile, String scratchLocation, String backForRollBackPath, String relativeWorkName, ArrayList failed, ArrayList childs, String relWorkName, String tempOutput, boolean modify, ZipInputStream targetJarFile, ZipOutputStream jos) throws IOException {
        ZipEntry entry;
        while ((entry = targetJarFile.getNextEntry()) != null) {
            boolean entryInTree = false;
            for (int i2 = 0; i2 < childs.size(); ++i2) {
                StringBuffer buff;
                JarActionEntityTree.TreeNode curNode = (JarActionEntityTree.TreeNode)childs.get(i2);
                if (!MultiJarUtil.foundEntry(entry.getName(), curNode.getEntryName())) continue;
                entryInTree = true;
                curNode.setEntryExist(true);
                if (curNode.isLeaf()) {
                    if (!JarActionEntityTree.isJarActionNode(curNode)) break;
                    String backupLocation = MultiJarUtil.getBackupForRollbackPath(backForRollBackPath, curNode.getJarAction().getClassName());
                    try {
                        Path backup = WrapperFactory.getNioServiceWrapper().getPath(backupLocation, new String[0]);
                        if (curNode.getJarAction().isBackupZip() && Files.exists(WrapperFactory.getNioServiceWrapper().getPath(backupLocation + ".zip", new String[0]), new LinkOption[0])) {
                            ZipUtilities.unzip(backupLocation + ".zip", backup.getParent().toString());
                        }
                        long fileSize = 0L;
                        if (Files.exists(backup, new LinkOption[0])) {
                            fileSize = Files.size(backup);
                        }
                        buff = new StringBuffer("backupForRollback File: \"" + backup.toAbsolutePath().toString() + "\" Size: " + fileSize);
                        OLogger.debug(buff.toString());
                        if (!Files.exists(backup, new LinkOption[0]) || Files.size(backup) == 0L) {
                            curNode.getJarAction().setAlreadyPatched(true);
                            targetJarFile.closeEntry();
                            break;
                        }
                        buff = new StringBuffer("Writing entry file \"" + backupLocation + "\" to Jar File \"" + tempOutput + "\"");
                        OLogger.debug(buff.toString());
                        if (modify) {
                            MultiJarUtil.addOneZipEntryToStreamUsingFile(jos, backupLocation, entry);
                        }
                        curNode.getJarAction().setAlreadyPatched(true);
                    }
                    catch (IOException e2) {
                        curNode.getJarAction().setRollbackFailed();
                        curNode.getJarAction().setErrorMsg(e2.getMessage());
                        failed.add(curNode.getJarAction());
                        Files.deleteIfExists(WrapperFactory.getNioServiceWrapper().getPath(backupLocation, new String[0]));
                        buff = new StringBuffer("Fail in reading or writing backup for rollback file \"");
                        buff.append(tempOutput);
                        buff.append("\" back. Error Message: ");
                        buff.append(e2.getMessage());
                        OLogger.printlnOnLog(buff.toString());
                    }
                    break;
                }
                String lowLevelRelLoc = MultiJarUtil.combineEntry(relativeWorkName, curNode.getEntryName());
                String lowLevelToLoc = MultiJarUtil.getWorkPath(scratchLocation, lowLevelRelLoc);
                Path tmpLowLevelJar = WrapperFactory.getNioServiceWrapper().getPath(lowLevelToLoc, new String[0]);
                buff = new StringBuffer("Rollback : Unzip multi-level jar entry \"");
                buff.append(entry.getName());
                buff.append("\" to file \"");
                buff.append(lowLevelToLoc);
                buff.append("\"");
                OLogger.debug(buff.toString());
                try {
                    MultiJarUtil.writeOneZipEntryToFile(lowLevelToLoc, targetJarFile);
                }
                catch (IOException e3) {
                    MultiJarUtil.getAllLeavesForNode(curNode, failed, JarOperation.ROLLBACK, true, e3.getMessage());
                    buff = new StringBuffer("Unzip Multi-level jar to file \"");
                    buff.append(lowLevelToLoc);
                    buff.append("\" fail in MultiJarUtil::rollbackBaseOnJarTree()");
                    buff.append(e3.getStackTrace().toString());
                    OLogger.printlnOnLog(buff.toString());
                    break;
                }
                String lowLevelJarPath = MultiJarUtil.rollbackBaseOnJarTree(curNode, lowLevelToLoc, scratchLocation, backForRollBackPath, relWorkName, failed);
                Path lowLevelJar = WrapperFactory.getNioServiceWrapper().getPath(lowLevelJarPath, new String[0]);
                try {
                    buff = new StringBuffer("Rollback: Archive low-level Jar File: \"" + lowLevelJarPath + "\" into parent file \"");
                    buff.append(tempOutput + "\"");
                    OLogger.debug(buff.toString());
                    if (modify) {
                        MultiJarUtil.addOneZipEntryToStreamUsingFile(jos, lowLevelJarPath, entry);
                        Files.deleteIfExists(lowLevelJar);
                    }
                    Files.deleteIfExists(tmpLowLevelJar);
                }
                catch (IOException e4) {
                    MultiJarUtil.getAllLeavesForNode(curNode, failed, JarOperation.ROLLBACK, true, e4.getMessage());
                    buff = new StringBuffer("Write Entry back failed");
                    buff.append(e4.getMessage());
                    OLogger.printlnOnLog(buff.toString());
                }
                break;
            }
            if (entryInTree) continue;
            try {
                if (!modify) continue;
                MultiJarUtil.writeBackEntry(parentJarFile, targetJarFile, jos, entry);
            }
            catch (IOException e5) {
                RuntimeException rte = new RuntimeException(e5.getMessage());
                rte.setStackTrace(e5.getStackTrace());
                throw rte;
            }
        }
    }

    private static void rollbackDeleteJarActions(String scratchLocation, String backForRollBackPath, String relativeWorkName, ArrayList failed, ArrayList childs, String relWorkName, String tempOutput, boolean modify, ZipOutputStream jos, Path patchedJar) throws IOException {
        for (int i2 = 0; i2 < childs.size(); ++i2) {
            StringBuffer buff;
            JarActionEntityTree.TreeNode curNode = (JarActionEntityTree.TreeNode)childs.get(i2);
            if (!curNode.isLeaf() || curNode.isEntryExist() || !JarActionEntityTree.isDeleteJarActionNode(curNode)) continue;
            curNode.setEntryExist(true);
            ZipEntry entry = new ZipEntry(curNode.getEntryName());
            String backupLocation = MultiJarUtil.getBackupForRollbackPath(backForRollBackPath, curNode.getJarAction().getClassName());
            try {
                Path backup = WrapperFactory.getNioServiceWrapper().getPath(backupLocation, new String[0]);
                if (curNode.getJarAction().isBackupZip() && Files.exists(WrapperFactory.getNioServiceWrapper().getPath(backupLocation + ".zip", new String[0]), new LinkOption[0])) {
                    ZipUtilities.unzip(backupLocation + ".zip", backup.getParent().toString());
                }
                long fileSize = 0L;
                if (Files.exists(backup, new LinkOption[0])) {
                    fileSize = Files.size(backup);
                }
                buff = new StringBuffer("backupForRollback File: \"" + backup.toAbsolutePath().toString() + "\" Size: " + fileSize);
                OLogger.debug(buff.toString());
                if (!Files.exists(backup, new LinkOption[0]) || Files.size(backup) == 0L) {
                    buff = new StringBuffer("Skip writing entry file \"" + backupLocation + "\" to Jar File \"" + tempOutput + "\"");
                    OLogger.debug(buff.toString());
                } else {
                    buff = new StringBuffer("Writing entry file \"" + backupLocation + "\" to Jar File \"" + tempOutput + "\"");
                    OLogger.debug(buff.toString());
                    if (modify) {
                        MultiJarUtil.addOneZipEntryToStreamUsingFile(jos, backupLocation, entry);
                    }
                }
                curNode.getJarAction().setAlreadyPatched(true);
                continue;
            }
            catch (IOException e2) {
                curNode.getJarAction().setRollbackFailed();
                curNode.getJarAction().setErrorMsg(e2.getMessage());
                failed.add(curNode.getJarAction());
                Files.deleteIfExists(WrapperFactory.getNioServiceWrapper().getPath(backupLocation, new String[0]));
                buff = new StringBuffer("Fail in reading or writing backup for rollback file \"");
                buff.append(tempOutput);
                buff.append("\" back. Error Message: ");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void verifyBaseOnJarTree(JarActionEntityTree.TreeNode node, HashMap result, String jarIn, String scratchLocation, String patchLocation, String relativeWorkName) throws IOException {
        StringBuffer buff = new StringBuffer("MultiJarUtil::verifyBaseOnJarTree called");
        OLogger.debug(buff.toString());
        if (node == null || node.isLeaf()) {
            return;
        }
        ArrayList childs = node.getChilds();
        String parentPath = MultiJarUtil.combineEntry(relativeWorkName, node.getJarPath());
        ZipInputStream patchedJar = null;
        try {
            Path patchJarFile = WrapperFactory.getNioServiceWrapper().getPath(jarIn, new String[0]);
            if (!Files.exists(patchJarFile, new LinkOption[0])) {
                buff = new StringBuffer("verifyBaseOnJarTree() failed. Verified file not exist : \"");
                buff.append(jarIn);
                buff.append("\"");
                OLogger.printlnOnLog(buff.toString());
                throw new IOException(buff.toString());
            }
            patchedJar = new ZipInputStream(Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(jarIn, new String[0]), new OpenOption[0]));
        }
        catch (IOException e2) {
            ArrayList failedEntries = new ArrayList();
            MultiJarUtil.getAllLeavesForNode(node, failedEntries, JarOperation.VERIFY, true, e2.getMessage());
            for (int i2 = 0; i2 < failedEntries.size(); ++i2) {
                result.put(((JarAction)failedEntries.get(i2)).getClassName(), new Boolean(false));
            }
            buff = new StringBuffer("Creating input stream for \"" + jarIn + "\"");
            buff.append(" failed.");
            buff.append(e2.getMessage());
            OLogger.printlnOnLog(buff.toString());
            return;
        }
        ZipEntry entry = null;
        while ((entry = patchedJar.getNextEntry()) != null) {
            boolean entryExist = false;
            for (int i3 = 0; i3 < childs.size(); ++i3) {
                JarActionEntityTree.TreeNode curNode = (JarActionEntityTree.TreeNode)childs.get(i3);
                if (!MultiJarUtil.foundEntry(entry.getName(), curNode.getEntryName())) continue;
                entryExist = true;
                curNode.setEntryExist(true);
                String curEntry = curNode.getEntryName();
                String completeRelativePath = MultiJarUtil.combineEntry(parentPath, curEntry);
                if (curNode.isLeaf()) {
                    if (JarActionEntityTree.isJarActionNode(curNode)) {
                        boolean ok = false;
                        String classFileLoc = curNode.getJarAction().getSourceFile(patchLocation);
                        buff = new StringBuffer("\n(J+): Comparing nested file \"");
                        buff.append(classFileLoc);
                        buff.append("\" to the class entry \"");
                        buff.append(entry.getName());
                        buff.append("\" inside the jar file \"");
                        buff.append(jarIn);
                        buff.append("\"").append(" using scratch area \"");
                        buff.append(scratchLocation).append("\"");
                        OLogger.log(OLogger.FINE, buff.toString());
                        InputStream srcStream = null;
                        InputStream patchStream = null;
                        try {
                            String toCompareFile = MultiJarUtil.getWorkPath(scratchLocation, completeRelativePath);
                            MultiJarUtil.writeOneZipEntryToFile(toCompareFile, patchedJar);
                            Path classSourceFile = WrapperFactory.getNioServiceWrapper().getPath(classFileLoc, new String[0]);
                            srcStream = Files.newInputStream(classSourceFile, new OpenOption[0]);
                            patchStream = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(toCompareFile, new String[0]), new OpenOption[0]);
                            ok = PatchAction.fileCompare(srcStream, patchStream);
                            result.put(curNode.getJarAction().getClassName(), new Boolean(ok));
                            break;
                        }
                        catch (IOException ioe) {
                            result.put(curNode.getJarAction().getClassName(), new Boolean(false));
                            buff = new StringBuffer("verify() file comparetion failed: ");
                            buff.append(ioe.getMessage());
                            OLogger.printlnOnLog(buff.toString());
                            break;
                        }
                        finally {
                            try {
                                if (srcStream != null) {
                                    srcStream.close();
                                }
                                if (patchStream != null) {
                                    patchStream.close();
                                }
                            }
                            catch (IOException e3) {}
                        }
                    }
                    if (!JarActionEntityTree.isDeleteJarActionNode(curNode)) break;
                    buff = new StringBuffer("The entry " + curNode.getEntryName() + " has been found in target Jar File");
                    OLogger.printlnOnLog(buff.toString());
                    result.put(curNode.getJarAction().getClassName(), new Boolean(false));
                    break;
                }
                String workJarFile = MultiJarUtil.getWorkPath(scratchLocation, completeRelativePath);
                buff = new StringBuffer("Unzip multi-level jar : ");
                buff.append("Extract low-level jar to \"" + workJarFile + "\"");
                OLogger.debug(buff.toString());
                try {
                    MultiJarUtil.writeOneZipEntryToFile(workJarFile, patchedJar);
                }
                catch (IOException e4) {
                    buff = new StringBuffer("Unzip multi-level jar failed: \n");
                    buff.append("Failed Jar Action Entries: ");
                    ArrayList failedEntries = new ArrayList();
                    MultiJarUtil.getAllLeavesForNode(curNode, failedEntries, JarOperation.VERIFY, true, e4.getMessage());
                    for (int j2 = 0; j2 < failedEntries.size(); ++j2) {
                        buff.append(" [ \"" + failedEntries.get(j2) + " ] ");
                        result.put(((JarAction)failedEntries.get(j2)).getClassName(), new Boolean(false));
                    }
                    buff.append(e4.getStackTrace());
                    OLogger.printlnOnLog(buff.toString());
                    break;
                }
                MultiJarUtil.verifyBaseOnJarTree(curNode, result, workJarFile, scratchLocation, patchLocation, parentPath);
                break;
            }
            if (entryExist) continue;
            patchedJar.closeEntry();
        }
        try {
            patchedJar.close();
        }
        catch (IOException e5) {
            buff = new StringBuffer("Close Jar File \"" + jarIn);
            buff.append("\" failed");
            buff.append(e5.getMessage());
            OLogger.printlnOnLog(buff.toString());
        }
        for (int i4 = 0; i4 < childs.size(); ++i4) {
            JarActionEntityTree.TreeNode curNode = (JarActionEntityTree.TreeNode)childs.get(i4);
            if (curNode.isEntryExist() || !curNode.isLeaf()) continue;
            if (JarActionEntityTree.isJarActionNode(curNode)) {
                buff = new StringBuffer("The entry " + curNode.getEntryName() + " has not been applied into target Jar File");
                OLogger.printlnOnLog(buff.toString());
                result.put(curNode.getJarAction().getClassName(), new Boolean(false));
                continue;
            }
            if (!JarActionEntityTree.isDeleteJarActionNode(curNode)) continue;
            buff = new StringBuffer("The entry " + curNode.getEntryName() + " has not been found in target Jar File");
            OLogger.printlnOnLog(buff.toString());
            result.put(curNode.getJarAction().getClassName(), new Boolean(true));
        }
    }

    protected static void clearEntryExistFlagRecursively(JarActionEntityTree.TreeNode root) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            root.setEntryExist(false);
        } else {
            ArrayList childs = root.getChilds();
            for (int i2 = 0; i2 < childs.size(); ++i2) {
                MultiJarUtil.clearEntryExistFlagRecursively((JarActionEntityTree.TreeNode)childs.get(i2));
            }
        }
    }

    protected static void getAllLeavesForNode(JarActionEntityTree.TreeNode node, ArrayList leaves, JarOperation jarOp, boolean fail, String errorMsg) {
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            if (fail) {
                if (jarOp.equals(JarOperation.APPLY)) {
                    node.getJarAction().setApplyFailed();
                } else if (jarOp.equals(JarOperation.ROLLBACK)) {
                    node.getJarAction().setRollbackFailed();
                } else if (jarOp.equals(JarOperation.BACKUPFORROLLBACK)) {
                    StringBuffer buff = new StringBuffer("Didn't back up entry [");
                    JarActionEntity ja = node.getJarAction();
                    buff.append(ja.getChildPath().substring(1)).append(", ");
                    buff.append("] from file ").append(ja.getJarName());
                    ja.setBackupForRollbackDesc(buff.toString());
                    ja.setTriedToBackUp(true);
                }
                if (errorMsg != null && !errorMsg.isEmpty()) {
                    node.getJarAction().setErrorMsg(errorMsg);
                }
            }
            leaves.add(node.getJarAction());
        } else {
            ArrayList childs = node.getChilds();
            for (int i2 = 0; i2 < childs.size(); ++i2) {
                MultiJarUtil.getAllLeavesForNode((JarActionEntityTree.TreeNode)childs.get(i2), leaves, jarOp, fail, errorMsg);
            }
        }
    }

    protected static void resetPatchedStatusInJarActionTree(JarActionEntityTree.TreeNode node) {
        if (node == null) {
            return;
        }
        if (node.isLeaf() && node.getJarAction() != null) {
            node.getJarAction().setAlreadyPatched(false);
        } else if (node.getChilds() != null && node.getChilds().size() != 0) {
            ArrayList childs = node.getChilds();
            for (int i2 = 0; i2 < childs.size(); ++i2) {
                MultiJarUtil.resetPatchedStatusInJarActionTree((JarActionEntityTree.TreeNode)childs.get(i2));
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String patchingBaseOnJarTree(JarActionEntityTree.TreeNode node, String jarIn, String scratchPath, String patchLocation, String jarOut, String patchedJar, ArrayList failed) {
        if (node == null) return null;
        if (node.isLeaf()) {
            return null;
        }
        buff = new StringBuffer("MultiJarUtil:: patchingBaseOnJarTree() called");
        OLogger.debug(buff.toString());
        childs = node.getChilds();
        parentEntry = node.getEntryName();
        nodeJarPath = MultiJarUtil.combineEntry(jarOut, node.getJarPath());
        completeRelativePath = MultiJarUtil.combineEntry(jarOut, parentEntry);
        outAsInPath = MultiJarUtil.getPatchedPath(scratchPath, completeRelativePath);
        modify = Rules.SystemWrite_continue();
        jar = null;
        outStream = null;
        try {
            inputJarFile = WrapperFactory.getNioServiceWrapper().getPath(jarIn, new String[0]);
            if (!Files.exists(inputJarFile, new LinkOption[0])) {
                buff = new StringBuffer("patchingBaseOnJarTree() failed. Parent file which needs to be applied not exist : \"");
                buff.append(jarIn);
                buff.append("\"");
                OLogger.printlnOnLog(buff.toString());
                throw new IOException(buff.toString());
            }
            jar = new ZipInputStream(Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(jarIn, new String[0]), new OpenOption[0]));
            if (modify) {
                outStream = new ZipOutputStream(Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(outAsInPath, new String[0]), new OpenOption[0]));
            }
            buff = new StringBuffer("Apply for Jar actions: Archive entry into file \"" + jarIn + "\"");
            buff.append(" to produce file  \"" + outAsInPath + "\"");
            OLogger.debug(buff.toString());
        }
        catch (IOException e) {
            MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.APPLY, true, e.getMessage());
            buff = new StringBuffer("Apply failed in creating inputstream/outputstream.");
            buff.append(e.getMessage());
            OLogger.printlnOnLog(buff.toString());
            try {
                if (jar != null) {
                    jar.close();
                }
                if (outStream == null) return null;
                outStream.close();
                return null;
            }
            catch (IOException ioe) {
                OLogger.printlnOnLog("Close stream failed: " + ioe.getMessage());
            }
            return null;
        }
        entry = null;
        jarEntryNameSet = new HashSet<String>();
        while (true) {
            block32: {
                try {
                    while (true) {
                        entry = jar.getNextEntry();
                        if (entry != null) {
                            entryExist = false;
                            break block32;
                        }
                        jar.close();
                        break;
                    }
                }
                catch (IOException e) {
                    MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.APPLY, true, e.getMessage());
                    buff = new StringBuffer("Apply failed: ");
                    buff.append(e.getMessage());
                    OLogger.printlnOnLog(buff.toString());
                }
                MultiJarUtil.processNewPatchingEntries(scratchPath, patchLocation, failed, childs, nodeJarPath, outAsInPath, modify, outStream, jarEntryNameSet);
                try {
                    if (modify == false) return outAsInPath;
                    outStream.flush();
                    outStream.close();
                    return outAsInPath;
                }
                catch (IOException e) {
                    MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.APPLY, true, e.getMessage());
                    buff = new StringBuffer("Clode stream failed ");
                    buff.append(e.getMessage());
                    OLogger.printlnOnLog(buff.toString());
                }
                return outAsInPath;
            }
            for (i = 0; i < childs.size(); ++i) {
                curNode = (JarActionEntityTree.TreeNode)childs.get(i);
                entryName = curNode.getEntryName();
                jarEntryName = entry.getName();
                jarEntryNameSet.add(jarEntryName);
                if (!MultiJarUtil.foundEntry(jarEntryName, entryName)) continue;
                curNode.setEntryExist(true);
                if (curNode.isLeaf()) {
                    if (JarActionEntityTree.isJarActionNode(curNode)) {
                        classSourceFile = curNode.getJarAction().getSourceFile(patchLocation);
                        buff = new StringBuffer("Update jar entry of Jar file \"");
                        buff.append(jarIn);
                        buff.append(" with patch file \"");
                        buff.append(classSourceFile + "\"");
                        OLogger.debug(buff.toString());
                        try {
                            if (modify) {
                                sourceFile = WrapperFactory.getNioServiceWrapper().getPath(classSourceFile, new String[0]);
                                if (!Files.exists(sourceFile, new LinkOption[0])) {
                                    buff = new StringBuffer("Patching file \"");
                                    buff.append(curNode.getJarAction().getChildPath());
                                    buff.append("\" does not exist in patch location.");
                                    throw new IOException(buff.toString());
                                }
                                MultiJarUtil.addOneZipEntryToStreamUsingFile(outStream, classSourceFile, entry);
                            }
                        }
                        catch (IOException e) {
                            curNode.getJarAction().setErrorMsg(e.getMessage());
                            curNode.getJarAction().setApplyFailed();
                            failed.add(curNode.getJarAction());
                            buff = new StringBuffer("Apply failed while adding entry \"" + entry.getName() + "\"");
                            buff.append(" into file \"" + outAsInPath + "\"");
                            buff.append(e.getMessage());
                            OLogger.printlnOnLog(buff.toString());
                            jar.closeEntry();
                        }
                    } else if (JarActionEntityTree.isDeleteJarActionNode(curNode)) {
                        buff = new StringBuffer("Delete jar entry of Jar file \"");
                        buff.append(jarIn);
                        OLogger.debug(buff.toString());
                    }
                    curNode.getJarAction().setAlreadyPatched(true);
                } else {
                    outEntryName = curNode.getEntryName();
                    entInPatchedPath = MultiJarUtil.combineEntry(nodeJarPath, outEntryName);
                    outEntryPath = MultiJarUtil.getWorkPath(scratchPath, entInPatchedPath);
                    outEntryFile = WrapperFactory.getNioServiceWrapper().getPath(outEntryPath, new String[0]);
                    buff = new StringBuffer("Unzip multi-level jar entry \"");
                    buff.append(entry.getName());
                    buff.append("\" to file \"");
                    buff.append(outEntryPath);
                    buff.append("\"");
                    OLogger.debug(buff.toString());
                    try {
                        MultiJarUtil.writeOneZipEntryToFile(outEntryPath, jar);
                    }
                    catch (IOException e) {
                        MultiJarUtil.getAllLeavesForNode(curNode, failed, JarOperation.APPLY, true, e.getMessage());
                        buff = new StringBuffer("Unzip multi-level jar failed: ");
                        buff.append(e.getMessage());
                        OLogger.printlnOnLog(buff.toString());
                        break;
                    }
                    outAsIn = null;
                    try {
                        outAsIn = MultiJarUtil.patchingBaseOnJarTree(curNode, outEntryPath, scratchPath, patchLocation, nodeJarPath, patchedJar, failed);
                        buff = new StringBuffer("Archive updated low-level jar file \"");
                        buff.append(outEntryPath);
                        buff.append("\" into file \"");
                        buff.append(outAsInPath + "\"");
                        OLogger.debug(buff.toString());
                        if (modify) {
                            MultiJarUtil.addOneZipEntryToStreamUsingFile(outStream, outAsIn, entry);
                            Files.deleteIfExists(WrapperFactory.getNioServiceWrapper().getPath(outAsIn, new String[0]));
                        }
                        Files.deleteIfExists(outEntryFile);
                    }
                    catch (IOException e) {
                        MultiJarUtil.getAllLeavesForNode(curNode, failed, JarOperation.APPLY, true, e.getMessage());
                        buff = new StringBuffer("Write low-level jar entry \"" + outAsIn + "\" into file \"" + outAsInPath + "\" failed");
                        buff.append(e.getMessage());
                        OLogger.printlnOnLog(buff.toString());
                    }
                }
                entryExist = true;
                break;
            }
            if (entryExist) ** continue;
            try {
                if (!modify) continue;
                MultiJarUtil.writeBackEntry(outAsInPath, jar, outStream, entry);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private static void processNewPatchingEntries(String scratchPath, String patchLocation, ArrayList failed, ArrayList childs, String nodeJarPath, String outAsInPath, boolean modify, ZipOutputStream outStream, Set<String> jarEntryNameSet) {
        for (int i2 = 0; i2 < childs.size(); ++i2) {
            JarActionEntityTree.TreeNode curNode = (JarActionEntityTree.TreeNode)childs.get(i2);
            if (curNode.isEntryExist()) continue;
            StringBuffer buff = new StringBuffer("There is new entry file which will be added into JAR file \"");
            buff.append(outAsInPath + "\"");
            buff.append("Add new entry \"" + curNode.getEntryName() + "\" into target jar");
            if (curNode.isLeaf()) {
                DeleteJarAction dja;
                if (JarActionEntityTree.isJarActionNode(curNode)) {
                    String classSourceFile = curNode.getJarAction().getSourceFile(patchLocation);
                    ZipEntry newLeafEntry = new ZipEntry(curNode.getEntryName());
                    if (modify) {
                        try {
                            List<String> newDirectoryEntries = MultiJarUtil.getNewParentDirectoryEntries(jarEntryNameSet, curNode.getEntryName());
                            for (String newDirectoryEntry : newDirectoryEntries) {
                                MultiJarUtil.addOneZipEntryToStreamUsingDirectory(outStream, new ZipEntry(newDirectoryEntry));
                            }
                            Path sourceFile = WrapperFactory.getNioServiceWrapper().getPath(classSourceFile, new String[0]);
                            if (!Files.exists(sourceFile, new LinkOption[0])) {
                                buff = new StringBuffer("Patching file not exist \"");
                                buff.append(classSourceFile);
                                buff.append("\"");
                                throw new IOException(buff.toString());
                            }
                            MultiJarUtil.addOneZipEntryToStreamUsingFile(outStream, classSourceFile, newLeafEntry);
                        }
                        catch (IOException e2) {
                            curNode.getJarAction().setErrorMsg(e2.getMessage());
                            curNode.getJarAction().setApplyFailed();
                            failed.add(curNode.getJarAction());
                            buff = new StringBuffer("Add new leaf entry file \"" + classSourceFile + "\" into file \"");
                            buff.append(outAsInPath + "\" failed");
                            buff.append(e2.getMessage());
                            OLogger.printlnOnLog(buff.toString());
                        }
                    }
                } else if (JarActionEntityTree.isDeleteJarActionNode(curNode) && !(dja = (DeleteJarAction)curNode.getJarAction()).isReq()) {
                    String classSourceFile = curNode.getJarAction().getSourceFile(patchLocation);
                    buff = new StringBuffer(dja.getActionName() + "::skip deleting file: \"");
                    buff.append(classSourceFile);
                    buff.append("\", since it does not exist");
                    OLogger.justlog(OLogger.WARNING, buff.toString());
                }
                curNode.getJarAction().setAlreadyPatched(true);
                continue;
            }
            try {
                String relativeJarPath = MultiJarUtil.recursiveJarNewFiles(curNode, patchLocation, scratchPath, nodeJarPath);
                if (relativeJarPath == null) continue;
                String finalJarPath = MultiJarUtil.getPatchedPath(scratchPath, relativeJarPath);
                ZipEntry newLeafEntry = new ZipEntry(curNode.getEntryName());
                buff.append("Add new jar file \"" + finalJarPath + "\"");
                buff.append(" to file \"" + outAsInPath + "\"");
                Path newFinalJar = WrapperFactory.getNioServiceWrapper().getPath(finalJarPath, new String[0]);
                if (modify && finalJarPath != null) {
                    MultiJarUtil.addOneZipEntryToStreamUsingFile(outStream, finalJarPath, newLeafEntry);
                    Files.deleteIfExists(newFinalJar);
                }
                Files.deleteIfExists(newFinalJar);
                continue;
            }
            catch (IOException e3) {
                MultiJarUtil.getAllLeavesForNode(curNode, failed, JarOperation.APPLY, true, e3.getMessage());
                buff = new StringBuffer("Archive all new jar action files failed ");
                buff.append(e3.getMessage());
                OLogger.printlnOnLog(buff.toString());
            }
        }
    }

    private static List<String> getNewDirectoryEntry(Set<String> jarEntryNameSet, String entryName) {
        if (OPatchEnv.isWindows()) {
            entryName = entryName.replace('\\', '/');
        }
        ArrayList<String> newEntryList = new ArrayList<String>();
        String[] directories = entryName.split("/");
        StringBuffer newEntry = new StringBuffer("");
        for (int i2 = 0; i2 < directories.length - 1; ++i2) {
            newEntry.append(directories[i2]);
            newEntry.append(File.separator);
            String temp = newEntry.toString();
            if (jarEntryNameSet.contains(temp)) continue;
            newEntryList.add(temp);
            jarEntryNameSet.add(temp);
        }
        return newEntryList;
    }

    private static List<String> getNewParentDirectoryEntries(Set<String> jarEntryNameSet, String entryName) {
        if (OPatchEnv.isWindows()) {
            entryName = entryName.replace('\\', '/');
        }
        ArrayList<String> newEntryList = new ArrayList<String>();
        String[] directories = entryName.split("/");
        StringBuffer newEntry = new StringBuffer("");
        for (int i2 = 0; i2 < directories.length - 2; ++i2) {
            newEntry.append(directories[i2]);
            newEntry.append(File.separator);
            String temp = newEntry.toString();
            if (jarEntryNameSet.contains(temp)) continue;
            newEntryList.add(temp);
            jarEntryNameSet.add(temp);
        }
        return newEntryList;
    }

    protected static String recursiveJarNewFiles(JarActionEntityTree.TreeNode node, String patchLocation, String scratchPath, String tempJarInPatched) throws FileNotFoundException, IOException {
        if (node == null || node.isLeaf()) {
            return null;
        }
        boolean modify = Rules.SystemWrite_continue();
        StringBuffer buff = new StringBuffer("MultiJarUtil:: recursiveJarNewFiles() called");
        OLogger.debug(buff.toString());
        ArrayList childs = node.getChilds();
        String parentEntry = node.getEntryName();
        String relativeJarPath = MultiJarUtil.combineEntry(tempJarInPatched, node.getJarPath());
        String dstJarRelativePath = MultiJarUtil.combineEntry(tempJarInPatched, parentEntry);
        String dstJarPath = MultiJarUtil.getPatchedPath(scratchPath, dstJarRelativePath);
        ZipOutputStream jarOut = new ZipOutputStream(Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(dstJarPath, new String[0]), new OpenOption[0]));
        byte[] data = new byte[1024];
        HashSet<String> newDirectoryEntrySet = new HashSet<String>();
        boolean newEntryAdded = false;
        for (int i2 = 0; i2 < childs.size(); ++i2) {
            JarActionEntityTree.TreeNode curNode = (JarActionEntityTree.TreeNode)childs.get(i2);
            String entryName = curNode.getEntryName();
            ZipEntry newEntry = new ZipEntry(entryName);
            List<String> newDirectoryEntrys = MultiJarUtil.getNewDirectoryEntry(newDirectoryEntrySet, entryName);
            if (modify) {
                for (String newDirectoryEntry : newDirectoryEntrys) {
                    jarOut.putNextEntry(new ZipEntry(newDirectoryEntry));
                }
                jarOut.putNextEntry(newEntry);
            }
            String sourceFile = null;
            if (curNode.isLeaf()) {
                if (JarActionEntityTree.isJarActionNode(curNode)) {
                    sourceFile = curNode.getJarAction().getSourceFile(patchLocation);
                }
                if (!modify) {
                    curNode.getJarAction().setAlreadyPatched(true);
                }
            } else {
                String generatedJarFilePath = MultiJarUtil.recursiveJarNewFiles(curNode, patchLocation, scratchPath, relativeJarPath);
                if (generatedJarFilePath != null) {
                    sourceFile = MultiJarUtil.getPatchedPath(scratchPath, generatedJarFilePath);
                }
            }
            if (sourceFile == null) continue;
            buff = new StringBuffer("Archive low-level file \"" + sourceFile + "\" into file \"");
            buff.append(dstJarPath + "\"");
            OLogger.debug(buff.toString());
            newEntryAdded = true;
            InputStream fis = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(sourceFile, new String[0]), new OpenOption[0]);
            if (modify) {
                int count;
                while ((count = fis.read(data)) != -1) {
                    jarOut.write(data, 0, count);
                }
                jarOut.flush();
            }
            fis.close();
        }
        if (modify) {
            jarOut.flush();
            jarOut.close();
        }
        if (newEntryAdded) {
            return dstJarRelativePath;
        }
        return null;
    }

    protected static String getPatchedPath(String scratchPath, String subPath) {
        StringBuffer path = new StringBuffer(scratchPath);
        if (!scratchPath.endsWith(File.separator)) {
            path.append(File.separator);
        }
        path.append("patched");
        if (!subPath.startsWith(File.separator)) {
            path.append(File.separator);
        }
        path.append(subPath);
        Path patchedFile = WrapperFactory.getNioServiceWrapper().getPath(path.toString(), new String[0]);
        if (!Files.exists(patchedFile.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(patchedFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        return path.toString();
    }

    protected static String getWorkPath(String scratchPath, String subPath) {
        StringBuffer path = new StringBuffer(scratchPath);
        if (!scratchPath.endsWith(File.separator)) {
            path.append(File.separator);
        }
        path.append("work");
        if (!subPath.startsWith(File.separator)) {
            path.append(File.separator);
        }
        path.append(subPath);
        Path workFile = WrapperFactory.getNioServiceWrapper().getPath(path.toString(), new String[0]);
        if (!Files.exists(workFile.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(workFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        return path.toString();
    }

    protected static String getBackupForRollbackPath(String backForRollBackPath, String childPath) {
        StringBuffer backupForRollbackPath = new StringBuffer(backForRollBackPath);
        if (!backForRollBackPath.endsWith(File.separator)) {
            backupForRollbackPath.append(File.separator);
        }
        if (childPath.startsWith(File.separator)) {
            childPath = childPath.substring(1);
        }
        backupForRollbackPath.append(childPath);
        return backupForRollbackPath.toString();
    }

    protected static String combineEntry(String jarPath, String jarName) {
        StringBuffer entry = new StringBuffer();
        if (jarPath.startsWith(File.separator)) {
            jarPath = jarPath.substring(1);
        }
        if (jarPath.endsWith(File.separator)) {
            int sepIndex = jarPath.lastIndexOf(File.separator);
            jarPath = jarPath.substring(0, sepIndex);
        }
        entry.append(jarPath);
        if (!(jarPath.equals("") || jarName.equals("") || jarName.startsWith(File.separator))) {
            entry.append(File.separator);
        }
        entry.append(jarName);
        return entry.toString();
    }

    protected static boolean isBackupFileExistsInPatchStorage(JarActionEntityTree.TreeNode node, String backForRollBackPath) {
        String backupLocation = MultiJarUtil.getBackupForRollbackPath(backForRollBackPath, node.getJarAction().getClassName());
        Path backup = WrapperFactory.getNioServiceWrapper().getPath(backupLocation, new String[0]);
        if (node.getJarAction().isBackupZip() && Files.exists(WrapperFactory.getNioServiceWrapper().getPath(backupLocation + ".zip", new String[0]), new LinkOption[0])) {
            return true;
        }
        return Files.exists(backup, new LinkOption[0]);
    }

    public static void main(String[] args) {
    }

    static class JarOperation {
        public static final JarOperation APPLY = new JarOperation(1);
        public static final JarOperation ROLLBACK = new JarOperation(2);
        public static final JarOperation BACKUPFORROLLBACK = new JarOperation(3);
        public static final JarOperation VERIFY = new JarOperation(4);
        private int value;

        private JarOperation(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

