/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.TreeSet;
import oracle.opatch.Applicable;
import oracle.opatch.CopyAction;
import oracle.opatch.MaintenanceAliasPatchHelper;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.Rollbackable;
import oracle.opatch.Rules;
import oracle.opatch.cup.CUPAdapter;
import oracle.opatch.cup.CUPPatchComponent;
import oracle.opatch.opatchactions.IOrderedAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchActionExecutor {
    private OPatchActionExecutor() {
    }

    public static OPatchActionExecutor getInstance() {
        return new OPatchActionExecutor();
    }

    public void runApply(String oracleHomePath, PatchObject patchObject) throws RuntimeException {
        StringBuilder errorBuff = new StringBuilder();
        boolean errorFlag = false;
        PatchComponent[] includedComponents = patchObject.getIncludedPatchComponents();
        int includedLen = includedComponents.length;
        StringBuilder buff = new StringBuilder("   There are ");
        buff.append(includedLen);
        buff.append(" components to be processed");
        OLogger.debug(buff.toString());
        CopyAction.getSameFileCache(oracleHomePath, patchObject.getCookedPatchID());
        for (PatchComponent pc : includedComponents) {
            StringBuilder msg = new StringBuilder();
            msg.append(pc.getName());
            msg.append(", ");
            msg.append(pc.getVersion());
            if (Rules.SystemWrite_continue()) {
                OLogger.info("OUI-67044", new Object[]{msg.toString()});
            } else {
                OLogger.info("OUI-67119", new Object[]{msg.toString()});
            }
            for (IOrderedAction ai : pc.getImmediateOrderedActions()) {
                if (ai.isAppliedOK()) {
                    try {
                        ai.apply(oracleHomePath, patchObject.getPatchLocation());
                    }
                    catch (RuntimeException e2) {
                        OPatchStateManagerFactory.getInstance().setErrorCode(105);
                        ai.setApplyFailed();
                        errorBuff.append(e2.getMessage());
                        errorBuff.append("\n");
                        errorFlag = true;
                    }
                    continue;
                }
                buff = new StringBuilder("   Skip not applicable action ");
                buff.append(ai.toString());
                OLogger.debug(buff.toString());
            }
            if (!this.applyExternalPluginActions(pc.getImmediateExternalPluginActions(), oracleHomePath, patchObject.getPatchLocation(), errorBuff)) continue;
            errorFlag = true;
        }
        CopyAction.cleanSameFileCache(oracleHomePath, patchObject.getCookedPatchID());
        MaintenanceAliasPatchHelper.applyMaintenanceAlias(oracleHomePath, patchObject);
        if (errorFlag) {
            OLogger.println("\nThe following actions have failed:");
            OLogger.warn("OUI-67124", new Object[]{errorBuff.toString()});
            StringBuffer emptyBuff = new StringBuffer("");
            if (!OPatchEnv.proceedWithOperationDefaultNo(emptyBuff)) {
                RuntimeException e3 = new RuntimeException(errorBuff.toString());
                throw e3;
            }
        }
        this.generateApplyMakeFile(oracleHomePath, patchObject);
    }

    private boolean applyExternalPluginActions(List<PatchAction> pluginAIs, String oracleHomePath, String patchLocation, StringBuilder errorBuff) {
        boolean errorFlag = false;
        for (PatchAction p2 : pluginAIs) {
            if (!(p2 instanceof Applicable)) continue;
            Applicable ap = (Applicable)((Object)p2);
            boolean actionApplicable = p2.isAppliedOK();
            if (!actionApplicable) {
                StringBuilder buff = new StringBuilder("   Skip not applicable action ");
                buff.append(ap.toString());
                OLogger.debug(buff.toString());
                p2.setApplyFailed();
                continue;
            }
            if (!(p2 instanceof PatchAction)) continue;
            PatchAction pa = p2;
            Applicable aa = (Applicable)((Object)p2);
            StringBuilder msg = new StringBuilder();
            msg.append(aa.getApplyDescription(oracleHomePath));
            OLogger.onlyLogInfo("OUI-67124", new Object[]{msg.toString()});
            try {
                StringBuilder buff = new StringBuilder("   Process Plugin Action ");
                buff.append(pa.toString());
                OLogger.debug(buff.toString());
                aa.apply(oracleHomePath, patchLocation);
            }
            catch (RuntimeException e2) {
                pa.setApplyFailed();
                errorBuff.append(e2.getMessage());
                errorBuff.append("\n");
                errorFlag = true;
            }
        }
        return errorFlag;
    }

    private void generateApplyMakeFile(String oracleHomePath, PatchObject patchObject) {
        TreeSet<MakeAction> applicableMakeActions = new TreeSet<MakeAction>();
        for (PatchComponent pc : patchObject.getIncludedPatchComponents()) {
            for (MakeAction mk : pc.getImmediateMakeActions()) {
                applicableMakeActions.add(mk);
                if (!Rules.shouldSetMakeActionFailed(mk, OPatchEnv.isNolink())) continue;
                mk.setApplyFailed();
            }
        }
        if (!patchObject.shouldInvokeMakeAction()) {
            StringBuilder buff = new StringBuilder(" nApply, skip running make");
            OLogger.debug(buff.toString());
            buff = new StringBuilder("Re-link is delayed. It will be done in the end.");
            OLogger.log(OLogger.FINE, buff.toString());
        } else {
            int makeLen = applicableMakeActions.size();
            String makeFile = null;
            Path fMake = null;
            BufferedWriter fMakeWriter = null;
            if (makeLen > 0) {
                try {
                    StringBuilder buff = new StringBuilder("   creating manual make file ");
                    makeFile = OPatchEnv.getManualMakeFile(oracleHomePath, patchObject.getCookedPatchID());
                    buff.append(makeFile);
                    OLogger.debug(buff.toString());
                    if (makeFile != null) {
                        fMake = WrapperFactory.getNioServiceWrapper().getPath(makeFile, new String[0]);
                        boolean ok = false;
                        if (!Files.exists(fMake, new LinkOption[0])) {
                            try {
                                Files.createFile(fMake, new FileAttribute[0]);
                                ok = true;
                            }
                            catch (Exception e2) {
                                ok = false;
                            }
                        } else {
                            ok = true;
                        }
                        if (ok) {
                            boolean append = true;
                            fMakeWriter = Files.newBufferedWriter(fMake, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                        }
                    }
                    for (MakeAction ma : applicableMakeActions) {
                        StringBuilder msg = new StringBuilder();
                        msg.append(ma.getMakeTarget());
                        String[] makeCmdAndDir = ma.getLocalMakeCommandEntryForMakeTxt(oracleHomePath);
                        String makeCmd = makeCmdAndDir[0];
                        String chDir = makeCmdAndDir[1];
                        StringBuffer makeEntry = new StringBuffer("cd");
                        makeEntry.append(" ");
                        makeEntry.append(chDir);
                        makeEntry.append(";");
                        makeEntry.append(makeCmd);
                        makeEntry.append("\n");
                        if (fMakeWriter == null) continue;
                        buff = new StringBuilder("   writing the following entry to make.txt: \"");
                        buff.append(makeEntry.toString());
                        buff.append("\"");
                        OLogger.debug(buff.toString());
                        fMakeWriter.write(makeEntry.toString());
                        fMakeWriter.flush();
                    }
                    if (fMakeWriter != null) {
                        fMakeWriter.close();
                    }
                }
                catch (IOException e3) {
                    StringBuilder buff = new StringBuilder("ApplySession cannot create and write make.txt.  ");
                    buff.append("The list of make actions for manual step cannot be created.");
                    OLogger.warn("OUI-67124", new Object[]{buff.toString()});
                }
            }
        }
    }

    public void runRollback(String oracleHomePath, PatchObject patchObject, boolean calledFromApply, PatchObject applyPatchObject) {
        StringBuilder errorBuff = new StringBuilder();
        boolean errorFlag = false;
        MaintenanceAliasPatchHelper.rollbackMaintenanceAlias(oracleHomePath, patchObject);
        for (PatchComponent pc : patchObject.getIncludedPatchComponents()) {
            StringBuilder msg = new StringBuilder();
            msg.append(pc.getName());
            msg.append(", ");
            msg.append(pc.getVersion());
            if (Rules.SystemWrite_continue()) {
                OLogger.info("OUI-67044", new Object[]{msg.toString()});
            } else {
                OLogger.info("OUI-67119", new Object[]{msg.toString()});
            }
            for (IOrderedAction ai : pc.getImmediateReverseOrderedActions()) {
                try {
                    ai.rollback(oracleHomePath, patchObject.getCookedPatchID());
                }
                catch (RuntimeException e2) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(108);
                    ai.setRollbackFailed();
                    errorBuff.append(e2.getMessage());
                    errorBuff.append("\n");
                    errorFlag = true;
                }
            }
            if (!this.rollbackExternalPluginActions(pc.getImmediateExternalPluginActions(), oracleHomePath, patchObject.getCookedPatchID(), errorBuff)) continue;
            errorFlag = true;
        }
        CUPAdapter cupAdapter = new CUPAdapter(patchObject);
        for (CUPPatchComponent cupComponent : cupAdapter.getCUPPatchComponentList()) {
            cupComponent.rollback();
        }
        CopyAction.cleanSameFilesMap();
        if (errorFlag) {
            OLogger.println("\nThe following actions have failed:");
            OLogger.warn("OUI-67124", new Object[]{errorBuff.toString()});
            StringBuffer emptyBuff = new StringBuffer("");
            if (!OPatchEnv.proceedWithOperationDefaultNo(emptyBuff)) {
                RuntimeException e3 = new RuntimeException(errorBuff.toString());
                throw e3;
            }
        }
        this.generateRollbackMakeFile(oracleHomePath, patchObject, calledFromApply, applyPatchObject);
    }

    private boolean rollbackExternalPluginActions(List<PatchAction> pluginAIs, String oracleHomePath, String cookedPatchID, StringBuilder errorBuff) {
        boolean errorFlag = false;
        for (PatchAction p2 : pluginAIs) {
            if (!(p2 instanceof PatchAction) || !(p2 instanceof Rollbackable)) continue;
            PatchAction pa = p2;
            Rollbackable ra = (Rollbackable)((Object)p2);
            StringBuilder tmpB = new StringBuilder();
            tmpB.append(" executes plugin action at line ");
            tmpB.append(p2.getLineNumber());
            OLogger.debug(tmpB.toString());
            tmpB = new StringBuilder();
            tmpB.append(ra.getRollbackDescription(oracleHomePath));
            OLogger.info("OUI-67124", new Object[]{tmpB.toString()});
            try {
                ra.rollback(oracleHomePath, cookedPatchID);
            }
            catch (RuntimeException e2) {
                pa.setRollbackFailed();
                errorBuff.append(e2.getMessage());
                errorBuff.append("\n");
                errorFlag = true;
            }
        }
        return errorFlag;
    }

    private void generateRollbackMakeFile(String oracleHomePath, PatchObject patchObject, boolean calledFromApply, PatchObject applyPatchObject) {
        TreeSet<MakeAction> makeActions = new TreeSet<MakeAction>();
        StringBuilder buff = null;
        for (PatchComponent pc : patchObject.getIncludedPatchComponents()) {
            for (MakeAction mk : pc.getImmediateMakeActions()) {
                makeActions.add(mk);
                if (!Rules.shouldSetMakeActionFailed(mk, OPatchEnv.isNolink())) continue;
                mk.setApplyFailed();
            }
        }
        if (!patchObject.shouldInvokeMakeAction()) {
            buff = new StringBuilder("OPatchActionExecutor::generateRollbackMakeFile(): nRollback, skip running make");
            OLogger.debug(buff.toString());
            buff = new StringBuilder("Re-link is delayed. It will be done in the end.");
            OLogger.log(OLogger.FINE, buff.toString());
        } else {
            BufferedWriter fMakeWriterApply;
            BufferedWriter fMakeWriter;
            Path fMake;
            String makeFileApply;
            String makeFile;
            block25: {
                int makeLen = makeActions.size();
                makeFile = null;
                makeFileApply = null;
                fMake = null;
                fMakeWriter = null;
                fMakeWriterApply = null;
                if (makeLen > 0) {
                    try {
                        buff = new StringBuilder("   creating manual make file ");
                        makeFile = calledFromApply ? OPatchEnv.getManualAutoRollbackMakeFile(oracleHomePath, patchObject.getCookedPatchID(), applyPatchObject.getCookedPatchID()) : OPatchEnv.getManualMakeFile(oracleHomePath, patchObject.getCookedPatchID());
                        buff.append(makeFile);
                        OLogger.debug(buff.toString());
                        if (makeFile == null) break block25;
                        fMake = WrapperFactory.getNioServiceWrapper().getPath(makeFile, new String[0]);
                        boolean ok = true;
                        Files.deleteIfExists(fMake);
                        try {
                            Files.createFile(fMake, new FileAttribute[0]);
                        }
                        catch (Exception e2) {
                            ok = false;
                        }
                        if (ok) {
                            fMakeWriter = Files.newBufferedWriter(fMake, Charset.forName("UTF-8"), new OpenOption[0]);
                        }
                    }
                    catch (IOException e3) {
                        OPatchStateManagerFactory.getInstance().setErrorCode(111);
                        buff = new StringBuilder("RollbackSession cannot create make.txt.  ");
                        buff.append("The list of make actions for manual step cannot be created.");
                        OLogger.warn("OUI-67124", new Object[]{buff.toString()});
                    }
                }
            }
            for (MakeAction ma : makeActions) {
                StringBuilder msg = new StringBuilder();
                msg.append(ma.getMakeTarget());
                buff = new StringBuilder("RollbackSession::modifySystem(): not -norelink, not nApply/nRollback, about to run make");
                OLogger.debug(buff.toString());
                String[] makeCmdAndDir = ma.getLocalMakeCommandEntryForMakeTxt(oracleHomePath);
                String makeCmd = makeCmdAndDir[0];
                String chDir = makeCmdAndDir[1];
                StringBuffer makeEntry = new StringBuffer("cd");
                makeEntry.append(" ");
                makeEntry.append(chDir);
                makeEntry.append(";");
                makeEntry.append(makeCmd);
                makeEntry.append("\n");
                if (fMakeWriter == null) continue;
                try {
                    buff = new StringBuilder("   writing the following entry to make.txt: \"");
                    buff.append(makeEntry.toString());
                    buff.append("\"");
                    OLogger.debug(buff.toString());
                    fMakeWriter.write(makeEntry.toString());
                    fMakeWriter.flush();
                }
                catch (IOException e4) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(112);
                    buff = new StringBuilder("RollbackSession cannot update make.txt.  ");
                    buff.append("The list of make actions for manual step cannot be created.");
                    OLogger.warn("OUI-67124", new Object[]{buff.toString()});
                }
            }
            if (fMakeWriter != null) {
                try {
                    fMakeWriter.close();
                    if (calledFromApply) {
                        buff = new StringBuilder("   appending to manual make file ");
                        makeFileApply = OPatchEnv.getManualMakeFile(oracleHomePath, applyPatchObject.getCookedPatchID());
                        buff.append(makeFileApply);
                        OLogger.debug(buff.toString());
                        if (makeFileApply != null) {
                            fMake = WrapperFactory.getNioServiceWrapper().getPath(makeFileApply, new String[0]);
                            boolean ok = false;
                            if (!Files.exists(fMake, new LinkOption[0])) {
                                try {
                                    Files.createFile(fMake, new FileAttribute[0]);
                                    ok = true;
                                }
                                catch (Exception e5) {
                                    ok = false;
                                }
                            } else {
                                ok = true;
                            }
                            if (ok) {
                                boolean append = true;
                                fMakeWriterApply = Files.newBufferedWriter(fMake, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                            }
                            if (fMakeWriterApply != null) {
                                int c2;
                                FileReader fMakeRead = new FileReader(makeFile);
                                while ((c2 = fMakeRead.read()) != -1) {
                                    fMakeWriterApply.write(c2);
                                }
                                fMakeRead.close();
                                fMakeWriterApply.flush();
                                fMakeWriterApply.close();
                            }
                        }
                    }
                }
                catch (IOException e6) {
                    buff = new StringBuilder("RollbackSession cannot close the file make.txt.  ");
                    OLogger.warn("OUI-67124", new Object[]{buff.toString()});
                }
            }
            PatchObject[] patchObjectsTouched = new PatchObject[1];
            buff = new StringBuilder("OPatch will run make even if it is auto-rollback");
            OLogger.debug(buff.toString());
            patchObjectsTouched[0] = patchObject;
            OPatchSession.runMake("RollbackSession", oracleHomePath, patchObjectsTouched);
        }
    }
}

