/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.opatch.Crs;
import oracle.opatch.LsInventoryRacInfo;
import oracle.opatch.OPatchEnv;
import oracle.opatch.Rac;
import oracle.opatch.RacSrvm;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.RacPrereqAPI;
import oracle.opatch.ops.EnvInfo;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchExternalFactory {
    public static URLClassLoader customClassLoader;

    public static URL loadOPatchExternalLib() {
        URL externalJarURL = null;
        String opatchExtName = "opatch-external.jar";
        Path opatchJarFile = WrapperFactory.getNioServiceWrapper().getPath(new EnvInfo().locateClass(OPatchExternalFactory.class.getName(), OPatchExternalFactory.class.getClassLoader()).toString(), new String[0]);
        Path externalJarFile = null;
        if (opatchJarFile != null) {
            externalJarFile = WrapperFactory.getNioServiceWrapper().getPath(opatchJarFile.getParent().toString(), opatchExtName);
        }
        if (opatchJarFile == null || !Files.exists(externalJarFile, new LinkOption[0])) {
            String jarPath = OPatchEnv.getOracleHome() + File.separator + "OPatch" + File.separator + "jlib";
            externalJarFile = WrapperFactory.getNioServiceWrapper().getPath(jarPath, opatchExtName);
        }
        OLogger.printlnOnLog("opatch-external.jar is in " + externalJarFile.toAbsolutePath().toString());
        try {
            externalJarURL = externalJarFile.toUri().toURL();
        }
        catch (MalformedURLException e2) {
            // empty catch block
        }
        return externalJarURL;
    }

    public static LsInventoryRacInfo getLsInventoryRacInfo(String oracleHomePath) {
        URL externalURL = OPatchExternalFactory.loadOPatchExternalLib();
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(externalURL);
        String srvmLibPath = OPatchExternalFactory.loadRACRelatedLibFile(oracleHomePath);
        try {
            URL srvmJarURL = new File(srvmLibPath).toURI().toURL();
            urls.add(srvmJarURL);
        }
        catch (MalformedURLException e2) {
            // empty catch block
        }
        URL[] urlArrays = new URL[urls.size()];
        customClassLoader = new URLClassLoader(urls.toArray(urlArrays), OPatchExternalFactory.class.getClassLoader());
        try {
            return (LsInventoryRacInfo)customClassLoader.loadClass("oracle.opatch.LsInventoryRacInfoImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e3) {
            StringBuffer exceptionBuff = new StringBuffer("OPatch failed to load the LsInventoryRacInfo. Please refer log file for more details");
            OLogger.printStackTrace(e3);
            e3.printStackTrace();
            OLogger.log(OLogger.INFO, exceptionBuff.toString());
            RuntimeException re = new RuntimeException(exceptionBuff.toString());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
    }

    public static Crs getCrs(String oracleHomePath) {
        URL externalURL = OPatchExternalFactory.loadOPatchExternalLib();
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(externalURL);
        List<String> srvmLibPaths = OPatchExternalFactory.loadCRSRelatedLibFiles(oracleHomePath);
        for (String srvmLibPath : srvmLibPaths) {
            try {
                URL url = new File(srvmLibPath).toURI().toURL();
                urls.add(url);
            }
            catch (MalformedURLException e2) {}
        }
        URL[] urlArrays = new URL[urls.size()];
        customClassLoader = new URLClassLoader(urls.toArray(urlArrays), OPatchExternalFactory.class.getClassLoader());
        try {
            return (Crs)customClassLoader.loadClass("oracle.opatch.CrsImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e3) {
            StringBuffer exceptionBuff = new StringBuffer("OPatch failed to load the Crs. Please refer log file for more details");
            OLogger.printStackTrace(e3);
            OLogger.log(OLogger.INFO, exceptionBuff.toString());
            RuntimeException re = new RuntimeException(exceptionBuff.toString());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
    }

    public static Rac getRac(String oracleHomePath) {
        URL externalURL = OPatchExternalFactory.loadOPatchExternalLib();
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(externalURL);
        String srvmLibPath = OPatchExternalFactory.loadRACRelatedLibFile(oracleHomePath);
        try {
            URL url = new File(srvmLibPath).toURI().toURL();
            urls.add(url);
        }
        catch (MalformedURLException e2) {
            // empty catch block
        }
        URL[] urlArrays = new URL[urls.size()];
        customClassLoader = new URLClassLoader(urls.toArray(urlArrays), OPatchExternalFactory.class.getClassLoader());
        try {
            return (Rac)customClassLoader.loadClass("oracle.opatch.RacImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e3) {
            StringBuffer exceptionBuff = new StringBuffer("OPatch failed to load the Rac. Please refer log file for more details");
            OLogger.printStackTrace(e3);
            OLogger.log(OLogger.INFO, exceptionBuff.toString());
            RuntimeException re = new RuntimeException(exceptionBuff.toString());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
    }

    public static RacPrereqAPI getRacPrereqAPI(String oracleHomePath) {
        URL externalURL = OPatchExternalFactory.loadOPatchExternalLib();
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(externalURL);
        String srvmLibPath = OPatchExternalFactory.loadRACRelatedLibFile(oracleHomePath);
        try {
            URL url = new File(srvmLibPath).toURI().toURL();
            urls.add(url);
        }
        catch (MalformedURLException e2) {
            // empty catch block
        }
        URL[] urlArrays = new URL[urls.size()];
        customClassLoader = new URLClassLoader(urls.toArray(urlArrays), OPatchExternalFactory.class.getClassLoader());
        try {
            return (RacPrereqAPI)customClassLoader.loadClass("oracle.opatch.opatchprereq.RacPrereqAPIImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e3) {
            StringBuffer exceptionBuff = new StringBuffer("OPatch failed to load the RacPrereqAPI. Please refer log file for more details");
            OLogger.printStackTrace(e3);
            OLogger.log(OLogger.INFO, exceptionBuff.toString());
            RuntimeException re = new RuntimeException(exceptionBuff.toString());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
    }

    public static RacSrvm getRacSrvm(String oracleHomePath) {
        URL externalURL = OPatchExternalFactory.loadOPatchExternalLib();
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(externalURL);
        String srvmLibPath = OPatchExternalFactory.loadRACRelatedLibFile(oracleHomePath);
        try {
            URL url = new File(srvmLibPath).toURI().toURL();
            urls.add(url);
        }
        catch (MalformedURLException e2) {
            // empty catch block
        }
        URL[] urlArrays = new URL[urls.size()];
        customClassLoader = new URLClassLoader(urls.toArray(urlArrays), OPatchExternalFactory.class.getClassLoader());
        try {
            return (RacSrvm)customClassLoader.loadClass("oracle.opatch.RacSrvmImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e3) {
            StringBuffer exceptionBuff = new StringBuffer("OPatch failed to load the RacSrvm. Please refer log file for more details");
            OLogger.printStackTrace(e3);
            OLogger.log(OLogger.INFO, exceptionBuff.toString());
            RuntimeException re = new RuntimeException(exceptionBuff.toString());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
    }

    private static String loadRACRelatedLibFile(String oracleHomePath) {
        Properties prop = System.getProperties();
        if (oracleHomePath == null && prop != null) {
            oracleHomePath = prop.getProperty("OPatch.ORACLE_HOME");
        }
        StringBuffer srvm_lib_location = new StringBuffer("");
        if (prop != null) {
            String oui = prop.getProperty("OPatch.OUI_LOCATION");
            if (oui == null || oui.equals("")) {
                srvm_lib_location.append(oracleHomePath);
                srvm_lib_location.append(File.separator);
                srvm_lib_location.append("oui");
            } else {
                srvm_lib_location.append(oui);
            }
            srvm_lib_location.append(File.separator);
            srvm_lib_location.append(OPatchEnv.isNextGen() ? "modules" : "jlib");
            srvm_lib_location.append(File.separator);
            srvm_lib_location.append("srvm.jar");
        }
        return srvm_lib_location.toString();
    }

    private static List<String> loadCRSRelatedLibFiles(String oracleHomePath) {
        Properties prop = System.getProperties();
        if (oracleHomePath == null && prop != null) {
            oracleHomePath = prop.getProperty("OPatch.ORACLE_HOME");
        }
        String jlibLoc = oracleHomePath + File.separator + (OPatchEnv.isNextGen() ? "modules" : "jlib");
        String srvmasm = jlibLoc + File.separator + "srvmasm.jar";
        String srvmhas = jlibLoc + File.separator + "srvmhas.jar";
        String netcfg = jlibLoc + File.separator + "netcfg.jar";
        ArrayList<String> crsLibFiles = new ArrayList<String>();
        crsLibFiles.add(srvmasm);
        crsLibFiles.add(srvmhas);
        crsLibFiles.add(netcfg);
        return crsLibFiles;
    }
}

