/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import oracle.opatch.ApplyDeploySession;
import oracle.opatch.ApplySession;
import oracle.opatch.CheckStabilitySession;
import oracle.opatch.CmdLineParser;
import oracle.opatch.CompareInventorySession;
import oracle.opatch.CopyAction;
import oracle.opatch.DisableCasSession;
import oracle.opatch.EnableCasSession;
import oracle.opatch.EnableIOCSession;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.HeapMemory;
import oracle.opatch.Help;
import oracle.opatch.IOPatchSession;
import oracle.opatch.LsInventorySession;
import oracle.opatch.LsPatchesSession;
import oracle.opatch.MakeAction;
import oracle.opatch.NotFoundException;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OUIVersion;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchException;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchValidationException;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.PrereqSession;
import oracle.opatch.QuerySession;
import oracle.opatch.RegenerateLib;
import oracle.opatch.Restorable;
import oracle.opatch.RestoreStabilitySession;
import oracle.opatch.RollbackDeploySession;
import oracle.opatch.RollbackSession;
import oracle.opatch.Rules;
import oracle.opatch.SQLUtilities;
import oracle.opatch.StdoutStatus;
import oracle.opatch.StringResource;
import oracle.opatch.SymbolFailureException;
import oracle.opatch.SystemCall;
import oracle.opatch.UpdateSession;
import oracle.opatch.UtilSession;
import oracle.opatch.VerifyFailedException;
import oracle.opatch.Version;
import oracle.opatch.VersionSession;
import oracle.opatch.cup.CUPPatchComponent;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.opatchfafmw.FmwHelp;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchSession
implements IOPatchSession,
Help {
    private boolean hasOUI = true;
    static MakeStatus makeStatus = new MakeStatus();
    static boolean oracleHomeHasBeenModified = false;
    static ArrayList backupMakeActionsForRestore = new ArrayList();
    static ArrayList backupPatchGenPatchesForRestore = new ArrayList();
    static List<String> applyPatchgenPatchIdsForRestore = new ArrayList<String>();
    static List<String> rollbackPatchgenPatchIdsForRestore = new ArrayList<String>();
    private static PatchObject sessionPatchObject = null;
    private static PatchObject[] triggeredPatchObjects = null;
    public static final ConflictHandler conflictHandler = new ConflictHandler();
    private static String version;
    public static final LsPatchesSession LSPATCHES;
    public static final CompareInventorySession COMPARE;
    public static final LsInventorySession LSINVENTORY;
    public static final FmwHelp FMW;
    public static final ApplySession APPLY;
    public static final RollbackSession ROLLBACK;
    public static final QuerySession QUERY;
    public static final OPatchSession HELP;
    public static final VersionSession VERSION;
    public static final UtilSession UTIL;
    public static final PrereqSession PREREQ;
    public static final ApplyDeploySession APPLYDEPLOY;
    public static final RollbackDeploySession ROLLBACKDEPLOY;
    public static final UpdateSession UPDATE;
    public static final EnableCasSession ENABLECAS;
    public static final DisableCasSession DISABLECAS;
    public static final EnableIOCSession ENABLEIOC;
    public static final CheckStabilitySession CHECKSTABILITY;
    public static final RestoreStabilitySession RESTORESTABILITY;
    private String name;
    boolean readOnly = false;

    @Override
    public boolean isOUIBased() {
        return this.hasOUI;
    }

    protected OPatchSession(String name, boolean readOnly) {
        this.name = name;
        this.readOnly = readOnly;
        version = this.initVersion();
    }

    protected void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    protected OPatchSession() {
        version = this.initVersion();
    }

    static boolean isOracleHomeHasBeenModified() {
        return oracleHomeHasBeenModified;
    }

    static void setOracleHomeHasBeenModified(OPatchSession caller) {
        if (caller instanceof ApplySession || caller instanceof RollbackSession || caller instanceof ApplyDeploySession || caller instanceof RollbackDeploySession) {
            oracleHomeHasBeenModified = true;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isReadWrite() {
        return !this.readOnly;
    }

    public String toString() {
        return this.name;
    }

    public String getSessionName() {
        return this.name;
    }

    @Override
    public boolean helpPresent() {
        return true;
    }

    public void displayHelp(String helpFileName) {
        StringBuffer helpM = new StringBuffer("\n");
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                if (thisLine.startsWith("/")) continue;
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFileName});
            OLogger.println(msg);
        }
    }

    @Override
    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        boolean isObrepo = Boolean.parseBoolean(System.getProperties().getProperty("OPatch.OBREPO"));
        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) && isObrepo) {
            this.displayHelp("obrepo_help.txt");
        } else {
            this.displayHelp("opatch_help.txt");
        }
    }

    protected static String getVersion() {
        return version;
    }

    protected String initVersion() {
        return new Version().getOPatchVersion();
    }

    public static void runCustomScript() throws RuntimeException {
        if (OPatchEnv.isSqlScript() && OPatchEnv.isRunSql()) {
            String sqlFilePath = OPatchEnv.getSqlScriptFilePath();
            if (sqlFilePath == null || sqlFilePath.equals("")) {
                throw new RuntimeException("Invalid custom sql script file path is given as input \"" + sqlFilePath + "\"");
            }
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(sqlFilePath, new String[0]);
            if (!Files.exists(f2, new LinkOption[0]) || !Files.isReadable(f2)) {
                throw new RuntimeException("The given custom sql script \"" + sqlFilePath + "\" does not exist (or) is not readable");
            }
            String runMsg = OLogger.getString("OUI-67265", new Object[]{sqlFilePath});
            OLogger.println(runMsg);
            OPatchSessionHelper.runSqlScript(sqlFilePath, false);
        }
    }

    public static void runMake(String oracleHomePath, String cookedPatchID) throws Error {
        StringBuffer someMakeFail = null;
        StringBuffer buff = new StringBuffer("runMake():");
        OLogger.debug(buff);
        String makeFile = OPatchEnv.getManualMakeFile(oracleHomePath, cookedPatchID);
        if (makeFile == null) {
            return;
        }
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(makeFile, new String[0]);
        if (!Files.exists(f2, new LinkOption[0])) {
            return;
        }
        try {
            BufferedReader reader = Files.newBufferedReader(f2, Charset.forName("UTF-8"));
            BufferedReader bReader = new BufferedReader(reader);
            String line = "";
            while ((line = bReader.readLine()) != null) {
                StringTokenizer t = new StringTokenizer(line, ";");
                String dir = null;
                String cmd = null;
                if (t.hasMoreTokens()) {
                    dir = t.nextToken();
                    if (t.hasMoreTokens()) {
                        cmd = t.nextToken();
                    }
                    if (dir.startsWith("cd")) {
                        int len = "cd".length() + 1;
                        dir = dir.substring(len, dir.length());
                    }
                }
                if (dir == null || cmd == null) continue;
                StringBuffer tmp = new StringBuffer("OPatchSession::runMake(), prior to ORACLE_HOME replacement: ");
                tmp.append("makeCmd=\"");
                tmp.append(cmd);
                tmp.append("\", dir=\"");
                tmp.append(dir);
                tmp.append("\"");
                OLogger.debug(tmp);
                StringBuffer ohPattern = new StringBuffer("\\$ORACLE_HOME");
                Pattern p2 = Pattern.compile(ohPattern.toString());
                tmp = new StringBuffer("  try to pattern-match for command.");
                OLogger.debug(tmp);
                String[] items = p2.split(cmd);
                StringBuffer tmpCmd = new StringBuffer();
                if (items.length > 0) {
                    tmpCmd.append(items[0]);
                    tmpCmd.append(oracleHomePath);
                    cmd = tmpCmd.toString();
                    tmp = new StringBuffer("  cmd becomes \"");
                    tmp.append(cmd);
                    tmp.append("\"");
                    OLogger.debug(tmp);
                }
                p2 = Pattern.compile(ohPattern.toString());
                tmp = new StringBuffer("  try to pattern-match for dir.");
                OLogger.debug(tmp);
                items = p2.split(dir);
                StringBuffer tmpDir = new StringBuffer();
                if (items.length > 1) {
                    tmpDir.append(oracleHomePath);
                    tmpDir.append(items[1]);
                    dir = tmpDir.toString();
                    tmp = new StringBuffer("  dir becomes \"");
                    tmp.append(dir);
                    tmp.append("\"");
                    OLogger.debug(tmp);
                }
                tmp = new StringBuffer("OPatchSession::runMake() after ORACLE_HOME replacement, calling SystemCall.runMake() with ");
                tmp.append("makeCmd=\"");
                tmp.append(cmd);
                tmp.append("\", dir=\"");
                tmp.append(dir);
                tmp.append("\"");
                OLogger.debug(tmp);
                SystemCall.ExecReturn ret = SystemCall.runMake(makeStatus, cmd, dir);
                if (!ret.isOK()) {
                    if (someMakeFail == null) {
                        someMakeFail = new StringBuffer(line);
                        continue;
                    }
                    someMakeFail.append("\n");
                    someMakeFail.append(line);
                    continue;
                }
                tmp = new StringBuffer(ret.toString());
                OLogger.debug(tmp);
            }
            bReader.close();
            reader.close();
        }
        catch (Throwable t) {
            OPatchStateManagerFactory.getInstance().setErrorCode(113);
            if (someMakeFail != null) {
                String msg = OLogger.getString("OUI-67112", new Object[]{someMakeFail.toString(), makeFile});
                OLogger.println(msg);
                Error e2 = new Error(msg, t);
                e2.setStackTrace(t.getStackTrace());
                throw e2;
            }
            String msg = OLogger.getString("OUI-67112", new Object[]{makeFile});
            OLogger.println(msg);
            Error e3 = new Error(msg, t);
            e3.setStackTrace(t.getStackTrace());
            throw e3;
        }
        if (someMakeFail != null) {
            String msg = OLogger.getString("OUI-67112", new Object[]{someMakeFail.toString(), makeFile});
            OLogger.println(msg);
            throw new Error(msg);
        }
    }

    protected static void runMake(String sessionName, String oracleHomePath, PatchObject[] patchObjects) throws Error {
        MakeAction[] makes = OPatchSessionHelper.getIncludedMakeActions(oracleHomePath, patchObjects);
        OPatchSession.runMake(sessionName, oracleHomePath, makes);
    }

    public static void runMake(String sessionName, String oracleHomePath, MakeAction[] makes) throws Error {
        boolean errorFlag = false;
        StringBuffer consolidateBuff = new StringBuffer();
        StringBuffer buff = new StringBuffer(sessionName);
        buff.append(": re-link Oracle binaries.");
        OLogger.debug(buff);
        boolean noRelink = OPatchEnv.isNolink();
        String patchLoc = "";
        buff = new StringBuffer("There are ");
        buff.append(makes.length);
        buff.append(" make actions.");
        OLogger.debug(buff);
        boolean systemWrite = Rules.SystemWrite_continue();
        for (int i2 = 0; i2 < makes.length; ++i2) {
            MakeAction ma = makes[i2];
            buff = new StringBuffer(ma.getMakeTarget());
            if (noRelink) {
                OLogger.onlyLogInfo("OUI-67056", new Object[]{buff.toString()});
            } else {
                OLogger.onlyLogInfo("OUI-67050", new Object[]{buff.toString()});
            }
            if (!systemWrite) continue;
            String target = ma.getMakeTarget();
            buff = new StringBuffer("Invoking make on target \"");
            buff.append(target);
            buff.append("\"");
            OLogger.debug(buff);
            try {
                backupMakeActionsForRestore.add(ma);
                ma.apply(oracleHomePath, patchLoc);
                continue;
            }
            catch (RuntimeException e2) {
                buff = new StringBuffer("Re-link fails on target \"");
                if (target != null) {
                    buff.append(target);
                }
                buff.append("\".");
                consolidateBuff.append(buff.toString());
                consolidateBuff.append("\n");
                OLogger.debug(buff);
                OLogger.printStackTrace(e2);
                errorFlag = true;
                ma.setApplyFailed();
            }
        }
        if (errorFlag) {
            Error err;
            OLogger.println("\nThe following make actions have failed :\n");
            OLogger.warn("OUI-67124", new Object[]{consolidateBuff.toString()});
            StringBuffer dummyBuff = new StringBuffer("");
            if (OPatchEnv.isCASFlow()) {
                if (OPatchEnv.isSilent() && !OPatchEnv.proceedWithOperationDefaultYes(dummyBuff)) {
                    err = new Error(consolidateBuff.toString());
                    throw err;
                }
            } else if (!OPatchEnv.proceedWithOperationDefaultNo(dummyBuff)) {
                err = new Error(consolidateBuff.toString());
                throw err;
            }
        }
    }

    public static void restoreMake(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("OPatchSession::restoreMake()");
        OLogger.debug(buff);
        boolean systemWrite = Rules.SystemWrite_continue();
        String patchLoc = "";
        boolean allSucceed = true;
        if (systemWrite) {
            for (int i2 = 0; i2 < backupMakeActionsForRestore.size(); ++i2) {
                MakeAction ma = (MakeAction)backupMakeActionsForRestore.get(i2);
                String target = ma.getMakeTarget();
                try {
                    buff = new StringBuffer("Running make for target \"");
                    buff.append(target);
                    buff.append("\"");
                    OLogger.printlnOnLog(buff.toString());
                    ma.apply(oracleHomePath, patchLoc);
                    continue;
                }
                catch (RuntimeException e2) {
                    buff = new StringBuffer("Re-link fails on target \"");
                    if (target != null) {
                        buff.append(target);
                    }
                    buff.append("\".");
                    OLogger.printlnOnLog(buff.toString());
                    allSucceed = false;
                }
            }
            if (!allSucceed) {
                String msg = OLogger.getString("OUI-67113", new Object[]{OPatchEnv.getManualMakeFile(oracleHomePath, cookedPatchID)});
                OLogger.println(msg);
                throw new Error(msg);
            }
        }
        backupMakeActionsForRestore = new ArrayList();
    }

    public static void runPatchgen(String oracleHomePath, String patchId, boolean apply, boolean restore) {
        StringBuffer buff = new StringBuffer("OPatchSession::runPatchgen() call for patch ");
        buff.append(patchId);
        OLogger.debug(buff);
        String patchgen = "";
        try {
            patchgen = OPatchSessionHelper.getPatchgenCommand(oracleHomePath, patchId, apply, restore);
        }
        catch (NoSuchMethodException e2) {
            buff = new StringBuffer("Command patchgen is missing in desired oracle home.");
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException(e2.getMessage(), e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        if (!patchgen.equals("")) {
            boolean ok = true;
            String msg = "";
            SystemCall.ExecReturn ret = null;
            boolean systemWrite = Rules.SystemWrite_continue();
            boolean noPatchgen = OPatchEnv.isNoPatchgen();
            if (systemWrite && !noPatchgen) {
                buff = new StringBuffer("Start invoking 'patchgen' at ");
                OLogger.logTime(buff);
                OLogger.printlnOnLog("Command call is : " + patchgen);
                try {
                    ret = SystemCall.runPatchGen(patchgen);
                    buff = new StringBuffer(ret.toString());
                    OLogger.debug(buff);
                }
                catch (RuntimeException e3) {
                    ok = false;
                    throw e3;
                }
                ok = ret.isOK();
                msg = ret.getErrorMessage();
                if (!ok) {
                    OLogger.printlnOnLog(msg);
                    throw new RuntimeException(msg);
                }
                OLogger.printlnOnLog(ret.getNormalMessage());
                if (!restore) {
                    if (apply) {
                        applyPatchgenPatchIdsForRestore.add(patchId);
                    } else {
                        rollbackPatchgenPatchIdsForRestore.add(patchId);
                    }
                }
                buff = new StringBuffer("Finish invoking 'patchgen' at ");
                OLogger.logTime(buff);
            } else {
                buff = new StringBuffer("OPatchSession::runPatchgen() skips running command \"");
                buff.append(patchgen);
                buff.append("\"");
                OLogger.debug(buff);
            }
        } else {
            buff = new StringBuffer("Oracle Home \"" + oracleHomePath + "\" version is less than " + "12.1.0.0.0" + " so that command \"patchgen\" is not there");
            OLogger.debug(buff.toString());
        }
    }

    public static void restorePatchgen(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("OPatchSession::restorePatchgen() call");
        OLogger.debug(buff);
        boolean systemWrite = Rules.SystemWrite_continue();
        boolean noPatchgen = OPatchEnv.isNoPatchgen();
        boolean allSucceed = true;
        StringBuffer errorMsg = new StringBuffer();
        if (systemWrite && !noPatchgen) {
            for (String patchId : applyPatchgenPatchIdsForRestore) {
                try {
                    buff = new StringBuffer("Try to run patchgen command to restore patching level info");
                    OLogger.debug(buff.toString());
                    OPatchSession.runPatchgen(oracleHomePath, patchId, true, true);
                }
                catch (RuntimeException e2) {
                    buff = new StringBuffer("Failed to recover patch level by calling patchgen command, please refer following trace : \n");
                    OLogger.printlnOnLog(buff.toString());
                    OLogger.printStackTrace(e2);
                    errorMsg.append(e2.getMessage());
                    allSucceed = false;
                }
            }
            for (String patchId : rollbackPatchgenPatchIdsForRestore) {
                try {
                    buff = new StringBuffer("Try to run patchgen command to restore patching level info");
                    OLogger.debug(buff.toString());
                    OPatchSession.runPatchgen(oracleHomePath, patchId, false, true);
                }
                catch (RuntimeException e3) {
                    buff = new StringBuffer("Failed to recover patchlevel by calling patchgen command, please refer following trace : \n");
                    OLogger.printlnOnLog(buff.toString());
                    OLogger.printStackTrace(e3);
                    errorMsg.append(e3.getMessage());
                    allSucceed = false;
                }
            }
            if (!allSucceed) {
                throw new Error(errorMsg.toString());
            }
        }
        applyPatchgenPatchIdsForRestore.clear();
        rollbackPatchgenPatchIdsForRestore.clear();
    }

    private static boolean meetOUIVersionRequired() {
        boolean ouiOK = OUIVersion.isOUICompatible();
        return ouiOK;
    }

    public static void processDebugEnvironment() throws RuntimeException {
        String debugStr = System.getProperty("OPatch.DEBUG");
        if (debugStr != null && debugStr.compareToIgnoreCase("true") == 0) {
            OPatchEnv.setConsoleLogLevel(OLogger.FINEST);
            OPatchEnv.setFileLogLevel(OLogger.FINEST);
            try {
                OPatchACL.invokeOLogger(HELP, "setLogLevel", new Object[]{OLogger.FINEST});
                OPatchACL.invokeOLogger(HELP, "setLogFileLevel", new Object[]{OLogger.FINEST});
            }
            catch (IllegalAccessException e2) {
                RuntimeException rt = new RuntimeException(e2.getMessage(), e2);
                rt.setStackTrace(e2.getStackTrace());
                throw rt;
            }
            Properties prop = System.getProperties();
            if (prop != null) {
                prop.setProperty("TRACING.ENABLED", "TRUE");
                prop.setProperty("TRACING.LEVEL", "2");
            }
        }
    }

    public static void setSessionPatchObject(PatchObject p2) {
        sessionPatchObject = p2;
    }

    public static PatchObject getSessionPatchObject() {
        return sessionPatchObject;
    }

    public static void setTriggeredPatchObjects(PatchObject[] p2) {
        triggeredPatchObjects = p2;
    }

    public static PatchObject[] getTriggeredPatchObjects() {
        return triggeredPatchObjects;
    }

    protected static void restoreOH(String oracleHomePath, String cookedPatchID, String session, boolean debug) throws RuntimeException, Error {
        int i2;
        StringBuffer buff = new StringBuffer("OPatchSession::restoreOH()");
        OLogger.debug(buff);
        boolean apply = false;
        boolean rollback = false;
        if (session.equals("apply")) {
            apply = true;
        } else if (session.equals("rollback")) {
            rollback = true;
        } else {
            buff = new StringBuffer("Restore is supported for apply and rollback sessions only.");
            buff.append("\nGiven session is \"" + session + "\" an unsupported session.");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        if (OPatchEnv.isRegenerationNeeded() && !OPatchEnv.isRLibSuccess()) {
            RegenerateLib.restoreLibraries(oracleHomePath, cookedPatchID);
        }
        OPatchSession.restoreSystemAndInventory(oracleHomePath, cookedPatchID, debug);
        PatchObject pObj = OPatchSession.getSessionPatchObject();
        PatchObject[] tPObjs = OPatchSession.getTriggeredPatchObjects();
        CUPPatchComponent.restore(new PatchObject[]{pObj});
        CUPPatchComponent.restore(tPObjs);
        OPatchSession.restorePatchesInventory(oracleHomePath, new PatchObject[]{pObj}, tPObjs, apply);
        if (apply) {
            OPatchSession.restoreNewCopyActions(oracleHomePath, cookedPatchID, pObj);
        }
        boolean delayed = false;
        OPatchSession.restorePluginActions(oracleHomePath, cookedPatchID, pObj, apply, rollback, delayed);
        if (tPObjs != null && tPObjs.length != 0 && apply) {
            for (i2 = 0; i2 < tPObjs.length; ++i2) {
                OPatchSession.restorePluginActions(oracleHomePath, cookedPatchID, tPObjs[i2], true, true, delayed);
            }
        }
        if (!OPatchEnv.isWindows()) {
            OPatchSession.restorePatchgen(oracleHomePath);
            OLogger.info("OUI-67111");
            if (OPatchEnv.isNolink()) {
                OLogger.info("OUI-67217");
            } else {
                OPatchSession.restoreMake(oracleHomePath, cookedPatchID);
            }
        }
        delayed = true;
        OPatchSession.restorePluginActions(oracleHomePath, cookedPatchID, pObj, apply, rollback, delayed);
        if (tPObjs != null && tPObjs.length != 0 && apply) {
            for (i2 = 0; i2 < tPObjs.length; ++i2) {
                OPatchSession.restorePluginActions(oracleHomePath, cookedPatchID, tPObjs[i2], true, true, delayed);
            }
        }
        SQLUtilities.shutdownAllDB(oracleHomePath);
        OLogger.info("OUI-67037");
    }

    public static void restoreSystemAndInventory(String oracleHomePath, String cookedPatchID, boolean debug) {
        String patchStorage = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID);
        if (oracleHomePath != null && patchStorage != null) {
            OLogger.info("OUI-67110");
            String rollbackBackup = OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID);
            String patchInv = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, "");
            SystemCall.deleteRecurse(oracleHomePath, cookedPatchID, WrapperFactory.getNioServiceWrapper().getPath(rollbackBackup, new String[0]), true);
            try {
                SystemCall.deleteRecurse(WrapperFactory.getNioServiceWrapper().getPath(patchInv, new String[0]), true);
            }
            catch (Exception e2) {
                OLogger.info("OUI-67214");
                OLogger.printStackTrace(e2);
                OLogger.printlnOnLog("Patch inventory cleanup \"" + patchInv + "\" has failed. Will continue to try restore from backup area...");
            }
            if (SystemCall.copyRecurse(WrapperFactory.getNioServiceWrapper().getPath(patchStorage, new String[0]), WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]), debug, false)) {
                OLogger.info("OUI-67214");
                throw new RuntimeException("Restore: Copying of files from backup area failed");
            }
            String rInterim = OPatchEnv.getRecordInventoryFileLoc(oracleHomePath);
            Path interimInv = WrapperFactory.getNioServiceWrapper().getPath(rInterim, new String[0]);
            String sInterim = OPatchEnv.getInterimInventoryFileLoc(oracleHomePath);
            Path restoreInv = WrapperFactory.getNioServiceWrapper().getPath(sInterim, new String[0]);
            if (Files.exists(interimInv, new LinkOption[0])) {
                try {
                    SystemCall.copyFile(interimInv, restoreInv);
                }
                catch (RuntimeException e3) {
                    OLogger.info("OUI-67214");
                    OLogger.printStackTrace(e3);
                    RuntimeException rt = new RuntimeException("Restore of \"" + sInterim + "\" has failed.", e3);
                    rt.setStackTrace(e3.getStackTrace());
                    throw rt;
                }
            } else {
                OLogger.log(OLogger.INFO, "Unable to get \"" + rInterim + "\" for restore.");
            }
        }
    }

    public static void restorePatchesInventory(String oracleHomePath, PatchObject[] ap, PatchObject[] rb, boolean apply) {
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        if (Rules.OUIWrite_continue()) {
            boolean restoreFailure = false;
            String restoreOH = OPatchEnv.getRestoreOHCommand(oracleHomePath);
            try {
                OneOffEntry oneoff;
                int i2;
                boolean invChange = false;
                if (!rwServices.isInventoryLoaded()) {
                    OLogger.printlnOnLogAndVerbose("OPatch got <null> Oracle Home inventory object.");
                    throw new RuntimeException(OLogger.getString("OUI-68014", new Object[]{restoreOH}));
                }
                if (ap != null) {
                    invChange = true;
                    for (i2 = 0; i2 < ap.length; ++i2) {
                        block20: {
                            try {
                                if (apply) {
                                    rwServices.remove(ap[i2]);
                                } else {
                                    rwServices.add(ap[i2]);
                                }
                            }
                            catch (Throwable t) {
                                if (apply) {
                                    oneoff = rwServices.getPatchFromInv(ap[i2].getPatchID(), ap[i2].getPatchInventory().getPSENumber());
                                    if (oneoff != null) {
                                        OLogger.printlnOnLogAndVerbose("ERROR: patch \"" + ap[i2].getPatchID() + "\" with " + "UPI + \"" + ap[i2].getPatchInventory().getPSENumber() + "\" not removed.");
                                        restoreFailure = true;
                                        continue;
                                    }
                                }
                                oneoff = rwServices.getPatchFromInv(ap[i2].getPatchID(), ap[i2].getPatchInventory().getPSENumber());
                                if (oneoff != null) break block20;
                                OLogger.printlnOnLogAndVerbose("ERROR: patch \"" + ap[i2].getPatchID() + "\" with " + "UPI + \"" + ap[i2].getPatchInventory().getPSENumber() + "\" not added back.");
                                restoreFailure = true;
                                continue;
                            }
                        }
                        if (apply) {
                            OLogger.printlnOnLogAndVerbose("Removed patch \"" + ap[i2].getPatchID() + "\" with " + "UPI + \"" + ap[i2].getPatchInventory().getPSENumber() + "\" from OUI inventory memory..");
                            continue;
                        }
                        OLogger.printlnOnLogAndVerbose("Added patch \"" + ap[i2].getPatchID() + "\" with " + "UPI + \"" + ap[i2].getPatchInventory().getPSENumber() + "\" to OUI inventory memory..");
                    }
                }
                if (rb != null) {
                    invChange = true;
                    for (i2 = 0; i2 < rb.length; ++i2) {
                        block21: {
                            try {
                                rwServices.add(rb[i2]);
                            }
                            catch (Throwable t) {
                                oneoff = rwServices.getPatchFromInv(rb[i2].getPatchID(), rb[i2].getPatchInventory().getPSENumber());
                                if (oneoff != null) break block21;
                                OLogger.printlnOnLogAndVerbose("ERROR: patch \"" + rb[i2].getPatchID() + "\" with " + "UPI + \"" + rb[i2].getPatchInventory().getPSENumber() + "\" not added back.");
                                restoreFailure = true;
                                continue;
                            }
                        }
                        OLogger.printlnOnLogAndVerbose("Added patch \"" + rb[i2].getPatchID() + "\" with " + "UPI + \"" + rb[i2].getPatchInventory().getPSENumber() + "\" to OUI inventory memory..");
                    }
                }
                if (invChange) {
                    rwServices.saveInstallInventory();
                }
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                OLogger.printStackTrace(re);
                RuntimeException rt = new RuntimeException(OLogger.getString("OUI-68014", new Object[]{restoreOH}), e2);
                rt.setStackTrace(e2.getStackTrace());
                throw rt;
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                OLogger.printStackTrace(re);
                RuntimeException rt = new RuntimeException(OLogger.getString("OUI-68014", new Object[]{restoreOH}), t);
                rt.setStackTrace(t.getStackTrace());
                throw rt;
            }
            if (restoreFailure) {
                throw new RuntimeException(OLogger.getString("OUI-68014", new Object[]{restoreOH}));
            }
        }
    }

    public static void restorePluginActions(String oracleHomePath, String cookedPatchID, PatchObject pObj, boolean apply, boolean rollback, boolean delayed) throws RuntimeException {
        try {
            ListIterator pa = null;
            pa = delayed ? pObj.getAllDelayedPluginActions() : pObj.getAllNormalPluginActions();
            while (pa.hasNext()) {
                PatchAction p2 = (PatchAction)pa.next();
                if (!(p2 instanceof Restorable)) continue;
                Restorable rpa = (Restorable)((Object)p2);
                rpa.restore(oracleHomePath, cookedPatchID, apply, rollback, pObj.getCookedPatchID());
            }
        }
        catch (Error e2) {
            StringBuffer buff = new StringBuffer("Restore of plugin actions failed for patch ");
            buff.append(pObj.getPatchID());
            OLogger.debug(buff);
            RuntimeException rt = new RuntimeException(buff.toString(), e2);
            rt.setStackTrace(e2.getStackTrace());
            throw rt;
        }
        catch (Exception e3) {
            StringBuffer buff = new StringBuffer("Restore of plugin actions failed for patch ");
            buff.append(pObj.getPatchID());
            OLogger.debug(buff);
            RuntimeException rt = new RuntimeException(buff.toString(), e3);
            rt.setStackTrace(e3.getStackTrace());
            throw rt;
        }
    }

    public static void restoreNewCopyActions(String oracleHomePath, String cookedPatchID, PatchObject pObj) throws RuntimeException {
        PatchAction[] actions = pObj.getAllActions();
        for (int i2 = 0; i2 < actions.length; ++i2) {
            CopyAction action;
            if (!(actions[i2] instanceof CopyAction) || !(action = (CopyAction)actions[i2]).isAppliedOK()) continue;
            StringBuffer buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
            buff.append(File.separator);
            buff.append(action.getFilename());
            String src = buff.toString();
            Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
            if (Files.exists(srcFile, new LinkOption[0])) continue;
            StringBuffer newFilePath = new StringBuffer(oracleHomePath);
            newFilePath.append(File.separator);
            newFilePath.append(action.getFilename());
            Path newFile = WrapperFactory.getNioServiceWrapper().getPath(newFilePath.toString(), new String[0]);
            if (!Files.exists(newFile, new LinkOption[0])) continue;
            OLogger.printlnOnLog("Restoring files: delete new file in " + newFilePath.toString());
            try {
                Files.delete(newFile);
                continue;
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
    }

    public static String getSessionNameString(String arg) {
        boolean isObrepo = Boolean.parseBoolean(System.getProperties().getProperty("OPatch.OBREPO"));
        if (isObrepo) {
            if (arg.equals("attach") || arg.equals("createview") || arg.equals("destroyview") || arg.equals("detach") || arg.equals("lsviews") || arg.equals("synchview") || arg.equals("tagbranch") || arg.equals("cleanup") || arg.equals("iscasrepospresent")) {
                return arg;
            }
            return "";
        }
        if (arg.equals("apply") || arg.equals("rollback") || arg.equals("lsinventory") || arg.equals("lsinv") || arg.equals("util") || arg.equals("query") || arg.equals("prereq") || arg.equals("version") || arg.equals("lspatches") || arg.equals("update") || arg.equals("enablecas") || arg.equals("disablecas") || arg.equals("checkstability") || arg.equals("restorestability") || arg.equals("enableioc")) {
            return arg;
        }
        return "";
    }

    @Override
    public void process(String oracleHomePath) {
    }

    public static void process(IOPatchSession session, String[] args) throws Throwable {
        block236: {
            String option;
            String patchLoc;
            String detectedOUI;
            String opatchVer;
            String customDir;
            boolean debug;
            String patchStorage;
            block235: {
                Path f2;
                boolean shouldDelete;
                boolean shouldRunScript;
                block234: {
                    shouldRunScript = false;
                    shouldDelete = false;
                    f2 = null;
                    patchStorage = "";
                    OPatchSession.processDebugEnvironment();
                    debug = true;
                    try {
                        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
                            if (argIndex == 0) {
                                OPatchEnv.setSessionName(args[argIndex]);
                            }
                            if (argIndex == 1) {
                                if (!args[argIndex].startsWith("-")) {
                                    OPatchEnv.setSpecifiedOLoggerPatchLoc(args[argIndex]);
                                } else {
                                    OPatchEnv.setSpecifiedOLoggerPatchLoc(".");
                                }
                            }
                            if (args[argIndex].equalsIgnoreCase("-ph") && argIndex + 1 < args.length) {
                                OPatchEnv.setSpecifiedOLoggerPatchLoc(args[argIndex + 1]);
                            }
                            if (!args[argIndex].equalsIgnoreCase("-id") || argIndex + 1 >= args.length) continue;
                            OPatchEnv.setSpecifiedOLoggerPatchID(args[argIndex + 1]);
                        }
                        if (OPatchEnv.isOPatchSDKMode()) {
                            OPatchACL.invokeOLogger(HELP, "disableConsoleOutput", null);
                        }
                    }
                    catch (Exception e2) {
                        if (!OPatchEnv.isOPatchSDKMode()) break block234;
                        OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                        throw e2;
                    }
                }
                String tempOracleHome = "";
                boolean alreadyPresent = false;
                customDir = OPatchEnv.getCustomLogDir();
                boolean isCustomDir = false;
                if (session instanceof UtilSession && customDir != null && !customDir.equals("")) {
                    patchStorage = OPatchEnv.getPatchStorageDirectoryPath(customDir);
                    isCustomDir = true;
                } else {
                    patchStorage = OPatchEnv.getPatchStorageDirectoryPath(OPatchEnv.getOracleHome());
                }
                f2 = WrapperFactory.getNioServiceWrapper().getPath(patchStorage, new String[0]);
                if (Files.exists(f2, new LinkOption[0])) {
                    alreadyPresent = true;
                }
                if (!alreadyPresent) {
                    boolean gotCreated = false;
                    gotCreated = !isCustomDir ? OPatchEnv.setupPatchStorage(OPatchEnv.getOracleHome()) : OPatchEnv.setupPatchStorage(customDir);
                    shouldDelete = true;
                    if (!gotCreated) {
                        StringBuffer errorBuff = new StringBuffer();
                        errorBuff.append("OPatch was not able to create .patch_storage directory");
                        errorBuff.append("\n");
                        errorBuff.append("Unable to get Environent variables for Stand Alone home");
                        OLogger.printlnOnLog(OLogger.INFO, errorBuff.toString());
                    } else {
                        shouldRunScript = true;
                    }
                } else {
                    shouldRunScript = true;
                }
                if (shouldRunScript) {
                    StringBuffer filePath = new StringBuffer(patchStorage);
                    filePath.append(File.separator);
                    filePath.append(StringResource.getEnvScriptName());
                    OUIReplacer.runEnvScript(filePath.toString());
                }
                StringBuffer filePath = new StringBuffer(patchStorage);
                Path fdir = WrapperFactory.getNioServiceWrapper().getPath(filePath.toString(), new String[0]);
                filePath.append(File.separator);
                filePath.append(StringResource.getEnvScriptName());
                f2 = WrapperFactory.getNioServiceWrapper().getPath(filePath.toString(), new String[0]);
                try {
                    boolean fileDel = true;
                    fileDel = Files.deleteIfExists(f2);
                    if (!fileDel) {
                        OLogger.debug(new StringBuffer("Some problem in deleting the file : " + f2.toAbsolutePath().normalize().toString()));
                    }
                    if (shouldDelete && !(fileDel = Files.deleteIfExists(fdir))) {
                        OLogger.debug(new StringBuffer("Some problem in deleting the dir : " + fdir.toAbsolutePath().normalize().toString()));
                        StringBuffer warnBuff = new StringBuffer();
                        warnBuff.append("Please delete .patch_storage directory ONLY IF NO PATCH IS APPLIED");
                        warnBuff.append("\n");
                        warnBuff.append("This is because OPatch was not able to delete this directory which\n");
                        warnBuff.append("was only created to run script for getting environment variables\n");
                        warnBuff.append("No manual deletion may result in OPatch wrongly detecting irregular inventory for future invocation.");
                        OLogger.printlnOnLog(OLogger.INFO, warnBuff.toString());
                    }
                }
                catch (SecurityException e3) {
                    StringBuffer errorBuff = new StringBuffer();
                    errorBuff.append("OPatch encounters exception while performing deletion of Env script (or) .patch_storage directory");
                    errorBuff.append("\n");
                    errorBuff.append(e3.getMessage());
                    OLogger.printlnOnLog(OLogger.INFO, errorBuff.toString());
                    OLogger.printStackTrace(e3);
                }
                System.setProperty("OPatch.PATH", OUIReplacer.getEnv("PATH"));
                System.setProperty("OPatch.PLATFORM_ID", OUIReplacer.getEnv("OPATCH_PLATFORM_ID"));
                System.setProperty("OPatch.NO_FUSER", OUIReplacer.getEnv("OPATCH_NO_FUSER"));
                Properties opatchProp = OPatchEnv.getOPatchProperties();
                Properties systemProp = System.getProperties();
                Properties mergedProp = OPatchProperty.mergeProperties(opatchProp, systemProp);
                System.setProperties(mergedProp);
                OPatchEnv.setOPatchProperties(mergedProp);
                try {
                    String historyFilename = OPatchEnv.getHistoryFile(OPatchEnv.getOracleHome());
                    String logfile = OPatchEnv.getLogFileNameAndLocation(OPatchEnv.getOracleHome());
                    StringBuffer buff = new StringBuffer("Log File    : ");
                    buff.append(logfile);
                    buff.append("\n\n");
                    try {
                        if (!OPatchEnv.isLogDisabled()) {
                            if (!Files.exists(WrapperFactory.getNioServiceWrapper().getPath(historyFilename, new String[0]), new LinkOption[0]) && OUIReplacer.isRootAccess(OPatchEnv.getOracleHome())) {
                                String newFileCmd = "touch " + historyFilename.toString();
                                SystemCall.ExecReturn re = SystemCall.process(newFileCmd, OPatchEnv.getOHOwner(OPatchEnv.getOracleHome()));
                                if (!re.isOK()) {
                                    throw new RuntimeException(re.getErrorMessage());
                                }
                                OUIReplacer.changePermission(historyFilename, 416);
                            }
                            BufferedWriter historyFile = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(historyFilename, new String[0]), Charset.forName("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                            historyFile.write(buff.toString());
                            historyFile.close();
                            break block235;
                        }
                        OLogger.debug("Skip creating history file: log is disabled.");
                    }
                    catch (Exception e4) {
                        buff = new StringBuffer("OPatch could not create/open history file to add log filename :\n" + historyFilename.toString());
                        buff.append("\n" + e4.getMessage());
                        OLogger.debug(buff);
                    }
                }
                catch (NoSuchElementException e5) {
                    OLogger.log(OLogger.INFO, "LogFile name is not written to history file.");
                    OLogger.debug(new StringBuffer("LogFile name is not written to history file : " + e5.getMessage()));
                }
            }
            StringBuffer optLog = new StringBuffer("OPatch invoked as follows: '");
            boolean ignoreFlag = false;
            boolean isSuppliedNodes = false;
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].equalsIgnoreCase("-pre") || ignoreFlag) {
                    if (!args[i2].equalsIgnoreCase("-opatch_pre_end")) {
                        ignoreFlag = true;
                        continue;
                    }
                    ignoreFlag = false;
                    continue;
                }
                if (args[i2].equalsIgnoreCase("-post") || ignoreFlag) {
                    if (!args[i2].equalsIgnoreCase("-opatch_post_end")) {
                        ignoreFlag = true;
                        continue;
                    }
                    ignoreFlag = false;
                    continue;
                }
                if (args[i2].equalsIgnoreCase("-init") || ignoreFlag) {
                    if (!args[i2].equalsIgnoreCase("-opatch_init_end")) {
                        ignoreFlag = true;
                        continue;
                    }
                    ignoreFlag = false;
                    continue;
                }
                if (args[i2].equalsIgnoreCase("-connectstring") && i2 + 1 < args.length && args[i2 + 1] != null && !args[i2 + 1].equals("")) {
                    args[i2 + 1] = "*****";
                }
                if (args[i2].equalsIgnoreCase("-supplied_nodes")) {
                    isSuppliedNodes = true;
                }
                optLog.append(args[i2]);
                optLog.append(" ");
            }
            optLog.append("'");
            if (isSuppliedNodes) {
                optLog.append("\nThis option '-");
                optLog.append("supplied_nodes");
                optLog.append("' is a private interface being used during install only.");
            }
            OLogger.justlog(OLogger.INFO, optLog.toString());
            OLogger.log(OLogger.FINEST, "OPatchSession::process()");
            if (OPatchEnv.isHelp()) {
                OPatchSession.displaySessionHelp(session);
                return;
            }
            HeapMemory.logMemoryInfo();
            try {
                if (session instanceof LsPatchesSession) {
                    String oh = OPatchEnv.getOracleHome();
                    String opatchVersion = OPatchSession.getVersion();
                    String logFile = OPatchEnv.getLogFileNameAndLocation(oh);
                    OLogger.onlyLogInfo("OUI-67737", new Object[]{oh, opatchVersion, logFile});
                    String oraInstLoc = OPatchEnv.getInvPtrLoc();
                    if (OPatchEnv.isInvPtrLocSpecified() && oraInstLoc.equals("")) {
                        String userSupply = OPatchEnv.getUserSpecifiedInvPtrLoc();
                        String error = OLogger.getString("OUI-67106", new Object[]{userSupply});
                        OLogger.error("OUI-67106", new Object[]{userSupply});
                        OPatchEnv.setOpatchExitCode(2);
                        throw new RuntimeException(error);
                    }
                } else {
                    OPatchEnv.printOPatchHeader();
                    if (OPatchEnv.isUser_allNode()) {
                        OLogger.printOnConsole("Warning: OPatch was called with -all_nodes option. The -all_nodes option is being deprecated.\n         Please remove it while calling OPatch.\n\n");
                    }
                }
            }
            catch (RuntimeException e6) {
                if (OPatchEnv.isOPatchSDKMode()) {
                    try {
                        OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                    }
                    catch (IllegalAccessException e1) {
                        // empty catch block
                    }
                }
                throw e6;
            }
            IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
            if (readServices.isLocked()) {
                OPatchEnv.setInvExists(true);
            } else {
                OPatchEnv.setInvExists(false);
            }
            String oracleHomePath = OPatchEnv.getOracleHome();
            patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
            customDir = OPatchEnv.getCustomLogDir();
            if (session instanceof UtilSession && customDir != null && !customDir.equals("")) {
                patchStorage = OPatchEnv.getPatchStorageDirectoryPath(customDir);
            }
            if (session instanceof QuerySession || session instanceof FmwHelp || session instanceof VersionSession || session instanceof LsInventorySession || session instanceof PrereqSession) {
                OPatchSessionHelper.loadRACRelatedLibFile();
                OPatchSessionHelper.loadFMWRelatedLibFile();
            }
            if (session instanceof QuerySession) {
                String patchLocation = OPatchEnv.getPatchloc();
                QUERY.process(patchLocation);
                break block236;
            }
            if (session instanceof FmwHelp) {
                FMW.process();
                return;
            }
            if (session instanceof VersionSession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting VersionSession at: ");
                    OLogger.logTime(ts);
                    if (!OPatchSession.meetOUIVersionRequired()) {
                        opatchVer = OPatchSession.getVersion();
                        detectedOUI = OPatchSDK.getOUIVersion();
                        String requiredOUI = "10.2";
                        String msg = OLogger.getString("OUI-67114", new Object[]{opatchVer, detectedOUI, requiredOUI});
                        throw new UnsupportedOperationException(msg);
                    }
                    OPatchStateManagerFactory.initializeSpecifiedSessionStateMangaer("version", "");
                    VERSION.process(oracleHomePath);
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    break block236;
                }
                catch (RuntimeException e7) {
                    OLogger.error("OUI-67073", new Object[]{"VersionSession", e7.getMessage()});
                    throw e7;
                }
                finally {
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningList", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    StringBuffer ts = new StringBuffer("Finishing VersionSession at ");
                    OLogger.logTime(ts);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof LsInventorySession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting LsInventorySession at ");
                    OLogger.logTime(ts);
                    if (OPatchSession.meetOUIVersionRequired()) {
                        if (OPatchEnv.isLsinv_last_update_checked()) {
                            OLogger.println("The latest timestamp inventory got updated: " + LsInventorySession.getLastUpdateInv(oracleHomePath) + " " + "GMT");
                        } else {
                            LSINVENTORY.process(oracleHomePath);
                        }
                        break block236;
                    }
                    opatchVer = OPatchSession.getVersion();
                    detectedOUI = OPatchSDK.getOUIVersion();
                    String requiredOUI = "10.2";
                    String msg = OLogger.getString("OUI-67114", new Object[]{opatchVer, detectedOUI, requiredOUI});
                    throw new UnsupportedOperationException(msg);
                }
                catch (RuntimeException e8) {
                    OLogger.error("OUI-67073", new Object[]{"LsInventorySession", e8.getMessage()});
                    throw e8;
                }
                finally {
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningListOnLog", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    StringBuffer ts = new StringBuffer("Finishing LsInventorySession at ");
                    OLogger.logTime(ts);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof LsPatchesSession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting LsPatchesSession at ");
                    OLogger.logTime(ts);
                    if (OPatchSession.meetOUIVersionRequired()) {
                        LSPATCHES.process(oracleHomePath);
                        break block236;
                    }
                    opatchVer = OPatchSession.getVersion();
                    detectedOUI = OPatchSDK.getOUIVersion();
                    String requiredOUI = "10.2";
                    String msg = OLogger.getString("OUI-67114", new Object[]{opatchVer, detectedOUI, requiredOUI});
                    throw new UnsupportedOperationException(msg);
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(1);
                    throw ne;
                }
                catch (VerifyFailedException e9) {
                    OLogger.println(e9.getMessage());
                    OPatchEnv.setOpatchExitCode(3);
                    throw e9;
                }
                catch (RuntimeException e10) {
                    if (e10.getMessage().contains(OLogger.getString("OUI-68011"))) {
                        OLogger.println(e10.getMessage());
                        OPatchEnv.setOpatchExitCode(21);
                        throw e10;
                    }
                    OLogger.error("OUI-67073", new Object[]{"LsPatchesSession", e10.getMessage()});
                    OPatchEnv.setOpatchExitCode(2);
                    throw e10;
                }
                finally {
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningList", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    StringBuffer ts = new StringBuffer("Finishing LsPatchesSession at ");
                    OLogger.logTime(ts);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof EnableCasSession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting EnableCasSession at ");
                    OLogger.logTime(ts);
                    ENABLECAS.process();
                    break block236;
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
            }
            if (session instanceof DisableCasSession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting DisableCasSession at ");
                    OLogger.logTime(ts);
                    DISABLECAS.process();
                    break block236;
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
            }
            if (session instanceof EnableIOCSession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting EnableIOCSession at ");
                    OLogger.logTime(ts);
                    ENABLEIOC.process(oracleHomePath);
                    break block236;
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
            }
            if (session instanceof CheckStabilitySession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting CheckStabilitySession at ");
                    OLogger.logTime(ts);
                    CHECKSTABILITY.process(oracleHomePath);
                    break block236;
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
            }
            if (session instanceof RestoreStabilitySession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting RestoreStabilitySession at ");
                    OLogger.logTime(ts);
                    RESTORESTABILITY.process(oracleHomePath);
                    break block236;
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
            }
            if (session instanceof CheckStabilitySession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting CheckStabilitySession at ");
                    OLogger.logTime(ts);
                    CHECKSTABILITY.process(oracleHomePath);
                    break block236;
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
            }
            if (session instanceof RestoreStabilitySession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting RestoreStabilitySession at ");
                    OLogger.logTime(ts);
                    RESTORESTABILITY.process(oracleHomePath);
                    break block236;
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
            }
            if (session instanceof CompareInventorySession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting CompareInventorySession at ");
                    OLogger.logTime(ts);
                    if (OPatchSession.meetOUIVersionRequired()) {
                        COMPARE.process();
                        break block236;
                    }
                    opatchVer = OPatchSession.getVersion();
                    detectedOUI = OPatchSDK.getOUIVersion();
                    String requiredOUI = "10.2";
                    String msg = OLogger.getString("OUI-67114", new Object[]{opatchVer, detectedOUI, requiredOUI});
                    throw new UnsupportedOperationException(msg);
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
                catch (VerifyFailedException e11) {
                    OLogger.println(e11.getMessage());
                    OPatchEnv.setOpatchExitCode(6);
                    throw e11;
                }
                catch (RuntimeException e12) {
                    OLogger.error("OUI-67073", new Object[]{"CompareInventorySession", e12.getMessage()});
                    OPatchEnv.setOpatchExitCode(5);
                    throw e12;
                }
                finally {
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningList", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    StringBuffer ts = new StringBuffer("Finishing CompareInventorySession at ");
                    OLogger.logTime(ts);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof ApplySession || session instanceof ApplyDeploySession) {
                patchLoc = OPatchEnv.getPatchloc();
                try {
                    StringBuffer ts = new StringBuffer("Starting ApplySession at ");
                    OLogger.logTime(ts);
                    if (OPatchSession.meetOUIVersionRequired()) {
                        OPatchStateManagerFactory.initializeSpecifiedSessionStateMangaer("apply", OPatchEnv.getPatchloc());
                        if (OPatchEnv.getisAuto() && OPatchEnv.isBeaHome()) {
                            APPLYDEPLOY.process(patchLoc, oracleHomePath);
                        } else {
                            APPLY.process(patchLoc, oracleHomePath);
                        }
                    } else {
                        String opatchVer2 = OPatchSession.getVersion();
                        String detectedOUI2 = OPatchSDK.getOUIVersion();
                        String requiredOUI = "10.2";
                        String msg = OLogger.getString("OUI-67114", new Object[]{opatchVer2, detectedOUI2, requiredOUI});
                        throw new UnsupportedOperationException(msg);
                    }
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OPatchStateManagerFactory.fallBackToPreviousStateManager();
                    break block236;
                }
                catch (PrereqFailedException e13) {
                    OLogger.logError("OUI-67074", new Object[]{"ApplySession", e13.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e13;
                }
                catch (ExitOPatchException e14) {
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OLogger.error("OUI-67005", new Object[]{"OPatch", e14.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e14;
                }
                catch (RuntimeException e15) {
                    OLogger.error("OUI-67073", new Object[]{"OPatch", e15.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e15;
                }
                catch (Error e16) {
                    OLogger.error("OUI-67073", new Object[]{"OPatch", e16.getMessage()});
                    OLogger.info("OUI-67036");
                    String cookedPatchID = OPatchEnv.getCookedPatchID();
                    try {
                        OPatchSession.restoreOH(oracleHomePath, cookedPatchID, APPLY.getSessionName(), debug);
                    }
                    catch (Throwable t) {
                        OLogger.printlnOnLogAndVerbose(t.getMessage());
                        OLogger.error("OUI-67115", new Object[]{oracleHomePath});
                    }
                    throw e16;
                }
                finally {
                    if (!OPatchEnv.isSrvmUtil()) {
                        OPatchSessionHelper.cleanupPatchUnzipArea();
                        OPatchSessionHelper.cleanupUnzipActionArea();
                    }
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningListOnLog", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    StringBuffer ts = new StringBuffer("Finishing ApplySession at ");
                    OLogger.logTime(ts);
                    long sSpent = OPatchEnv.getTotalTimeSpentOnUserInput() / 1000L;
                    ts = new StringBuffer("Total time spent waiting for user-input is ");
                    ts.append(sSpent);
                    ts.append(" seconds.  Finish at ");
                    OLogger.logTime(ts);
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    String logFile = OPatchEnv.getCmdlineSessionLogFileLocation();
                    OLogger.println("Log file location: " + logFile);
                    SQLUtilities.shutdownAllDB(oracleHomePath);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof RollbackSession || session instanceof RollbackDeploySession) {
                patchLoc = OPatchEnv.getPatchloc();
                String patchID = OPatchEnv.getRollbackPatchid();
                try {
                    StringBuffer ts = new StringBuffer("Starting RollbackSession at ");
                    OLogger.logTime(ts);
                    if (OPatchSession.meetOUIVersionRequired()) {
                        OPatchStateManagerFactory.initializeSpecifiedSessionStateMangaer("rollback", OPatchEnv.getPatchloc());
                        if (OPatchEnv.getisAuto() && OPatchEnv.isBeaHome() && !OPatchEnv.isOPatchSDKMode()) {
                            ROLLBACKDEPLOY.process(patchLoc, patchID, oracleHomePath);
                        } else {
                            ROLLBACK.process(patchLoc, patchID, oracleHomePath);
                        }
                    } else {
                        String opatchVer3 = OPatchSession.getVersion();
                        String detectedOUI3 = OPatchSDK.getOUIVersion();
                        String requiredOUI = "10.2";
                        String msg = OLogger.getString("OUI-67114", new Object[]{opatchVer3, detectedOUI3, requiredOUI});
                        throw new UnsupportedOperationException(msg);
                    }
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OPatchStateManagerFactory.fallBackToPreviousStateManager();
                    break block236;
                }
                catch (PrereqFailedException e17) {
                    OLogger.error("OUI-67074", new Object[]{"RollbackSession", e17.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e17;
                }
                catch (ExitOPatchException e18) {
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OLogger.error("OUI-67005", new Object[]{"RollbackSession", e18.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e18;
                }
                catch (RuntimeException e19) {
                    if (e19.getMessage().contains(OLogger.getString("OUI-68011"))) {
                        OLogger.println(e19.getMessage());
                        OPatchEnv.setOpatchExitCode(21);
                        throw e19;
                    }
                    if (e19.getMessage().equals(OLogger.getString("OUI-67656"))) {
                        OLogger.println(OLogger.getString("OUI-67656"));
                        OPatchEnv.setOpatchExitCode(73);
                        throw e19;
                    }
                    OLogger.error("OUI-67073", new Object[]{"RollbackSession", e19.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e19;
                }
                catch (Error e20) {
                    OLogger.error("OUI-67073", new Object[]{"RollbackSession", e20.getMessage()});
                    OLogger.info("OUI-67036");
                    String cookedPatchID = OPatchEnv.getCookedPatchID();
                    try {
                        OPatchSession.restoreOH(oracleHomePath, cookedPatchID, ROLLBACK.getSessionName(), debug);
                    }
                    catch (Throwable t) {
                        OLogger.printlnOnLogAndVerbose(t.getMessage());
                        OLogger.error("OUI-67115", new Object[]{oracleHomePath});
                    }
                    throw e20;
                }
                finally {
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningList", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    StringBuffer ts = new StringBuffer("Finishing RollbackSession at ");
                    OLogger.logTime(ts);
                    long sSpent = OPatchEnv.getTotalTimeSpentOnUserInput() / 1000L;
                    ts = new StringBuffer("Total time spent waiting for user-input is ");
                    ts.append(sSpent);
                    ts.append(" seconds .  Finish at ");
                    OLogger.logTime(ts);
                    String logFile = OPatchEnv.getCmdlineSessionLogFileLocation();
                    OLogger.println("Log file location: " + logFile);
                    SQLUtilities.shutdownAllDB(oracleHomePath);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof UtilSession) {
                if (!OPatchEnv.isOPatchSDKMode()) {
                    OPatchEnv.setBranchKey("CLI");
                }
                option = OPatchEnv.getUtilOption();
                boolean invokedOplan = option.toLowerCase().equals("saveconfigurationsnapshot");
                if (!(option.equalsIgnoreCase("napply") || option.equalsIgnoreCase("nrollback") || invokedOplan)) {
                    OPatchSessionHelper.loadRACRelatedLibFile();
                    OPatchSessionHelper.loadFMWRelatedLibFile();
                }
                try {
                    UTIL.process(oracleHomePath, option);
                    break block236;
                }
                catch (UnsupportedOperationException e21) {
                    OLogger.error("OUI-67073", new Object[]{"UtilSession", e21.getMessage()});
                    throw e21;
                }
                catch (PrereqFailedException e22) {
                    OLogger.logError("OUI-67074", new Object[]{"UtilSession", e22.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e22;
                }
                catch (ExitOPatchException e23) {
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OLogger.error("OUI-67005", new Object[]{"UtilSession", e23.getMessage()});
                    throw e23;
                }
                catch (OnlinePatchException e24) {
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OLogger.println(e24.getMessage());
                    OPatchEnv.setOpatchExitCode(OnlinePatchException.getErrorCode());
                    throw e24;
                }
                catch (SymbolFailureException e25) {
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OLogger.println(e25.getMessage());
                    OPatchEnv.setOpatchExitCode(SymbolFailureException.getErrorCode());
                    throw e25;
                }
                catch (PatchValidationException e26) {
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OLogger.println(e26.getMessage());
                    OPatchEnv.setOpatchExitCode(PatchValidationException.getErrorCode());
                    throw e26;
                }
                catch (RuntimeException e27) {
                    if (e27.getMessage() != null && e27.getMessage().contains(OLogger.getString("OUI-68011"))) {
                        OLogger.println(e27.getMessage());
                        OPatchEnv.setOpatchExitCode(21);
                        throw e27;
                    }
                    if (e27.getMessage() != null && e27.getMessage().equals(OLogger.getString("OUI-67656"))) {
                        OLogger.println(OLogger.getString("OUI-67656"));
                        OPatchEnv.setOpatchExitCode(73);
                        throw e27;
                    }
                    if (!OPatchEnv.getLogWritePermission()) {
                        OLogger.println(OLogger.getString("OUI-67073", new Object[]{"UtilSession", e27.getMessage()}));
                    }
                    OLogger.error("OUI-67073", new Object[]{"UtilSession", e27.getMessage()});
                    throw e27;
                }
                catch (Error e28) {
                    OLogger.error("OUI-67073", new Object[]{"UtilSession", e28.getMessage()});
                    throw e28;
                }
                finally {
                    if (option.equalsIgnoreCase("napply") && !OPatchEnv.isSrvmUtil()) {
                        OPatchSessionHelper.cleanupPatchUnzipArea();
                        OPatchSessionHelper.cleanupUnzipActionArea();
                    }
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    SQLUtilities.shutdownAllDB(oracleHomePath);
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningListOnLog", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    StringBuffer ts = new StringBuffer("Finishing UtilSession at ");
                    OLogger.logTime(ts);
                    if (option.equals("napply") || option.equals("nrollback")) {
                        String logFile = OPatchEnv.getCmdlineSessionLogFileLocation();
                        OLogger.println("Log file location: " + logFile);
                    }
                    SQLUtilities.shutdownAllDB(oracleHomePath);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof PrereqSession) {
                option = OPatchEnv.getPrereqOption();
                try {
                    PREREQ.process(oracleHomePath, option);
                    break block236;
                }
                catch (UnsupportedOperationException e29) {
                    OLogger.error("OUI-67073", new Object[]{"PrereqSession", e29.getMessage()});
                    OPatchEnv.setOpatchExitCode(2);
                    throw e29;
                }
                catch (RuntimeException e30) {
                    if (e30.getMessage() != null && e30.getMessage().contains(OLogger.getString("OUI-68011"))) {
                        OLogger.println(e30.getMessage());
                        OPatchEnv.setOpatchExitCode(21);
                        throw e30;
                    }
                    OLogger.error("OUI-67073", new Object[]{"PrereqSession", e30.getMessage()});
                    OPatchEnv.setOpatchExitCode(2);
                    throw e30;
                }
                catch (Error e31) {
                    OLogger.error("OUI-67073", new Object[]{"PrereqSession", e31.getMessage()});
                    OPatchEnv.setOpatchExitCode(2);
                    throw e31;
                }
                finally {
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningListOnLog", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    StringBuffer ts = new StringBuffer("Finishing PrereqSession at ");
                    OLogger.logTime(ts);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof UpdateSession) {
                UPDATE.process(oracleHomePath);
            } else {
                System.out.println("This version of OPatch only supports Update, Version, Query, Util, Prereq, LsInventory, Apply and Rollback.");
            }
        }
    }

    public static void main(String[] args) throws Throwable {
        block251: {
            String option;
            String patchLoc;
            String detectedOUI;
            String opatchVer;
            String customDir;
            IOPatchSession session;
            boolean debug;
            String patchStorage;
            block250: {
                Path f2;
                boolean shouldDelete;
                boolean shouldRunScript;
                block249: {
                    block248: {
                        shouldRunScript = false;
                        shouldDelete = false;
                        f2 = null;
                        patchStorage = "";
                        OPatchSession.processDebugEnvironment();
                        debug = true;
                        try {
                            for (int argIndex = 0; argIndex < args.length; ++argIndex) {
                                if (argIndex == 0) {
                                    OPatchEnv.setSessionName(args[argIndex]);
                                }
                                if (argIndex == 1) {
                                    if (!args[argIndex].startsWith("-")) {
                                        OPatchEnv.setSpecifiedOLoggerPatchLoc(args[argIndex]);
                                    } else {
                                        OPatchEnv.setSpecifiedOLoggerPatchLoc(".");
                                    }
                                }
                                if (args[argIndex].equalsIgnoreCase("-ph") && argIndex + 1 < args.length) {
                                    OPatchEnv.setSpecifiedOLoggerPatchLoc(args[argIndex + 1]);
                                }
                                if (!args[argIndex].equalsIgnoreCase("-id") || argIndex + 1 >= args.length) continue;
                                OPatchEnv.setSpecifiedOLoggerPatchID(args[argIndex + 1]);
                            }
                            if (OPatchEnv.isOPatchSDKMode()) {
                                OPatchACL.invokeOLogger(HELP, "disableConsoleOutput", null);
                            }
                        }
                        catch (Exception e2) {
                            if (!OPatchEnv.isOPatchSDKMode()) break block248;
                            OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                            throw e2;
                        }
                    }
                    session = null;
                    try {
                        if (args.length < 1) {
                            OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                            OLogger.error("OUI-67014", new Object[]{"No command specified."});
                            HELP.displayHelp();
                            return;
                        }
                        String tempOracleHome = "";
                        session = CmdLineParser.parse(args);
                    }
                    catch (OnlinePatchException e3) {
                        OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                        OLogger.println(e3.getMessage());
                        OPatchEnv.setOpatchExitCode(OnlinePatchException.getErrorCode());
                        throw e3;
                    }
                    catch (RuntimeException e4) {
                        boolean isObrepo;
                        if (e4.getMessage().contains(OLogger.getString("OUI-68011"))) {
                            throw e4;
                        }
                        OLogger.error("OUI-67014", new Object[]{e4.getMessage()});
                        String sessionName = OPatchSession.getSessionNameString(args[0]);
                        StringBuffer sessionStr = new StringBuffer(" " + sessionName);
                        if (OPatchEnv.isBeaHome() && (sessionName.equals("apply") || sessionName.equals("rollback")) && (OPatchEnv.getisAuto() || OPatchEnv.getFMWDomainName() != null)) {
                            sessionStr.append("-fmw");
                        }
                        String scriptName = (isObrepo = Boolean.parseBoolean(System.getProperties().getProperty("OPatch.OBREPO"))) ? "obrepo" : "opatch";
                        OLogger.log(OLogger.INFO, "Please use the option '" + scriptName + sessionStr.toString() + " -help' to get correct syntax");
                        if (!OPatchEnv.isOPatchSDKMode()) break block249;
                        try {
                            OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                        throw e4;
                    }
                }
                boolean alreadyPresent = false;
                customDir = OPatchEnv.getCustomLogDir();
                boolean isCustomDir = false;
                if (session instanceof UtilSession && customDir != null && !customDir.equals("")) {
                    patchStorage = OPatchEnv.getPatchStorageDirectoryPath(customDir);
                    isCustomDir = true;
                } else {
                    patchStorage = OPatchEnv.getPatchStorageDirectoryPath(OPatchEnv.getOracleHome());
                }
                f2 = WrapperFactory.getNioServiceWrapper().getPath(patchStorage, new String[0]);
                if (Files.exists(f2, new LinkOption[0])) {
                    alreadyPresent = true;
                }
                if (!alreadyPresent) {
                    boolean gotCreated = false;
                    gotCreated = !isCustomDir ? OPatchEnv.setupPatchStorage(OPatchEnv.getOracleHome()) : OPatchEnv.setupPatchStorage(customDir);
                    shouldDelete = true;
                    if (!gotCreated) {
                        StringBuffer errorBuff = new StringBuffer();
                        errorBuff.append("OPatch was not able to create .patch_storage directory");
                        errorBuff.append("\n");
                        errorBuff.append("Unable to get Environent variables for Stand Alone home");
                        OLogger.printlnOnLog(OLogger.INFO, errorBuff.toString());
                    } else {
                        shouldRunScript = true;
                    }
                } else {
                    shouldRunScript = true;
                }
                if (shouldRunScript) {
                    StringBuffer filePath = new StringBuffer(patchStorage);
                    filePath.append(File.separator);
                    filePath.append(StringResource.getEnvScriptName());
                    OUIReplacer.runEnvScript(filePath.toString());
                }
                StringBuffer filePath = new StringBuffer(patchStorage);
                Path fdir = WrapperFactory.getNioServiceWrapper().getPath(filePath.toString(), new String[0]);
                filePath.append(File.separator);
                filePath.append(StringResource.getEnvScriptName());
                f2 = WrapperFactory.getNioServiceWrapper().getPath(filePath.toString(), new String[0]);
                try {
                    boolean fileDel = true;
                    fileDel = Files.deleteIfExists(f2);
                    if (!fileDel) {
                        OLogger.debug(new StringBuffer("Some problem in deleting the file : " + f2.toAbsolutePath().normalize().toString()));
                    }
                    if (shouldDelete && !(fileDel = Files.deleteIfExists(fdir))) {
                        OLogger.debug(new StringBuffer("Some problem in deleting the dir : " + fdir.toAbsolutePath().normalize().toString()));
                        StringBuffer warnBuff = new StringBuffer();
                        warnBuff.append("Please delete .patch_storage directory ONLY IF NO PATCH IS APPLIED");
                        warnBuff.append("\n");
                        warnBuff.append("This is because OPatch was not able to delete this directory which\n");
                        warnBuff.append("was only created to run script for getting environment variables\n");
                        warnBuff.append("No manual deletion may result in OPatch wrongly detecting irregular inventory for future invocation.");
                        OLogger.printlnOnLog(OLogger.INFO, warnBuff.toString());
                    }
                }
                catch (SecurityException e5) {
                    StringBuffer errorBuff = new StringBuffer();
                    errorBuff.append("OPatch encounters exception while performing deletion of Env script (or) .patch_storage directory");
                    errorBuff.append("\n");
                    errorBuff.append(e5.getMessage());
                    OLogger.printlnOnLog(OLogger.INFO, errorBuff.toString());
                    OLogger.printStackTrace(e5);
                }
                System.setProperty("OPatch.PATH", OUIReplacer.getEnv("PATH"));
                System.setProperty("OPatch.PLATFORM_ID", OUIReplacer.getEnv("OPATCH_PLATFORM_ID"));
                System.setProperty("OPatch.NO_FUSER", OUIReplacer.getEnv("OPATCH_NO_FUSER"));
                Properties opatchProp = OPatchEnv.getOPatchProperties();
                Properties systemProp = System.getProperties();
                Properties mergedProp = OPatchProperty.mergeProperties(opatchProp, systemProp);
                System.setProperties(mergedProp);
                OPatchEnv.setOPatchProperties(mergedProp);
                try {
                    String historyFilename = OPatchEnv.getHistoryFile(OPatchEnv.getOracleHome());
                    String logfile = OPatchEnv.getLogFileNameAndLocation(OPatchEnv.getOracleHome());
                    StringBuffer buff = new StringBuffer("Log File    : ");
                    buff.append(logfile);
                    buff.append("\n\n");
                    try {
                        if (!OPatchEnv.isLogDisabled()) {
                            if (!Files.exists(WrapperFactory.getNioServiceWrapper().getPath(historyFilename, new String[0]), new LinkOption[0]) && OUIReplacer.isRootAccess(OPatchEnv.getOracleHome())) {
                                String newFileCmd = "touch " + historyFilename.toString();
                                SystemCall.ExecReturn re = SystemCall.process(newFileCmd, OPatchEnv.getOHOwner(OPatchEnv.getOracleHome()));
                                if (!re.isOK()) {
                                    throw new RuntimeException(re.getErrorMessage());
                                }
                                OUIReplacer.changePermission(historyFilename, 416);
                            }
                            BufferedWriter historyFile = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(historyFilename, new String[0]), Charset.forName("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                            historyFile.write(buff.toString());
                            historyFile.close();
                            break block250;
                        }
                        OLogger.debug("Skip creating history file: log is disabled.");
                    }
                    catch (Exception e6) {
                        buff = new StringBuffer("OPatch could not create/open history file to add log filename :\n" + historyFilename.toString());
                        buff.append("\n" + e6.getMessage());
                        OLogger.debug(buff);
                    }
                }
                catch (NoSuchElementException e7) {
                    OLogger.log(OLogger.INFO, "LogFile name is not written to history file.");
                    OLogger.debug(new StringBuffer("LogFile name is not written to history file : " + e7.getMessage()));
                }
            }
            StringBuffer optLog = new StringBuffer("OPatch invoked as follows: '");
            boolean ignoreFlag = false;
            boolean isSuppliedNodes = false;
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].equalsIgnoreCase("-pre") || ignoreFlag) {
                    if (!args[i2].equalsIgnoreCase("-opatch_pre_end")) {
                        ignoreFlag = true;
                        continue;
                    }
                    ignoreFlag = false;
                    continue;
                }
                if (args[i2].equalsIgnoreCase("-post") || ignoreFlag) {
                    if (!args[i2].equalsIgnoreCase("-opatch_post_end")) {
                        ignoreFlag = true;
                        continue;
                    }
                    ignoreFlag = false;
                    continue;
                }
                if (args[i2].equalsIgnoreCase("-init") || ignoreFlag) {
                    if (!args[i2].equalsIgnoreCase("-opatch_init_end")) {
                        ignoreFlag = true;
                        continue;
                    }
                    ignoreFlag = false;
                    continue;
                }
                if (args[i2].equalsIgnoreCase("-connectstring") && i2 + 1 < args.length && args[i2 + 1] != null && !args[i2 + 1].equals("")) {
                    args[i2 + 1] = "*****";
                }
                if (args[i2].equalsIgnoreCase("-supplied_nodes")) {
                    isSuppliedNodes = true;
                }
                optLog.append(args[i2]);
                optLog.append(" ");
            }
            optLog.append("'");
            if (isSuppliedNodes) {
                optLog.append("\nThis option '-");
                optLog.append("supplied_nodes");
                optLog.append("' is a private interface being used during install only.");
            }
            OLogger.justlog(OLogger.INFO, optLog.toString());
            OLogger.log(OLogger.FINEST, "OPatchSession::main()");
            if (OPatchEnv.isSyntaxError()) {
                OLogger.error("OUI-67014", new Object[]{OPatchEnv.getSyntaxErrorMsg()});
                String sessionName = OPatchSession.getSessionNameString(args[0]);
                StringBuffer sessionStr = new StringBuffer(" " + sessionName);
                if ((sessionName.equals("apply") || sessionName.equals("rollback")) && (OPatchEnv.getisAuto() || OPatchEnv.getFMWDomainName() != null)) {
                    sessionStr.append(" ");
                    sessionStr.append("-fmw");
                    sessionStr.append(" ");
                }
                boolean isObrepo = Boolean.parseBoolean(System.getProperties().getProperty("OPatch.OBREPO"));
                if (sessionName.equals("lspatches") && !isObrepo) {
                    OPatchEnv.setOpatchExitCode(2);
                }
                String scriptName = isObrepo ? "obrepo" : "opatch";
                OLogger.log(OLogger.INFO, "Please use the option '" + scriptName + sessionStr.toString() + " -help' to get correct syntax");
                if (OPatchEnv.isOPatchSDKMode()) {
                    try {
                        OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                    }
                    catch (IllegalAccessException e8) {
                        // empty catch block
                    }
                }
                throw new UnsupportedOperationException(OLogger.getString("OUI-67014", new Object[]{OPatchEnv.getSyntaxErrorMsg()}));
            }
            if (OPatchEnv.isArgumentError()) {
                OLogger.error("OUI-67135", new Object[]{OPatchEnv.getArgumentErrorMsg()});
                OLogger.log(OLogger.INFO, "Please check the arguments and try again.");
                if (OPatchEnv.isOPatchSDKMode()) {
                    try {
                        OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                    }
                    catch (IllegalAccessException e9) {
                        // empty catch block
                    }
                }
                throw new UnsupportedOperationException(OLogger.getString("OUI-67135", new Object[]{OPatchEnv.getArgumentErrorMsg()}));
            }
            if (session == null) {
                if (OPatchEnv.isFmwHelp()) {
                    FMW.displayHelp();
                } else if (HELP instanceof Help && HELP.helpPresent()) {
                    HELP.displayHelp();
                }
                return;
            }
            if (OPatchEnv.isHelp()) {
                OPatchSession.displaySessionHelp(session);
                return;
            }
            try {
                if (session instanceof LsPatchesSession) {
                    String oh = OPatchEnv.getOracleHome();
                    String opatchVersion = OPatchSession.getVersion();
                    String logFile = OPatchEnv.getLogFileNameAndLocation(oh);
                    OLogger.onlyLogInfo("OUI-67737", new Object[]{oh, opatchVersion, logFile});
                    String oraInstLoc = OPatchEnv.getInvPtrLoc();
                    if (OPatchEnv.isInvPtrLocSpecified() && oraInstLoc.equals("")) {
                        String userSupply = OPatchEnv.getUserSpecifiedInvPtrLoc();
                        String error = OLogger.getString("OUI-67106", new Object[]{userSupply});
                        OLogger.error("OUI-67106", new Object[]{userSupply});
                        OPatchEnv.setOpatchExitCode(2);
                        throw new RuntimeException(error);
                    }
                } else {
                    OPatchEnv.printOPatchHeader();
                }
            }
            catch (RuntimeException e10) {
                if (OPatchEnv.isOPatchSDKMode()) {
                    try {
                        OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                    }
                    catch (IllegalAccessException e1) {
                        // empty catch block
                    }
                }
                throw e10;
            }
            IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
            if (readServices.isLocked()) {
                OPatchEnv.setInvExists(true);
            } else {
                OPatchEnv.setInvExists(false);
            }
            String oracleHomePath = OPatchEnv.getOracleHome();
            patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
            customDir = OPatchEnv.getCustomLogDir();
            if (session instanceof UtilSession && customDir != null && !customDir.equals("")) {
                patchStorage = OPatchEnv.getPatchStorageDirectoryPath(customDir);
            }
            if (session instanceof QuerySession || session instanceof FmwHelp || session instanceof VersionSession || session instanceof LsInventorySession || session instanceof PrereqSession) {
                OPatchSessionHelper.loadRACRelatedLibFile();
                OPatchSessionHelper.loadFMWRelatedLibFile();
            }
            if (session instanceof QuerySession) {
                String patchLocation = OPatchEnv.getPatchloc();
                QUERY.process(patchLocation);
                break block251;
            }
            if (session instanceof FmwHelp) {
                FMW.process();
                return;
            }
            if (session instanceof VersionSession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting VersionSession at: ");
                    OLogger.logTime(ts);
                    if (!OPatchSession.meetOUIVersionRequired()) {
                        opatchVer = OPatchSession.getVersion();
                        detectedOUI = OPatchSDK.getOUIVersion();
                        String requiredOUI = "10.2";
                        String msg = OLogger.getString("OUI-67114", new Object[]{opatchVer, detectedOUI, requiredOUI});
                        throw new UnsupportedOperationException(msg);
                    }
                    OPatchStateManagerFactory.initializeSpecifiedSessionStateMangaer("version", "");
                    VERSION.process(oracleHomePath);
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    break block251;
                }
                catch (RuntimeException e11) {
                    OLogger.error("OUI-67073", new Object[]{"VersionSession", e11.getMessage()});
                    throw e11;
                }
                finally {
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningList", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    StringBuffer ts = new StringBuffer("Finishing VersionSession at ");
                    OLogger.logTime(ts);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof EnableCasSession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting EnableCasSession at ");
                    OLogger.logTime(ts);
                    ENABLECAS.process();
                    break block251;
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
            }
            if (session instanceof DisableCasSession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting DisableCasSession at ");
                    OLogger.logTime(ts);
                    DISABLECAS.process();
                    break block251;
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
            }
            if (session instanceof EnableIOCSession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting EnableIOCSession at ");
                    OLogger.logTime(ts);
                    ENABLEIOC.process(oracleHomePath);
                    break block251;
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
            }
            if (session instanceof CheckStabilitySession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting CheckStabilitySession at ");
                    OLogger.logTime(ts);
                    CHECKSTABILITY.process(oracleHomePath);
                    break block251;
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
            }
            if (session instanceof RestoreStabilitySession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting RestoreStabilitySession at ");
                    OLogger.logTime(ts);
                    RESTORESTABILITY.process(oracleHomePath);
                    break block251;
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
            }
            if (session instanceof LsInventorySession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting LsInventorySession at ");
                    OLogger.logTime(ts);
                    if (OPatchSession.meetOUIVersionRequired()) {
                        LSINVENTORY.process(oracleHomePath);
                        break block251;
                    }
                    opatchVer = OPatchSession.getVersion();
                    detectedOUI = OPatchSDK.getOUIVersion();
                    String requiredOUI = "10.2";
                    String msg = OLogger.getString("OUI-67114", new Object[]{opatchVer, detectedOUI, requiredOUI});
                    throw new UnsupportedOperationException(msg);
                }
                catch (RuntimeException e12) {
                    OLogger.error("OUI-67073", new Object[]{"LsInventorySession", e12.getMessage()});
                    throw e12;
                }
                finally {
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningListOnLog", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    StringBuffer ts = new StringBuffer("Finishing LsInventorySession at ");
                    OLogger.logTime(ts);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof LsPatchesSession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting LsPatchesSession at ");
                    OLogger.logTime(ts);
                    if (OPatchSession.meetOUIVersionRequired()) {
                        LSPATCHES.process(oracleHomePath);
                        break block251;
                    }
                    opatchVer = OPatchSession.getVersion();
                    detectedOUI = OPatchSDK.getOUIVersion();
                    String requiredOUI = "10.2";
                    String msg = OLogger.getString("OUI-67114", new Object[]{opatchVer, detectedOUI, requiredOUI});
                    throw new UnsupportedOperationException(msg);
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(1);
                    throw ne;
                }
                catch (VerifyFailedException e13) {
                    OLogger.println(e13.getMessage());
                    OPatchEnv.setOpatchExitCode(3);
                    throw e13;
                }
                catch (RuntimeException e14) {
                    if (e14.getMessage().contains(OLogger.getString("OUI-68011"))) {
                        OLogger.println(e14.getMessage());
                        OPatchEnv.setOpatchExitCode(21);
                        throw e14;
                    }
                    OLogger.error("OUI-67073", new Object[]{"LsPatchesSession", e14.getMessage()});
                    OPatchEnv.setOpatchExitCode(2);
                    throw e14;
                }
                finally {
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningList", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    StringBuffer ts = new StringBuffer("Finishing LsPatchesSession at ");
                    OLogger.logTime(ts);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof CompareInventorySession) {
                try {
                    StringBuffer ts = new StringBuffer("Starting CompareInventorySession at ");
                    OLogger.logTime(ts);
                    if (OPatchSession.meetOUIVersionRequired()) {
                        COMPARE.process();
                        break block251;
                    }
                    opatchVer = OPatchSession.getVersion();
                    detectedOUI = OPatchSDK.getOUIVersion();
                    String requiredOUI = "10.2";
                    String msg = OLogger.getString("OUI-67114", new Object[]{opatchVer, detectedOUI, requiredOUI});
                    throw new UnsupportedOperationException(msg);
                }
                catch (NotFoundException ne) {
                    OLogger.println(ne.getMessage());
                    OPatchEnv.setOpatchExitCode(4);
                    throw ne;
                }
                catch (VerifyFailedException e15) {
                    OLogger.println(e15.getMessage());
                    OPatchEnv.setOpatchExitCode(6);
                    throw e15;
                }
                catch (RuntimeException e16) {
                    OLogger.error("OUI-67073", new Object[]{"CompareInventorySession", e16.getMessage()});
                    OPatchEnv.setOpatchExitCode(5);
                    throw e16;
                }
                finally {
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningList", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    StringBuffer ts = new StringBuffer("Finishing CompareInventorySession at ");
                    OLogger.logTime(ts);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof ApplySession || session instanceof ApplyDeploySession) {
                patchLoc = OPatchEnv.getPatchloc();
                try {
                    StringBuffer ts = new StringBuffer("Starting ApplySession at ");
                    OLogger.logTime(ts);
                    if (OPatchSession.meetOUIVersionRequired()) {
                        OPatchStateManagerFactory.initializeSpecifiedSessionStateMangaer("apply", OPatchEnv.getPatchloc());
                        if (OPatchEnv.getisAuto() && OPatchEnv.isBeaHome()) {
                            APPLYDEPLOY.process(patchLoc, oracleHomePath);
                        } else {
                            APPLY.process(patchLoc, oracleHomePath);
                        }
                    } else {
                        String opatchVer2 = OPatchSession.getVersion();
                        String detectedOUI2 = OPatchSDK.getOUIVersion();
                        String requiredOUI = "10.2";
                        String msg = OLogger.getString("OUI-67114", new Object[]{opatchVer2, detectedOUI2, requiredOUI});
                        throw new UnsupportedOperationException(msg);
                    }
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OPatchStateManagerFactory.fallBackToPreviousStateManager();
                    break block251;
                }
                catch (PrereqFailedException e17) {
                    OLogger.logError("OUI-67074", new Object[]{"ApplySession", e17.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e17;
                }
                catch (ExitOPatchException e18) {
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OLogger.error("OUI-67005", new Object[]{"OPatch", e18.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e18;
                }
                catch (RuntimeException e19) {
                    OLogger.error("OUI-67073", new Object[]{"OPatch", e19.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e19;
                }
                catch (Error e20) {
                    OLogger.error("OUI-67073", new Object[]{"OPatch", e20.getMessage()});
                    OLogger.info("OUI-67036");
                    String cookedPatchID = OPatchEnv.getCookedPatchID();
                    try {
                        OPatchSession.restoreOH(oracleHomePath, cookedPatchID, APPLY.getSessionName(), debug);
                    }
                    catch (Throwable t) {
                        OLogger.printlnOnLogAndVerbose(t.getMessage());
                        OLogger.error("OUI-67115", new Object[]{oracleHomePath});
                    }
                    throw e20;
                }
                finally {
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningListOnLog", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    StringBuffer ts = new StringBuffer("Finishing ApplySession at ");
                    OLogger.logTime(ts);
                    long sSpent = OPatchEnv.getTotalTimeSpentOnUserInput() / 1000L;
                    ts = new StringBuffer("Total time spent waiting for user-input is ");
                    ts.append(sSpent);
                    ts.append(" seconds.  Finish at ");
                    OLogger.logTime(ts);
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    String logFile = OPatchEnv.getCmdlineSessionLogFileLocation();
                    OLogger.println("Log file location: " + logFile);
                    SQLUtilities.shutdownAllDB(oracleHomePath);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof RollbackSession || session instanceof RollbackDeploySession) {
                patchLoc = OPatchEnv.getPatchloc();
                String patchID = OPatchEnv.getRollbackPatchid();
                try {
                    StringBuffer ts = new StringBuffer("Starting RollbackSession at ");
                    OLogger.logTime(ts);
                    if (OPatchSession.meetOUIVersionRequired()) {
                        OPatchStateManagerFactory.initializeSpecifiedSessionStateMangaer("rollback", OPatchEnv.getPatchloc());
                        if (OPatchEnv.getisAuto() && OPatchEnv.isBeaHome() && !OPatchEnv.isOPatchSDKMode()) {
                            ROLLBACKDEPLOY.process(patchLoc, patchID, oracleHomePath);
                        } else {
                            ROLLBACK.process(patchLoc, patchID, oracleHomePath);
                        }
                    } else {
                        String opatchVer3 = OPatchSession.getVersion();
                        String detectedOUI3 = OPatchSDK.getOUIVersion();
                        String requiredOUI = "10.2";
                        String msg = OLogger.getString("OUI-67114", new Object[]{opatchVer3, detectedOUI3, requiredOUI});
                        throw new UnsupportedOperationException(msg);
                    }
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OPatchStateManagerFactory.fallBackToPreviousStateManager();
                    break block251;
                }
                catch (PrereqFailedException e21) {
                    OLogger.error("OUI-67074", new Object[]{"RollbackSession", e21.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e21;
                }
                catch (ExitOPatchException e22) {
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OLogger.error("OUI-67005", new Object[]{"RollbackSession", e22.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e22;
                }
                catch (RuntimeException e23) {
                    if (e23.getMessage().contains(OLogger.getString("OUI-68011"))) {
                        OLogger.println(e23.getMessage());
                        OPatchEnv.setOpatchExitCode(21);
                        throw e23;
                    }
                    if (e23.getMessage().equals(OLogger.getString("OUI-67656"))) {
                        OLogger.println(OLogger.getString("OUI-67656"));
                        OPatchEnv.setOpatchExitCode(73);
                        throw e23;
                    }
                    OLogger.error("OUI-67073", new Object[]{"RollbackSession", e23.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e23;
                }
                catch (Error e24) {
                    OLogger.error("OUI-67073", new Object[]{"RollbackSession", e24.getMessage()});
                    OLogger.info("OUI-67036");
                    String cookedPatchID = OPatchEnv.getCookedPatchID();
                    try {
                        OPatchSession.restoreOH(oracleHomePath, cookedPatchID, ROLLBACK.getSessionName(), debug);
                    }
                    catch (Throwable t) {
                        OLogger.printlnOnLogAndVerbose(t.getMessage());
                        OLogger.error("OUI-67115", new Object[]{oracleHomePath});
                    }
                    throw e24;
                }
                finally {
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningList", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    StringBuffer ts = new StringBuffer("Finishing RollbackSession at ");
                    OLogger.logTime(ts);
                    long sSpent = OPatchEnv.getTotalTimeSpentOnUserInput() / 1000L;
                    ts = new StringBuffer("Total time spent waiting for user-input is ");
                    ts.append(sSpent);
                    ts.append(" seconds .  Finish at ");
                    OLogger.logTime(ts);
                    String logFile = OPatchEnv.getCmdlineSessionLogFileLocation();
                    OLogger.println("Log file location: " + logFile);
                    SQLUtilities.shutdownAllDB(oracleHomePath);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof UtilSession) {
                boolean invokedOplan;
                if (!OPatchEnv.isOPatchSDKMode()) {
                    OPatchEnv.setBranchKey("CLI");
                }
                if (!(invokedOplan = (option = OPatchEnv.getUtilOption()).toLowerCase().equals("saveconfigurationsnapshot"))) {
                    OPatchSessionHelper.loadRACRelatedLibFile();
                }
                if (!(option.equalsIgnoreCase("napply") || option.equalsIgnoreCase("nrollback") || invokedOplan)) {
                    OPatchSessionHelper.loadRACRelatedLibFile();
                    OPatchSessionHelper.loadFMWRelatedLibFile();
                }
                try {
                    UTIL.process(oracleHomePath, option);
                    break block251;
                }
                catch (UnsupportedOperationException e25) {
                    OLogger.error("OUI-67073", new Object[]{"UtilSession", e25.getMessage()});
                    throw e25;
                }
                catch (PrereqFailedException e26) {
                    OLogger.logError("OUI-67074", new Object[]{"UtilSession", e26.getMessage()});
                    OLogger.onlyLogInfo("OUI-67035");
                    throw e26;
                }
                catch (ExitOPatchException e27) {
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OLogger.error("OUI-67005", new Object[]{"UtilSession", e27.getMessage()});
                    throw e27;
                }
                catch (OnlinePatchException e28) {
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OLogger.println(e28.getMessage());
                    OPatchEnv.setOpatchExitCode(OnlinePatchException.getErrorCode());
                    throw e28;
                }
                catch (SymbolFailureException e29) {
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OLogger.println(e29.getMessage());
                    OPatchEnv.setOpatchExitCode(SymbolFailureException.getErrorCode());
                    throw e29;
                }
                catch (PatchValidationException e30) {
                    OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                    OLogger.println(e30.getMessage());
                    OPatchEnv.setOpatchExitCode(PatchValidationException.getErrorCode());
                    throw e30;
                }
                catch (RuntimeException e31) {
                    if (e31.getMessage() != null && e31.getMessage().contains(OLogger.getString("OUI-68011"))) {
                        OLogger.println(e31.getMessage());
                        OPatchEnv.setOpatchExitCode(21);
                        throw e31;
                    }
                    if (e31.getMessage() != null && e31.getMessage().equals(OLogger.getString("OUI-67656"))) {
                        OLogger.println(OLogger.getString("OUI-67656"));
                        OPatchEnv.setOpatchExitCode(73);
                        throw e31;
                    }
                    if (!OPatchEnv.getLogWritePermission()) {
                        OLogger.println(OLogger.getString("OUI-67073", new Object[]{"UtilSession", e31.getMessage()}));
                    }
                    OLogger.error("OUI-67073", new Object[]{"UtilSession", e31.getMessage()});
                    throw e31;
                }
                catch (Error e32) {
                    OLogger.error("OUI-67073", new Object[]{"UtilSession", e32.getMessage()});
                    throw e32;
                }
                finally {
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    SQLUtilities.shutdownAllDB(oracleHomePath);
                    OPatchUtilHelper.resetSession();
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningListOnLog", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    StringBuffer ts = new StringBuffer("Finishing UtilSession at ");
                    OLogger.logTime(ts);
                    if (option.equals("napply") || option.equals("nrollback")) {
                        String logFile = OPatchEnv.getCmdlineSessionLogFileLocation();
                        OLogger.println("Log file location: " + logFile);
                    }
                    SQLUtilities.shutdownAllDB(oracleHomePath);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof PrereqSession) {
                option = OPatchEnv.getPrereqOption();
                try {
                    PREREQ.process(oracleHomePath, option);
                    break block251;
                }
                catch (UnsupportedOperationException e33) {
                    OLogger.error("OUI-67073", new Object[]{"PrereqSession", e33.getMessage()});
                    OPatchEnv.setOpatchExitCode(2);
                    throw e33;
                }
                catch (RuntimeException e34) {
                    if (e34.getMessage().contains(OLogger.getString("OUI-68011"))) {
                        OLogger.println(e34.getMessage());
                        OPatchEnv.setOpatchExitCode(21);
                        throw e34;
                    }
                    OLogger.error("OUI-67073", new Object[]{"PrereqSession", e34.getMessage()});
                    OPatchEnv.setOpatchExitCode(2);
                    throw e34;
                }
                catch (Error e35) {
                    OLogger.error("OUI-67073", new Object[]{"PrereqSession", e35.getMessage()});
                    OPatchEnv.setOpatchExitCode(2);
                    throw e35;
                }
                finally {
                    if (readServices.isLocked()) {
                        readServices.release();
                    }
                    if (Integer.parseInt(OPatchACL.invokeOLogger(HELP, "getWarningListLength", null).toString()) != 0) {
                        OPatchACL.invokeOLogger(HELP, "printWarningListOnLog", null);
                        if (OPatchEnv.getOpatchExitCode() == 0) {
                            OLogger.error("OUI-67008");
                        }
                    }
                    StringBuffer ts = new StringBuffer("Finishing PrereqSession at ");
                    OLogger.logTime(ts);
                    OPatchACL.invokeOLogger(HELP, "enableConsoleOutput", null);
                }
            }
            if (session instanceof UpdateSession) {
                UPDATE.process(oracleHomePath);
            } else {
                System.out.println("This version of OPatch only supports Update, Version, Query, Util, Prereq, LsInventory, Apply and Rollback.");
            }
        }
    }

    public static void displaySessionHelp(IOPatchSession session) {
        if (session instanceof ApplyDeploySession) {
            if (OPatchEnv.isFmwHelp()) {
                if (APPLYDEPLOY instanceof Help && APPLYDEPLOY.helpPresent()) {
                    APPLYDEPLOY.displayHelp();
                }
            } else if (APPLY instanceof Help && APPLY.helpPresent()) {
                APPLY.displayHelp();
            }
        } else if (session instanceof ApplySession) {
            if (OPatchEnv.isFmwHelp()) {
                if (APPLYDEPLOY instanceof Help && APPLYDEPLOY.helpPresent()) {
                    APPLYDEPLOY.displayHelp();
                }
            } else if (APPLY instanceof Help && APPLY.helpPresent()) {
                APPLY.displayHelp();
            }
        } else if (session instanceof RollbackSession) {
            if (OPatchEnv.isFmwHelp()) {
                if (ROLLBACKDEPLOY instanceof Help && ROLLBACKDEPLOY.helpPresent()) {
                    ROLLBACKDEPLOY.displayHelp();
                }
            } else if (ROLLBACK instanceof Help && ROLLBACK.helpPresent()) {
                ROLLBACK.displayHelp();
            }
        } else if (session instanceof RollbackDeploySession) {
            if (OPatchEnv.isFmwHelp()) {
                if (ROLLBACKDEPLOY instanceof Help && ROLLBACKDEPLOY.helpPresent()) {
                    ROLLBACKDEPLOY.displayHelp();
                }
            } else if (ROLLBACK instanceof Help && ROLLBACK.helpPresent()) {
                ROLLBACK.displayHelp();
            }
        } else if (session instanceof VersionSession) {
            if (VERSION instanceof Help && VERSION.helpPresent()) {
                VERSION.displayHelp();
            }
        } else if (session instanceof LsInventorySession) {
            if (LSINVENTORY instanceof Help && LSINVENTORY.helpPresent()) {
                LSINVENTORY.displayHelp();
            }
        } else if (session instanceof LsPatchesSession) {
            if (LSPATCHES instanceof Help && LSPATCHES.helpPresent()) {
                LSPATCHES.displayHelp();
            }
        } else if (session instanceof CompareInventorySession) {
            if (COMPARE instanceof Help && COMPARE.helpPresent()) {
                COMPARE.displayHelp();
            }
        } else if (session instanceof QuerySession) {
            if (QUERY instanceof Help && QUERY.helpPresent()) {
                QUERY.displayHelp();
            }
        } else if (session instanceof UtilSession) {
            if (UTIL instanceof Help && UTIL.helpPresent()) {
                UTIL.displayHelp();
            }
        } else if (session instanceof PrereqSession) {
            if (PREREQ instanceof Help && PREREQ.helpPresent()) {
                PREREQ.displayHelp();
            }
        } else if (session instanceof FmwHelp) {
            if (FMW instanceof Help && FMW.helpPresent()) {
                FMW.displayHelp();
            }
        } else if (session instanceof CheckStabilitySession) {
            if (CHECKSTABILITY instanceof Help && CHECKSTABILITY.helpPresent()) {
                CHECKSTABILITY.displayHelp();
            }
        } else if (session instanceof RestoreStabilitySession && RESTORESTABILITY instanceof Help && RESTORESTABILITY.helpPresent()) {
            RESTORESTABILITY.displayHelp();
        }
    }

    public static void validateConnectStringNodes(String localNode, String[] remoteNodes) {
        boolean noRac = false;
        if (!(localNode != null && !localNode.equals("") || remoteNodes != null && remoteNodes.length != 0)) {
            noRac = true;
        }
        String[] dbNodes = OPatchEnv.getDBNodes();
        if (noRac) {
            if (dbNodes == null || dbNodes.length == 0) {
                return;
            }
            for (int i2 = 0; i2 < dbNodes.length; ++i2) {
                if (dbNodes[i2] == null || dbNodes[i2].equals("")) continue;
                StringBuffer buff = new StringBuffer("This is not a RAC setup.");
                buff.append(" OPatch cannot determine the local node name,");
                buff.append("\nbut the value to \"connectString\" option has the node name.");
                buff.append("\nPlease remove the node name if only local node is being patched.");
                buff.append("\nSee help file for more details about \"connectString\" option.\n");
                OLogger.println(buff.toString());
                RuntimeException re = new RuntimeException("Invalid values specified.");
                throw re;
            }
        } else {
            if (dbNodes == null || dbNodes.length == 0) {
                return;
            }
            for (int i3 = 0; i3 < dbNodes.length; ++i3) {
                if (dbNodes[i3] == null || dbNodes[i3].equals("")) continue;
                boolean found = false;
                if (localNode.equals(dbNodes[i3])) {
                    found = true;
                } else {
                    for (int j2 = 0; j2 < remoteNodes.length; ++j2) {
                        if (!remoteNodes[j2].equals(dbNodes[i3])) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                StringBuffer buff = new StringBuffer("This is RAC setup.");
                buff.append(" The node name given in the \"connectString\" option");
                buff.append("\nis neither the local node nor the remote node.");
                buff.append("\nPlease provide the correct node name in the value.");
                buff.append("\nSee help file for more details about \"connectString\" option.\n");
                OLogger.println(buff.toString());
                RuntimeException re = new RuntimeException("Invalid values specified.");
                throw re;
            }
        }
    }

    static {
        LSPATCHES = new LsPatchesSession("lspatches", true);
        COMPARE = new CompareInventorySession("compare", true);
        LSINVENTORY = new LsInventorySession("lsinventory", true);
        FMW = new FmwHelp("fmw", true);
        APPLY = new ApplySession("apply", false);
        ROLLBACK = new RollbackSession("rollback", false);
        QUERY = new QuerySession("query", true);
        HELP = new OPatchSession("help", true);
        VERSION = new VersionSession("version", false);
        UTIL = new UtilSession("util", false);
        PREREQ = new PrereqSession("prereq", true);
        APPLYDEPLOY = new ApplyDeploySession("apply", false);
        ROLLBACKDEPLOY = new RollbackDeploySession("rollback", false);
        UPDATE = new UpdateSession("update", false);
        ENABLECAS = new EnableCasSession("enablecas", true);
        DISABLECAS = new DisableCasSession("disablecas", true);
        ENABLEIOC = new EnableIOCSession("enableioc", true);
        CHECKSTABILITY = new CheckStabilitySession("checkstability", true);
        RESTORESTABILITY = new RestoreStabilitySession("restorestability", true);
    }

    public static class MakeStatus
    implements StdoutStatus {
        @Override
        public void printStdout(SystemCall.ExecReturn ret) {
            String cmd = ret.getCommand();
            int retCode = ret.getReturnCode();
            String stdoutMsg = ret.getNormalMessage();
            String stderrMsg = ret.getErrorMessage();
            StringBuffer tmp = new StringBuffer("\nMake result:\n");
            tmp.append("  Command: ");
            tmp.append(cmd);
            tmp.append("\n");
            tmp.append("  Returned code: ");
            tmp.append(retCode);
            tmp.append("\n");
            tmp.append("  Stdout output:\n");
            tmp.append(stdoutMsg);
            tmp.append("\n");
            tmp.append("  Stderr output:\n");
            tmp.append(stderrMsg);
            tmp.append("\n");
            OLogger.log(OLogger.SEVERE, tmp.toString());
        }
    }
}

