/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchsdk.OPatchBundlePatchValidatorAndGenerator;
import oracle.opatch.patchsdk.OPatchEngineeredSystemPatchValidatorAndGenerator;
import oracle.opatch.patchsdk.OPatchSingletonPatchValidatorAndGenerator;
import oracle.opatch.patchsdk.PatchFactory;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.patchmodel.PatchPackage;

public class PatchPackageGenerator {
    private static PatchFactory pf = new PatchFactory();

    public static PatchPackage getPatchInstance(String patchLocation) throws PatchPackageException {
        if (patchLocation == null || patchLocation.equals("")) {
            return null;
        }
        PatchPackage patch = null;
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        try {
            if (!isConsoleOutputDisabled) {
                OLogger.disableConsoleOutput(true);
            }
            patch = pf.getInstance(patchLocation);
        }
        catch (PatchPackageException pe) {
            throw pe;
        }
        finally {
            if (!isConsoleOutputDisabled) {
                OLogger.enableConsoleOutput(true);
            }
        }
        return patch;
    }

    static {
        pf.addPatchValidatorAndGenerator(new OPatchSingletonPatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator(new OPatchEngineeredSystemPatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator(new OPatchBundlePatchValidatorAndGenerator());
    }
}

