/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import oracle.opatch.OPatchEnv;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.INPatchPlan;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.IStep;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.conflicttextualinterpreter.OracleHomeConflictMap;
import oracle.opatch.conflicttextualinterpreter.SetResolution;
import oracle.opatch.opatchlogger.OLogger;

public class LocalConflictResolution
implements IStep {
    @Override
    public void process(IConflictMap map, INPatchPlan plan) {
        SetResolution setRes = SetResolution.getInstance();
        for (IPatch patch : map.getPoh()) {
            NPatchRelations relations = map.getRelations(patch);
            this.processSubset(relations, patch);
            if (!relations.getWorses().isEmpty()) {
                if (patch.isComposite()) continue;
                setRes.mark(patch, new NPatchRelations(relations));
                continue;
            }
            if (!relations.getLowerPSUs().isEmpty()) {
                setRes.mark(patch, null);
                continue;
            }
            if (relations.getSubsetPSU().isEmpty()) continue;
            patch.setECPB(true);
            setRes.mark(patch, null);
        }
        setRes.resolve(map, plan);
    }

    private void processSubset(NPatchRelations relations, IPatch patch) {
        if (!relations.getWholeSubsets().isEmpty()) {
            if (patch.isComposite()) {
                return;
            }
            IPatch supersetPatch = null;
            boolean inactive = false;
            for (NPatchRelation subsetRel : relations.getSubsets()) {
                if (subsetRel.to().isInOh()) {
                    inactive = true;
                    break;
                }
                supersetPatch = subsetRel.to();
            }
            if (inactive) {
                patch.setInactiveAlready();
                return;
            }
            OLogger.debug("Mark subpatch in OH" + patch.getPatchId());
            if (OPatchEnv.isAutoRollbackSubsets() || patch.getOneOffEntry().getAutoRollback()) {
                patch.setRemoveInactiveSubset(true);
            } else {
                OracleHomeConflictMap instance;
                patch.setInActive();
                if (supersetPatch != null && (instance = OracleHomeConflictMap.getInstance()) != null) {
                    instance.getToInActivePatchMap().put(patch.getPatchId(), supersetPatch.getPatchId());
                }
                for (NPatchRelation conflictRel : relations.getConflicts()) {
                    IPatch conflictPatch = conflictRel.to();
                    if (conflictPatch.isInOh() || !patch.getOverlaysID().contains(conflictPatch.getPatchId())) continue;
                    patch.setActive();
                }
            }
            SetResolution.getInstance().mark(patch, new NPatchRelations(relations));
            return;
        }
    }
}

