/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cup;

import com.oracle.cie.common.SecureUnmarshaller;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.opatch.cup.CUPXmlException;
import oracle.opatch.cup.jaxb.PatchComponentInfoCUP;
import oracle.opatch.opatchlogger.OLogger;

public class CUPxmlJaxbBinder {
    private static final String xsdSchema = "files_changed_by_oui.xsd";
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private Schema schema;
    private static volatile CUPxmlJaxbBinder instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CUPxmlJaxbBinder getInstance() throws Exception {
        Class<CUPxmlJaxbBinder> clazz = CUPxmlJaxbBinder.class;
        synchronized (CUPxmlJaxbBinder.class) {
            if (instance == null) {
                instance = new CUPxmlJaxbBinder();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CUPxmlJaxbBinder() throws Exception {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PatchComponentInfoCUP.class});
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.schema = schemaFactory.newSchema(this.getClass().getResource(xsdSchema));
            this.marshaller = context.createMarshaller();
            this.marshaller.setSchema(this.schema);
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            this.marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            this.unmarshaller = context.createUnmarshaller();
            this.unmarshaller.setSchema(this.schema);
        }
        catch (Exception e2) {
            throw new CUPXmlException("Failed to initialize jaxb context");
        }
    }

    public PatchComponentInfoCUP loadFromXML(Path xmlFile) throws CUPXmlException {
        PatchComponentInfoCUP PatchCompInfoObj;
        OLogger.debug(" Loading Patch Info From Poh files_changed_by_oui.xml");
        if (!(xmlFile != null && Files.exists(xmlFile, new LinkOption[0]) && Files.isRegularFile(xmlFile, new LinkOption[0]) && Files.isReadable(xmlFile))) {
            throw new CUPXmlException("Can not load Xml from an invalid File.");
        }
        try (InputStream inputStream = Files.newInputStream(xmlFile, new OpenOption[0]);){
            PatchCompInfoObj = (PatchComponentInfoCUP)SecureUnmarshaller.unmarshal((Unmarshaller)this.unmarshaller, (InputStream)inputStream);
        }
        catch (Exception e2) {
            throw new CUPXmlException("Can not unmarshal object:" + e2);
        }
        return PatchCompInfoObj;
    }

    public void saveToXML(PatchComponentInfoCUP CUPObject, Path xmlFile) throws CUPXmlException {
        OLogger.debug("Marshal to file " + xmlFile);
        if (!(!Files.exists(xmlFile, new LinkOption[0]) || Files.isRegularFile(xmlFile, new LinkOption[0]) && Files.isReadable(xmlFile))) {
            throw new CUPXmlException("Can not load Xml from an invalid File.");
        }
        try (OutputStream outputStream = Files.newOutputStream(xmlFile, new OpenOption[0]);){
            this.marshaller.marshal((Object)CUPObject, outputStream);
            OLogger.debug("Finish Save files_change_by_oui XML.");
        }
        catch (Exception e2) {
            throw new CUPXmlException("Can not marshal the object:" + e2);
        }
    }
}

