/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.UpdateComponent;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchactions.hotpatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.BugConflictException;
import oracle.opatch.opatchprereq.BugSubsetException;
import oracle.opatch.opatchprereq.BugSupersetException;
import oracle.opatch.opatchprereq.GenericConflictException;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiReleaseLevels;
import oracle.sysman.oii.oiii.OiiiVersion;

public class ConflictHandler {
    private boolean activeBugConflict;
    private boolean activeGenericConflict;
    private boolean activeBugSuperset;
    private boolean activeBugSubset;

    public ConflictHandler() {
        this.activeBugConflict = true;
        this.activeGenericConflict = true;
        this.activeBugSuperset = true;
    }

    public ConflictHandler(boolean bugConflict, boolean genericConflict, boolean bugSuperset, boolean bugSubset) {
        this.activeBugConflict = bugConflict;
        this.activeGenericConflict = genericConflict;
        this.activeBugSuperset = bugSuperset;
        this.activeBugSubset = bugSubset;
    }

    private static int compareBugList(OneOffEntry ohOneOff, String applyingPatchID, String[] bugsToFix) {
        if (bugsToFix != null || bugsToFix.length > 0) {
            int j2;
            Arrays.sort(bugsToFix);
            Object[] bugsFixed = ohOneOff.getBugIDsFixed();
            if (bugsFixed == null || bugsFixed.length == 0) {
                return 3;
            }
            Arrays.sort(bugsFixed);
            if (bugsFixed.length == bugsToFix.length) {
                boolean identical = true;
                for (j2 = 0; j2 < bugsFixed.length; ++j2) {
                    if (((String)bugsFixed[j2]).equals(bugsToFix[j2])) continue;
                    identical = false;
                }
                if (identical) {
                    return 0;
                }
                for (j2 = 0; j2 < bugsToFix.length; ++j2) {
                    String bugToFix = bugsToFix[j2];
                    for (int k2 = 0; k2 < bugsFixed.length; ++k2) {
                        Object bugFixed = bugsFixed[k2];
                        if (!bugToFix.equals(bugFixed)) continue;
                        return 2;
                    }
                }
            }
            if (bugsToFix.length > bugsFixed.length) {
                boolean superset = true;
                for (j2 = 0; j2 < bugsFixed.length; ++j2) {
                    boolean found = false;
                    Object bugFixed = bugsFixed[j2];
                    for (int k3 = 0; k3 < bugsToFix.length; ++k3) {
                        String bugToFix = bugsToFix[k3];
                        if (!((String)bugFixed).equals(bugToFix)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    superset = false;
                    break;
                }
                if (superset) {
                    return 1;
                }
            }
            if (bugsToFix.length < bugsFixed.length) {
                boolean subset = true;
                for (j2 = 0; j2 < bugsToFix.length; ++j2) {
                    boolean found = false;
                    String bugToFix = bugsToFix[j2];
                    for (int k4 = 0; k4 < bugsFixed.length; ++k4) {
                        Object bugFixed = bugsFixed[k4];
                        if (!((String)bugFixed).equals(bugToFix)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    subset = false;
                    break;
                }
                if (subset) {
                    return -1;
                }
            }
            return 3;
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OneOffEntry[] skipSubset(String oracleHomePath, OneOffEntry[] patchesToApply) {
        if (patchesToApply == null && patchesToApply.length == 0) {
            return new OneOffEntry[0];
        }
        OneOffEntry[] OHOneOffs = null;
        try {
            OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable t) {
            if (OHOneOffs == null || OHOneOffs.length == 0) {
                return patchesToApply;
            }
        }
        finally {
            if (OHOneOffs == null || OHOneOffs.length == 0) {
                return patchesToApply;
            }
        }
        ArrayList<OneOffEntry> patchesCanGo = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> patchesFiltered = new ArrayList<OneOffEntry>();
        for (int i2 = 0; i2 < patchesToApply.length; ++i2) {
            OneOffEntry eachApplyingPatch = patchesToApply[i2];
            String applyingPatchID = eachApplyingPatch.getID();
            String[] bugsToFix = eachApplyingPatch.getBugIDsFixed();
            if (bugsToFix == null || bugsToFix.length == 0) continue;
            boolean canGo = true;
            for (int j2 = 0; j2 < OHOneOffs.length; ++j2) {
                OneOffEntry ohOneOff = OHOneOffs[j2];
                String ohID = ohOneOff.getID();
                int bugCode = ConflictHandler.compareBugList(ohOneOff, applyingPatchID, bugsToFix);
                if (bugCode != -1) continue;
                patchesFiltered.add(eachApplyingPatch);
                canGo = false;
                break;
            }
            if (!canGo) continue;
            patchesCanGo.add(eachApplyingPatch);
        }
        if (patchesFiltered.size() > 0) {
            String id;
            OneOffEntry e2;
            int i3;
            StringBuffer buff = new StringBuffer("These patches will be skipped ");
            buff.append("because they are subset patches of some patch(es) in the Oracle Home: ");
            for (i3 = 0; i3 < patchesFiltered.size(); ++i3) {
                e2 = (OneOffEntry)patchesFiltered.get(i3);
                id = e2.getID();
                if (i3 > 0) {
                    buff.append(",");
                }
                buff.append(id);
            }
            OLogger.println(buff.toString());
            if (patchesCanGo.size() > 0) {
                buff = new StringBuffer("OPatch continues with these patches: ");
                for (i3 = 0; i3 < patchesCanGo.size(); ++i3) {
                    e2 = (OneOffEntry)patchesCanGo.get(i3);
                    id = e2.getID();
                    if (i3 > 0) {
                        buff.append(",");
                    }
                    buff.append(id);
                }
                OLogger.println(buff.toString());
            }
        }
        OneOffEntry[] retList = new OneOffEntry[patchesCanGo.size()];
        patchesCanGo.toArray(retList);
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OneOffEntry[] skipDuplicate(String oracleHomePath, OneOffEntry[] patchesToApply) {
        if (patchesToApply == null && patchesToApply.length == 0) {
            return new OneOffEntry[0];
        }
        OneOffEntry[] OHOneOffs = null;
        try {
            OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable t) {
            if (OHOneOffs == null || OHOneOffs.length == 0) {
                return patchesToApply;
            }
        }
        finally {
            if (OHOneOffs == null || OHOneOffs.length == 0) {
                return patchesToApply;
            }
        }
        ArrayList<OneOffEntry> patchesCanGo = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> patchesFiltered = new ArrayList<OneOffEntry>();
        for (int i2 = 0; i2 < patchesToApply.length; ++i2) {
            OneOffEntry eachApplyingPatch = patchesToApply[i2];
            String applyingPatchID = eachApplyingPatch.getID();
            String[] bugsToFix = eachApplyingPatch.getBugIDsFixed();
            if (bugsToFix == null || bugsToFix.length == 0) continue;
            boolean canGo = true;
            for (int j2 = 0; j2 < OHOneOffs.length; ++j2) {
                OneOffEntry ohOneOff = OHOneOffs[j2];
                String ohID = ohOneOff.getID();
                int bugCode = ConflictHandler.compareBugList(ohOneOff, applyingPatchID, bugsToFix);
                if (bugCode != 0) continue;
                patchesFiltered.add(eachApplyingPatch);
                canGo = false;
                break;
            }
            if (!canGo) continue;
            patchesCanGo.add(eachApplyingPatch);
        }
        if (patchesFiltered.size() > 0) {
            String id;
            OneOffEntry e2;
            int i3;
            StringBuffer buff = new StringBuffer("These patches will be skipped ");
            buff.append("because they are duplicates of some patch(es) in the Oracle Home: ");
            for (i3 = 0; i3 < patchesFiltered.size(); ++i3) {
                e2 = (OneOffEntry)patchesFiltered.get(i3);
                id = e2.getID();
                if (i3 > 0) {
                    buff.append(",");
                }
                buff.append(id);
            }
            OLogger.println(buff.toString());
            if (patchesCanGo.size() > 0) {
                buff = new StringBuffer("OPatch continues with these patches: ");
                for (i3 = 0; i3 < patchesCanGo.size(); ++i3) {
                    e2 = (OneOffEntry)patchesCanGo.get(i3);
                    id = e2.getID();
                    if (i3 > 0) {
                        buff.append(",");
                    }
                    buff.append(id);
                }
                OLogger.println(buff.toString());
            }
        }
        OneOffEntry[] retList = new OneOffEntry[patchesCanGo.size()];
        patchesCanGo.toArray(retList);
        return retList;
    }

    protected OneOffEntry[] checkBugSuperset(OneOffEntry[] ohOneOffs, String[] bugsToFix, String[] bugsThatSuperset) {
        OneOffEntry[] bugSupersetList = new OneOffEntry[]{};
        StringBuffer buff = new StringBuffer();
        if (!this.isActiveBugSuperset()) {
            return ohOneOffs;
        }
        if (ohOneOffs != null && ohOneOffs.length > 0) {
            boolean flag2 = false;
            boolean flag1 = false;
            ArrayList<OneOffEntry> supersetList = new ArrayList<OneOffEntry>();
            for (int i2 = 0; i2 < ohOneOffs.length; ++i2) {
                String[] bugsFixed = ohOneOffs[i2].getBugIDsFixed();
                flag1 = true;
                for (int j2 = 0; j2 < bugsFixed.length; ++j2) {
                    flag2 = false;
                    for (int k2 = 0; k2 < bugsToFix.length; ++k2) {
                        String bugToFix = bugsToFix[k2];
                        if (!bugsFixed[j2].equals(bugToFix)) continue;
                        flag2 = true;
                        buff.append(bugToFix);
                        buff.append(", ");
                    }
                    if (flag2) continue;
                    flag1 = false;
                    break;
                }
                if (!flag1) continue;
                supersetList.add(ohOneOffs[i2]);
                bugsThatSuperset[i2] = new String(buff.toString());
            }
            if (supersetList.size() > 0) {
                bugSupersetList = new OneOffEntry[supersetList.size()];
                supersetList.toArray(bugSupersetList);
            }
        }
        return bugSupersetList;
    }

    protected OneOffEntry[] checkBugSubset(OneOffEntry[] ohOneOffs, String[] bugsToFix, String[] bugsThatSubset) {
        OneOffEntry[] bugSubsetList = new OneOffEntry[]{};
        StringBuffer buff = new StringBuffer();
        if (!this.isActiveBugSubset()) {
            return ohOneOffs;
        }
        if (ohOneOffs != null && ohOneOffs.length > 0) {
            boolean flag2 = false;
            boolean flag1 = false;
            ArrayList<OneOffEntry> subsetList = new ArrayList<OneOffEntry>();
            for (int i2 = 0; i2 < ohOneOffs.length; ++i2) {
                String[] bugsFixed = ohOneOffs[i2].getBugIDsFixed();
                flag1 = true;
                for (int j2 = 0; j2 < bugsToFix.length; ++j2) {
                    flag2 = false;
                    for (int k2 = 0; k2 < bugsFixed.length; ++k2) {
                        String bugFixed = bugsFixed[k2];
                        if (!bugsToFix[j2].equals(bugFixed)) continue;
                        flag2 = true;
                        buff.append(bugFixed);
                        buff.append(", ");
                    }
                    if (flag2) continue;
                    flag1 = false;
                    break;
                }
                if (!flag1) continue;
                subsetList.add(ohOneOffs[i2]);
                bugsThatSubset[i2] = new String(buff.toString());
            }
            if (subsetList.size() > 0) {
                bugSubsetList = new OneOffEntry[subsetList.size()];
                subsetList.toArray(bugSubsetList);
            }
        }
        return bugSubsetList;
    }

    protected boolean isFileSuperset(OneOffEntry oneOff, PatchAction[] patchActions) {
        OLogger.debug("ConflictHandler::isFileSuperset()");
        PatchAction[] inPatchActions = oneOff.getPatchActions();
        ArrayList<PatchAction> al1 = new ArrayList<PatchAction>();
        for (int i2 = 0; i2 < inPatchActions.length; ++i2) {
            al1.add(inPatchActions[i2]);
        }
        ArrayList<PatchAction> al2 = new ArrayList<PatchAction>();
        for (int j2 = 0; j2 < patchActions.length; ++j2) {
            al2.add(patchActions[j2]);
        }
        return al2.containsAll(al1);
    }

    public boolean isFileWithVersionSubset(OneOffEntry oneOff, OneOffEntry toOneOff, boolean isProper) throws BugSubsetException {
        OLogger.debug("ConflictHandler::isFileWithVersionSubset()");
        PatchAction[] fromPatchActions = oneOff.getPatchActions();
        PatchAction[] toPatchActions = toOneOff.getPatchActions();
        ArrayList<String> fromFileListNotInTo = new ArrayList<String>();
        HashSet<String> noOfFromCopyActions = new HashSet<String>();
        HashSet<String> noOfToCopyActions = new HashSet<String>();
        for (PatchAction frompa : fromPatchActions) {
            if (!(frompa instanceof CopyAction)) continue;
            CopyAction frompaca = (CopyAction)frompa;
            noOfFromCopyActions.add(frompaca.getFilename());
            fromFileListNotInTo.add(frompaca.getFilename());
            for (int i2 = 0; i2 < toPatchActions.length; ++i2) {
                PatchAction topa = toPatchActions[i2];
                if (!(topa instanceof CopyAction)) continue;
                CopyAction topaca = (CopyAction)topa;
                noOfToCopyActions.add(topaca.getFilename());
                if (!frompaca.getFilename().equals(topaca.getFilename())) continue;
                if (frompaca.getFileVersion().equals("") || topaca.getFileVersion().equals("")) {
                    throw new BugSubsetException("File version not found");
                }
                int rel = OPatchSessionHelper.isGreaterDecimal(frompaca.getFileVersion(), topaca.getFileVersion());
                if (rel <= 0) {
                    fromFileListNotInTo.remove(frompaca.getFilename());
                    break;
                }
                return false;
            }
            if (fromFileListNotInTo.size() <= 0) continue;
            return false;
        }
        return !isProper || noOfFromCopyActions.size() != noOfToCopyActions.size();
    }

    public boolean isFileWithVersionSuperset(OneOffEntry oneOff, OneOffEntry toOneOff, boolean isProper) throws BugSupersetException {
        OLogger.debug("ConflictHandler::isFileWithVersionSuperset()");
        boolean isSuperset = false;
        try {
            isSuperset = this.isFileWithVersionSubset(toOneOff, oneOff, isProper);
        }
        catch (BugSubsetException e2) {
            BugSupersetException bse = new BugSupersetException(e2.getMessage());
            bse.setStackTrace(e2.getStackTrace());
            throw bse;
        }
        return isSuperset;
    }

    public boolean isBugSuperset(OneOffEntry[] ohOneOffs, String[] bugsToFix, String[] bugsThatSuperset) throws BugSupersetException {
        try {
            int i2;
            OneOffEntry[] bugSupersetList = new OneOffEntry[]{};
            boolean result = true;
            if (!this.isActiveBugSuperset()) {
                return false;
            }
            if (ohOneOffs != null && ohOneOffs.length == 0) {
                return false;
            }
            bugSupersetList = this.checkBugSuperset(ohOneOffs, bugsToFix, bugsThatSuperset);
            ArrayList<OneOffEntry> tmpAL1 = new ArrayList<OneOffEntry>();
            for (int i3 = 0; i3 < bugSupersetList.length; ++i3) {
                tmpAL1.add(bugSupersetList[i3]);
            }
            ArrayList<OneOffEntry> tmpAL2 = new ArrayList<OneOffEntry>();
            for (i2 = 0; i2 < ohOneOffs.length; ++i2) {
                tmpAL2.add(ohOneOffs[i2]);
            }
            for (i2 = 0; i2 < tmpAL2.size(); ++i2) {
                if (tmpAL1.contains(tmpAL2.get(i2))) continue;
                result = false;
                break;
            }
            return result;
        }
        catch (Throwable t) {
            BugSupersetException e2 = new BugSupersetException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
    }

    public boolean isBugSubset(OneOffEntry[] ohOneOffs, String[] bugsToFix, String[] bugsThatSubset) throws BugSubsetException {
        try {
            int i2;
            OneOffEntry[] bugSubsetList = new OneOffEntry[]{};
            boolean result = true;
            if (!this.isActiveBugSubset()) {
                return false;
            }
            if (ohOneOffs != null && ohOneOffs.length == 0) {
                return false;
            }
            bugSubsetList = this.checkBugSubset(ohOneOffs, bugsToFix, bugsThatSubset);
            ArrayList<OneOffEntry> tmpAL1 = new ArrayList<OneOffEntry>();
            for (int i3 = 0; i3 < bugSubsetList.length; ++i3) {
                tmpAL1.add(bugSubsetList[i3]);
            }
            ArrayList<OneOffEntry> tmpAL2 = new ArrayList<OneOffEntry>();
            for (i2 = 0; i2 < ohOneOffs.length; ++i2) {
                tmpAL2.add(ohOneOffs[i2]);
            }
            for (i2 = 0; i2 < tmpAL2.size(); ++i2) {
                if (tmpAL1.contains(tmpAL2.get(i2))) continue;
                result = false;
                break;
            }
            return result;
        }
        catch (Throwable t) {
            BugSubsetException e2 = new BugSubsetException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
    }

    protected OneOffEntry[] checkIdenticalPatch(OneOffEntry[] ohOneOffs, String[] bugsToFix) {
        OneOffEntry[] bugSupersetList = new OneOffEntry[]{};
        if (ohOneOffs != null) {
            boolean flag2 = false;
            boolean flag1 = false;
            Vector<OneOffEntry> superlist = new Vector<OneOffEntry>();
            for (int i2 = 0; i2 < ohOneOffs.length; ++i2) {
                String[] bugsFixed = ohOneOffs[i2].getBugIDsFixed();
                flag1 = false;
                for (int j2 = 0; j2 < bugsFixed.length; ++j2) {
                    flag2 = false;
                    for (int k2 = 0; k2 < bugsToFix.length; ++k2) {
                        String bugToFix = bugsToFix[k2];
                        if (bugsFixed[j2] != bugToFix) continue;
                        flag2 = true;
                        break;
                    }
                    if (!flag2) continue;
                    flag1 = true;
                    break;
                }
                if (!flag1 || bugsToFix.length != bugsFixed.length) continue;
                superlist.add(ohOneOffs[i2]);
            }
            bugSupersetList = new OneOffEntry[superlist.size()];
            for (int listIter = 0; listIter < superlist.size(); ++listIter) {
                bugSupersetList[listIter] = (OneOffEntry)superlist.elementAt(listIter);
            }
        }
        return bugSupersetList;
    }

    protected OneOffEntry[] checkBugConflict(OneOffEntry[] ohOneOffs, String[] bugsToFix, String[] bugsThatConflict) {
        OneOffEntry[] bugConflictList = new OneOffEntry[]{};
        StringBuffer tmpS = new StringBuffer();
        StringBuffer buff = new StringBuffer();
        boolean flag = false;
        if (!this.isActiveBugConflict()) {
            OLogger.debug("ConflictHandler::isBugConflict: Bug Conflict checking not Active, return NO_BUG_CONFLICT");
            return bugConflictList;
        }
        if (ohOneOffs != null && ohOneOffs.length > 0) {
            ArrayList<OneOffEntry> conflictList = new ArrayList<OneOffEntry>();
            for (int i2 = 0; i2 < ohOneOffs.length; ++i2) {
                int j2;
                String[] bugsFixed = ohOneOffs[i2].getBugIDsFixed();
                flag = false;
                ArrayList<String> tmpAL1 = new ArrayList<String>();
                for (int j3 = 0; j3 < bugsFixed.length; ++j3) {
                    tmpAL1.add(bugsFixed[j3]);
                }
                ArrayList<String> tmpAL2 = new ArrayList<String>();
                for (j2 = 0; j2 < bugsToFix.length; ++j2) {
                    tmpAL2.add(bugsToFix[j2]);
                }
                for (j2 = 0; j2 < tmpAL1.size(); ++j2) {
                    if (!tmpAL2.contains(tmpAL1.get(j2))) continue;
                    flag = true;
                    buff.append((String)tmpAL1.get(j2));
                    buff.append(", ");
                }
                if (!flag) continue;
                if (OLogger.isDebug()) {
                    tmpS = new StringBuffer("ConflictHandler::checkBugConflict: Adding oneoff ");
                    tmpS.append(ohOneOffs[i2].getID());
                    tmpS.append(" to the conflict list");
                    OLogger.debug(tmpS);
                }
                conflictList.add(ohOneOffs[i2]);
                bugsThatConflict[i2] = new String(buff.toString());
            }
            if (conflictList.size() > 0) {
                bugConflictList = new OneOffEntry[conflictList.size()];
                conflictList.toArray(bugConflictList);
            }
        }
        if (OLogger.isDebug()) {
            tmpS = new StringBuffer("ConflictHandler::checkBugConflict: conflict list ");
            for (int i3 = 0; i3 < bugConflictList.length; ++i3) {
                tmpS.append(" ");
                tmpS.append(bugConflictList[i3].getID());
            }
            OLogger.debug(tmpS);
        }
        return bugConflictList;
    }

    public boolean isBugConflict(OneOffEntry[] ohOneOffs, String[] bugsToFix, String[] bugsThatConflict) throws BugConflictException {
        try {
            if (!this.isActiveBugConflict()) {
                OLogger.debug("ConflictHandler::isBugConflict: Bug Conflict checking not Active, return NO_BUG_CONFLICT");
                return false;
            }
            if (ohOneOffs != null && ohOneOffs.length > 0 && this.checkBugConflict(ohOneOffs, bugsToFix, bugsThatConflict).length > 0) {
                OLogger.debug("ConflictHandler::isBugConflict: Returning TRUE for bugConflict");
                return true;
            }
            OLogger.debug("ConflictHandler::isBugConflict: Returning FALSE for bugConflict");
            return false;
        }
        catch (Throwable t) {
            BugConflictException e2 = new BugConflictException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
    }

    public static boolean compareFilesForConflict(String[] filesInv, String[] filesPatch) {
        boolean result = false;
        if (filesInv == null || filesInv.length == 0) {
            return false;
        }
        if (filesPatch == null || filesPatch.length == 0) {
            return false;
        }
        result = true;
        int lengthToTraverse = filesInv.length < filesPatch.length ? filesInv.length : filesPatch.length;
        for (int i2 = 0; i2 < lengthToTraverse; ++i2) {
            if (filesInv[i2].equals(filesPatch[i2])) continue;
            result = false;
            break;
        }
        return result;
    }

    protected static OneOffEntry[] checkFileConflict(String oracleHomePath, OneOffEntry[] ohOneOffs, String[] filesThatConflict) {
        OneOffEntry[] fileConflictList = new OneOffEntry[]{};
        StringBuffer tmpS = new StringBuffer();
        StringBuffer buff = null;
        if (ohOneOffs != null && ohOneOffs.length > 0) {
            ArrayList<OneOffEntry> conflictList = new ArrayList<OneOffEntry>();
            for (int i2 = 0; i2 < ohOneOffs.length; ++i2) {
                buff = new StringBuffer();
                String f_patchID = ohOneOffs[i2].getID();
                PatchAction[] piActions = ohOneOffs[i2].getPatchActions();
                if (!ohOneOffs[i2].getIsComposite() && piActions.length == 0) {
                    RuntimeException e2 = new RuntimeException("No actions defined for patch: " + f_patchID);
                    throw e2;
                }
                boolean flag = false;
                for (int j2 = 0; j2 < piActions.length; ++j2) {
                    if (OLogger.isDebug()) {
                        tmpS = new StringBuffer("ConflictHandler:checkFileConflict: Action in inventory ");
                        tmpS.append(piActions[j2].toString());
                        OLogger.debug(tmpS);
                    }
                    if (!(piActions[j2] instanceof ConflictDetectable)) continue;
                    try {
                        ConflictDetectable cdi = (ConflictDetectable)((Object)piActions[j2]);
                        String[] filesj = cdi.filesTouched(oracleHomePath);
                        if (piActions[j2] instanceof hotpatchAction) {
                            hotpatchAction hpa = (hotpatchAction)piActions[j2];
                            String[][] filesjList = hotpatchAction.processObjectName(oracleHomePath, filesj);
                            for (int newj = 0; newj < filesjList.length; ++newj) {
                                String[] filesFlat = filesjList[newj];
                                if (OLogger.isDebug()) {
                                    int s;
                                    tmpS = new StringBuffer("ConflictHandler:isFileConflict: Files to be compared ");
                                    tmpS.append(" Files touched by hotpatch: (");
                                    for (s = 0; s < filesFlat.length; ++s) {
                                        tmpS.append(" ");
                                        tmpS.append(filesFlat[s]);
                                    }
                                    tmpS.append(") Files to be touched by the patch to be applied: (");
                                    for (s = 0; s < filesThatConflict.length; ++s) {
                                        tmpS.append(" ");
                                        tmpS.append(filesThatConflict[s]);
                                    }
                                    tmpS.append(")");
                                    OLogger.debug(tmpS);
                                }
                                if (!ConflictHandler.compareFilesForConflict(filesFlat, filesThatConflict)) continue;
                                OLogger.debug("ConflictHandler:isFileConflict: There is FILE CONFLICT");
                                flag = true;
                                for (int fileIter = 0; fileIter < filesj.length; ++fileIter) {
                                    buff.append(filesj[fileIter]);
                                    if (fileIter + 1 == filesj.length) continue;
                                    buff.append(":");
                                }
                                buff.append(",");
                            }
                            continue;
                        }
                        if (OLogger.isDebug()) {
                            int s;
                            tmpS = new StringBuffer("ConflictHandler:checkFileConflict: Files to be compared ");
                            tmpS.append(" Files touched in inventory: (");
                            for (s = 0; s < filesj.length; ++s) {
                                tmpS.append(" ");
                                tmpS.append(filesj[s]);
                            }
                            tmpS.append(") Files to be touched by the patch to be applied: (");
                            for (s = 0; s < filesThatConflict.length; ++s) {
                                tmpS.append(" ");
                                tmpS.append(filesThatConflict[s]);
                            }
                            tmpS.append(")");
                            OLogger.debug(tmpS);
                        }
                        if (!ConflictHandler.compareFilesForConflict(filesj, filesThatConflict)) continue;
                        OLogger.debug("ConflictHandler:checkFileConflict: There is FILE CONFLICT");
                        flag = true;
                        for (int fileIter = 0; fileIter < filesj.length; ++fileIter) {
                            buff.append(filesj[fileIter]);
                            if (fileIter + 1 == filesj.length) continue;
                            buff.append(":");
                        }
                        buff.append(",");
                        continue;
                    }
                    catch (Throwable t) {
                        RuntimeException re = new RuntimeException(t.getMessage());
                        re.setStackTrace(t.getStackTrace());
                        throw re;
                    }
                }
                if (!flag) continue;
                conflictList.add(ohOneOffs[i2]);
            }
            if (conflictList.size() > 0) {
                fileConflictList = new OneOffEntry[conflictList.size()];
                conflictList.toArray(fileConflictList);
            }
        }
        if (OLogger.isDebug()) {
            tmpS = new StringBuffer("ConflictHandler::checkFileConflict: conflict list ");
            for (int i3 = 0; i3 < fileConflictList.length; ++i3) {
                tmpS.append(" ");
                tmpS.append(fileConflictList[i3].getID());
            }
            OLogger.debug(tmpS);
        }
        return fileConflictList;
    }

    public static boolean isFileConflict(String oracleHomePath, OneOffEntry[] ohOneOffs, String[] filesThatConflict) throws RuntimeException {
        try {
            if (ohOneOffs != null && ohOneOffs.length > 0 & ConflictHandler.checkFileConflict(oracleHomePath, ohOneOffs, filesThatConflict).length > 0) {
                OLogger.debug("ConflictHandler::isFileConflict: Returning TRUE for fileConflict");
                return true;
            }
            OLogger.debug("ConflictHandler::isFileConflict: Returning FALSE for fileConflict");
            return false;
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
    }

    public static String checkCommonConflict(String oracleHomePath, OneOffEntry[] oneoffs, ConflictDetectable cd) throws RuntimeException {
        String[] filesPath = cd.filesTouched(oracleHomePath);
        if (ConflictHandler.isFileConflict(oracleHomePath, oneoffs, filesPath)) {
            StringBuffer buff = new StringBuffer();
            for (int fileIter = 0; fileIter < filesPath.length; ++fileIter) {
                buff.append(filesPath[fileIter]);
                if (fileIter + 1 == filesPath.length) continue;
                buff.append(":");
            }
            buff.append(",");
            return buff.toString();
        }
        return "";
    }

    public boolean isGenericConflict(String oracleHomePath, OneOffEntry[] ohOneOffs, PatchAction[] pActions, String[] conflictDetails) throws GenericConflictException {
        try {
            if (!this.isActiveGenericConflict()) {
                OLogger.debug("ConflictHandler::isGenericConflict(): Generic Conflict checking not Active, return NO_GENERIC_CONFLICT");
                return false;
            }
            if (ohOneOffs != null && ohOneOffs.length > 0 && this.checkGenericConflict(oracleHomePath, ohOneOffs, pActions, conflictDetails).length > 0) {
                OLogger.debug("ConflictHandler::isGenericConflict: Returning TRUE for genericConflict");
                return true;
            }
            OLogger.debug("ConflictHandler::isGenericConflict: Returning FALSE for genericConflict");
            return false;
        }
        catch (Throwable t) {
            GenericConflictException e2 = new GenericConflictException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
    }

    protected OneOffEntry[] checkGenericConflict(String oracleHomePath, OneOffEntry[] oneoffs, PatchAction[] pActions, String[] conflictDetails) {
        OLogger.debug("ConflictHandler::checkGenericConflict()");
        StringBuffer buff = new StringBuffer();
        boolean flag = false;
        for (int i2 = 0; i2 < pActions.length; ++i2) {
            ConflictDetectable cdAction;
            String details;
            if (!(pActions[i2] instanceof ConflictDetectable) || (details = (cdAction = (ConflictDetectable)((Object)pActions[i2])).checkConflict(oracleHomePath, oneoffs)) == null || details.equals("")) continue;
            buff.append(details);
            flag = true;
        }
        conflictDetails[0] = buff.toString();
        if (flag) {
            return oneoffs;
        }
        return new OneOffEntry[0];
    }

    public OiiiCompInstallID getComponentInstallID(InstalledComponent[] installComponents, PatchComponent patchComponent) throws NullPointerException {
        StringBuffer buff = new StringBuffer();
        if (installComponents == null || patchComponent == null) {
            buff = new StringBuffer("ConflictHandler.getComponentInstallID(): installComponents = ");
            buff.append(installComponents);
            buff.append(", patchComponent = ");
            buff.append(patchComponent);
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        if (installComponents.length == 0) {
            buff = new StringBuffer("ConflictHandler.getComponentInstallID(): can't look up ");
            buff.append(patchComponent.getName()).append(", ");
            buff.append(patchComponent.getVersion()).append(" because the ");
            buff.append("installed component list is empty.");
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        String compName = patchComponent.getName();
        String compVer = patchComponent.getVersion();
        if (compName == null || compVer == null) {
            buff = new StringBuffer("ConflictHandler.getComponentInstallID() gets either null compName ");
            buff.append("or null compVersion: compName = ");
            buff.append(compName);
            buff.append(", compVer = ");
            buff.append(compVer);
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        for (InstalledComponent entry : installComponents) {
            String ver;
            OiiiVersion oVer;
            String name;
            OiiiCompInstallID oID;
            if (entry == null || (oID = entry.getCompInstallID()) == null || (name = entry.getID()) == null || !name.equalsIgnoreCase(compName) || (oVer = new OiiiVersion(entry.getVersion())) == null || (ver = oVer.getVerString()) == null || !ver.equalsIgnoreCase(compVer)) continue;
            OiiiCompInstallID returnOID = new OiiiCompInstallID(compName, oVer, OUIReplacer.Platform.getCurrentPlatformVector(), new OiiiVersion("0.0.0.0.0"), 1, 2, OiiiReleaseLevels.DefaultReleaseLevel());
            return returnOID;
        }
        buff = new StringBuffer("ConflictHandler.getComponentInstallID(): cannot locate ");
        buff.append("the component install ID: ");
        buff.append(compName).append(", ").append(compVer);
        throw new NullPointerException(buff.toString());
    }

    public OiiiCompInstallID getComponentInstallID(InstalledComponent[] installComponents, UpdateComponent updateComp) throws NullPointerException {
        StringBuffer buff = new StringBuffer();
        if (installComponents == null || updateComp == null) {
            buff = new StringBuffer("ConflictHandler.getComponentInstallID(): installComponents = ");
            buff.append(installComponents);
            buff.append(", updateComponent = ");
            buff.append(updateComp);
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        if (installComponents.length == 0) {
            buff = new StringBuffer("ConflictHandler.getComponentInstallID(): can't look up ");
            buff.append(updateComp.getCompName()).append(", ");
            buff.append(updateComp.getFromVersion()).append(" because the ");
            buff.append("installed component list is empty.");
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        String compName = updateComp.getCompName();
        String compFromVer = updateComp.getFromVersion();
        String compToVer = updateComp.getToVersion();
        if (compName == null || compToVer == null || compToVer == null) {
            buff = new StringBuffer("ConflictHandler.getComponentInstallID() gets either null compName ");
            buff.append("or null compVersion: compName = ");
            buff.append(compName);
            buff.append(", compFromVer = ");
            buff.append(compFromVer);
            buff.append(", compToVer = ");
            buff.append(compToVer);
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        for (InstalledComponent entry : installComponents) {
            boolean isOK;
            OiiiVersion oVer;
            String name;
            OiiiCompInstallID oID;
            if (entry == null || (oID = entry.getCompInstallID()) == null || (name = entry.getID()) == null || !name.equalsIgnoreCase(compName) || (oVer = new OiiiVersion(entry.getHighestVersion())) == null) continue;
            String ver = oVer.getVerString();
            OiiiVersion fromVer = new OiiiVersion(compFromVer);
            OiiiVersion toVer = new OiiiVersion(compToVer);
            boolean bl = isOK = !(!fromVer.equals(oVer) && !oVer.laterThan(fromVer) || !toVer.equals(oVer) && !toVer.laterThan(oVer));
            if (ver == null || !isOK) continue;
            return oID;
        }
        buff = new StringBuffer("ConflictHandler.getComponentInstallID(): cannot locate ");
        buff.append("the component install ID in the range of the highest version: ");
        buff.append(compName).append(", ").append(compFromVer).append(", ").append(compToVer);
        throw new NullPointerException(buff.toString());
    }

    protected boolean isActiveBugConflict() {
        return this.activeBugConflict;
    }

    protected void setActiveBugConflict(boolean valBugConflict) {
        this.activeBugConflict = valBugConflict;
    }

    protected boolean isActiveGenericConflict() {
        return this.activeGenericConflict;
    }

    protected void setActiveGenericConflict(boolean valGenericConflict) {
        this.activeGenericConflict = valGenericConflict;
    }

    protected boolean isActiveBugSuperset() {
        return this.activeBugSuperset;
    }

    protected void setActiveBugSuperset(boolean valBugSuperset) {
        this.activeBugSuperset = valBugSuperset;
    }

    protected boolean isActiveBugSubset() {
        return this.activeBugSubset;
    }

    protected void setActiveBugSubset(boolean valBugSubset) {
        this.activeBugSubset = valBugSubset;
    }
}

