/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ops;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.PatchingModel;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class EnvInfo {
    private int modelCode = 1;
    private String execMode = "CLI";

    public int getModelCode() {
        return PatchingModel.returnModelCode(OPatchEnv.getOracleHome());
    }

    public String getExecMode() {
        if (OPatchEnv.isOPatchSDKMode()) {
            return "SDK";
        }
        return "CLI";
    }

    public String getOUIVersion() {
        String ouiVersion = OPatchSDK.getOUIVersion();
        String[] ouiVerParts = ouiVersion.split("\\.");
        String tempOuiVer = ouiVerParts[0] + "." + ouiVerParts[1];
        return tempOuiVer;
    }

    public boolean isOUIExists() {
        StringBuffer ouiLocation = null;
        String oracleHomePath = OPatchEnv.getOracleHome();
        String cmdOuiLocation = System.getProperty("OPatch.OUI_LOCATION");
        if (cmdOuiLocation == null || cmdOuiLocation.trim().length() == 0) {
            ouiLocation = new StringBuffer(oracleHomePath);
            ouiLocation.append(File.separator);
            ouiLocation.append("oui");
        } else {
            ouiLocation = new StringBuffer(cmdOuiLocation);
        }
        OLogger.debug("isOUIBased: Path to oui location: " + ouiLocation.toString());
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(ouiLocation.toString(), new String[0]);
        return Files.exists(f2, new LinkOption[0]);
    }

    public boolean isIOCSupported() {
        try {
            Class<?> chkClass = Class.forName("oracle.glcm.opatch.content.api.IIOCMgmt");
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
        return true;
    }

    public ArrayList<Path> getCasJars() {
        ArrayList<Path> casJars = new ArrayList<Path>();
        try {
            Path pathToClass = this.locateClass("oracle.opatch.ops.OPS", this.getClass().getClassLoader());
            if (pathToClass != null && Files.exists(pathToClass, new LinkOption[0])) {
                Path glcmClassDir;
                Path classDir;
                if (Files.isDirectory(pathToClass, new LinkOption[0])) {
                    classDir = pathToClass;
                    glcmClassDir = pathToClass.getParent().getParent();
                } else {
                    classDir = pathToClass.getParent();
                    glcmClassDir = WrapperFactory.getNioServiceWrapper().getPath(pathToClass.getParent().getParent().getParent() + File.separator + "modules", new String[0]);
                }
                DirectoryStream<Path> files = Files.newDirectoryStream(classDir);
                for (Path casJar : files) {
                    if (!casJar.toString().contains("com.oracle.glcm.patch.content-store")) continue;
                    casJars.add(casJar);
                }
                DirectoryStream<Path> filesInGlcm = Files.newDirectoryStream(glcmClassDir);
                for (Path casJar : filesInGlcm) {
                    if (!casJar.toString().contains("com.oracle.glcm.patch.content-store")) continue;
                    casJars.add(casJar);
                }
            }
        }
        catch (RuntimeException e2) {
            OLogger.println("OPatch cannot locate CAS jar.");
        }
        catch (IOException e3) {
            OLogger.println("Cannot list files in the directory.");
        }
        return casJars;
    }

    public boolean isCASJarExists() {
        boolean isExist = false;
        try {
            boolean isCASClassExists = this.isCASExistsInClasspath("oracle.glcm.opatch.content.patch.PatchMemento");
            if (isCASClassExists) {
                isExist = true;
            }
        }
        catch (RuntimeException re) {
            OLogger.debug("OPatch cannot locate CAS jar.");
        }
        OLogger.debug("isCASJarExists: Is CAS jar exists: " + isExist);
        return isExist;
    }

    private boolean isCASExistsInClasspath(String className) {
        if (className != null && className != "") {
            try {
                Class<?> c1 = Class.forName(className);
                if (c1 != null) {
                    return true;
                }
                OLogger.debug("Unable to locate class " + className);
            }
            catch (Exception e2) {
                OLogger.debug("isCASExistsInClasspath:" + e2.getMessage());
            }
        }
        return false;
    }

    public Path locateClass(String className, ClassLoader classloader) throws RuntimeException {
        if (className != null && classloader != null) {
            try {
                URL classResource = classloader.getResource(className.endsWith(".class") ? className : className.replace('.', '/') + ".class");
                if (classResource != null) {
                    String fileComponent = classResource.getFile();
                    if (classResource.getProtocol().equals("file")) {
                        int classFileIndex = fileComponent.lastIndexOf(className);
                        if (classFileIndex != -1) {
                            fileComponent = fileComponent.substring(0, classFileIndex);
                        }
                        fileComponent = fileComponent.replaceAll("\\+", "%2B");
                        String urlDecoder = URLDecoder.decode(fileComponent, "UTF-8");
                        if (OPatchEnv.isWindows()) {
                            urlDecoder = (urlDecoder = urlDecoder.replace("\\", "/")).startsWith("/") ? urlDecoder.substring(1) : urlDecoder;
                        }
                        return WrapperFactory.getNioServiceWrapper().getPath(urlDecoder, new String[0]);
                    }
                    if (classResource.getProtocol().equals("jar")) {
                        int classSeparatorIndex = fileComponent.lastIndexOf("!");
                        if (classSeparatorIndex != -1) {
                            fileComponent = fileComponent.substring(0, classSeparatorIndex);
                        }
                        fileComponent = fileComponent.replaceAll("\\+", "%2B");
                        URL u = new URL(URLDecoder.decode(fileComponent, "UTF-8"));
                        String jarPath = u.getFile();
                        if (OPatchEnv.isWindows()) {
                            jarPath = (jarPath = jarPath.replace("\\", "/")).startsWith("/") ? jarPath.substring(1) : jarPath;
                        }
                        return WrapperFactory.getNioServiceWrapper().getPath(jarPath, new String[0]);
                    }
                } else {
                    OLogger.println("Unable to locate class " + className);
                }
            }
            catch (UnsupportedEncodingException e2) {
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            catch (MalformedURLException e3) {
                RuntimeException re = new RuntimeException(e3.getMessage());
                re.setStackTrace(e3.getStackTrace());
                throw re;
            }
        }
        return null;
    }
}

