/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.patchsdk.patchmodel.CompositePatch;
import oracle.opatch.patchsdk.patchmodel.GenericSingletonPatch;

public class OPatchCompositePatch
extends CompositePatch {
    private String compositeXmlLoc;
    private String compositeXml;
    private List<GenericSingletonPatch> subPatches;

    public OPatchCompositePatch(String patchLocation) {
        this.subPatches = null;
        this.setPatchLocation(patchLocation);
        this.setPatchTool("opatch");
        this.setCompositeXmlLoc(CompositePatchObject.getCompositeFilePath(patchLocation));
    }

    public OPatchCompositePatch() {
        this.subPatches = null;
        this.setPatchLocation(null);
        this.setPatchTool("opatch");
        this.setCompositeXmlLoc(null);
    }

    public OPatchCompositePatch(String patchID, String patchLoc, List subPatches) {
        this.setPatchID(patchID);
        this.setPatchLocation(patchLoc);
        this.setPatchTool("opatch");
        this.setCompositeXmlLoc(patchLoc + File.separator + patchID + File.separator + "etc" + File.separator + "config" + File.separator + "composite.xml");
        this.setSubPatches(subPatches);
    }

    public String getCompositeXmlLoc() {
        return this.compositeXmlLoc;
    }

    public void setCompositeXmlLoc(String compositeXmlLoc) {
        this.compositeXmlLoc = compositeXmlLoc;
    }

    public String getCompositeXml() {
        return this.compositeXml;
    }

    public void setCompositeXml(String compositeXml) {
        this.compositeXml = compositeXml;
    }

    @Override
    public List<GenericSingletonPatch> getSubPatches() {
        if (this.subPatches == null) {
            this.subPatches = new ArrayList<GenericSingletonPatch>();
        }
        return this.subPatches;
    }

    @Override
    public void setSubPatches(List<GenericSingletonPatch> subPatches) {
        this.subPatches = subPatches;
    }
}

