/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.driver.crs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.BaseClass;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.ASMCluster;
import model.db_crs.ASMInstance;
import model.db_crs.DBService;
import model.db_crs.DBServiceNode;
import model.db_crs.HAS;
import model.db_crs.OracleListener;
import model.db_crs.PDB;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMFactory;
import oracle.cluster.common.Cluster;
import oracle.cluster.common.ClusterException;
import oracle.cluster.common.CommonFactory;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.NoVersionAvailableException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.Service;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.NotExistsException;
import oracle.oplan.db.driver.crs.AbstractCrsProductDriver;
import oracle.oplan.db.driver.util.CRSutil;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrsProductDriver
extends AbstractCrsProductDriver {
    Logger logger = Logger.getLogger(CrsProductDriver.class.getName());
    ArrayList<File> dbHomes = new ArrayList();
    private boolean isAdminPolicyDBMixedSetup = false;
    private Map<String, String> dbForSkipping = new HashMap<String, String>();
    private Map<String, String> dbForPatching = new HashMap<String, String>();
    private List<String> lowerVersionSkippedDBHomeList = null;

    public SystemInstance buildSystemInstance(ArrayList<String> oracleHomes) throws ProductDriverException {
        return this.buildSystemInstance(oracleHomes, false);
    }

    public SystemInstance buildSystemInstance(ArrayList<String> oracleHomes, boolean auto) throws ProductDriverException {
        CRSutil.setupLogs();
        this.logger.entering(((Object)((Object)this)).getClass().getName(), "constructConfigGraphForSepecifiedHomes");
        if (oracleHomes == null || oracleHomes.size() < 1) {
            throw new ProductDriverException("Invalid oracle home targets", ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        this.ti = new SystemInstance();
        boolean giHomeSpecified = false;
        boolean sfwOnlySpecified = false;
        File gridHome = new File(this.detectCrsHome());
        ArrayList<File> softwareOnlyGridHomes = new ArrayList<File>();
        for (String home : oracleHomes) {
            File homef = new File(home);
            this.userSpecifiedHomes.add(homef);
            if (this.crsSftwareInsOnly.contains(homef)) {
                this.logger.log(Level.FINE, "Software-only grid home is specified.");
                sfwOnlySpecified = true;
                softwareOnlyGridHomes.add(homef);
                continue;
            }
            if (gridHome.equals(homef)) {
                this.logger.log(Level.FINE, "Configured grid home is specified.");
                giHomeSpecified = true;
                continue;
            }
            this.dbHomes.add(homef);
        }
        this.crsSftwareInsOnly = softwareOnlyGridHomes;
        boolean stackRunning = this.isStackRunning();
        Cluster cluster = null;
        String clusterName = "";
        if (this.crsType == AbstractCrsProductDriver.CrsType.CRS || this.crsType == AbstractCrsProductDriver.CrsType.SOFTWARE_ONLY) {
            if (stackRunning) {
                cluster = this.getSrvmCluster();
                clusterName = cluster.getName();
            } else {
                Properties prop = this.getConfigProperties();
                clusterName = prop.getProperty("CLUSTER_NAME", "");
            }
            if (!giHomeSpecified) {
                clusterName = "";
            }
            this.crsCluster = this.makeClusterObj(clusterName);
            if (CrsProductDriver.isExadata()) {
                this.crsCluster.setHWtype("EXADATA");
            } else {
                this.crsCluster.setHWtype("NON-EXADATA");
            }
            this.makeNodes();
            this.getLocalInfo();
            this.crsCluster.setVersion(this.getCrsVersion(stackRunning));
        } else if (this.crsType == AbstractCrsProductDriver.CrsType.SIHA) {
            this.siha = this.makeSIHAObj();
            this.makeNodesForSIHA();
            this.getLocalInfo();
            this.siha.setVersion(this.getCrsVersion(stackRunning));
        }
        this.getLocalInfo();
        if (giHomeSpecified || sfwOnlySpecified) {
            this.makeCrsHomes();
            if (giHomeSpecified && stackRunning) {
                if (this.crsType == AbstractCrsProductDriver.CrsType.CRS) {
                    this.makeCrsDaemons();
                    this.makeASM();
                } else if (this.crsType == AbstractCrsProductDriver.CrsType.SIHA) {
                    this.makeASMForSIHA();
                    this.makeSIHAHome();
                }
            }
        }
        if (stackRunning) {
            if (giHomeSpecified) {
                if (this.crsType == AbstractCrsProductDriver.CrsType.CRS) {
                    this.makeDBs(cluster);
                    this.makeListeners(cluster);
                } else if (auto) {
                    this.makeDBsForSIHA();
                    this.makeListenersForSIHA();
                }
            } else if (this.dbHomes.size() > 0) {
                this.makeDBHomes(this.dbHomes);
                if (this.crsType == AbstractCrsProductDriver.CrsType.CRS) {
                    this.makeDBs(cluster);
                } else if (this.crsType == AbstractCrsProductDriver.CrsType.SIHA) {
                    this.makeDBsForSIHA();
                }
            }
        } else {
            this.makeDBHomes(this.dbHomes);
        }
        this.setHomeIds();
        return this.ti;
    }

    private void checkCRSSIHA() {
        block5: {
            File gridHome = new File(this.detectCrsHome());
            ClusterwareInfo crsInfo = new ClusterwareInfo();
            try {
                if (crsInfo.isCRSConfigured(gridHome.getAbsolutePath())) {
                    this.crsType = AbstractCrsProductDriver.CrsType.CRS;
                    break block5;
                }
                if (crsInfo.isHAConfigured(gridHome.getAbsolutePath())) {
                    this.crsType = AbstractCrsProductDriver.CrsType.SIHA;
                    break block5;
                }
                if (this.crsSftwareInsOnly.size() > 0) {
                    this.crsType = AbstractCrsProductDriver.CrsType.SOFTWARE_ONLY;
                    break block5;
                }
                throw new ProductDriverException("No any valid Grid Home detected on current system", ProductDriverException.Type.ConfigurationNotSupported);
            }
            catch (InstallException e) {
                this.logger.log(Level.FINE, e.getMessage());
            }
        }
    }

    private boolean isCRSHASRunning() {
        boolean isRunning = false;
        File gridHome = new File(this.detectCrsHome());
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            if (this.crsType == AbstractCrsProductDriver.CrsType.CRS) {
                isRunning = crsInfo.isCRSRunning(gridHome.getAbsolutePath());
            } else if (this.crsType == AbstractCrsProductDriver.CrsType.SIHA) {
                isRunning = crsInfo.isHARunning(gridHome.getAbsolutePath());
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.FINE, e.getMessage());
        }
        this.logger.log(Level.INFO, "isRunning: " + isRunning);
        return isRunning;
    }

    public boolean isSIHA() {
        return this.crsType == AbstractCrsProductDriver.CrsType.SIHA;
    }

    @Override
    boolean isStackRunning() {
        boolean running = false;
        String crsHomePath = this.detectCrsHome();
        File gridHome = new File(crsHomePath);
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            if (crsInfo.isCRSConfigured(crsHomePath)) {
                this.crsType = AbstractCrsProductDriver.CrsType.CRS;
            } else if (crsInfo.isHAConfigured(crsHomePath)) {
                this.crsType = AbstractCrsProductDriver.CrsType.SIHA;
            } else if (this.crsSftwareInsOnly.size() > 0) {
                this.crsType = AbstractCrsProductDriver.CrsType.SOFTWARE_ONLY;
            } else {
                throw new ProductDriverException("No any valid Grid Home detected on current system", ProductDriverException.Type.ConfigurationNotSupported);
            }
            this.logger.log(Level.INFO, "crsType: " + (Object)((Object)this.crsType));
            if (this.crsType == AbstractCrsProductDriver.CrsType.CRS) {
                running = crsInfo.isCRSRunning(gridHome.getAbsolutePath());
            } else if (this.crsType == AbstractCrsProductDriver.CrsType.SIHA) {
                running = crsInfo.isHARunning(gridHome.getAbsolutePath());
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.FINE, e.getMessage());
        }
        this.logger.log(Level.INFO, "running: " + running);
        return running;
    }

    protected HAS makeSIHAObj() {
        HAS has = new HAS();
        this.defaultValues((AbstractBaseTarget)has);
        has.setDBInstance(new ArrayList());
        has.setInstanceASM(new ArrayList());
        this.ti.getEntities().add(has);
        this.ti.setTop((AbstractBaseTarget)has);
        return has;
    }

    protected void buildSIHASystemInstance() throws ProductDriverException {
        this.logger.entering(((Object)((Object)this)).getClass().getName(), "buildSIHASystemInstance");
        this.ti = new SystemInstance();
        this.siha = this.makeSIHAObj();
        this.makeNodesForSIHA();
        this.siha.setVersion(this.getCrsVersion(true));
        this.getLocalInfo();
        this.makeCrsHomes();
        if (this.isCRSHASRunning()) {
            this.makeASMForSIHA();
        }
        this.makeDBsForSIHA();
        this.makeListenersForSIHA();
        this.makeSIHAHome();
        this.setHomeIds();
    }

    private void makeSIHAHome() {
        if (this.gihomes.get(this.siha.getHost()) != null) {
            ((OracleHome)this.gihomes.get(this.siha.getHost())).getInstalledSWComponents().add(this.siha);
            OracleHome home = (OracleHome)this.gihomes.get(this.siha.getHost());
            home.setHomeType("siha");
            home.setVersion(this.siha.getVersion());
            this.siha.setRuns_from(home);
        }
    }

    protected void buildCRSSystemInstance() throws ProductDriverException {
        Cluster cluster = null;
        String clusterName = null;
        cluster = this.getSrvmCluster();
        clusterName = cluster.getName();
        this.crsCluster = this.makeClusterObj(clusterName);
        this.crsCluster.setVersion(this.getCrsVersion(true));
        if (CrsProductDriver.isExadata()) {
            this.crsCluster.setHWtype("EXADATA");
        } else {
            this.crsCluster.setHWtype("NON-EXADATA");
        }
        this.makeNodes();
        this.getLocalInfo();
        this.makeCrsHomes();
        if (this.isCRSHASRunning()) {
            this.makeASM();
        }
        this.makeDBs(cluster);
        this.makeListeners(cluster);
        this.makeCrsDaemons();
        this.setHomeIds();
        this.checkDBUnpresentOnLocalNode(cluster);
    }

    public SystemInstance buildSystemInstance() throws ProductDriverException {
        CRSutil.setupLogs();
        this.logger.entering(((Object)((Object)this)).getClass().getName(), "buildSystemInstance");
        this.ti = new SystemInstance();
        this.checkCRSSIHA();
        if (this.isSIHA()) {
            this.buildSIHASystemInstance();
        } else {
            this.buildCRSSystemInstance();
        }
        for (BaseClass b : this.ti.getEntities()) {
            this.logger.log(Level.FINE, b.getLeafClassName() + " object:" + b.getId());
        }
        this.logger.exiting(((Object)((Object)this)).getClass().getName(), "buildSystemInstance");
        return this.ti;
    }

    Cluster getSrvmCluster() {
        try {
            CommonFactory cf = CommonFactory.getInstance();
            return cf.getCluster();
        }
        catch (ClusterException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (ManageableEntityException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    public void checkDBUnpresentOnLocalNode(Cluster cluster) {
        boolean existed = false;
        try {
            for (Database sdb : cluster.fetchDatabases()) {
                OracleHome localHome = this.getLocalInfo().getHome(sdb.getOracleHome());
                if (localHome != null) continue;
                if (!existed) {
                    System.out.println("Could not generate patching steps for the following databases as they do not run from the current host.");
                    existed = true;
                }
                System.out.println("\tDatabase Name: " + sdb.getDBName());
                System.out.println("\tOracle Home: " + sdb.getOracleHome());
                System.out.print("\tHost: ");
                for (DatabaseInstance inst : sdb.configuredInstances()) {
                    System.out.print(" " + inst.node().getHostName());
                }
                System.out.println();
            }
            if (existed) {
                System.out.println("To generate the patching steps for the above databases, execute it on host where the databases are running.");
            }
        }
        catch (ClusterException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NotExistsException e) {
            return;
        }
        catch (DatabaseException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (InstanceException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NodeException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    private String getCrsVersion(boolean stackRunning) {
        String version = null;
        this.logger.entering(CrsProductDriver.class.getName(), "getCrsVersion");
        if (!stackRunning) {
            this.logger.log(Level.FINE, "CRS stack is down. Now getting crs version by OUI.");
            return this.getCrsVersion();
        }
        File ohpath = new File(this.detectCrsHome());
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            version = this.crsType != AbstractCrsProductDriver.CrsType.CRS ? crsInfo.getSIHAReleaseVersionString(ohpath.getAbsolutePath()) : crsInfo.getCRSActiveVersionString(ohpath.getAbsolutePath());
            return version;
        }
        catch (NoSuchExecutableException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NoSuchCRSHomeException e) {
            throw new ProductDriverException("OracleHome Path given does not exist", (Throwable)e, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        catch (ClusterInfoException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        catch (InstallException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    private static File getTargetHome() {
        String oh = System.getenv("ORACLE_HOME");
        if (oh == null) {
            StringBuffer msg = new StringBuffer(" ORACLE_HOME environment variable is not set.");
            throw new ProductDriverException(msg.toString());
        }
        File f = new File(oh);
        if (!f.exists()) {
            StringBuffer msg = new StringBuffer("OracleHome:");
            msg.append(f.getAbsolutePath());
            msg.append(" doesn't exist.");
            throw new ProductDriverException(msg.toString());
        }
        return f;
    }

    public void makeASM() {
        try {
            ASMFactory factory = ASMFactory.getInstance();
            ASM srvmAsm = factory.getASM();
            ASMCluster asmCluster = new ASMCluster();
            asmCluster.setASMinstances(this.makeASMInstances(srvmAsm));
            asmCluster.setName(srvmAsm.getName());
            this.defaultValues((AbstractBaseTarget)asmCluster);
            this.crsCluster.setASMCluster(asmCluster);
            this.ti.getEntities().add(asmCluster);
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NotExistsException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (AlreadyStoppedException e) {
            this.logger.log(Level.INFO, "Unable to detect ASM information", e);
        }
    }

    public void makeASMForSIHA() {
        try {
            ASMFactory factory = ASMFactory.getInstance();
            ASM srvmAsm = factory.getASM();
            this.siha.setInstanceASM(this.makeASMInstances(srvmAsm));
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NotExistsException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (AlreadyStoppedException e) {
            this.logger.log(Level.INFO, "Unable to detect ASM information", e);
        }
    }

    private List<ASMInstance> makeASMInstances(ASM srvmAsm) throws AlreadyStoppedException {
        try {
            int i;
            List srvmAsmInstances = srvmAsm.instances();
            ArrayList<ASMInstance> asmInstances = new ArrayList<ASMInstance>();
            for (i = 0; i < srvmAsmInstances.size(); ++i) {
                if (((oracle.cluster.asm.ASMInstance)srvmAsmInstances.get(i)).node().getName() == null || ((oracle.cluster.asm.ASMInstance)srvmAsmInstances.get(i)).node().getName().length() == 0) continue;
                asmInstances.add(new ASMInstance());
                ((ASMInstance)asmInstances.get(i)).setName(((oracle.cluster.asm.ASMInstance)srvmAsmInstances.get(i)).getName());
                this.defaultValues((AbstractBaseTarget)asmInstances.get(i));
                String nodeName = ((oracle.cluster.asm.ASMInstance)srvmAsmInstances.get(i)).node().getName();
                Host host = this.findHostByName(nodeName);
                ((OracleHome)this.gihomes.get(host)).getInstalledSWComponents().add(asmInstances.get(i));
                ((ASMInstance)asmInstances.get(i)).setRuns_from((OracleHome)this.gihomes.get(host));
            }
            for (i = 0; i < asmInstances.size(); ++i) {
                this.ti.getEntities().add(asmInstances.get(i));
            }
            return asmInstances;
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NodeException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    public void makeDBsForSIHA() {
        ClusterwareInfo info = new ClusterwareInfo();
        try {
            List dbuniqnames = info.getHAManagedDatabases(this.detectCrsHome());
            DatabaseFactory fact = DatabaseFactory.getInstance();
            block7: for (String dbname : dbuniqnames) {
                OracleHome localHome;
                Database sdb;
                try {
                    sdb = fact.getDatabase(dbname);
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    this.logger.info("exception message: " + message);
                    if (message.indexOf("PRCD-1027") != -1 || message.indexOf("PRCD-1229") != -1) {
                        Map dbInfo = fact.getDatabaseInfos();
                        Set keySet = dbInfo.keySet();
                        for (String s : keySet) {
                            this.logger.info("keySet: " + s);
                            if (!s.equalsIgnoreCase(dbname)) continue;
                            List list = (List)dbInfo.get(s);
                            this.logger.info("list: " + list);
                            if (list == null || list.size() <= 0) continue block7;
                            if (this.lowerVersionSkippedDBHomeList == null) {
                                this.lowerVersionSkippedDBHomeList = new ArrayList<String>();
                            }
                            this.lowerVersionSkippedDBHomeList.add((String)list.get(0));
                            continue block7;
                        }
                        continue;
                    }
                    throw e;
                }
                if (this.dbHomes.size() > 0 && !this.dbHomes.contains(new File(sdb.getOracleHome())) || (localHome = this.getLocalInfo().getHome(sdb.getOracleHome())) == null) continue;
                this.siha.getDBInstance().add(this.makeSIDatabase(sdb));
            }
        }
        catch (NotExistsException e) {
            this.logger.log(Level.WARNING, "Unable to detect any databases in SIHA", e);
            System.out.println("Warning: Unable to detect any databases in SIHA.");
            return;
        }
        catch (InstallException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (Exception e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    public void makeDBs(Cluster cluster) {
        try {
            List<Database> dbList = new ArrayList();
            try {
                dbList = cluster.fetchDatabases();
                this.logger.info("dbList.size: " + dbList.size());
            }
            catch (Exception e) {
                String message = e.getMessage();
                this.logger.info("exception message: " + message);
                if (message.indexOf("PRCD-1027") != -1 || message.indexOf("PRCD-1229") != -1) {
                    ClusterwareInfo info = new ClusterwareInfo();
                    List dbuniqnames = info.getHAManagedDatabases(this.detectCrsHome());
                    DatabaseFactory fact = DatabaseFactory.getInstance();
                    block9: for (String dbname : dbuniqnames) {
                        try {
                            dbList.add(fact.getDatabase(dbname));
                        }
                        catch (Exception e1) {
                            String msg = e1.getMessage();
                            this.logger.info("exception msg: " + msg);
                            if (msg.indexOf("PRCD-1027") != -1 || message.indexOf("PRCD-1229") != -1) {
                                Map dbInfo = fact.getDatabaseInfos();
                                Set keySet = dbInfo.keySet();
                                for (String s : keySet) {
                                    this.logger.info("keySet: " + s);
                                    if (!s.equalsIgnoreCase(dbname)) continue;
                                    List list = (List)dbInfo.get(s);
                                    this.logger.info("list: " + list);
                                    if (list == null || list.size() <= 0) continue block9;
                                    if (this.lowerVersionSkippedDBHomeList == null) {
                                        this.lowerVersionSkippedDBHomeList = new ArrayList<String>();
                                    }
                                    this.lowerVersionSkippedDBHomeList.add((String)list.get(0));
                                    continue block9;
                                }
                                continue;
                            }
                            throw e1;
                        }
                    }
                }
                throw e;
            }
            boolean isAdminDB = false;
            boolean isPolicyDB = false;
            for (Database sdb : dbList) {
                if (this.userSpecifiedHomes.size() > 0 && !this.dbHomes.contains(new File(sdb.getOracleHome()))) continue;
                if (this.isAdminManagedDB(sdb)) {
                    isAdminDB = true;
                } else {
                    isPolicyDB = true;
                }
                if (!isAdminDB || !isPolicyDB) continue;
                this.isAdminPolicyDBMixedSetup = true;
                break;
            }
            this.logger.info("isAdminPolicyDBMixedSetup: " + this.isAdminPolicyDBMixedSetup);
            for (Database sdb : dbList) {
                OracleHome localHome;
                if (this.userSpecifiedHomes.size() > 0 && !this.dbHomes.contains(new File(sdb.getOracleHome())) || (localHome = this.getLocalInfo().getHome(sdb.getOracleHome())) == null) continue;
                if (sdb.isClusterDatabase()) {
                    this.makeRACDatabase(sdb);
                    continue;
                }
                this.crsCluster.getDbSI().add(this.makeSIDatabase(sdb));
            }
        }
        catch (NotExistsException e) {
            this.logger.log(Level.WARNING, "Unable to detect any databases in this cluster", e);
            return;
        }
        catch (ClusterException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (DatabaseException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    public RACDatabase makeRACDatabase(Database sdb) throws Exception {
        try {
            RACDatabase db = new RACDatabase();
            if (DatabaseType.RAC == sdb.databaseType()) {
                db.setDatabaseType("rac");
            } else if (DatabaseType.RACOneNode == sdb.databaseType()) {
                db.setDatabaseType("racone");
            }
            db.setName(this.stripPrefixSuffix(sdb.getName(), "ora.", ".db"));
            this.defaultValues((AbstractBaseTarget)db);
            db.setDatabaseName(sdb.getUserAssignedName());
            db.setVersion(sdb.version().toString());
            db.setDbInstances(new ArrayList());
            this.makeDBInstances(sdb, db);
            db.setPDB(this.findPDB(sdb));
            db.setServices(this.makeServices(sdb));
            this.setPDBWithRACDatabase(db);
            this.ti.getEntities().add(db);
            this.crsCluster.getDbRAC().add(db);
            return db;
        }
        catch (DatabaseException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NoVersionAvailableException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (Exception e) {
            if (e.getMessage().equalsIgnoreCase("ADMIN_POLICY_MIXED_DB")) {
                this.logger.log(Level.INFO, "Unable to detect information for database " + sdb.getUserAssignedName());
                return null;
            }
            throw e;
        }
    }

    public void setPDBWithRACDatabase(RACDatabase db) {
        List pdbList = db.getPDB();
        for (PDB pdb : pdbList) {
            pdb.setRACDatabase(db);
        }
    }

    public void setPDBWithSIDatabase(SIDatabase db) {
        List pdbList = db.getPDB();
        for (PDB pdb : pdbList) {
            pdb.setSIDatabase(db);
        }
    }

    public List<PDB> findPDB(Database sdb) {
        ArrayList<PDB> pdbList = new ArrayList<PDB>();
        HashMap<String, PDB> pdbMap = new HashMap<String, PDB>();
        try {
            List services = sdb.services();
            for (Service serv : services) {
                String pdbName;
                Method getPDBMethod = serv.getClass().getMethod("getPDB", new Class[0]);
                Object obj = getPDBMethod.invoke((Object)serv, new Object[0]);
                if (!(obj instanceof String) || (pdbName = (String)obj) == null || pdbName.length() <= 0 || pdbMap.containsKey(pdbName)) continue;
                PDB pdb = new PDB();
                this.logger.log(Level.FINE, "Found PDB " + pdbName);
                pdb.setName(pdbName);
                pdbList.add(pdb);
                pdbMap.put(pdbName, pdb);
                this.ti.getEntities().add(pdb);
            }
        }
        catch (NoSuchMethodException e) {
            this.logger.config("Method not found" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ProductDriverException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ProductDriverException(e.getMessage());
        }
        catch (DatabaseException e) {
            throw new ProductDriverException("Exception when get the pdb service:\t" + e.getMessage());
        }
        return pdbList;
    }

    private List<DBService> makeServices(Database sdb) {
        ArrayList<DBService> dbServices = new ArrayList<DBService>();
        try {
            Version version = sdb.version();
            if (null != version && version.toString().startsWith("12")) {
                for (Service service : sdb.services()) {
                    DBService dbService = new DBService();
                    dbService.setName(service.getUserAssignedName());
                    dbService.setIsRunning(service.isRunning());
                    if (this.isAdminManagedDB(sdb)) {
                        dbService.setAdministrationType("adminManagedDB");
                    } else {
                        dbService.setAdministrationType("policyManagedDB");
                    }
                    ArrayList<DBServiceNode> configuredNodes = new ArrayList<DBServiceNode>();
                    for (DatabaseInstance databaseInstance : service.getProviderInstances()) {
                        if (!(null != service.getServerGroup() & null != service.getServerGroup().servers())) continue;
                        for (Server server : service.getServerGroup().servers()) {
                            if (!server.node().getName().equalsIgnoreCase(databaseInstance.node().getName())) continue;
                            DBServiceNode node = new DBServiceNode();
                            node.setDatabaseName(databaseInstance.getName());
                            node.setDatabaseInstance(databaseInstance.getUserAssignedName());
                            node.setHostName(databaseInstance.node().getName());
                            node.setIsRunning(service.isRunning(databaseInstance.node()));
                            configuredNodes.add(node);
                        }
                    }
                    dbService.setConfiguredNodes(configuredNodes);
                    dbServices.add(dbService);
                }
            }
            return dbServices;
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException(e.getMessage());
        }
        catch (ServerGroupException e) {
            throw new ProductDriverException(e.getMessage());
        }
        catch (NodeException e) {
            throw new ProductDriverException(e.getMessage());
        }
        catch (ServerException e) {
            throw new ProductDriverException(e.getMessage());
        }
        catch (NoVersionAvailableException e) {
            throw new ProductDriverException(e.getMessage());
        }
    }

    public void makeDBInstances(Database sdb, RACDatabase rdb) throws Exception {
        try {
            RACDBInstance dbInst;
            List dbis = sdb.instances();
            boolean isAdminManaged = this.isAdminManagedDB(sdb);
            this.logger.info("isAdminManaged: " + isAdminManaged);
            List candServer = isAdminManaged ? ((ServerGroup)sdb.serverGroups().get(0)).configuredServers() : ((ServerGroup)sdb.serverGroups().get(0)).servers();
            this.logger.info("No of candidate Server: " + candServer.size());
            ArrayList<Node> candidateNodes = new ArrayList<Node>(candServer.size());
            for (Server server : candServer) {
                this.logger.info("server: " + server);
                try {
                    candidateNodes.add(server.node());
                }
                catch (ServerException e) {
                    this.logger.warning("ServerException: " + e.getMessage());
                }
            }
            String dbConfigType = isAdminManaged ? "adminManagedDB" : "policyManagedDB";
            this.logger.info("dbConfigType: " + dbConfigType);
            if (dbis.size() == 0) {
                this.logger.log(Level.WARNING, "Warning: There are no RAC Database Instances running for " + sdb);
                if (this.isAdminPolicyDBMixedSetup) {
                    this.dbForSkipping.put(sdb.getUserAssignedName(), dbConfigType);
                    throw new Exception("ADMIN_POLICY_MIXED_DB");
                }
            }
            this.dbForPatching.put(sdb.getUserAssignedName(), dbConfigType);
            this.logger.log(Level.INFO, "There are " + dbis.size() + " RAC database insatnces running for database: " + sdb);
            for (DatabaseInstance inst : dbis) {
                try {
                    Method isPQ = inst.getClass().getMethod("isPQInstance", new Class[0]);
                    if (((Boolean)isPQ.invoke((Object)inst, new Object[0])).booleanValue()) {
                        this.logger.info("the instance " + inst.getName() + " : " + inst.getUserAssignedName() + " runs on leaf node that belongs to PQ pools ");
                    } else {
                        this.logger.info("the instance " + inst.getName() + " : " + inst.getUserAssignedName() + " runs on hub node that belongs to server pools ");
                    }
                }
                catch (NoSuchMethodException e) {
                    System.out.println();
                }
                catch (IllegalAccessException e) {
                    System.out.println();
                }
                catch (InvocationTargetException e) {
                    System.out.println();
                }
                dbInst = new RACDBInstance();
                dbInst.setName(inst.getUserAssignedName());
                dbInst.setInstanceName(inst.getUserAssignedName());
                this.defaultValues((AbstractBaseTarget)dbInst);
                dbInst.setDbRAC(rdb);
                dbInst.setVersion(sdb.version().toString());
                Node node = inst.node();
                this.updateCandidateNode(node, candidateNodes);
                this.logger.info("updated candidateNode: " + candidateNodes.isEmpty());
                String nodename = node.getName();
                dbInst.setHost(this.findHostByName(nodename));
                if (inst.isRunning()) {
                    dbInst.setIsRunning("yes");
                } else {
                    dbInst.setIsRunning("no");
                }
                String ohPath = sdb.getOracleHome(node);
                OracleHome oh = this.findOrMakeHome(nodename, ohPath);
                oh.setHomeType("rac");
                oh.getInstalledSWComponents().add(dbInst);
                oh.setVersion(dbInst.getVersion());
                dbInst.setRuns_from(oh);
                this.logger.fine("Found DB Instance " + dbInst.getInstanceName() + " running on " + nodename + " from " + ohPath);
                rdb.getDbInstances().add(dbInst);
                this.ti.getEntities().add(dbInst);
            }
            if (!candidateNodes.isEmpty() && sdb.databaseType() == DatabaseType.RACOneNode) {
                for (Node node : candidateNodes) {
                    dbInst = new RACDBInstance();
                    dbInst.setName("InactiveRACOne");
                    dbInst.setInstanceName("InactiveRACOne");
                    this.defaultValues((AbstractBaseTarget)dbInst);
                    dbInst.setDbRAC(rdb);
                    dbInst.setVersion(sdb.version().toString());
                    String nodename = node.getName();
                    dbInst.setHost(this.findHostByName(nodename));
                    dbInst.setIsRunning("no");
                    String ohPath = sdb.getOracleHome(node);
                    OracleHome oh = this.findOrMakeHome(nodename, ohPath);
                    oh.setHomeType("rac");
                    oh.getInstalledSWComponents().add(dbInst);
                    oh.setVersion(dbInst.getVersion());
                    dbInst.setRuns_from(oh);
                    this.logger.info("Found RACOne candidate home on " + nodename + " from " + ohPath);
                    rdb.getDbInstances().add(dbInst);
                    this.ti.getEntities().add(dbInst);
                }
            }
        }
        catch (NotExistsException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (DatabaseException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (InstanceException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NodeException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NoVersionAvailableException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (ServerGroupException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    private boolean isAdminManagedDB(Database sdb) throws ServerGroupException {
        boolean isAdminManaged = false;
        List serverGrp = sdb.serverGroups();
        if (serverGrp.size() == 1 && !((ServerGroup)serverGrp.get(0)).isServerPool()) {
            isAdminManaged = true;
        }
        this.logger.info("isAdminManaged: " + isAdminManaged);
        return isAdminManaged;
    }

    private void updateCandidateNode(Node instanceNode, List<Node> candidateNodes) {
        for (Node node : candidateNodes) {
            try {
                if (!instanceNode.getName().equals(node.getName())) continue;
                this.logger.info("Removing Node: " + node.getName());
                candidateNodes.remove(node);
                break;
            }
            catch (NodeException e) {
                this.logger.warning("NodeException: " + e.getMessage());
            }
        }
    }

    public void makeSIDBInstances(Database sdb, SIDatabase sidb) {
        try {
            List dbis = sdb.instances();
            this.logger.info("There are " + dbis.size() + " SI database instances running for database: " + sdb);
            for (DatabaseInstance inst : dbis) {
                try {
                    Method isPQ = inst.getClass().getMethod("isPQInstance", new Class[0]);
                    if (((Boolean)isPQ.invoke((Object)inst, new Object[0])).booleanValue()) {
                        this.logger.info("the instance " + inst.getName() + " : " + inst.getUserAssignedName() + " runs on leaf node that belongs to PQ pools ");
                    } else {
                        this.logger.info("the instance " + inst.getName() + " : " + inst.getUserAssignedName() + " runs on hub node that belongs to server pools ");
                    }
                }
                catch (NoSuchMethodException e) {
                    System.out.println();
                }
                catch (IllegalAccessException e) {
                    System.out.println();
                }
                catch (InvocationTargetException e) {
                    System.out.println();
                }
                sidb.setInstanceName(inst.getUserAssignedName());
            }
        }
        catch (DatabaseException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    public SIDatabase makeSIDatabase(Database sdb) {
        try {
            SIDatabase db = new SIDatabase();
            db.setName(this.stripPrefixSuffix(sdb.getName(), "ora.", ".db"));
            this.defaultValues((AbstractBaseTarget)db);
            db.setPDB(this.findPDB(sdb));
            this.setPDBWithSIDatabase(db);
            db.setDatabaseName(sdb.getUserAssignedName());
            db.setVersion(sdb.version().toString());
            List nodes = sdb.nodes();
            if (nodes.size() != 1) {
                throw new ProductDriverException("Non-cluster database " + db.getName() + " has " + String.valueOf(nodes.size()) + " nodes", ProductDriverException.Type.InvalidConfiguration);
            }
            Node node = (Node)nodes.get(0);
            String nodename = node.getName();
            db.setHost(this.findHostByName(nodename));
            String ohPath = sdb.getOracleHome(node);
            OracleHome oh = this.findOrMakeHome(nodename, ohPath);
            if (oh.getHomeType() == null || !oh.getHomeType().equals("rac")) {
                oh.setHomeType("sidb");
            }
            oh.getInstalledSWComponents().add(db);
            oh.setVersion(db.getVersion());
            db.setRuns_from(oh);
            this.makeSIDBInstances(sdb, db);
            this.ti.getEntities().add(db);
            return db;
        }
        catch (NodeException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (DatabaseException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NotExistsException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NoVersionAvailableException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
    }

    public void makeListenersForSIHA() {
        try {
            NodeAppsFactory fact = NodeAppsFactory.getInstance();
            this.makeListeners(fact.getListeners());
        }
        catch (SoftwareModuleException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NotExistsException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    public void makeListeners(Cluster cluster) {
        try {
            this.makeListeners(cluster.fetchListeners());
        }
        catch (NotExistsException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (ClusterException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
    }

    public void makeListeners(List<Listener> listeners) {
        this.logger.entering(((Object)((Object)this)).getClass().getName(), "makeListeners");
        try {
            for (Listener lsnr : listeners) {
                String lsnrName = this.stripPrefixSuffix(lsnr.getName(), "ora.", ".lsnr");
                this.logger.fine("Found Listener:" + lsnrName);
                List nodes = lsnr.crsResource().fetchRunningNodes();
                for (Node node : nodes) {
                    OracleListener listener = new OracleListener();
                    listener.setName(lsnrName);
                    this.defaultValues((AbstractBaseTarget)listener);
                    String nodeName = node.getName();
                    listener.setHost(this.findHostByName(nodeName));
                    String ohPath = lsnr.getOracleHome(node);
                    this.logger.fine("Running on " + nodeName + " from " + ohPath);
                    if (this.userSpecifiedHomes.size() != 0 && !this.userSpecifiedHomes.contains(new File(ohPath)) || this.lowerVersionSkippedDBHomeList != null && this.lowerVersionSkippedDBHomeList.contains(ohPath)) continue;
                    OracleHome oh = this.findHome(nodeName, ohPath);
                    oh.getInstalledSWComponents().add(listener);
                    listener.setRuns_from(oh);
                    this.ti.getEntities().add(listener);
                }
            }
        }
        catch (NodeException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (CRSException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (NotExistsException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        catch (ListenerException e) {
            throw new ProductDriverException((Throwable)e, ProductDriverException.Type.ProductApiException);
        }
        this.logger.exiting(((Object)((Object)this)).getClass().getName(), "makeListeners");
    }

    public Map<String, String> getDBForSkipping() {
        return this.dbForSkipping;
    }

    public Map<String, String> getDBForPatching() {
        return this.dbForPatching;
    }

    String stripPrefixSuffix(String name, String prefix, String suffix) {
        if (name.startsWith(prefix) && name.endsWith(suffix)) {
            return name.substring(prefix.length(), name.length() - suffix.length());
        }
        return name;
    }

    public static boolean isExadata() {
        Logger logger = Logger.getLogger(CrsProductDriver.class.getName());
        logger.info("Checking for Exadata. Looking for /opt/oracle.cellos/ORACLE_CELL_OS_IS_SETUP file.");
        File imageinfo = new File("/opt/oracle.cellos/ORACLE_CELL_OS_IS_SETUP");
        if (imageinfo.exists()) {
            logger.info("Found Exadata!");
            return true;
        }
        logger.info("This is not an Exadata environment");
        return false;
    }

    public static boolean isExadata_skgxpinfo() {
        Logger logger = Logger.getLogger(CrsProductDriver.class.getName());
        logger.entering(CrsProductDriver.class.getName(), "isExadata");
        try {
            File ohpath = CrsProductDriver.getTargetHome();
            File skgxpinfo = new File(ohpath, File.separator + "bin" + File.separator + "skgxpinfo");
            if (!skgxpinfo.isFile()) {
                logger.info("Non-Exadata environment: skgxpinfo command does not exists at " + skgxpinfo.getPath());
                return false;
            }
            Process p = Runtime.getRuntime().exec(new String[]{skgxpinfo.getPath()});
            BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String s = b.readLine();
            b.close();
            logger.info("skgxpinfo returned: " + s);
            if (s != null && s.equalsIgnoreCase("rds")) {
                logger.info("Found Exadata env");
                logger.entering(CrsProductDriver.class.getName(), "isExadata");
                return true;
            }
            logger.info("Found non-Exadata env");
            logger.exiting(CrsProductDriver.class.getName(), "isExadata");
            return false;
        }
        catch (IOException e) {
            throw new ProductDriverException(e.getMessage(), (Throwable)e, ProductDriverException.Type.Unknown);
        }
    }
}

