/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common;

import java.io.PrintStream;
import java.io.PrintWriter;

public class CommonException
extends Exception {
    private int _type = -1;
    private Exception _rootCauseException = null;

    public CommonException() {
        this("There was an unkown problem.");
    }

    public CommonException(int type, String msg) {
        this(msg);
        if (type > -1 || type < -16) {
            throw new IllegalArgumentException("Error type not supported!");
        }
        this._type = type;
    }

    public CommonException(String msg) {
        super(msg);
    }

    public CommonException(int type, String msg, Exception x) {
        this(type, msg);
        this.setRootCauseException(x);
    }

    public CommonException(String msg, Exception x) {
        this(-1, msg, x);
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    public void setRootCauseException(Exception x) {
        this._rootCauseException = x;
    }

    public Exception getRootCauseException() {
        return this._rootCauseException;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
    }

    public String getRootCauseMessage() {
        StringBuffer sb = new StringBuffer(super.getMessage());
        if (this._rootCauseException != null) {
            sb.append("\nRoot Cause Message: " + this._rootCauseException.getMessage());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        if (this._rootCauseException != null) {
            sb.append("\nRoot Cause: " + this._rootCauseException.toString());
        }
        return sb.toString();
    }
}

