/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class MiniFrameBorder
extends AbstractBorder
implements PropertyChangeListener,
HierarchyListener {
    protected static final int TITLE_STRIP_HEIGHT = 17;
    protected static final int TITLE_BAR_SPACE_BELOW = 3;
    protected static final int SIZE_BORDER_WIDTH = 4;
    protected static final int TITLE_BAR_LEADING = 5;
    protected static final int TITLE_ICON_MARGIN = 2;
    protected static final int SIZE_FILL_WIDTH = 2;
    private boolean _resizable;
    private boolean _active;
    private Rectangle _rectPaint = new Rectangle();
    private Rectangle _rectPaintLast = new Rectangle();
    private String _sClippedText;
    private String _titleText = "";
    private Image _titleIcon;
    private boolean _titleCentered;
    private Component _component;
    private Font _titleFont;
    private Color _titleTextColor;

    public MiniFrameBorder(String title) {
        if (title == null) {
            title = "";
        }
        this._titleText = title;
    }

    public boolean getResizable() {
        return this._resizable;
    }

    public void setResizable(boolean resizable) {
        if (this._resizable == resizable) {
            return;
        }
        this._resizable = resizable;
        this.repaintBorder();
    }

    public String getTitleText() {
        return this._titleText;
    }

    public void setTitleText(String titleText) {
        if (titleText == null) {
            titleText = "";
        }
        this._titleText = titleText;
        this.titleChanged();
    }

    public Image getTitleIcon() {
        return this._titleIcon;
    }

    public void setTitleIcon(Image titleIcon) {
        this._titleIcon = titleIcon;
        this.repaintBorder();
    }

    public boolean isTitleCentered() {
        return this._titleCentered;
    }

    public void setTitleCentered(boolean centered) {
        if (centered == this._titleCentered) {
            return;
        }
        this._titleCentered = centered;
        this.titleChanged();
    }

    public int getTitleHeight() {
        return 17;
    }

    public void titleChanged() {
        this._rectPaintLast.setBounds(0, 0, 0, 0);
        this.repaintTitle();
    }

    public void repaintTitle() {
        if (this._component == null) {
            return;
        }
        int width = this._component.getWidth();
        this._component.repaint(0, 0, width, this.getTitleHeight());
    }

    public void repaintBorder() {
        if (this._component == null) {
            return;
        }
        this.repaintTitle();
        int width = this._component.getWidth();
        int height = this._component.getHeight();
        this._component.repaint(0, 0, 4, height);
        this._component.repaint(width - 4, 0, 4, height);
        this._component.repaint(0, 0, width, 4);
        this._component.repaint(0, height - 4, width, 4);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        this.setComponent(c);
        insets.top = this.getTitleHeight() + 3;
        insets.right = insets.bottom = (insets.left = this._resizable ? 4 : 1);
        return insets;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        this.setComponent(c);
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.setComponent(c);
        Graphics2D g2 = (Graphics2D)g;
        int titleHeight = this.getTitleHeight();
        if (this._resizable) {
            g2.setColor(this.getBorderColor());
            g2.drawRect(x, y, width - 1, height - 1);
            g2.setColor(this.getSizeBorderFillColor());
            g2.fillRect(++x, ++y, 3, (height -= 2) - 2);
            g2.fillRect(x + (width -= 2) - 2 - 1, y, 3, height - 2);
            g2.fillRect(x, y + height - 2, width, 2);
            x += 2;
            width -= 4;
            height -= 2;
        }
        g2.setColor(this.getBorderColor());
        if (this._resizable) {
            g2.fillRect(x, y + titleHeight - 1, 1, height - titleHeight + 1);
            g2.fillRect(x + width - 1, y + titleHeight - 1, 1, height - titleHeight + 1);
            g2.fillRect(x, y + height - 1, width, 1);
            g2.setColor(this.getSizeBorderFillColor());
            g2.fillRect(x, y + height - 1, 1, 1);
            g2.fillRect(x + width - 1, y + height - 1, 1, 1);
            ++x;
            width -= 2;
        } else {
            g2.drawRect(x, y, width - 1, height - 1);
            g2.setColor(this._resizable ? this.getSizeBorderFillColor() : UIManager.getColor("ViewPanel.background"));
            g2.fillRect(x, y, 1, 1);
            g2.fillRect(x + width - 1, y, 1, 1);
            g2.fillRect(x, y + height - 1, 1, 1);
            g2.fillRect(x + width - 1, y + height - 1, 1, 1);
            ++x;
            ++y;
            width -= 2;
        }
        height = titleHeight - 2;
        g2.setColor(this.getTitleColor());
        g2.fillRect(x, y, width, height);
        g2.setColor(this.getBorderColor());
        g2.fillRect(x, y + height, width, 1);
        g2.setColor(this.getTitleBackgroundColor());
        g2.fillRect(x, y + height + 1, width, 3);
        this._rectPaint.setBounds(x, y, width, height);
        this._rectPaint.grow(-5, 0);
        g2.setBackground(this.getTitleColor());
        g2.setColor(this.getTitleTextColor());
        g2.setFont(this.getTitleFont());
        FontMetrics fm = g2.getFontMetrics();
        Image img = this.getTitleIcon();
        if (img != null) {
            Rectangle rectImage = new Rectangle(0, 0, img.getWidth(null), img.getHeight(null));
            int dy = (this._rectPaint.height - img.getHeight(null)) / 2;
            rectImage.grow(2, dy);
            rectImage.setLocation(this._rectPaint.x, this._rectPaint.y);
            int widthNew = Math.max(this._rectPaint.width - rectImage.width, 0);
            int xNew = this._rectPaint.x + Math.min(this._rectPaint.width, rectImage.width);
            g2.drawImage(img, rectImage.x, rectImage.y + dy, null);
            this._rectPaint.setBounds(xNew, this._rectPaint.y, widthNew, this._rectPaint.height);
        }
        if (this._sClippedText == null || !this._rectPaint.equals(this._rectPaintLast)) {
            this._sClippedText = this.clipTextToFit(this.getTitleText(), this._rectPaint.width, fm);
            this._rectPaintLast.setBounds(this._rectPaint);
        }
        int xOffset = 0;
        if (this.isTitleCentered()) {
            int widthText = SwingUtilities.computeStringWidth(fm, this._sClippedText);
            xOffset = this._rectPaint.width >= widthText ? (this._rectPaint.width - widthText) / 2 : 0;
        }
        g2.drawString(this._sClippedText, this._rectPaint.x + xOffset, this._rectPaint.y + this._rectPaint.height - fm.getDescent());
    }

    public Font getTitleFont() {
        if (this._titleFont != null) {
            return this._titleFont;
        }
        return UIManager.getFont("MiniFrame.captionFont") != null ? UIManager.getFont("MiniFrame.captionFont") : UIManager.getFont("Dialog");
    }

    public void setTitleFont(Font font) {
        this._titleFont = font;
    }

    public Color getTitleBackgroundColor() {
        Color c = UIManager.getColor("MiniFrame.background");
        return c != null ? c : UIManager.getColor("controlShadow");
    }

    public Color getTitleColor() {
        Color c = UIManager.getColor(this._active ? "MiniFrame.caption" : "MiniFrame.inactiveCaption");
        if (c == null) {
            c = UIManager.getColor(this._active ? "activeCaption" : "inactiveCaption");
        }
        return c;
    }

    public Color getTitleTextColor() {
        if (this._titleTextColor != null) {
            return this._titleTextColor;
        }
        Color c = UIManager.getColor(this._active ? "MiniFrame.text" : "MiniFrame.inactiveText");
        if (c == null) {
            c = UIManager.getColor(this._active ? "activeCaptionText" : "inactiveCaptionText");
        }
        return c;
    }

    public void setTitleTextColor(Color color) {
        this._titleTextColor = color;
    }

    public Color getBorderColor() {
        Color c = UIManager.getColor(this._active ? "MiniFrame.border" : "MiniFrame.inactiveBorder");
        if (c == null) {
            c = UIManager.getColor(this._active ? "activeCaptionBorder" : "activeCaptionBorder");
        }
        return c;
    }

    public Color getSizeBorderFillColor() {
        Color c = UIManager.getColor(this._active ? "MiniFrame.borderFill" : "MiniFrame.inactiveBorderFill");
        if (c == null) {
            c = UIManager.getColor(this._active ? "activeCaption" : "inactiveCaption");
        }
        return c;
    }

    protected String clipTextToFit(String str, int width, FontMetrics fm) {
        String sRet = "";
        String clipString = "...";
        int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
        if (totalWidth <= width) {
            int nChars;
            int len = str.length();
            for (nChars = 0; nChars < len && (totalWidth += fm.charWidth(str.charAt(nChars))) <= width; ++nChars) {
            }
            sRet = nChars == len ? str : str.substring(0, nChars) + clipString;
        }
        return sRet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object comp = evt.getNewValue();
        if (comp instanceof Component) {
            Component component = (Component)comp;
            this._active = SwingUtilities.isDescendingFrom(component, this._component);
            this.repaintBorder();
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (e.getID() == 1400 && this._component.getParent() == null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
        }
    }

    public boolean isBorderFrameFocused() {
        return this._active;
    }

    private void setComponent(Component comp) {
        if (this._component == null || !this._component.equals(comp)) {
            this._component = comp;
            this._component.addHierarchyListener(this);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", this);
        }
    }
}

