/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Execute {
    private static final String osName = System.getProperty("os.name").toLowerCase();
    private static final Logger s_logger = Logger.getLogger(Execute.class.getName());
    public static final String newLineSep = System.getProperty("line.separator");
    public static final String winOsName = "windows";
    public static final String win2000OsName = "windows 2";
    public static final String win7OsName = "windows 7";
    public static final String winVistaOsName = "windows vista";
    public static final String winXpOsName = "windows x";
    public static final String win95OsName = "windows 95";
    public static final String win98OsName = "windows 98";
    public static final String winNtOsName = "windows nt";
    public static final String winServer2008OsName = "windows server 2008";
    public static final String unixOsName = "unix";
    public static final String sunOsOsName = "sunos";
    public static final String hpUxOsName = "hp-ux";
    public static final String linuxOsName = "linux";
    public static final String osf1OsName = "osf1";
    public static final String aixOsName = "aix";
    public static final boolean osIsOldWindows = osName.startsWith("windows 95") || osName.startsWith("windows 98") || osName.startsWith("windows nt");
    public static final boolean osIsNewWindows = osName.startsWith("windows x") || osName.startsWith("windows 2") || osName.startsWith("windows 7") || osName.startsWith("windows vista") || osName.startsWith("windows server 2008");
    public static final boolean osIsUnix = osName.startsWith("unix") || osName.startsWith("sunos") || osName.startsWith("hp-ux") || osName.startsWith("linux") || osName.startsWith("aix") || osName.startsWith("osf1");
    private List outputList = new LinkedList();
    private List inputList = new LinkedList();
    private List errorList = new LinkedList();

    public final List getOutputList() {
        return this.outputList;
    }

    public final List getInputList() {
        return this.inputList;
    }

    public final List getErrorList() {
        return this.errorList;
    }

    private void populateInputList(InputStream iStream, List inputList) {
        BufferedReader in = new BufferedReader(new InputStreamReader(iStream));
        String str = null;
        try {
            while ((str = in.readLine()) != null) {
                inputList.add(str);
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        in = null;
    }

    public boolean exec(String command) {
        return this.exec(command, null, null);
    }

    public boolean exec(String command, String[] env) {
        return this.exec(command, env, null);
    }

    public boolean exec(String command, File runDir) {
        return this.exec(command, null, runDir);
    }

    public boolean exec(String command, String[] env, File runDir) {
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        return this.exec(cmdarray, env, runDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exec(String[] cmdarray, String[] env, File runDir) {
        boolean rc = false;
        if (s_logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer(this.getClass().getName());
            sb.append(".exec() cmd=");
            for (String arg : cmdarray) {
                sb.append(" \"").append(arg).append("\"");
            }
            s_logger.fine(sb.toString());
        }
        Process aProc = null;
        try {
            aProc = Runtime.getRuntime().exec(cmdarray, env, runDir);
            if (!this.inputList.isEmpty()) {
                if (s_logger.isLoggable(Level.FINE)) {
                    s_logger.fine(this.getClass() + "exec() THE INPUT IS:");
                }
                Iterator iter = this.inputList.iterator();
                BufferedOutputStream out = new BufferedOutputStream(aProc.getOutputStream());
                byte[] theBytes = null;
                while (iter.hasNext()) {
                    String line = (String)iter.next();
                    s_logger.fine(line);
                    theBytes = line.getBytes();
                    out.write(theBytes, 0, theBytes.length);
                    theBytes = newLineSep.getBytes();
                    out.write(theBytes, 0, theBytes.length);
                }
                out.flush();
                out = null;
            }
            this.populateInputList(aProc.getInputStream(), this.outputList);
            this.populateInputList(aProc.getErrorStream(), this.errorList);
            aProc.waitFor();
            if (aProc.exitValue() == 0) {
                rc = true;
                if (s_logger.isLoggable(Level.FINE)) {
                    s_logger.fine(this.getClass() + ".exec() COMMAND WAS SUCCESSFUL");
                }
            } else {
                s_logger.fine(this.getClass() + ".exec() COMMAND: '" + cmdarray[0] + "' FAILED With exitcode=" + aProc.exitValue());
            }
        }
        catch (FileNotFoundException notf) {
            notf.printStackTrace();
        }
        catch (IOException io) {
            rc = false;
            this.errorList.add(io.getMessage());
            io.printStackTrace();
        }
        catch (InterruptedException it) {
            rc = false;
            this.errorList.add(it.getMessage());
        }
        finally {
            aProc = null;
        }
        return rc;
    }
}

