/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.Execute;

public class FileSystemInfo {
    private String name_ = "";
    private long freeSpace_ = -1L;
    private String mountPt_ = null;

    public FileSystemInfo(String name, String freeSpace, String mountPt) {
        long multiplier = Execute.osIsUnix ? 512L : 1L;
        this.name_ = name;
        this.mountPt_ = mountPt;
        try {
            Long tmpLong = new Long(freeSpace);
            this.freeSpace_ = tmpLong * multiplier;
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
    }

    public FileSystemInfo(String name, long freeSpace) {
        this.name_ = name;
        this.freeSpace_ = freeSpace;
        this.mountPt_ = null;
    }

    public FileSystemInfo(String name, String freeSpace) {
        this(name, freeSpace, null);
    }

    public final String getName() {
        return this.name_;
    }

    public final long getFreeSpace() {
        return this.freeSpace_;
    }

    public final String getMountPoint() {
        return this.mountPt_;
    }
}

