/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.carbdiff.DependentDiffHandler;
import com.oracle.cie.common.util.DiffReport;
import com.oracle.cie.common.util.FileDiff;
import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.JarUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarDiff {
    private static final Logger _logger = Logger.getLogger(JarDiff.class.getName());
    private boolean _replacementFlag = false;
    private boolean _includeParentClass = true;
    private boolean _includeManifest = false;
    private List<String> _includedManifestList;
    private String _rootJarEntry;
    private DependentDiffHandler _dependentDiffHandler;
    private File _rootJar;
    private JarHelper _rootJarHelper;
    private File _tmp;
    private boolean _isManifestDiff;
    private boolean _isEntriesDiff;
    private Map<String, JarDiff> _innerJarDiffs;
    private Map<File, Collection<String>> _diffMap;
    private Collection<DiffHandler> _diffHandlers;
    private FileContentFilterer _fileContentFilterer;
    private DiffReport _diffReport;
    private static boolean _isEmptyJar = false;

    public static void main(String[] args) {
        JarDiff jarDiff = new JarDiff(new File(args[0]));
        File[] diffJars = new File[args.length - 1];
        for (int x = 1; x < args.length; ++x) {
            diffJars[x - 1] = new File(args[x]);
        }
        Map<File, Collection<String>> diffResult = null;
        try {
            diffResult = jarDiff.diff(diffJars);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        if (diffResult != null) {
            boolean root = true;
            for (File f : diffResult.keySet()) {
                if (!root) {
                    System.out.println("\n\nDiff Jar " + f + ":");
                } else {
                    System.out.println("Root Jar " + f + ":");
                }
                for (String entry : diffResult.get(f)) {
                    System.out.println("    " + entry);
                }
                root = false;
            }
        }
    }

    public JarDiff(File rootJar) {
        this(rootJar, null, null, null);
    }

    public JarDiff(File rootJar, Collection<DiffHandler> diffHandlers, FileContentFilterer fileContentFilterer, DiffReport diffReport) {
        this._rootJar = rootJar;
        this._innerJarDiffs = new HashMap<String, JarDiff>();
        this._diffHandlers = new ArrayList<DiffHandler>();
        if (diffHandlers != null) {
            for (DiffHandler diffHandler : diffHandlers) {
                if (diffHandler instanceof DefaultArchiveDiffHandler) continue;
                this._diffHandlers.add(diffHandler);
            }
        }
        this._diffHandlers.add(new DefaultArchiveDiffHandler());
        this._fileContentFilterer = fileContentFilterer;
        this._diffReport = diffReport;
        this._dependentDiffHandler = new DependentDiffHandler();
    }

    public Map<File, Collection<String>> diff(File ... diffJars) throws Exception {
        return this.diff(false, diffJars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<File, Collection<String>> diff(boolean isDiffQuery, File ... diffJars) throws Exception {
        if (this._rootJarHelper == null) {
            this._rootJarHelper = new JarHelper(this._rootJar);
        }
        JarHelper diffJarHelper = null;
        boolean emptyJar = false;
        LinkedHashMap<File, Collection<String>> diffJarEntries = new LinkedHashMap<File, Collection<String>>();
        boolean onlyManifest = false;
        File simpleJarFile = null;
        for (File f : diffJars) {
            if (f != null) {
                Collection<String> entries = this.getJarEntries(f);
                entries = JarHelper.getContentEntries(entries, f.getAbsolutePath(), this._includeManifest);
                diffJarEntries.put(f, entries);
                if (!this.isReplacementFlag()) continue;
                if (this.containsOnlyManifest(entries)) {
                    onlyManifest = true;
                }
                simpleJarFile = f;
                continue;
            }
            emptyJar = true;
        }
        for (Map.Entry entry : diffJarEntries.entrySet()) {
            diffJarHelper = new JarHelper((File)entry.getKey());
            try {
                Collection<String> diffEntries = this.diffEntries((File)entry.getKey(), diffJarHelper, (Collection)entry.getValue(), isDiffQuery);
                if (diffEntries.isEmpty()) {
                    if (this.isReplacementFlag()) {
                        onlyManifest = true;
                    }
                } else {
                    simpleJarFile = null;
                    if (diffJarHelper.isSignedJar()) {
                        diffEntries = this.getJarEntries((File)entry.getKey());
                        _logger.finest(entry.getKey() + " is a signed archive, its content will be completly added to avoid signature corruption.");
                    }
                }
                ((Collection)entry.getValue()).clear();
                ((Collection)entry.getValue()).addAll(diffEntries);
                this.diffManifest(diffJarHelper, simpleJarFile);
            }
            finally {
                diffJarHelper.close();
            }
        }
        if (onlyManifest && this._isManifestDiff && simpleJarFile != null) {
            diffJarEntries.put(simpleJarFile, this.getJarEntries(simpleJarFile));
            this.setEntriesDiff(onlyManifest);
        }
        if (emptyJar) {
            diffJarEntries.put(this._rootJar, this.getJarEntries(this._rootJar));
        }
        this._diffMap = diffJarEntries;
        this._rootJarHelper.close();
        return diffJarEntries;
    }

    private boolean containsOnlyManifest(Collection<String> entries) {
        return entries.size() == 2 && entries.contains("META-INF/MANIFEST.MF");
    }

    public Map<File, String> getDeltaJarEntries() throws IOException {
        HashMap<File, String> fileEntriesMap = new HashMap<File, String>();
        return fileEntriesMap;
    }

    public boolean isCompleteReplacement() throws IllegalArgumentException, IOException {
        for (Map.Entry<File, Collection<String>> entry : this._diffMap.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            _logger.finest("Complete replacement has been identified for " + this._rootJar + ", changing strategy to replacement.");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<File, File> createDeltaJar(File deltaLocation) throws IllegalArgumentException, IOException {
        JarHelper jarHelper = null;
        JarHelper deltaJarHelper = null;
        HashMap<File, File> deltaJars = new HashMap<File, File>();
        File currentDeltaJar = null;
        for (Map.Entry<File, Collection<String>> entry : this._diffMap.entrySet()) {
            jarHelper = new JarHelper(entry.getKey());
            if (!deltaLocation.getParentFile().exists()) {
                deltaLocation.getParentFile().mkdirs();
            }
            if ((currentDeltaJar = new File(deltaLocation.getParentFile(), entry.getKey().getName())).exists() && currentDeltaJar.getName() != deltaLocation.getName()) {
                currentDeltaJar = deltaLocation;
            }
            deltaJarHelper = new JarHelper(currentDeltaJar, 1);
            try {
                for (String jarEntryName : entry.getValue()) {
                    if (this._innerJarDiffs.containsKey(jarEntryName)) {
                        Map<File, File> innerJars = this._innerJarDiffs.get(jarEntryName).createDeltaJar(deltaLocation);
                        if (innerJars == null || innerJars.size() != 1) {
                            throw new IOException("Inner jar diff should have created 1 delta jar for " + jarEntryName);
                        }
                        for (Map.Entry<File, File> innerJar : innerJars.entrySet()) {
                            deltaJarHelper.append(jarEntryName, innerJar.getValue());
                        }
                        continue;
                    }
                    if (!JarUtils.contains(jarHelper, jarEntryName)) continue;
                    deltaJarHelper.append(jarEntryName, jarHelper.getInputStream(jarEntryName));
                }
            }
            finally {
                if (deltaJarHelper != null) {
                    deltaJarHelper.close();
                }
                if (jarHelper != null) {
                    jarHelper.close();
                }
            }
            deltaJars.put(entry.getKey(), currentDeltaJar);
        }
        return deltaJars;
    }

    private Manifest diffManifest(JarHelper diffJarHelper, File jarFile) throws IllegalArgumentException, IOException {
        Manifest diffManifest = null;
        Manifest rootManifest = this._rootJarHelper.getManifest();
        if (diffJarHelper.getManifest() == null) {
            if (rootManifest != null) {
                this._isManifestDiff = true;
            }
            return null;
        }
        diffManifest = (Manifest)diffJarHelper.getManifest().clone();
        this._isManifestDiff = !diffManifest.equals(rootManifest);
        try {
            if (this._isManifestDiff) {
                String manifestEntry = null;
                if (jarFile != null) {
                    Collection<String> entries = this.getJarEntries(jarFile);
                    for (String entry : entries) {
                        if (!entry.matches(".*META-INF/MANIFEST\\.MF")) continue;
                        manifestEntry = entry;
                        break;
                    }
                    this._isManifestDiff = this.isDifferent(jarFile, diffJarHelper, manifestEntry);
                }
            }
        }
        catch (Exception e) {
            _logger.warning(e + e.getMessage() + ". The file " + jarFile.getCanonicalPath() + " could not be handled correctly, it was only compared by default byte comparator.");
        }
        for (Map.Entry<String, Attributes> entry : diffManifest.getEntries().entrySet()) {
            if (rootManifest == null || !rootManifest.getEntries().containsKey(entry.getKey())) continue;
            entry.getValue().values().removeAll(rootManifest.getEntries().get(entry.getKey()).values());
        }
        return diffManifest;
    }

    private Collection<String> diffEntries(File diffJar, JarHelper diffJarHelper, Collection<String> entries, boolean isDiffQuery) throws Exception {
        TreeSet<String> diffEntries = new TreeSet<String>();
        Collection<String> rootJarEntries = this.getJarEntries(this._rootJar);
        TreeSet<String> copyOfRootJarEntries = new TreeSet<String>();
        rootJarEntries = JarHelper.getContentEntries(rootJarEntries, this._rootJar.getAbsolutePath(), this._includeManifest);
        for (String jarEntryName : entries) {
            if (JarUtils.contains(diffJarHelper, jarEntryName) && JarUtils.contains(this._rootJarHelper, jarEntryName) && !JarUtils.getJarEntry(diffJarHelper, jarEntryName).isDirectory() && this.isDifferent(diffJar, diffJarHelper, jarEntryName, true)) {
                if (!this._dependentDiffHandler.includeOnlyIfChanged(jarEntryName, entries)) {
                    List<String> moduleClasses;
                    _logger.finest(jarEntryName + " jar entry has been modified and is different.");
                    diffEntries.add(jarEntryName);
                    this._isEntriesDiff = true;
                    if (isDiffQuery) {
                        return diffEntries;
                    }
                    if (this._includeParentClass && !(moduleClasses = this.getInnerClasses(entries, jarEntryName)).isEmpty()) {
                        for (String parentEntryName : moduleClasses) {
                            _logger.finest(parentEntryName + " is included since its inner or parent class has changed.");
                            diffEntries.add(parentEntryName);
                        }
                    }
                }
            } else if (JarUtils.contains(diffJarHelper, jarEntryName) && !JarUtils.contains(this._rootJarHelper, jarEntryName)) {
                if (!this._dependentDiffHandler.includeOnlyIfChanged(jarEntryName, diffEntries)) {
                    _logger.finest(jarEntryName + " new jar entry has been found and is different.");
                    diffEntries.add(jarEntryName);
                    this._isEntriesDiff = true;
                }
                if (isDiffQuery) {
                    return diffEntries;
                }
            }
            rootJarEntries.remove(jarEntryName);
            if (!diffEntries.contains(jarEntryName) && !this.hasDependentFiles(entries, jarEntryName)) continue;
            copyOfRootJarEntries.add(jarEntryName);
        }
        if (!rootJarEntries.isEmpty()) {
            if (diffEntries.isEmpty()) {
                _isEmptyJar = true;
            }
            for (String jarEntryName : rootJarEntries) {
                if (!this._dependentDiffHandler.includeOnlyIfChanged(jarEntryName, diffEntries)) {
                    _logger.finest(jarEntryName + " entry has not been found in new jar version.");
                    diffEntries.add(jarEntryName);
                    copyOfRootJarEntries.add(jarEntryName);
                    this._isEntriesDiff = true;
                }
                if (!isDiffQuery) continue;
                return diffEntries;
            }
        }
        if (!diffEntries.isEmpty()) {
            diffEntries.addAll(this._dependentDiffHandler.getDependentEntries(diffEntries, copyOfRootJarEntries));
        }
        copyOfRootJarEntries.clear();
        return diffEntries;
    }

    private List<String> getInnerClasses(Collection<String> entries, String jarEntryName) {
        ArrayList<String> module = new ArrayList<String>();
        String parent = "";
        if (jarEntryName.contains("$")) {
            parent = jarEntryName.substring(0, jarEntryName.indexOf("$"));
        } else if (jarEntryName.endsWith(".class")) {
            parent = jarEntryName.substring(0, jarEntryName.lastIndexOf("."));
        }
        if (!parent.isEmpty()) {
            for (String entry : entries) {
                if (!entry.startsWith(parent + "$")) continue;
                module.add(entry);
            }
            if (entries.contains(parent + ".class")) {
                module.add(parent + ".class");
            }
        }
        return module;
    }

    private boolean hasDifferences(Map<File, Collection<String>> diff) {
        boolean hasDifferences = false;
        for (Map.Entry<File, Collection<String>> entry : diff.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            hasDifferences = true;
        }
        return hasDifferences;
    }

    public boolean hasDifferences() {
        return this.hasDifferences(this._diffMap);
    }

    public void setIncludeManifest(boolean includeManifest) {
        this._includeManifest = includeManifest;
    }

    public boolean isDifferent(File diffJar, JarHelper diffJarHelper, String entryName) throws Exception {
        return this.isDifferent(diffJar, diffJarHelper, entryName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDifferent(File diffJar, JarHelper diffJarHelper, String entryName, boolean isDiffQuery) throws Exception {
        boolean isDifferent = false;
        boolean isHandled = false;
        File tmpRootInnerFile = null;
        File tmpDiffInnerFile = null;
        try {
            if (this._fileContentFilterer != null && this._fileContentFilterer.canFilter(entryName) && !JarUtils.isArchive(this._rootJarHelper, entryName) && !JarUtils.isArchive(diffJarHelper, entryName)) {
                tmpRootInnerFile = JarUtils.extractIntoTempFile(this._rootJarHelper, entryName);
                tmpDiffInnerFile = JarUtils.extractIntoTempFile(diffJarHelper, entryName);
                if (tmpRootInnerFile != null) {
                    tmpRootInnerFile.deleteOnExit();
                }
                if (tmpDiffInnerFile != null) {
                    tmpDiffInnerFile.deleteOnExit();
                }
                tmpRootInnerFile = this._fileContentFilterer.filterPattern(tmpRootInnerFile, entryName);
                tmpDiffInnerFile = this._fileContentFilterer.filterPattern(tmpDiffInnerFile, entryName);
            }
            for (DiffHandler diffHandler : this._diffHandlers) {
                if (!diffHandler.isHandled(diffJarHelper, entryName) || isHandled) continue;
                isHandled = true;
                try {
                    if (tmpRootInnerFile == null) {
                        tmpRootInnerFile = JarUtils.extractIntoTempFile(this._rootJarHelper, entryName);
                    }
                    if (tmpDiffInnerFile == null) {
                        tmpDiffInnerFile = JarUtils.extractIntoTempFile(diffJarHelper, entryName);
                    }
                    isDifferent = diffHandler.diff(entryName, tmpRootInnerFile, tmpDiffInnerFile);
                }
                catch (Exception e) {
                    _logger.log(Level.FINEST, "Error while doing diff on entry " + entryName, e);
                    _logger.warning(e + ". " + e.getMessage() + ". The entry " + entryName + " in file " + diffJar + " could not be handled correctly, changing to default byte comparator.");
                    isHandled = false;
                }
            }
            if (!isHandled && this._fileContentFilterer != null && this._fileContentFilterer.canFilter(entryName)) {
                if (tmpRootInnerFile == null) {
                    tmpRootInnerFile = JarUtils.extractIntoTempFile(this._rootJarHelper, entryName);
                }
                if (tmpDiffInnerFile == null) {
                    tmpDiffInnerFile = JarUtils.extractIntoTempFile(diffJarHelper, entryName);
                }
                isDifferent = !FileUtils.areFilesEqual(tmpRootInnerFile, tmpDiffInnerFile);
                isHandled = true;
            }
        }
        finally {
            if (tmpRootInnerFile != null) {
                tmpRootInnerFile.deleteOnExit();
            }
            if (tmpDiffInnerFile != null) {
                tmpDiffInnerFile.deleteOnExit();
            }
        }
        if (!isHandled) {
            JarEntry rootEntry = JarUtils.getJarEntry(this._rootJarHelper, entryName);
            JarEntry diffEntry = JarUtils.getJarEntry(diffJarHelper, entryName);
            if (diffEntry == null || rootEntry == null) {
                isDifferent = false;
            } else if (rootEntry.getSize() != diffEntry.getSize()) {
                isDifferent = true;
            } else {
                isDifferent = JarUtils.hasDifferentBytes(this._rootJarHelper.getInputStream(rootEntry.getName()), diffJarHelper.getInputStream(diffEntry.getName()));
                if (isDifferent) {
                    _logger.log(Level.FINEST, "Entry diff found for " + entryName + " in base size:" + rootEntry.getSize() + " crc:" + rootEntry.getCrc() + " attributes: " + rootEntry.getAttributes() + ". Entry " + entryName + " in patched size:" + diffEntry.getSize() + " crc:" + diffEntry.getCrc() + " attributes: " + diffEntry.getAttributes());
                }
            }
            if (isDifferent && this._diffReport != null) {
                File baseFile = JarUtils.extractIntoTempFile(this._rootJarHelper, rootEntry.getName());
                File patchFile = JarUtils.extractIntoTempFile(diffJarHelper, diffEntry.getName());
                baseFile.deleteOnExit();
                patchFile.deleteOnExit();
                this._diffReport.addDiff(diffEntry.getName(), FileDiff.diff(baseFile, patchFile, this._diffReport.getShowBinaryDiff()), null);
            }
        }
        return isDifferent;
    }

    public boolean isSignedJar() {
        return this._rootJarHelper.isSignedJar();
    }

    private Collection<String> getJarEntries(File jarFile) throws IOException {
        TreeSet<String> jarEntries = new TreeSet<String>();
        JarFile jar = null;
        try {
            jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                jarEntries.add(entry.getName());
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
        return jarEntries;
    }

    public File getTmp() {
        return this._tmp;
    }

    public void setTmp(File tmp) {
        this._tmp = tmp;
    }

    public void setIncludeParentClass(boolean includeParentClass) {
        this._includeParentClass = includeParentClass;
    }

    public boolean isManifestDiff() {
        return this._isManifestDiff;
    }

    public void setManifestDiff(boolean isManifestDiff) {
        this._isManifestDiff = isManifestDiff;
    }

    public void setIncludedManifest(List<String> included) {
        this._includedManifestList = included;
    }

    public void setRootJarEntry(String name) {
        this._rootJarEntry = name;
    }

    public boolean isEntriesDiff() {
        return this._isEntriesDiff;
    }

    public void setEntriesDiff(boolean isEntriesDiff) {
        this._isEntriesDiff = isEntriesDiff;
    }

    public void addDiffHandler(DiffHandler diffHandler) {
        this._diffHandlers.add(diffHandler);
    }

    public void setDiffHandlers(List<DiffHandler> diffHandlers) {
        this._diffHandlers = diffHandlers;
    }

    public boolean isReplacementFlag() {
        return this._replacementFlag;
    }

    public void setReplacementFlag(boolean replacementFlag) {
        this._replacementFlag = replacementFlag;
    }

    public boolean hasDependentFiles(Collection<String> diffFiles, String entry) {
        if (entry.endsWith(".class") && (diffFiles.contains(entry.replaceFirst(".class", ".tstamp")) || diffFiles.contains(entry.replaceFirst(".class", ".java")))) {
            return true;
        }
        if (entry.endsWith(".tstamp") && (diffFiles.contains(entry.replaceFirst(".tstamp", ".class")) || diffFiles.contains(entry.replaceFirst(".tstamp", ".java")))) {
            return true;
        }
        return entry.endsWith(".java") && (diffFiles.contains(entry.replaceFirst(".java", ".class")) || diffFiles.contains(entry.replaceFirst(".java", ".tstamp")));
    }

    public class DefaultArchiveDiffHandler
    implements DiffHandler {
        private DiffReport _report;

        @Override
        public boolean isHandled(File jarFile, String entryName) throws IOException {
            return JarUtils.isArchive(jarFile, entryName);
        }

        @Override
        public boolean isHandled(JarHelper jarHandler, String entryName) throws IOException {
            return JarUtils.isArchive(jarHandler, entryName);
        }

        @Override
        public boolean diff(String entryName, File file1, File file2) throws Exception {
            JarDiff innerJarDiff = new JarDiff(file1, JarDiff.this._diffHandlers, JarDiff.this._fileContentFilterer, JarDiff.this._diffReport);
            innerJarDiff.setIncludeParentClass(JarDiff.this._includeParentClass);
            if (JarDiff.this._includedManifestList != null && !JarDiff.this._includedManifestList.isEmpty() && JarDiff.this._rootJarEntry != null && JarDiff.this._includedManifestList.contains(JarDiff.this._rootJarEntry + "!" + entryName)) {
                innerJarDiff.setIncludeManifest(true);
            }
            JarDiff.this._innerJarDiffs.put(entryName, innerJarDiff);
            boolean isDifferent = JarDiff.this.hasDifferences(innerJarDiff.diff(file2));
            if (_isEmptyJar) {
                _isEmptyJar = false;
                return false;
            }
            return isDifferent;
        }

        @Override
        public void setDiffReport(DiffReport report) {
            this._report = report;
        }

        public DiffReport getDiffReport() {
            return this._report;
        }
    }

    public static interface FileContentFilterer {
        public boolean canFilter(String var1) throws Exception;

        public File filterPattern(File var1, String var2) throws Exception;
    }

    public static interface DiffHandler {
        public boolean isHandled(File var1, String var2) throws Exception;

        public boolean isHandled(JarHelper var1, String var2) throws Exception;

        public boolean diff(String var1, File var2, File var3) throws Exception;

        public void setDiffReport(DiffReport var1);
    }
}

