/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

public class Platform {
    public static final String[] PLATFORMS = new String[]{"Windows", "SunOS", "HP-UX", "Linux"};
    public static final String[] MAPS = new String[]{"win", "solaris", "hpux", "linux"};
    public static final int WIN = 0;
    public static final int SUN = 1;
    public static final int HPUX = 2;
    public static final int LINUX = 3;

    public static String getPlatform() {
        String osName = Platform.getOsName();
        for (int x = 0; x < PLATFORMS.length; ++x) {
            if (!osName.startsWith(PLATFORMS[x])) continue;
            return MAPS[x];
        }
        return "generic";
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsType() {
        if (Platform.isWin()) {
            return "Windows";
        }
        return "Unix";
    }

    public static boolean isWin() {
        String osName = Platform.getOsName();
        return osName.startsWith(PLATFORMS[0]);
    }
}

