/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class XorInputStream
extends FilterInputStream {
    private byte _mask = 0;

    public XorInputStream(InputStream in, byte mask) {
        super(in);
        this._mask = mask;
    }

    @Override
    public int read() throws IOException {
        int input = this.in.read();
        if (input < 0) {
            return input;
        }
        return (byte)input ^ this._mask;
    }

    @Override
    public int read(byte[] inputBuffer, int offset, int length) throws IOException {
        byte[] codedInput = new byte[length];
        int bytesRead = this.in.read(codedInput);
        for (int k = 0; k < bytesRead; ++k) {
            inputBuffer[offset + k] = (byte)(codedInput[k] ^ this._mask);
        }
        return bytesRead;
    }
}

