/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.ini;

import com.oracle.cie.nextgen.common.ini.IniIterator;
import com.oracle.cie.nextgen.common.ini.IniObject;
import com.oracle.cie.nextgen.common.ini.IniPair;
import com.oracle.cie.nextgen.common.ini.IniSection;
import com.oracle.cie.nextgen.common.ini.OraparamIni;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;

public class SimpleOraparamIni
extends OraparamIni {
    private static final Logger _logger = Logger.getLogger(SimpleOraparamIni.class.getName());
    private HashMap<String, HashMap<String, String>> _map = new HashMap();

    public SimpleOraparamIni(String paramFileLoc) throws IOException {
        super(paramFileLoc);
    }

    public String get(String section, String key) {
        HashMap<String, String> sectionMap = this.getSectionMap(section);
        return sectionMap.get(key);
    }

    public HashMap<String, String> getSectionMap(String section) {
        _logger.finer("getSectionMap for section " + section);
        HashMap<String, String> sectionMap = this._map.get(section);
        if (sectionMap == null) {
            sectionMap = new HashMap();
            IniSection s = this._iniFile.getSection(section);
            if (s != null) {
                IniIterator iterator = s.getIterator(true);
                while (iterator.hasMoreItems()) {
                    IniObject item = (IniObject)iterator.nextItem();
                    if (!(item instanceof IniPair)) continue;
                    sectionMap.put(((IniPair)item).getName(), ((IniPair)item).getValue());
                }
            }
            this._map.put(section, sectionMap);
        }
        return sectionMap;
    }
}

