/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.alg;

import com.rsa.crypto.AlgInputParams;
import com.rsa.crypto.AlgorithmParams;
import com.rsa.crypto.BadPaddingException;
import com.rsa.crypto.IllegalBlockSizeException;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.ncm.alg.AbstractModeCipher;
import com.rsa.crypto.ncm.alg.AbstractSymmCipher;
import com.rsa.crypto.ncm.alg.a;
import com.rsa.crypto.ncm.alg.c;
import com.rsa.crypto.ncm.b;
import com.rsa.crypto.ncm.ccme.CCMEException;
import com.rsa.crypto.ncm.key.SecretKeyImpl;
import com.rsa.cryptoj.e.du;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class AESGCMCipher
extends a {
    private static final int r = 12;
    private static final int s = 12;
    private static final int t = 16;
    private static final int u = 1;
    int a = 16;
    byte[] b;
    private byte[] v = new byte[16];
    int d;
    byte[] e;

    public AESGCMCipher(b b2, String string, AbstractModeCipher.a a2, int n2, AbstractModeCipher.b b3, AbstractSymmCipher.a a3, String string2, int n3) {
        super(b2, string, a2, n2, b3, a3, string2, n3);
    }

    @Override
    void a(SecretKeyImpl secretKeyImpl, AlgInputParams algInputParams, byte[] byArray) {
        if (this.b != null) {
            Arrays.fill(this.b, (byte)0);
            this.b = null;
        }
        this.a = 0;
        Arrays.fill(this.v, (byte)0);
        this.d = 0;
        if (byArray != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            if (byteBuffer.remaining() < 1) {
                throw new InvalidAlgorithmParameterException("Full IV must contain at least 1 bytes.");
            }
            this.a = byteBuffer.get();
            byArray = null;
            if (byteBuffer.hasRemaining()) {
                byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
            }
        } else {
            this.a = com.rsa.crypto.ncm.alg.c.a(algInputParams, "macLen", 16);
            byArray = com.rsa.crypto.ncm.alg.c.b(algInputParams, "rawIv", null);
            if (byArray == null && com.rsa.crypto.ncm.alg.c.a(algInputParams, "partialIv", null) != null) {
                throw new InvalidAlgorithmParameterException("CCME does not currently support partial IV.");
            }
        }
        if (this.a != 4 && this.a != 8 && (this.a < 12 || this.a > 16)) {
            throw new InvalidAlgorithmParameterException("Allowable authentication tag length is 4, 8 or between 12 and 16");
        }
        if (byArray != null && byArray.length != 12) {
            throw new InvalidAlgorithmParameterException("CCME currently requires that the IV length is 12");
        }
        if (!this.o && this.a != 16) {
            throw new InvalidAlgorithmParameterException("CCME currently requires that the tag length is 16 for decrypt");
        }
        this.b = byArray;
        super.a(secretKeyImpl, algInputParams, byArray);
    }

    @Override
    public AlgorithmParams getAlgorithmParams() {
        if (this.b == null) {
            throw new IllegalStateException("IV not set");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(1 + this.b.length);
        byteBuffer.put((byte)this.a);
        byteBuffer.put(this.b);
        com.rsa.crypto.ncm.alg.b b2 = new com.rsa.crypto.ncm.alg.b(this.cryptoModule);
        b2.set("iv", byteBuffer.array());
        return b2;
    }

    @Override
    public int getOutputSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("inputLen parameter is negative");
        }
        if (this.o) {
            return n2 + this.a;
        }
        return n2;
    }

    @Override
    public int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (this.isHandleNull()) {
            throw new IllegalStateException("Cipher not initialized");
        }
        this.d();
        if (byArray == null) {
            return 0;
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length || n4 < 0 || n4 > byArray2.length) {
            throw new IllegalArgumentException("Invalid offset or length parameter");
        }
        if (n3 == 0) {
            return 0;
        }
        if (this.o) {
            return super.update(byArray, n2, n3, byArray2, n4);
        }
        int n5 = 0;
        int n6 = this.d + n3 - this.a;
        if (n6 > 0) {
            int n7;
            int n8 = Math.min(n6, this.d);
            if (n8 > 0) {
                n7 = super.update(this.v, 0, n8, byArray2, n4);
                n4 += n7;
                n5 = n7;
                n6 -= n8;
                this.d -= n8;
                System.arraycopy(this.v, n8, this.v, 0, this.d);
            }
            if (n6 > 0) {
                n7 = super.update(byArray, n2, n6, byArray2, n4);
                n5 += n7;
                n2 += n6;
                n3 -= n6;
            }
        }
        System.arraycopy(byArray, n2, this.v, this.d, n3);
        this.d += n3;
        return n5;
    }

    @Override
    public void updateAAD(byte[] byArray, int n2, int n3) {
        if (this.isHandleNull()) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null) {
            return;
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IllegalArgumentException("Invalid offset or length parameter");
        }
        if (n3 == 0) {
            return;
        }
        this.a(byArray, n2, n3);
    }

    private void d() {
        if (this.e != null) {
            this.updateAuthData(this.e, 0, this.e.length);
            du.a.a(this.e);
            this.e = null;
        }
    }

    private void a(byte[] byArray, int n2, int n3) {
        if (this.e == null) {
            this.e = new byte[n3];
            System.arraycopy(byArray, n2, this.e, 0, n3);
        } else {
            byte[] byArray2 = this.e;
            this.e = new byte[n3 + byArray2.length];
            System.arraycopy(byArray2, 0, this.e, 0, byArray2.length);
            System.arraycopy(byArray, n2, this.e, byArray2.length, n3);
            du.a.a(byArray2);
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws BadPaddingException, IllegalBlockSizeException {
        int n5 = this.update(byArray, n2, n3, byArray2, n4);
        return n5 + this.doFinal(byArray2, n4 + n5);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws BadPaddingException, IllegalBlockSizeException {
        this.d();
        if (this.o) {
            int n3 = super.doFinal(byArray, n2);
            byte[] byArray2 = this.getAuthTag();
            System.arraycopy(byArray2, 0, byArray, n2 += n3, this.a);
            return n3 + this.a;
        }
        if (this.isHandleNull()) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.d != this.a) {
            throw new BadPaddingException();
        }
        this.setAuthTag(this.v, 0, this.a);
        try {
            return super.doFinal(byArray, n2);
        }
        catch (CCMEException cCMEException) {
            if (cCMEException.getErrorCode() == 10018) {
                IllegalBlockSizeException illegalBlockSizeException = new IllegalBlockSizeException("GCM Authentication failed.");
                illegalBlockSizeException.initCause(cCMEException);
                throw illegalBlockSizeException;
            }
            throw cCMEException;
        }
    }

    @Override
    public boolean isIVRequired() {
        return false;
    }

    @Override
    public void clearSensitiveData() {
        if (this.b != null) {
            Arrays.fill(this.b, (byte)0);
            this.b = null;
        }
        this.a = 0;
        Arrays.fill(this.v, (byte)0);
        this.d = 0;
        du.a.a(this.e);
        super.clearSensitiveData();
    }

    @Override
    public Object clone() {
        AESGCMCipher aESGCMCipher = (AESGCMCipher)super.clone();
        if (this.b != null) {
            aESGCMCipher.b = (byte[])this.b.clone();
        }
        if (this.v != null) {
            aESGCMCipher.v = (byte[])this.v.clone();
        }
        if (this.e != null) {
            aESGCMCipher.e = (byte[])this.e.clone();
        }
        return aESGCMCipher;
    }

    private native void updateAuthData(byte[] var1, int var2, int var3);

    private native byte[] getAuthTag();

    private native void setAuthTag(byte[] var1, int var2, int var3);
}

