/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.crl;

import com.rsa.cryptoj.e.a;
import com.rsa.cryptoj.e.aa;
import com.rsa.cryptoj.e.b;
import com.rsa.cryptoj.e.d;
import com.rsa.cryptoj.e.dj;
import com.rsa.cryptoj.e.dn;
import com.rsa.cryptoj.e.dw;
import com.rsa.jsafe.cert.GeneralName;
import com.rsa.jsafe.cert.InvalidEncodingException;
import com.rsa.jsafe.cert.ObjectID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class X509CRLEntryExtensionSpec
implements Cloneable {
    private Set<ObjectID> a = new HashSet<ObjectID>();
    private int b = -1;
    private Date c;
    private List<GeneralName> d;
    private List<byte[]> e;

    public void setCRLReason(int n2) {
        if (n2 < 0 || n2 > 10) {
            throw new IllegalArgumentException("Unknown CRL reason code");
        }
        this.b = n2;
    }

    public void setInvalidityDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Invalidity date is null");
        }
        this.c = new Date(date.getTime());
    }

    public void setCertificateIssuer(List<GeneralName> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("certificateIssuers is null or contains null entries.");
        }
        this.d = Collections.unmodifiableList(new ArrayList<GeneralName>(list));
    }

    public void addOtherExtension(byte[] byArray) throws InvalidEncodingException {
        if (byArray == null) {
            throw new IllegalArgumentException("Encoded extension is null");
        }
        try {
            com.rsa.cryptoj.e.a.a("Extension", byArray, 0);
        }
        catch (b b2) {
            throw new InvalidEncodingException("Invalid extension encoding.");
        }
        if (this.e == null) {
            this.e = new ArrayList<byte[]>();
        }
        this.e.add(dj.a(byArray));
    }

    public void setCriticalExtnOIDS(Set<ObjectID> set) {
        if (set == null || set.contains(null)) {
            throw new IllegalArgumentException("Critical extension set is null or contains null elements");
        }
        this.a = new HashSet<ObjectID>(set);
    }

    public void addCriticalExtn(ObjectID objectID) {
        if (objectID == null) {
            throw new IllegalArgumentException("Critical extension OID is null");
        }
        this.a.add(objectID);
    }

    public void removeCriticalExtn(ObjectID objectID) {
        if (objectID == null) {
            throw new IllegalArgumentException("Critical extension OID is null");
        }
        this.a.remove(objectID);
    }

    public Set<ObjectID> getCriticalExtOIDS() {
        return new HashSet<ObjectID>(this.a);
    }

    public int getCRLReason() {
        return this.b;
    }

    public Date getInvalidityDate() {
        return this.c == null ? null : new Date(this.c.getTime());
    }

    public List<GeneralName> getCertificateIssuers() {
        return this.d;
    }

    public List<byte[]> getOtherExtensions() {
        if (this.e == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        dw.a(arrayList, this.e);
        return arrayList;
    }

    public Object clone() {
        try {
            X509CRLEntryExtensionSpec x509CRLEntryExtensionSpec = (X509CRLEntryExtensionSpec)super.clone();
            x509CRLEntryExtensionSpec.a = new HashSet<ObjectID>(this.a);
            x509CRLEntryExtensionSpec.e = dj.a(this.e);
            return x509CRLEntryExtensionSpec;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone could not be created", cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        X509CRLEntryExtensionSpec x509CRLEntryExtensionSpec = (X509CRLEntryExtensionSpec)object;
        return dw.b(this.a, x509CRLEntryExtensionSpec.a) && dw.b(this.d, x509CRLEntryExtensionSpec.d) && dw.b(this.e, x509CRLEntryExtensionSpec.e) && dw.a(this.c, x509CRLEntryExtensionSpec.c) && this.b == x509CRLEntryExtensionSpec.b;
    }

    public int hashCode() {
        int n2 = dn.a(7, this.a);
        n2 = dn.a(n2, this.d);
        n2 = dn.a(n2, this.b);
        n2 = dn.a(n2, this.c);
        n2 = dn.a(n2, this.e);
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CRL Entry Extension Spec [").append(dw.a);
        if (this.c != null) {
            stringBuffer.append("      ").append("Invalidity Date [").append(this.c.toString()).append("]").append(dw.a);
        }
        if (this.d != null) {
            stringBuffer.append("      ").append("Certificate Issuer [").append(dw.a);
            for (GeneralName object : this.d) {
                stringBuffer.append("      ").append(object.toString()).append(dw.a);
            }
            stringBuffer.append("      ").append("]").append(dw.a);
        }
        if (this.b != -1) {
            stringBuffer.append("      ").append("CRL Reason code [").append(this.b).append("]").append(dw.a);
        }
        if (this.e != null) {
            stringBuffer.append("      ").append("Other Extensions: [").append(dw.a);
            for (byte[] byArray : this.e) {
                d d2 = com.rsa.cryptoj.e.a.a("Extension", byArray, 0);
                aa aa2 = (aa)d2.a(0);
                stringBuffer.append("      ").append("Extension OID: ").append(aa2).append(", ").append("Value: ").append(d2.a(2)).append("]").append(dw.a);
            }
            stringBuffer.append("      ").append("]").append(dw.a);
        }
        stringBuffer.append("      ").append("Critical Extensions [").append(dw.a);
        for (ObjectID objectID : this.a) {
            stringBuffer.append("      ").append(objectID.toString()).append(dw.a);
        }
        stringBuffer.append("      ").append("]").append(dw.a);
        stringBuffer.append("   ").append("]").append(dw.a);
        return stringBuffer.toString();
    }
}

