/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.provider;

import com.rsa.crypto.AlgParamGenerator;
import com.rsa.crypto.CryptoException;
import com.rsa.crypto.CryptoModule;
import com.rsa.crypto.NoSuchAlgorithmException;
import com.rsa.crypto.PQGParams;
import com.rsa.crypto.PublicKey;
import com.rsa.crypto.PublicKeyIsValidNotSupportedException;
import com.rsa.cryptoj.e.bj;
import com.rsa.cryptoj.e.cc;
import com.rsa.cryptoj.e.cg;
import com.rsa.cryptoj.e.ch;
import com.rsa.cryptoj.e.cl;
import com.rsa.cryptoj.e.cn;
import com.rsa.cryptoj.e.dd;
import com.rsa.cryptoj.e.fq;
import com.rsa.cryptoj.e.fr;
import com.rsa.cryptoj.e.kf;
import com.rsa.cryptoj.e.ks;
import com.rsa.cryptoj.e.kt;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.X942DHParameterSpec;
import com.rsa.jsafe.provider.b;
import com.rsa.jsafe.security.spec.DSADomainParameterGenerationSpec;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;

public final class Assurance {
    public static final String DIGEST_SHA1 = "SHA1";
    public static final String DIGEST_SHA224 = "SHA224";
    public static final String DIGEST_SHA256 = "SHA256";
    public static final String DIGEST_SHA384 = "SHA384";
    public static final String DIGEST_SHA512 = "SHA512";
    public static final int VERSION_FIPS186_2 = 2;
    public static final int VERSION_FIPS186_3 = 3;

    private Assurance() {
    }

    public static boolean isValidPublicKey(java.security.PublicKey publicKey) throws InvalidKeyException {
        return Assurance.isValidPublicKey(publicKey, null, null);
    }

    public static boolean isValidPublicKey(java.security.PublicKey publicKey, SecureRandom secureRandom, FIPS140Context fIPS140Context) throws InvalidKeyException {
        ch ch2 = fIPS140Context == null ? cg.a() : b.a(fIPS140Context);
        PublicKey publicKey2 = ks.a(publicKey, publicKey.getAlgorithm(), cn.a(ch2, Assurance.a()));
        if (publicKey2 == null) {
            publicKey2 = ((fr)publicKey).b();
        }
        try {
            return publicKey2.isValid(dd.a(secureRandom, ch2));
        }
        catch (PublicKeyIsValidNotSupportedException publicKeyIsValidNotSupportedException) {
            return true;
        }
    }

    public static boolean isValidPrivateKey(PrivateKey privateKey, FIPS140Context fIPS140Context) throws InvalidKeyException {
        ch ch2 = fIPS140Context == null ? cg.a() : b.a(fIPS140Context);
        com.rsa.crypto.PrivateKey privateKey2 = ks.a(privateKey, privateKey.getAlgorithm(), cn.a(ch2, Assurance.a()));
        if (privateKey2 == null) {
            privateKey2 = ((fq)privateKey).b();
        }
        try {
            return privateKey2.isValid();
        }
        catch (PublicKeyIsValidNotSupportedException publicKeyIsValidNotSupportedException) {
            return true;
        }
    }

    public static boolean isValidPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        return Assurance.isValidPrivateKey(privateKey, null);
    }

    private static List<cc> a() {
        return kf.a;
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string) {
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, null, null);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        return Assurance.a("DSA", dSADomainParameterGenerationSpec, string, secureRandom, fIPS140Context);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, int n2, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        if (dSADomainParameterGenerationSpec == null) {
            throw new InvalidParameterException("A DSADomainParameterGenerationSpec spec must be specified");
        }
        if (n2 == 2 && !DIGEST_SHA1.equals(string)) {
            return false;
        }
        return Assurance.a("DSA", dSADomainParameterGenerationSpec, string, secureRandom, fIPS140Context);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, int n2) {
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, n2, null, null);
    }

    @Deprecated
    public static boolean verifyX942DHParams(X942DHParameterSpec x942DHParameterSpec, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        return Assurance.verifyDHParams(x942DHParameterSpec, DIGEST_SHA1, secureRandom, fIPS140Context);
    }

    public static boolean verifyDHParams(X942DHParameterSpec x942DHParameterSpec, String string) {
        return Assurance.verifyDHParams(x942DHParameterSpec, string, null, null);
    }

    public static boolean verifyDHParams(X942DHParameterSpec x942DHParameterSpec, String string, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        if (x942DHParameterSpec == null) {
            throw new InvalidParameterException("An X942DHParameter spec must be specified");
        }
        try {
            return Assurance.a("DH", x942DHParameterSpec, string, secureRandom, fIPS140Context);
        }
        catch (CryptoException cryptoException) {
            throw new InvalidParameterException(cryptoException.getMessage());
        }
    }

    @Deprecated
    public static boolean verifyX942DHParams(X942DHParameterSpec x942DHParameterSpec) {
        return Assurance.verifyX942DHParams(x942DHParameterSpec, null, null);
    }

    private static boolean a(String string, AlgorithmParameterSpec algorithmParameterSpec, String string2, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        cl cl2 = cn.a(b.a(fIPS140Context), cc.a);
        try {
            AlgParamGenerator algParamGenerator = cl2.newAlgParamGenerator("DSA");
            PQGParams pQGParams = "DSA".equals(string) ? kt.a((DSADomainParameterGenerationSpec)algorithmParameterSpec, string2, (CryptoModule)cl2) : kt.a((X942DHParameterSpec)algorithmParameterSpec, string2, (CryptoModule)cl2);
            algParamGenerator.initVerify(pQGParams, dd.a(secureRandom, b.a(fIPS140Context)));
            return algParamGenerator.verify();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (bj bj2) {
        }
        catch (CryptoException cryptoException) {
            return false;
        }
        return false;
    }
}

