/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary.action;

import java.util.ArrayList;
import java.util.List;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.binary.PatchingSessionOptions;
import oracle.opatchauto.core.binary.action.ActionResult;
import oracle.opatchauto.core.binary.action.CASAction;
import oracle.opatchauto.core.binary.action.PatchBag;
import oracle.opatchauto.core.binary.action.PatchParamBag;

public class CASApplyAction
extends CASAction {
    private static final byte APPLYING = 0;
    private static final byte APPLIED = 1;

    @Override
    public ActionResult execute(PatchParamBag paramBag) {
        OPatchTarget target = paramBag.getTarget();
        PatchingSessionOptions sessionOptions = paramBag.getSessionOptions();
        PatchBag patchbag = paramBag.getPatchbag();
        ActionResult actionResult = new ActionResult();
        List<OPatchPatch> patchList = patchbag.getPatchObjList();
        boolean hasRunPhaseOne = target.hasRunPhaseOne(patchList.toArray(new OPatchPatch[patchList.size()]));
        OACLogger.info("Has phase one executed for patches for target " + target.getOracleHome() + ":" + hasRunPhaseOne);
        if (hasRunPhaseOne) {
            actionResult = this.applyPatches(target, patchbag);
        } else {
            OACLogger.info("Analyzing patches before CAS apply");
            actionResult = this.analyzeAndPreparePatches(target, sessionOptions, patchbag, false);
            if (actionResult.getStatus() != ActionResult.Status.FAILED) {
                try {
                    PatchBag updatedPatchBag = this.getUpdatedPatchBag(actionResult, paramBag.getContext());
                    actionResult = this.applyPatches(target, updatedPatchBag);
                }
                catch (OPatchException e) {
                    // empty catch block
                }
            }
        }
        return actionResult;
    }

    private ActionResult applyPatches(OPatchTarget target, PatchBag patchbag) {
        OACLogger.info("Committing patches apply");
        ActionResult actionResult = new ActionResult();
        List<Object> resultList = new ArrayList();
        List<OPatchPatch> patchList = patchbag.getPatchObjList();
        this.printPatchDetails(patchbag, (byte)0);
        try {
            target.napplyCommit(patchList.toArray(new OPatchPatch[patchList.size()]));
            this.updateSystemPatchInformation(target.getOracleHome(), patchList, false);
            resultList = this.createPatchResult(patchbag, target.getLastSessionLogFile(), null);
            this.printPatchDetails(patchbag, (byte)1);
        }
        catch (OPatchException e) {
            resultList = this.createPatchResult(patchbag, target.getLastSessionLogFile(), (Exception)((Object)e));
        }
        for (PatchResult patchResult : resultList) {
            actionResult.addPatchResult(patchResult);
        }
        return actionResult;
    }

    private void printPatchDetails(PatchBag patchbag, byte status) {
        List<String> patchLocationList = patchbag.getPatchLocationList();
        if (!patchLocationList.isEmpty()) {
            for (String patchLoc : patchLocationList) {
                if (status == 0) {
                    OACLogger.console("Applying patch " + patchLoc + "...\n");
                    continue;
                }
                OACLogger.console("Patch " + patchLoc + " applied.");
            }
        }
    }

    private List<PatchResult> createPatchResult(PatchBag patchbag, String logFile, Exception e) {
        ArrayList<PatchResult> patchResultList = new ArrayList<PatchResult>();
        List<String> patchLocationList = patchbag.getPatchLocationList();
        if (!patchLocationList.isEmpty()) {
            for (String patchLoc : patchLocationList) {
                PatchResult result = null;
                result = e != null ? OPatchAutoBinaryUtil.buildFailedPR(patchLoc, "Failed during Patching: ", e, logFile) : OPatchAutoBinaryUtil.buildSuccessfulPR(patchLoc, logFile);
                patchResultList.add(result);
            }
        }
        return patchResultList;
    }
}

