/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary.action;

import java.util.ArrayList;
import java.util.List;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.binary.PatchingSessionOptions;
import oracle.opatchauto.core.binary.action.ActionResult;
import oracle.opatchauto.core.binary.action.AnalyzeReportGenerator;
import oracle.opatchauto.core.binary.action.BinaryAction;
import oracle.opatchauto.core.binary.action.PatchParamBag;
import oracle.opatchauto.core.binary.systempatch.SystemPatchInformationLoader;

public class LegacyPatchAction
implements BinaryAction {
    private final boolean isRollback;

    public LegacyPatchAction(boolean isRollback) {
        this.isRollback = isRollback;
    }

    @Override
    public ActionResult execute(PatchParamBag paramBag) {
        OPatchTarget target = paramBag.getTarget();
        PatchingSessionOptions sessionOptions = paramBag.getSessionOptions();
        List<PatchResult> analyzeResultList = paramBag.getAnalyzedResult();
        ActionResult actionResult = new ActionResult();
        AnalyzeReportGenerator analyzeExecutor = new AnalyzeReportGenerator(target, sessionOptions);
        IAnalysisReport report = null;
        boolean sessionFailed = false;
        SystemPatchInformationLoader instance = SystemPatchInformationLoader.getInstance();
        for (PatchResult patchResult : analyzeResultList) {
            if (sessionFailed && sessionOptions.getStopOnPatchFailure()) {
                patchResult.setReason("This patch has succeeded during analysis. However, some other patches failed during patching and hence, ending the session by skipping this patch.");
                patchResult.setResultAsSkip();
                actionResult.addPatchResult(patchResult);
                continue;
            }
            try {
                boolean isExecutionRequired;
                ActionResult analyzeExecutionResult = analyzeExecutor.execute(patchResult, this.isRollback);
                List<PatchResult> analyzedPatchResultList = analyzeExecutionResult.getPatchResultList();
                PatchResult analyzedPatchResult = null;
                if (analyzedPatchResultList != null && !analyzedPatchResultList.isEmpty()) {
                    analyzedPatchResult = analyzedPatchResultList.get(0);
                }
                if (analyzeExecutionResult.getStatus() == ActionResult.Status.FAILED) {
                    sessionFailed = true;
                    actionResult.addPatchResult(analyzedPatchResult);
                    continue;
                }
                if (analyzedPatchResult.getResult() == "SKIPPED") {
                    actionResult.addPatchResult(analyzedPatchResult);
                }
                boolean bl = (report = analyzeExecutionResult.getAnalysisReport()) != null && (this.isRollback ? report.getNRollbackPatches().size() > 0 : report.getNApplyPatches().size() > 0) ? true : (isExecutionRequired = false);
                if (isExecutionRequired) {
                    List patchList;
                    String systempatchID;
                    if (this.isRollback) {
                        OACLogger.console("Rolling back " + (patchResult.isPatchIDbased() ? patchResult.getPatchID() : patchResult.getPatchLocn()) + " ...");
                        target.NRollback(report);
                        OACLogger.console("Rollback of " + (patchResult.isPatchIDbased() ? patchResult.getPatchID() : patchResult.getPatchLocn()) + " completed.");
                    } else {
                        OACLogger.console("Applying " + patchResult.getPatchLocn() + " ...");
                        target.NApply(report);
                        OACLogger.console("Patch " + patchResult.getPatchLocn() + " applied.");
                    }
                    String logFile = target.getLastSessionLogFile();
                    if (patchResult.isPatchIDbased()) {
                        actionResult.addPatchResult(OPatchAutoBinaryUtil.buildSuccessfulPRwithID(patchResult.getPatchID(), logFile));
                    } else {
                        actionResult.addPatchResult(OPatchAutoBinaryUtil.buildSuccessfulPR(patchResult.getPatchLocn(), logFile));
                    }
                    if ((systempatchID = instance.getSystemPatchID(patchList = this.isRollback ? report.getNRollbackPatches() : report.getNApplyPatches(), this.isRollback)) == null) continue;
                    ArrayList<String> patchIDList = new ArrayList<String>();
                    for (OPatchPatch patch : patchList) {
                        patchIDList.add(patch.getPatchId());
                    }
                    instance.updateSubpatchInformationStore(sessionOptions.getTarget().getOracleHome(), systempatchID, patchIDList, this.isRollback);
                    continue;
                }
                if (this.isPatchResultAvailable(actionResult, analyzedPatchResult)) continue;
                String reason = null;
                if (patchResult.isPatchIDbased()) {
                    reason = "This patch is not applicable to the oracle home - \"" + (sessionOptions.getTarget().getTargetType() == null ? sessionOptions.getTarget().getOracleHome() : sessionOptions.getTarget().getTargetType()) + "\"";
                    actionResult.addPatchResult(OPatchAutoBinaryUtil.buildSkippedPRwithID(patchResult.getPatchID(), reason));
                    continue;
                }
                actionResult.addPatchResult(this.buildSkippedPR(patchResult.getPatchLocn(), sessionOptions.getTarget().getOracleHome(), sessionOptions.getTarget().getTargetType()));
            }
            catch (Exception e) {
                OACLogger.console("Patch " + (patchResult.isPatchIDbased() ? patchResult.getPatchID() : patchResult.getPatchLocn()) + " FAILED.");
                sessionFailed = true;
                OACLogger.printStackTrace(e);
                String logFile = target.getLastSessionLogFile();
                actionResult.addPatchResult(OPatchAutoBinaryUtil.buildFailedPR(patchResult.getPatchLocn(), patchResult.getPatchID(), "Failed during Patching: ", e, logFile));
            }
        }
        OACLogger.info("... Patching operations Completed.");
        return actionResult;
    }

    private boolean isPatchResultAvailable(ActionResult actionResult, PatchResult analyzedPatchResult) {
        boolean isAvailable = false;
        if (actionResult.getPatchResultList() != null && !actionResult.getPatchResultList().isEmpty()) {
            isAvailable = actionResult.getPatchResultList().contains(analyzedPatchResult) && (analyzedPatchResult.getResult() == "FAILED" || analyzedPatchResult.getResult() == "SKIPPED");
        }
        return isAvailable;
    }

    private PatchResult buildSkippedPR(String patch, String oracleHome, String targetType) {
        String reason = null;
        reason = targetType == null ? "This patch is not applicable to the oracle home - \"" + oracleHome + "\"" : "This patch is not applicable to this specified target type - \"" + targetType + "\"";
        return OPatchAutoBinaryUtil.buildSkippedPR(patch, reason);
    }
}

