/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PrereqAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import dbmodel.db_crs.SIDatabase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DBPrereqAction
extends PrereqAction {
    public DBPrereqAction() {
        super((Goal)InitPhase.Goal.init);
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        if (DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions())) {
            return false;
        }
        if (((HomeImpl)patchTarget.getHome()).isGIMRHome()) {
            return false;
        }
        return super.isActionRequired(patchTarget);
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        ArrayList<ExecutionStep> generatedSteps = new ArrayList<ExecutionStep>();
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        String dbTargetHomeConstant = "";
        String type = patchTarget.getProductType().getType();
        if (type.equals(DBProductTypes.PRODUCT_TYPE_SIDB.getValue())) {
            dbTargetHomeConstant = "SIDatabase";
            if (this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue() != null) {
                primarypatchVersion = configGraph.getTargets(SIDatabase.class).get(0).getShardProperty().getShardVersion();
            }
        } else {
            dbTargetHomeConstant = "RACDatabase";
        }
        boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
        List<ExecutionStep> steps = null;
        if (isTwelveVersion) {
            steps = this.getSPFilePreReqCommandExecutionSteps(configGraph, patchTarget, dbTargetHomeConstant);
            generatedSteps.addAll(steps);
        }
        steps = super.generateSteps(patchTarget);
        generatedSteps.addAll(steps);
        if (isTwelveVersion) {
            if (this.getPatchSession().isRollback()) {
                steps = this.getSQLpatchApplyCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchRollback.toString(), dbTargetHomeConstant);
                generatedSteps.addAll(steps);
            } else {
                steps = this.getSQLpatchApplyCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchApply.toString(), dbTargetHomeConstant);
                generatedSteps.addAll(steps);
            }
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue());
        return targetList;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("DBPrereqAction.start.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("DBPrereqAction.failure.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("DBPrereqAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("DBPrereqAction.success.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        statusMsg = this.addTag(statusMsg);
        return statusMsg;
    }
}

