/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.crs;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class RACOneAction
extends DBCommonPatchAction {
    public RACOneAction() {
        super(new Goal[]{ShutdownPhase.Goal.shutdown, StartupPhase.Goal.startup, OfflinePhase.Goal.finalize_binary_patching});
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue());
        return targetList;
    }

    @Override
    protected void displayNoStepMessage(PatchTarget patchTarget) {
        Reporting.report((String)this.getLocalizedString("RACOneAction.no.step.message", patchTarget.getHome().getLocation()));
    }

    public boolean isRollbackSupported() {
        return true;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        if (((HomeImpl)patchTarget.getHome()).isGIMRHome()) {
            return false;
        }
        boolean bl = isActionRequired = !DBPatchingHelper.isNonRollingMode(this.getPatchSession().getOptions()) && DBPatchingHelper.isRacOneDatabaseConfigured(patchTarget);
        if (isActionRequired) {
            boolean oopPreparePatchingSession = DBPatchingHelper.isOOPPreparePatchingSession(this.getPatchSession().getOptions());
            boolean oopSwitchPatchingSession = DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions());
            boolean oopSinglePatchingSession = DBPatchingHelper.isSingleOOPPatchingSession(this.getPatchSession().getOptions());
            Goal goal = this.getCurrentGoal();
            if (oopPreparePatchingSession) {
                isActionRequired = false;
            } else if (oopSwitchPatchingSession || oopSinglePatchingSession) {
                if (goal.equals(ShutdownPhase.Goal.shutdown)) {
                    isActionRequired = false;
                }
            } else if (goal.equals(OfflinePhase.Goal.finalize_binary_patching)) {
                isActionRequired = false;
            }
        }
        return isActionRequired;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<Object> generatedSteps = new ArrayList();
        generatedSteps = this.getCurrentGoal().equals(ShutdownPhase.Goal.shutdown) || this.getCurrentGoal().equals(OfflinePhase.Goal.finalize_binary_patching) ? this.getRelocateOutRACOneCommandExecutionSteps(configGraph, patchTarget) : this.getRelocateBackRACOneCommandExecutionSteps(configGraph, patchTarget);
        return generatedSteps;
    }

    public int getOrderingWeight(Goal goal) {
        return 30;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    @Override
    protected Class<? extends AbstractBaseTarget> getApplicableTargetHome(ActionType actionType) {
        return OracleHome.class;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("RACOneAction." + this.getCurrentGoal().getName() + ".start.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("RACOneAction." + this.getCurrentGoal().getName() + ".failure.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("RACOneAction." + this.getCurrentGoal().getName() + ".warning.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("RACOneAction." + this.getCurrentGoal().getName() + ".success.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        statusMsg = this.addTag(statusMsg);
        return statusMsg;
    }

    private List<ExecutionStep> getRelocateBackRACOneCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> steps = this.getRACOneCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.relocateback.toString(), ServiceStatus.DOWN);
        return steps;
    }

    private List<ExecutionStep> getRelocateOutRACOneCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> steps = this.getRACOneCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.relocateout.toString(), ServiceStatus.UP);
        return steps;
    }

    private List<ExecutionStep> getRACOneCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String commandType, ServiceStatus status) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, commandType);
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, "OracleHomeRACOne");
        argList.put(CommandDetailsGenerator.ActionTypeParams.SERVICE_STATUS, status);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, "oracle.server");
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, "rac");
        argList.put(CommandDetailsGenerator.ActionTypeParams.TAG, DBCommandParameters.DO_NOT_SKIP.getValue());
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Relocate-Home-Title");
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "Relocate-Home-Message");
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.LIFECYCLE_ACTION, argList);
        PatchingPhase phase = this.getPatchingPhase();
        Command stopStartOracleHomeCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, stopStartOracleHomeCommand);
        return steps;
    }

    private PatchingPhase getPatchingPhase() {
        PatchingPhase phase = null;
        boolean oopSwitchPatchingSession = DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions());
        boolean oopSinglePatchingSession = DBPatchingHelper.isSingleOOPPatchingSession(this.getPatchSession().getOptions());
        phase = this.getPatchSession().isRollback() ? (oopSinglePatchingSession || oopSwitchPatchingSession ? CommandDetailsGenerator.generatePatchingPhase(PhaseType.SWITCHBACK, ServiceStatus.LIMITED) : CommandDetailsGenerator.generatePatchingPhase(PhaseType.ROLLBACK, ServiceStatus.LIMITED)) : (oopSinglePatchingSession || oopSwitchPatchingSession ? CommandDetailsGenerator.generatePatchingPhase(PhaseType.MIGRATE, ServiceStatus.LIMITED) : CommandDetailsGenerator.generatePatchingPhase(PhaseType.APPLY, ServiceStatus.LIMITED));
        return phase;
    }
}

