/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.oop;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.lifecycle.FinalizePhase;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CopyOOPSessionFilePatchAction
extends DBCommonPatchAction {
    public CopyOOPSessionFilePatchAction() {
        super(new Goal[]{FinalizePhase.Goal.finalize});
    }

    public int getOrderingWeight(Goal goal) {
        return 210;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }

    @Override
    protected void displayNoStepMessage(PatchTarget target) {
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        String homeLocation = patchTarget.getHome(true).getLocation();
        boolean isGenerateStepCmd = DBPatchingHelper.isGenerateStepCommand(this.getPatchSession().getOptions());
        try {
            isActionRequired = DBPatchingHelper.isOOPPatchingSession(options) && !isGenerateStepCmd && DBPatchingHelper.compareFilePath(homeLocation, OPatchAutoHelper.getOPatchAutoHome()) && !patchTarget.isRemote();
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException((Throwable)e);
        }
        return isActionRequired;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionSteps = new ArrayList<ExecutionStep>();
        String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
        sessionInfoFile = sessionInfoFile.replace("$HOST_NAME", patchTarget.getHost().getHost());
        File currentOOPSessionFile = new File(OPatchAutoHelper.getOPatchAutoHome() + sessionInfoFile);
        OOPSessionInfoHandler oopSessionInfoHandler = OOPSessionInfoHandler.getInstance();
        Set patchTargetList = this.getPatchSession().getPatchPlanManager().getPatchTargets();
        for (PatchTarget target : patchTargetList) {
            oopSessionInfoHandler.updateHomeSessionStatus(target, true);
        }
        if (oopSessionInfoHandler.isSessionCompletedOnAllNode()) {
            oopSessionInfoHandler.setSessionCompleted();
        }
        oopSessionInfoHandler.saveOOPSessionCookie(currentOOPSessionFile.getAbsolutePath());
        return executionSteps;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        return "";
    }

    @Override
    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        super.postExecute(patchTarget, patchActionResult);
        if (patchActionResult.isFailure()) {
            return;
        }
        if (this.getPatchSession().getPatchTracking() != null) {
            Set patchTargetList = this.getPatchSession().getPatchPlanManager().getPatchTargets();
            DBPatchingSummaryCreator summaryCreator = this.getProductSupport().getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
            for (PatchTarget target : patchTargetList) {
                if (!this.getSupportedProductTypes().contains(target.getProductType().getType())) continue;
                summaryCreator.storePatchingSummary(0, SummaryID.oop_summary, target, "clone information");
            }
        }
    }
}

