/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.oop.sidb;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.oop.sidb.SIDBSwitchAction;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;

public class SIDBStopListenerAction
extends SIDBSwitchAction {
    private static final Logger logger = Logger.getLogger(SIDBStopListenerAction.class.getName());

    @Override
    public int getOrderingWeight(Goal goal) {
        return 10;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        ArrayList<ExecutionStep> generatedSteps = new ArrayList<ExecutionStep>();
        List<ExecutionStep> steps = null;
        if (this.checkListenerStatus(patchTarget)) {
            steps = this.getDatabaseModificationSteps(configGraph, patchTarget, DBCommandActionType.listenerStop.toString(), "SIDatabase", "Confirm-Config-Title", false);
            generatedSteps.addAll(steps);
        }
        return generatedSteps;
    }

    private boolean checkListenerStatus(PatchTarget patchTarget) {
        String owner;
        String loc = patchTarget.getHome(true).getLocation();
        String listenerStopCmd = "cd " + loc + "; ORACLE_HOME=" + loc + " ORACLE_SID=" + DBPatchingUtil.getSIDBInstancename(patchTarget) + " " + loc + File.separator + "bin" + File.separator + "lsnrctl status";
        GISystemCall.ExecReturn ret = GISystemCall.process(listenerStopCmd, owner = FileUtility.checkFileOwner((File)new File(loc, "oraInst.loc")), this.getPassword(patchTarget));
        if (!ret.isOK()) {
            Reporting.report((String)"Listener are already stopped....");
            logger.finest("Listener are already stopped....");
        }
        return ret.isOK();
    }
}

