/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.sdb;

import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Logger;

public class RemoteAnalysisStatusRetriever {
    protected final Logger _logger = Logger.getLogger(this.getClass().getName());

    private RemoteAnalysisStatusRetriever() {
    }

    public static RemoteAnalysisStatusRetriever getInstance() {
        return LoadClass.analysisStatusRetriever;
    }

    public boolean retrieveRemoteAnalyzeStatus(PatchTarget patchTarget, CredentialManager credentialManager) {
        boolean analyzeStatus = false;
        String localTxtPath = "";
        try {
            localTxtPath = OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB + patchTarget.getHost().getHost() + "_analyze.txt";
        }
        catch (OPatchAutoException e1) {
            this._logger.warning("Error while getting opatchauto home : " + e1.getMessage());
        }
        String remoteTxtPath = patchTarget.getHome().getLocation() + DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO + "report_analyze_failure.txt";
        this._logger.fine("remoteTxtPath : " + remoteTxtPath);
        this._logger.fine("localTxtPath : " + localTxtPath);
        try {
            DBHomeImpl dbHomeImpl = (DBHomeImpl)patchTarget.getHome();
            Credential credential = dbHomeImpl.getCredential();
            String owner = credential.getUsername();
            HostImpl hostImpl = PatchActionUtil.createHostImpl(credentialManager, patchTarget.getHost().getHost(), dbHomeImpl.getLocation(), owner);
            RemoteConnectionHandler handler = PatchActionUtil.getHandler(hostImpl);
            if (handler.exists(remoteTxtPath)) {
                DBPatchingUtil.createNewFile(localTxtPath, owner, null);
                IOUtils.chmodTo775(new File(localTxtPath), null);
                handler.get(remoteTxtPath, new File(localTxtPath));
                handler.delete(remoteTxtPath);
            }
        }
        catch (RemoteConnectionException e) {
            this._logger.throwing("Detailed Exception while getting analyze status file from remote: ", e.getMessage(), e);
        }
        analyzeStatus = this.isAnalyzeFailedOnRemoteHome(localTxtPath);
        if (new File(localTxtPath).exists()) {
            new File(localTxtPath).deleteOnExit();
        }
        return analyzeStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAnalyzeFailedOnRemoteHome(String localTxtPath) {
        boolean analyzeFailureStatus = false;
        if (new File(localTxtPath).exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(localTxtPath));
                try {
                    String currentLine;
                    while ((currentLine = br.readLine()) != null) {
                        if (!currentLine.startsWith("ANALYZE_FAILED_STATUS:")) continue;
                        String failedStatus = currentLine.substring(currentLine.indexOf(":") + 1, currentLine.length());
                        analyzeFailureStatus = failedStatus.equals("true");
                    }
                }
                catch (IOException e) {
                    this._logger.warning("Unable to read from file due to: " + e.getMessage());
                }
            }
            catch (FileNotFoundException e1) {
                this._logger.warning("Unable to read from file : " + e1.getMessage());
            }
            finally {
                if (null != br) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        this._logger.warning("Error while closing buffered reader : " + e.getMessage());
                    }
                }
            }
        }
        this._logger.info("Has analysis failed on remote : " + analyzeFailureStatus);
        return analyzeFailureStatus;
    }

    private static class LoadClass {
        static RemoteAnalysisStatusRetriever analysisStatusRetriever = new RemoteAnalysisStatusRetriever();

        private LoadClass() {
        }
    }
}

