/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.siha;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.product.CommandFailureException;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.SystemInstance;
import dbmodel.db_crs.SIDatabase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;

public class SIDBShutDownAction
extends DBShutDownStartupAction {
    public SIDBShutDownAction() {
        super(new Goal[]{ShutdownPhase.Goal.shutdown, OfflinePhase.Goal.finalize_binary_patching});
    }

    public int getOrderingWeight(Goal goal) {
        if (goal.equals(OfflinePhase.Goal.finalize_binary_patching)) {
            return 40;
        }
        return super.getOrderingWeight(goal);
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isRequired = super.isActionRequired(patchTarget);
        if (!isRequired) {
            return isRequired;
        }
        try {
            Boolean isSidbOnly = Boolean.parseBoolean(this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue());
            if (isSidbOnly.booleanValue()) {
                SystemInstance systemInstance = PatchPlanner.getInstance().getSystemInstance();
                SIDatabase siDatabase = (SIDatabase)systemInstance.getTargetsOfType(SIDatabase.class).get(0);
                String sidbDbUp = siDatabase.getShardProperty().getIsDatabaseUp();
                isRequired = "Y".equalsIgnoreCase(sidbDbUp);
                return isRequired;
            }
        }
        catch (Exception e) {
            throw new PatchActionException("Exception : " + e.getMessage(), new Object[0]);
        }
        isRequired = ClusterInformationLoader.getInstance().isStackRunning();
        return isRequired;
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> generatedSteps = super.generateSteps(patchTarget);
        List<ExecutionStep> steps = this.getStopOracleHomeCommandExecutionSteps(this.configGraph, patchTarget, "sidb", "OracleHome");
        generatedSteps.addAll(steps);
        return generatedSteps;
    }

    @Override
    protected ExecutionResult runCommand(PatchTarget patchTarget, ExecutionStep executionStep) throws CommandFailureException {
        ExecutionResult status = super.runCommand(patchTarget, executionStep);
        if (status != null && status.isSuccessful()) {
            for (ExecutionStep.Command command : executionStep.getCommand()) {
                if (command.getValue().indexOf("srvctl") == -1) continue;
                String listOfDBStopped = this.listOfDatabasesStopped(command.getValue());
                if (listOfDBStopped == null || listOfDBStopped.length() <= 0) break;
                Reporting.report((String)this.getLocalizedString("ShutdownAction.sidb.down.message", listOfDBStopped));
                break;
            }
        }
        return status;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }
}

