/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.siha;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.SystemInstance;
import dbmodel.db_crs.SIDatabase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;

public class SIDBStartupAction
extends DBShutDownStartupAction {
    public SIDBStartupAction() {
        super(new Goal[]{StartupPhase.Goal.startup});
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isRequired = super.isActionRequired(patchTarget);
        if (!isRequired) {
            return isRequired;
        }
        try {
            Boolean isSidbOnly = Boolean.parseBoolean(this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue());
            if (isSidbOnly.booleanValue()) {
                SystemInstance systemInstance = PatchPlanner.getInstance().getSystemInstance();
                SIDatabase siDatabase = (SIDatabase)systemInstance.getTargetsOfType(SIDatabase.class).get(0);
                String sidbDbUp = siDatabase.getShardProperty().getIsDatabaseUp();
                isRequired = "Y".equalsIgnoreCase(sidbDbUp);
                return isRequired;
            }
        }
        catch (Exception e) {
            throw new PatchActionException("Exception : " + e.getMessage(), new Object[0]);
        }
        isRequired = ClusterInformationLoader.getInstance().isStackRunning();
        return isRequired;
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> generatedSteps = super.generateSteps(patchTarget);
        List<ExecutionStep> steps = this.getStartOracleHomeCommandExecutionSteps(this.configGraph, patchTarget, "sidb", "OracleHome");
        if (!DBPatchingHelper.isNoRestartEnable(this.getPatchSession().getOptions())) {
            generatedSteps.addAll(steps);
        } else {
            Reporting.report((String)this.getLocalizedString("StartAction.norestart.database.warning", patchTarget.getHome().getLocation()));
            for (ExecutionStep step : steps) {
                for (ExecutionStep.Command command : step.getCommand()) {
                    Reporting.report((String)(command.getValue() + "\n"));
                }
            }
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }
}

