/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptionGroup;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBBaseProductSupport;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBCommonSupport;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.SDBProductSupport;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementType;
import com.oracle.glcm.patch.auto.product.CommonProductSupport;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DBProductSupport
extends CommonProductSupport {
    private static final Logger _log = Logger.getLogger(DBProductSupport.class.getName());
    public static final String DB_PRODUCT = "db";
    private static final List<String> UNSUPPORTED_OPTIONS = new ArrayList<String>();
    private static final List<String> UNVISIBLE_OPTIONS = new ArrayList<String>();
    private DBCommonSupport productSupport = new DBCommonSupport();
    DBBaseProductSupport dBBaseProductSupport = new DBBaseProductSupport();
    SDBProductSupport sdBProductSupport = new SDBProductSupport();
    private Map<String, String> libPathMap = null;

    public boolean isSupportedTopology(File topologyFile, OPatchAutoOptions options, CredentialManager credentialManager) throws OPatchAutoException {
        return this.productSupport.isSupportedTopology(topologyFile, options, credentialManager);
    }

    protected Set<ProductType> loadProductTypes() {
        LinkedHashSet<ProductType> productTypes = new LinkedHashSet<ProductType>();
        productTypes.addAll(this.dBBaseProductSupport.loadProductTypes());
        productTypes.addAll(this.sdBProductSupport.loadProductTypes());
        return productTypes;
    }

    public void loadTopology(OPatchAutoOptions options, CredentialManager credentialManager) throws OPatchAutoException {
        this.productSupport.loadTopology(options, credentialManager);
        this.libPathMap = this.productSupport.getLibPathMap();
        this.setTopology(this.productSupport.getTopology());
    }

    public Set<OPatchAutoOption> getOptions() {
        HashSet<OPatchAutoOption> options = new HashSet<OPatchAutoOption>();
        options.addAll(this.dBBaseProductSupport.getOptions());
        options.addAll(this.sdBProductSupport.getOptions());
        return options;
    }

    public Set<OPatchAutoOptionGroup> getOptionGroups(OPatchAutoOptions options) {
        HashSet<OPatchAutoOptionGroup> optionGroups = new HashSet<OPatchAutoOptionGroup>();
        optionGroups.addAll(this.dBBaseProductSupport.getOptionGroups(options));
        optionGroups.addAll(this.sdBProductSupport.getOptionGroups(options));
        return optionGroups;
    }

    public Set<String> getResourceBundles() {
        return this.productSupport.getResourceBundles();
    }

    public String getId() {
        return DB_PRODUCT;
    }

    public Set<Class<? extends PatchAction>> getPatchActions(OPatchAutoCommand command, OPatchAutoOptions options) {
        HashSet<Class<? extends PatchAction>> patchActions = new HashSet<Class<? extends PatchAction>>();
        patchActions.addAll(this.dBBaseProductSupport.getPatchActions(command, options));
        patchActions.addAll(this.sdBProductSupport.getPatchActions(command, options));
        return patchActions;
    }

    public void updateOptions(OPatchAutoOptions options) throws OPatchAutoException {
        this.productSupport.updateOptions(options);
    }

    public PatchPlanIncrementType getPatchPlanIncrementType(String incrementType) {
        return this.productSupport.getPatchPlanIncrementType(incrementType);
    }

    public void initialize(OPatchAutoCommand command, OPatchAutoOptions options) throws OPatchAutoException {
        OPatchAutoOption option = options.getOption(DBProductParameterConstants.SDB.getValue());
        Boolean isShardedDatabase = Boolean.parseBoolean(option.getValue());
        _log.finer(" ShardedDatabase set as " + isShardedDatabase);
        String dataGuardName = null;
        if (options.getOption(DBProductParameterConstants.DG.getValue()) != null) {
            dataGuardName = options.getOption(DBProductParameterConstants.DG.getValue()).getValue();
            _log.finer(" DataGuard primary set as : " + dataGuardName);
        }
        String shardGroupName = null;
        String shardSpaceName = null;
        if (options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue()) != null) {
            shardGroupName = options.getOption(DBProductParameterConstants.SHARD_GROUP.getValue()).getValue();
            _log.finer(" ShardGroup set as : " + shardGroupName);
        }
        if (options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue()) != null) {
            shardSpaceName = options.getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).getValue();
            _log.finer(" ShardSpace set as : " + shardSpaceName);
        }
        this.productSupport = !StringUtil.isNullOrEmpty((String)dataGuardName) || isShardedDatabase != false || !StringUtil.isNullOrEmpty((String)shardGroupName) || !StringUtil.isNullOrEmpty((String)shardSpaceName) ? new SDBProductSupport() : new DBBaseProductSupport();
        _log.finer(" productSupport initialize: " + (Object)((Object)this.productSupport));
        this.productSupport.initialize(command, options);
    }

    public void closeSession(OPatchAutoCommand command, boolean isSuccessful) {
        super.closeSession(command, isSuccessful);
        this.productSupport.closeSession(command, isSuccessful);
        this.setTopology(null);
    }

    public Map<String, String> getPluginVersions() {
        return this.productSupport.getPluginVersions();
    }

    public boolean isDefaultTopologyDisable(OPatchAutoOptions options) throws OPatchAutoException {
        return this.productSupport.isDefaultTopologyDisable(options);
    }

    public String getProductDisplayName() {
        return this.productSupport.getProductDisplayName();
    }

    public Set<String> getPatchPlans() {
        return this.productSupport.getPatchPlans();
    }

    public String getPatchPlanDescription(String patchPlan) {
        String description = this.productSupport.getPatchPlanDescription(patchPlan);
        if (null != description) {
            return description;
        }
        return super.getPatchPlanDescription(patchPlan);
    }

    public void updateOptionApplicability(OPatchAutoOptions options) throws OPatchAutoException {
        this.handleCommandOptions(options);
        this.loadUnSupportedOptions(options);
        this.loadUnVisibleOptions();
        for (OPatchAutoOption option : options.getAllOptions()) {
            if (UNSUPPORTED_OPTIONS.contains(option.getKey())) {
                option.setDisabled(true);
            }
            if (!UNVISIBLE_OPTIONS.contains(option.getKey())) continue;
            option.setVisible(false);
        }
    }

    public DBPatchingSummaryCreator getDBPatchingSummaryCreator(OPatchAutoCommand command) {
        return this.productSupport.getDBPatchingSummaryCreator(command);
    }

    private void handleCommandOptions(OPatchAutoOptions options) {
        for (OPatchAutoOption option : options.getAllOptions()) {
            if (!"session".equals(option.getKey())) continue;
            option.setCommands(new OPatchAutoCommand[]{OPatchAutoCommand.resume});
            options.updateOptionRegistration(option);
            break;
        }
    }

    private void loadUnSupportedOptions(OPatchAutoOptions options) throws OPatchAutoException {
        UNSUPPORTED_OPTIONS.addAll(this.dBBaseProductSupport.loadUnSupportedOptions(options));
        UNSUPPORTED_OPTIONS.addAll(this.sdBProductSupport.loadUnSupportedOptions());
    }

    private void loadUnVisibleOptions() {
        UNVISIBLE_OPTIONS.addAll(this.dBBaseProductSupport.loadUnVisibleOptions());
        UNVISIBLE_OPTIONS.addAll(this.sdBProductSupport.loadUnVisibleOptions());
    }

    public Set<? extends OPatchAutoCommand> getUnsupportedCommand() {
        HashSet<OPatchAutoCommand> unSupportedCommands = new HashSet<OPatchAutoCommand>();
        unSupportedCommands.add(OPatchAutoCommand.lsphases);
        unSupportedCommands.add(OPatchAutoCommand.lsplans);
        return unSupportedCommands;
    }

    public String getLibPathFromHost(String hostName) {
        String homePath = null;
        if (this.libPathMap != null && this.libPathMap.containsKey(hostName)) {
            homePath = this.libPathMap.get(hostName);
        }
        return homePath;
    }

    public boolean isGIPatchingRequested() {
        boolean isGIPatchingRequested = false;
        Set homes = this.productSupport.getTopology().getHomes();
        for (Home home : homes) {
            Set productTypes = home.getProductTypes();
            for (ProductType productType : productTypes) {
                String type = productType.getType();
                if (!type.equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue())) continue;
                isGIPatchingRequested = true;
                break;
            }
            if (!isGIPatchingRequested) continue;
            break;
        }
        _log.info("isGIPatchingRequested: " + isGIPatchingRequested);
        return isGIPatchingRequested;
    }

    public void postPatchSessionInit(PatchSession patchSession) {
        this.productSupport.postPatchSessionInit(patchSession);
    }

    public Set<PatchTarget> getSortedPatchTargets(Set<PatchTarget> patchTargets) {
        return this.productSupport.getSortedPatchTargets(patchTargets);
    }

    public void initializeOPatchAutoReporting(String reportingType) throws OPatchAutoException {
        this.productSupport.initializeOPatchAutoReporting(reportingType);
    }
}

