/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.assembler;

import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.assembler.IPatchTargetAssembler;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.HAS;
import dbmodel.db_crs.ShardSpace;
import java.util.List;
import java.util.logging.Logger;

public class ShardSpaceAssembler
implements IPatchTargetAssembler {
    Logger logger = Logger.getLogger(ShardSpaceAssembler.class.getName());
    private List<ShardSpace> shardSpaces = null;

    public ShardSpaceAssembler(List<ShardSpace> shardSpaces) {
        this.shardSpaces = shardSpaces;
    }

    @Override
    public boolean isShardRequired(AbstractBaseTarget shard, SystemInstance systemInstance, String option) {
        this.logger.fine(" shardSpaceOption :: " + option);
        if (this.shardSpaces == null) {
            this.shardSpaces = systemInstance.getTargetsOfType(ShardSpace.class);
        }
        for (ShardSpace shardSpc : this.shardSpaces) {
            if (!option.equals(shardSpc.getShardSpaceName())) continue;
            if (shard instanceof CRSCluster || shard instanceof HAS) {
                this.logger.fine(shard + " an instance of " + (shard instanceof CRSCluster ? "CRSCluster" : "HAS") + " is required");
                return true;
            }
            for (AbstractBaseTarget abt : shardSpc.getDatabases()) {
                this.logger.fine("Comparing abt name " + abt.getName() + " and shard name " + shard.getName());
                if (!shard.getName().equalsIgnoreCase(abt.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

