/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.formulator;

import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.DatabaseProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.formulator.HomeSupporter;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.formulator.IHomeFormulator;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.SIDatabase;
import java.util.List;

public class SIDBHomeFormulator
extends HomeSupporter
implements IHomeFormulator {
    private boolean isShardedDatabase = false;
    private List<String> shardGroupOptions = null;
    private List<String> shardSpaceOptions = null;

    public SIDBHomeFormulator(boolean isShardedDatabase, List<String> shardGroupOptions, List<String> shardSpaceOptions) {
        this.isShardedDatabase = isShardedDatabase;
        this.shardGroupOptions = shardGroupOptions;
        this.shardSpaceOptions = shardSpaceOptions;
    }

    @Override
    public DBHomeImpl createHome(AbstractBaseTarget shard, HostImpl host, boolean isOgg, String shardingType, OracleHome oracleHome) {
        ProductType productType = null;
        DBHomeImpl targetHome = new DBHomeImpl();
        SIDatabase siDatabase = (SIDatabase)shard;
        targetHome.setDrsetNumber(siDatabase.getShardProperty().getDrsetNumber());
        targetHome.setTargetName(siDatabase.getDatabaseName());
        targetHome.setOwner(oracleHome.getOwner());
        boolean isPrimary = siDatabase.getPrimary();
        if (siDatabase.getShardProperty().getDbType().equalsIgnoreCase("NON_RAC")) {
            targetHome.setTargetType("sidb_only");
        } else if (siDatabase.getShardProperty().getDbType().equalsIgnoreCase("SIHA")) {
            targetHome.setTargetType("sidb");
        }
        if (this.isShardedDatabase) {
            productType = this.setProductTypeForSDB(isOgg, isPrimary, targetHome);
            targetHome.setShardGroupName(siDatabase.getShardProperty().getShardGroupName());
            targetHome.setShardSpaceName(siDatabase.getShardProperty().getShardSpaceName());
        } else if (this.shardGroupOptions != null || this.shardSpaceOptions != null) {
            productType = new DatabaseProductType();
            if (this.shardGroupOptions != null) {
                targetHome.setShardGroupName(siDatabase.getShardProperty().getShardGroupName());
            } else if (isOgg) {
                targetHome.setShardSpaceName(siDatabase.getShardProperty().getShardSpaceName());
            } else {
                productType = this.setProductTypeForDG(isPrimary, targetHome);
            }
        } else {
            productType = this.setProductTypeForDG(isPrimary, targetHome);
            targetHome.setShardGroupName(siDatabase.getShardProperty().getShardGroupName());
            targetHome.setShardSpaceName(siDatabase.getShardProperty().getShardSpaceName());
        }
        targetHome.setShardingType(shardingType);
        targetHome.addProductType(productType);
        targetHome.setLocation(oracleHome.getPath());
        targetHome.setHost((Host)host);
        return targetHome;
    }
}

